/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryPane;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;

public class DataEntryDialog
extends JDialog
implements ActionListener {
    protected static final String PREV_STRING = "<< prev";
    protected static final String NEXT_STRING = "next >>";
    protected static final String OK_STRING = "OK";
    protected static final String CANCEL_STRING = "Cancel";
    protected DataEntryPane _dataPanel;
    protected int _defaultComponentIndex = -1;
    protected static final int CANCEL = 0;
    protected static final int PREV = 1;
    protected static final int NEXT = 2;
    protected static final int OK = 3;
    protected int _response;
    protected boolean _progressive;
    protected DataEntryDialog _prevDlg;
    protected DataEntryDialog _nextDlg;

    public static DataEntryDialog createSimpleDataEntryDialog(DataEntryElement[] elements, String dlgHeader) {
        return DataEntryDialog.createSimpleDataEntryDialog(elements, dlgHeader, null);
    }

    public static DataEntryDialog createSimpleProgressiveDataEntryDialog(DataEntryElement[] elements, String dlgHeader, boolean prev, boolean next) {
        return DataEntryDialog.createSimpleProgressiveDataEntryDialog(elements, dlgHeader, null, prev, next);
    }

    public static DataEntryDialog createSimpleDataEntryDialog(DataEntryElement[] elements, String dlgHeader, String title) {
        return DataEntryDialog.createSimpleProgressiveDataEntryDialog(elements, dlgHeader, title, false, false);
    }

    public static DataEntryDialog createSimpleProgressiveDataEntryDialog(DataEntryElement[] elements, String dlgHeader, String title, boolean prev, boolean next) {
        DataEntryPane dataPanel = null;
        if (elements.length == 1) {
            dataPanel = elements[0].getDataEntryPanel();
            dataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 12, 10, 12)));
        } else {
            dataPanel = new DataEntryPane(elements);
            dataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(13, 15, 13, 15)));
        }
        JFrame parent = ControllerImpl.getSingletonController().getParent();
        return new DataEntryDialog(parent, dataPanel, dlgHeader, title, prev, next);
    }

    public static DataEntryDialog createSimpleDataEntryDialog(DataEntryElement[] elements, int defIndex, String dlgHeader, String title) {
        DataEntryDialog dialog = DataEntryDialog.createSimpleDataEntryDialog(elements, dlgHeader, title);
        dialog.setDefaultComponent(defIndex);
        return dialog;
    }

    public static DataEntryDialog createSimpleProgressiveDataEntryDialog(DataEntryElement[] elements, int defIndex, String dlgHeader, String title, boolean prev, boolean next) {
        DataEntryDialog dialog = DataEntryDialog.createSimpleProgressiveDataEntryDialog(elements, dlgHeader, title, prev, next);
        dialog.setDefaultComponent(defIndex);
        return dialog;
    }

    protected DataEntryDialog(JFrame parent, DataEntryPane pane, String dlgHeader, String title, boolean prev, boolean next) {
        super((Frame)parent, dlgHeader);
        this.setResizable(false);
        this.setModal(true);
        this._progressive = prev || next;
        this._dataPanel = pane;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBackground(Deployer.TreeBackgroundColor);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 15, 20));
        if (title != null) {
            JLabel titleLabel = new JLabel(title, 0);
            titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            titleLabel.setFont(GuiUtil.getBoldDialogFont());
            contentPane.add((Component)titleLabel, "North");
        }
        contentPane.add((Component)pane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        if (prev) {
            JButton prevButton = new JButton(PREV_STRING);
            prevButton.setActionCommand(PREV_STRING);
            prevButton.addActionListener(this);
            buttonPane.add(prevButton);
            buttonPane.add(Box.createHorizontalStrut(20));
        }
        JButton cancelButton = new JButton(CANCEL_STRING);
        cancelButton.setActionCommand(CANCEL_STRING);
        cancelButton.addActionListener(this);
        buttonPane.add(cancelButton);
        JButton lastButton = null;
        if (next) {
            lastButton = new JButton(NEXT_STRING);
            lastButton.setActionCommand(NEXT_STRING);
        } else {
            lastButton = new JButton(OK_STRING);
            lastButton.setActionCommand(OK_STRING);
        }
        lastButton.addActionListener(this);
        buttonPane.add(Box.createHorizontalStrut(20));
        buttonPane.add(lastButton);
        contentPane.add((Component)buttonPane, "South");
        this.getRootPane().setDefaultButton(lastButton);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    protected void setDefaultComponent(int defIndex) {
        this._defaultComponentIndex = defIndex;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                Runnable focusRunnable = new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        JComponent[] components = 1.access$000(this.this$1)._dataPanel.getSwingComponents();
                        components[1.access$000(this.this$1)._defaultComponentIndex].requestFocusInWindow();
                    }
                };
                SwingUtilities.invokeLater(focusRunnable);
            }

            static /* synthetic */ DataEntryDialog access$000(1 x0) {
                return x0.DataEntryDialog.this;
            }
        });
    }

    public boolean showDialog() {
        this.show();
        switch (this._response) {
            case 0: {
                return false;
            }
            case 1: {
                return this._prevDlg.showDialog();
            }
            case 2: {
                return this._nextDlg.showDialog();
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(CANCEL_STRING)) {
            this._response = 0;
            this.dispose();
        } else if (actionCommand.equals(PREV_STRING)) {
            this._response = 1;
            this.dispose();
        } else {
            DataEntryElement[] elements = this.getDataEntryElements();
            for (int i = 0; i < elements.length; ++i) {
                DataEntryElement data = elements[i];
                if (data.isReadOnly()) continue;
                if (!data.checkValidEntry()) {
                    return;
                }
                data.setValueFromComponent();
            }
            this._response = actionCommand.equals(OK_STRING) ? 3 : 2;
            this.dispose();
        }
    }

    public void setPreviousDialog(DataEntryDialog prev) {
        this._prevDlg = prev;
    }

    public void setNextDialog(DataEntryDialog next) {
        this._nextDlg = next;
    }

    public DataEntryElement[] getDataEntryElements() {
        return this._dataPanel.getDataEntryElements();
    }

    public void setElementEnabled(int index, boolean enabled) {
        this._dataPanel.setElementEnabled(index, enabled);
    }
}

