/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.util.Enumeration;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.j2ee.Management;
import oracle.oc4j.admin.deploy.gui.AppJTreeBase;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.TargetModuleNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNodeSupport;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;

public class AppRootNode
extends ViewableJTreeNodeSupport {
    private AppJTreeBase _tree;
    private Target _target;
    private DeploymentManager _manager;

    public AppRootNode(Target target, DeploymentManager manager) {
        this._target = target;
        this._manager = manager;
    }

    public TargetModuleNode getApplicationNode(String appName) {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            TargetModuleNode node;
            Object obj = e.nextElement();
            if (!(obj instanceof TargetModuleNode) || !(node = (TargetModuleNode)obj).containsApplication(appName)) continue;
            return node;
        }
        return null;
    }

    protected TargetModuleNode getApplicationNode(TargetModuleID id) {
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            TargetModuleNode node;
            Object obj = e.nextElement();
            if (!(obj instanceof TargetModuleNode) || !(node = (TargetModuleNode)obj).containsTargetModuleID(id)) continue;
            return node;
        }
        return null;
    }

    protected void setAppTree(AppJTreeBase tree) {
        this._tree = tree;
    }

    protected AppJTreeBase getAppTree() {
        return this._tree;
    }

    protected String getTargetName() {
        return this._target.getName();
    }

    public void buildChildJTree() {
        Target[] targets = new Target[]{this._target};
        try {
            TargetModuleNode idNode;
            int i;
            TargetModuleID[] apps = this._manager.getAvailableModules(ModuleType.EAR, targets);
            Management mejb = ((ConnectedDeploymentManagerBase)this._manager).getMEJB();
            for (i = 0; i < apps.length; ++i) {
                idNode = new TargetModuleNode(mejb, apps[i]);
                this.addJTreeChild(idNode);
            }
            apps = this._manager.getAvailableModules(ModuleType.RAR, targets);
            for (i = 0; i < apps.length; ++i) {
                idNode = new TargetModuleNode(mejb, apps[i]);
                this.addJTreeChild(idNode);
            }
        }
        catch (TargetException te) {
            GuiUtil.errDialog("Error retrieving deployed object info: " + te.getMessage());
            te.printStackTrace();
        }
    }

    public String jtreeToolTip() {
        return this.viewHeaderString();
    }

    public String viewHeaderString() {
        return "J2ee Applications deployed to " + this._target.getName();
    }

    public String toString() {
        return "Deployed Applications";
    }

    public boolean leaf() {
        return false;
    }

    protected DeploymentManager deplManager() {
        return this._manager;
    }
}

