/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.j2ee.Management;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.oc4j.admin.deploy.gui.AppRootNode;
import oracle.oc4j.admin.deploy.gui.ClusterTargetModuleNode;
import oracle.oc4j.admin.deploy.gui.ControllerImpl;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.InstantiateableNode;
import oracle.oc4j.admin.deploy.gui.J2eeServerNode;
import oracle.oc4j.admin.deploy.gui.ModifiableRootNode;
import oracle.oc4j.admin.deploy.gui.RefreshableNode;
import oracle.oc4j.admin.deploy.gui.RemoveableNode;
import oracle.oc4j.admin.deploy.gui.TargetModuleNode;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.spi.ClusterDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.LifeCycleEvent;
import oracle.oc4j.admin.deploy.spi.LifeCycleListenerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;

public abstract class AppJTreeBase
extends ViewableJTree
implements ActionListener {
    protected static final String START_MENU_STRING = "Start";
    protected static final String STOP_MENU_STRING = "Stop";
    protected static final String REDEPLOY_MENU_STRING = "Redeploy";
    protected static final String UNDEPLOY_MENU_STRING = "Undeploy";
    protected JMenuItem _startMenuItem;
    protected JMenuItem _stopMenuItem;
    protected JMenuItem _redeployMenuItem;
    protected JMenuItem _undeployMenuItem;
    protected JPopupMenu _popupMenu;
    protected JMenuItem _addMenuItem;
    protected static final String REMOVE_MENU_STRING = "Remove";
    protected JMenuItem _removeMenuItem;
    protected static final String REFRESH_MENU_STRING = "Refresh";
    protected JMenuItem _refreshMenuItem;
    private String _newlyDeployedAppName;
    private String _newlyDeployedModuleIDName;
    private DeploymentManager _manager;
    protected static final String INSTANTIATE_MENU_STRING = "Instantiate";
    protected JMenuItem _instantiateMenuItem;

    protected AppJTreeBase(J2eeServerNode serverNode, DeploymentManager manager, boolean showRoot) {
        super(serverNode, showRoot);
        serverNode.getAppsNode().setAppTree(this);
        this._manager = manager;
        this.init();
    }

    protected AppJTreeBase(AppRootNode appRootNode, DeploymentManager manager, boolean showRoot) {
        super(appRootNode, showRoot);
        appRootNode.setAppTree(this);
        this._manager = manager;
        this.init();
    }

    protected void init() {
        this.createModuleMenuItems();
        this.createAddMenuItems();
        this.createRemoveMenuItems();
        this.createRefreshMenuItems();
        this.createInstantiateMenuItems();
        ProprietaryConnectedDeploymentManager pcdm = (ProprietaryConnectedDeploymentManager)this._manager;
        pcdm.addLifeCycleListener(new TargetLifeCycleListener());
    }

    protected void createModuleMenuItems() {
        this._startMenuItem = new JMenuItem(START_MENU_STRING);
        this._stopMenuItem = new JMenuItem(STOP_MENU_STRING);
        this._redeployMenuItem = new JMenuItem(REDEPLOY_MENU_STRING);
        this._undeployMenuItem = new JMenuItem(UNDEPLOY_MENU_STRING);
        this._startMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._stopMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._redeployMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._undeployMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._startMenuItem.setFont(GuiUtil.getRegularFont());
        this._stopMenuItem.setFont(GuiUtil.getRegularFont());
        this._redeployMenuItem.setFont(GuiUtil.getRegularFont());
        this._undeployMenuItem.setFont(GuiUtil.getRegularFont());
        this._startMenuItem.addActionListener(this);
        this._stopMenuItem.addActionListener(this);
        this._redeployMenuItem.addActionListener(this);
        this._undeployMenuItem.addActionListener(this);
        this._redeployMenuItem.setEnabled(!(this._manager instanceof ClusterDeploymentManager));
    }

    protected void addTargetModuleMenuItems() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        this._popupMenu.add(this._startMenuItem);
        this._popupMenu.add(this._stopMenuItem);
        this._popupMenu.add(this._redeployMenuItem);
        this._popupMenu.add(this._undeployMenuItem);
    }

    protected void createAddMenuItems() {
        this._addMenuItem = new JMenuItem();
        this._addMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._addMenuItem.setFont(GuiUtil.getRegularFont());
        this._addMenuItem.addActionListener(this);
    }

    protected void addAddMenuItems(String type) {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        this._addMenuItem.setText("Add " + type);
        this._popupMenu.add(this._addMenuItem);
    }

    protected void createRemoveMenuItems() {
        this._removeMenuItem = new JMenuItem(REMOVE_MENU_STRING);
        this._removeMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._removeMenuItem.setFont(GuiUtil.getRegularFont());
        this._removeMenuItem.addActionListener(this);
    }

    protected void addRemoveMenuItems() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        this._popupMenu.add(this._removeMenuItem);
    }

    protected void createRefreshMenuItems() {
        this._refreshMenuItem = new JMenuItem(REFRESH_MENU_STRING);
        this._refreshMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._refreshMenuItem.setFont(GuiUtil.getRegularFont());
        this._refreshMenuItem.addActionListener(this);
    }

    protected void addRefreshMenuItems() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        this._popupMenu.add(this._refreshMenuItem);
    }

    protected void createInstantiateMenuItems() {
        this._instantiateMenuItem = new JMenuItem(INSTANTIATE_MENU_STRING);
        this._instantiateMenuItem.setBackground(Deployer.MenuBackgroundColor);
        this._instantiateMenuItem.setFont(GuiUtil.getRegularFont());
        this._instantiateMenuItem.addActionListener(this);
    }

    protected void addInstantiateMenuItems() {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
        }
        this._popupMenu.add(this._instantiateMenuItem);
    }

    public JPopupMenu getPopupForNode(ViewableJTreeNode node) {
        Collection col;
        this._popupMenu = null;
        if (node instanceof TargetModuleNode && ((TargetModuleNode)node).isRootNode()) {
            this.addTargetModuleMenuItems();
        }
        if (node instanceof ModifiableRootNode) {
            ModifiableRootNode mrnode = (ModifiableRootNode)((Object)node);
            this.addAddMenuItems(mrnode.childType());
        }
        if (node instanceof RefreshableNode) {
            this.addRefreshMenuItems();
        }
        if (node instanceof RemoveableNode) {
            this.addRemoveMenuItems();
        }
        if (node instanceof InstantiateableNode) {
            this.addInstantiateMenuItems();
        }
        if ((col = node.getPopupMenuItems(this)) != null) {
            if (this._popupMenu == null) {
                this._popupMenu = new JPopupMenu();
            }
            Iterator it = col.iterator();
            while (it.hasNext()) {
                this._popupMenu.add((JMenuItem)it.next());
            }
        }
        return this._popupMenu;
    }

    public void setTargeted(boolean targeted) {
        this._redeployMenuItem.setEnabled(targeted);
    }

    public void appUnDeployed(TargetModuleNode node, TargetModuleID id) {
        RemoveAppRunnable rar = new RemoveAppRunnable(node);
        SwingUtilities.invokeLater(rar);
    }

    public void appUnDeployed(String appName) {
        RemoveAppRunnable rar = new RemoveAppRunnable(appName);
        SwingUtilities.invokeLater(rar);
    }

    public void newClusterAppDeployed(String appName, TargetModuleID[] ids, boolean selectApp) {
        this._newlyDeployedAppName = appName;
        AddAppRunnable aar = new AddAppRunnable(ids, selectApp);
        SwingUtilities.invokeLater(aar);
    }

    public void newAppDeployed(String appName, TargetModuleID id, boolean selectApp) {
        this._newlyDeployedAppName = appName;
        TargetModuleID oldApp = this.getOneTargetModuleIDForApp(appName);
        if (oldApp != null) {
            RemoveAppRunnable removeApp = new RemoveAppRunnable(appName);
            SwingUtilities.invokeLater(removeApp);
        }
        AddAppRunnable aar = new AddAppRunnable(id, selectApp);
        SwingUtilities.invokeLater(aar);
    }

    public abstract AppRootNode getAppRootNode();

    public abstract TreePath getAppRootPath();

    public TargetModuleID[] getAllTargetModuleIDsForApp(String appName) {
        return new TargetModuleID[]{this.getOneTargetModuleIDForApp(appName)};
    }

    public TargetModuleID getOneTargetModuleIDForApp(String appName) {
        AppRootNode appRoot = this.getAppRootNode();
        Enumeration e = appRoot.children();
        while (e.hasMoreElements()) {
            TargetModuleNode tmp;
            Object obj = e.nextElement();
            if (!(obj instanceof TargetModuleNode) || !(tmp = (TargetModuleNode)obj).getName().equals(appName)) continue;
            return tmp.getTargetModuleID();
        }
        return null;
    }

    public String[] getAppsForSelectedTargets() {
        Vector<String> apps = new Vector<String>();
        AppRootNode appRoot = this.getAppRootNode();
        Enumeration e = appRoot.children();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof TargetModuleNode)) continue;
            TargetModuleNode tmp = (TargetModuleNode)obj;
            apps.add(tmp.getName());
        }
        return apps.toArray(new String[apps.size()]);
    }

    public void actionPerformed(ActionEvent e) {
        ViewableJTreeNode jtnode;
        TreePath parentPath;
        Object obj = this.getLastSelectedPathComponent();
        if (obj instanceof TargetModuleNode) {
            TargetModuleNode node = (TargetModuleNode)obj;
            if (e.getActionCommand().equals(START_MENU_STRING)) {
                ControllerImpl.getSingletonController().start(node);
            } else if (e.getActionCommand().equals(STOP_MENU_STRING)) {
                ControllerImpl.getSingletonController().stop(node);
            } else if (e.getActionCommand().equals(REDEPLOY_MENU_STRING)) {
                ControllerImpl.getSingletonController().redeploy(node);
            } else {
                ControllerImpl.getSingletonController().undeploy(node);
            }
        }
        if (e.getActionCommand().equals(REMOVE_MENU_STRING)) {
            parentPath = this.getSelectionPath().getParentPath();
            if (((RemoveableNode)obj).removeNode()) {
                TreeNode parent = ((ViewableJTreeNode)obj).getParent();
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(parent);
                this.setSelectionPath(parentPath);
            }
        } else if (e.getActionCommand().equals(INSTANTIATE_MENU_STRING)) {
            parentPath = this.getSelectionPath().getParentPath();
            if (!((InstantiateableNode)obj).instantiateNode()) {
                TreeNode parent = ((ViewableJTreeNode)obj).getParent();
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(parent);
                this.setSelectionPath(parentPath);
            }
        } else if (e.getActionCommand().equals(REFRESH_MENU_STRING)) {
            parentPath = this.getSelectionPath().getParentPath();
            if (((RefreshableNode)obj).refreshNode()) {
                TreeNode parent = ((ViewableJTreeNode)obj).getParent();
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(parent);
                this.setSelectionPath(parentPath);
            }
        } else if (obj instanceof ModifiableRootNode && (jtnode = ((ModifiableRootNode)obj).addNewChildNode()) != null) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged((ViewableJTreeNode)obj);
            TreePath path = this.getSelectionPath();
            path = path.pathByAddingChild(jtnode);
            this.makeVisible(path);
            this.setSelectionPath(path);
        }
    }

    protected void selectNewlyDeployedApplicationNode() {
        AppRootNode appRoot = this.getAppRootNode();
        TreePath treePath = this.getAppRootPath();
        Enumeration e = appRoot.children();
        while (e.hasMoreElements()) {
            TargetModuleNode tmp;
            Object obj = e.nextElement();
            if (!(obj instanceof TargetModuleNode) || !(tmp = (TargetModuleNode)obj).getName().equals(this._newlyDeployedAppName)) continue;
            treePath = treePath.pathByAddingChild(tmp);
            this.makeVisible(treePath);
            this.setSelectionPath(treePath);
            return;
        }
    }

    protected void addNewClusterApplicationNode(TargetModuleID[] ids) {
        AppRootNode appRoot = this.getAppRootNode();
        Management mejb = ((ConnectedDeploymentManagerBase)this._manager).getMEJB();
        appRoot.addJTreeChild(new ClusterTargetModuleNode(mejb, ids));
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(appRoot);
        ProprietaryTargetModuleID pid = (ProprietaryTargetModuleID)ids[0];
        this._newlyDeployedModuleIDName = pid.getObjectName().getKeyProperty("name");
    }

    protected void addNewApplicationNode(TargetModuleID id) {
        AppRootNode appRoot = this.getAppRootNode();
        Management mejb = ((ConnectedDeploymentManagerBase)this._manager).getMEJB();
        appRoot.addJTreeChild(new TargetModuleNode(mejb, id));
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(appRoot);
        ProprietaryTargetModuleID pid = (ProprietaryTargetModuleID)id;
        this._newlyDeployedModuleIDName = pid.getObjectName().getKeyProperty("name");
    }

    protected void removeApplicationNode(TargetModuleNode node) {
        AppRootNode appRoot = this.getAppRootNode();
        appRoot.removeJTreeChild(node);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(appRoot);
        this.setSelectionPath(this.getPathForRow(0));
    }

    class TargetLifeCycleListener
    extends LifeCycleListenerBase {
        TargetLifeCycleListener() {
        }

        public void handleEvent(LifeCycleEvent event) {
        }
    }

    class RemoveAppRunnable
    implements Runnable {
        TargetModuleNode _node;

        RemoveAppRunnable(String appName) {
            AppRootNode appRoot = AppJTreeBase.this.getAppRootNode();
            this._node = appRoot.getApplicationNode(appName);
        }

        RemoveAppRunnable(TargetModuleID id) {
            AppRootNode appRoot = AppJTreeBase.this.getAppRootNode();
            this._node = appRoot.getApplicationNode(id);
        }

        RemoveAppRunnable(TargetModuleNode node) {
            this._node = node;
        }

        public void run() {
            AppJTreeBase.this.removeApplicationNode(this._node);
        }
    }

    class AddAppRunnable
    implements Runnable {
        TargetModuleID _id;
        TargetModuleID[] _ids;
        boolean _select;

        AddAppRunnable(TargetModuleID id, boolean select) {
            this._id = id;
            this._select = select;
        }

        AddAppRunnable(TargetModuleID[] ids, boolean select) {
            this._ids = ids;
            this._select = select;
        }

        public void run() {
            if (this._id != null) {
                AppJTreeBase.this.addNewApplicationNode(this._id);
            } else {
                AppJTreeBase.this.addNewClusterApplicationNode(this._ids);
            }
            if (this._select) {
                AppJTreeBase.this.selectNewlyDeployedApplicationNode();
            }
        }
    }
}

