/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.oc4j.admin.deploy.cmdline.util.ApplicationStatus;
import oracle.oc4j.admin.deploy.cmdline.util.CustomizedOutputUtils;

public class CommandOutputHelper {
    private static final String DEFAULT_FSEP = " | ";
    private static final String DEFAULT_RSEP = "\n";
    private static String _fieldSep = " | ";
    private static String _recSep = "\n";
    private static boolean _showHeader = true;

    public static void printMap(Map instanceAppMap, String command, boolean verbose) {
        CommandOutputHelper.printMap(instanceAppMap, command, null, verbose, System.out);
    }

    public static void printMap(Map instanceAppMap, String command, boolean verbose, OutputStream out) {
        CommandOutputHelper.printMap(instanceAppMap, command, null, verbose, new PrintStream(out));
    }

    public static void printMap(Map instanceAppMap, String command, String webSiteName, boolean verbose) {
        CommandOutputHelper.printMap(instanceAppMap, command, webSiteName, verbose, System.out);
    }

    public static void printMap(Map instanceAppMap, String command, String webSiteName, boolean verbose, OutputStream out) {
        CommandOutputHelper.printMap(instanceAppMap, command, webSiteName, verbose, new PrintStream(out));
    }

    public static void printMap(Map instanceAppMap, String command, String webSiteName, boolean verbose, PrintStream out) {
        Iterator instanceAppIter = instanceAppMap.entrySet().iterator();
        while (instanceAppIter.hasNext()) {
            Map.Entry entry = instanceAppIter.next();
            String instanceName = (String)entry.getKey();
            Vector appVector = (Vector)entry.getValue();
            CommandOutputHelper.printTitle(instanceName, command, webSiteName, out);
            if (appVector == null && command.equalsIgnoreCase("listWebBindings")) {
                CommandOutputHelper.printWebSiteNotExistError(webSiteName, out);
                continue;
            }
            TreeMap rowMap = new TreeMap(CommandOutputHelper.createMap(appVector, command, verbose));
            List columnListWithMaxWidth = CommandOutputHelper.getMaxColumnWidthFromMap(rowMap, command, verbose);
            CommandOutputHelper.printTableHeader(columnListWithMaxWidth, out);
            CommandOutputHelper.printRows(rowMap, columnListWithMaxWidth, out);
        }
    }

    static Map createMap(Vector appVector, String command, boolean verbose) {
        HashMap<String, List> rowMap = new HashMap<String, List>();
        for (int i = 0; i < appVector.size(); ++i) {
            ApplicationStatus appStatus = (ApplicationStatus)appVector.get(i);
            List rowValues = null;
            if (command.equals("listApplications")) {
                rowValues = CommandOutputHelper.fillInAppValues(appStatus, verbose);
            } else if (command.equals("listWebBindings")) {
                rowValues = CommandOutputHelper.fillInBindingValues(appStatus, verbose);
            }
            rowMap.put(appStatus.getAppName(), rowValues);
        }
        return rowMap;
    }

    private static List fillInAppValues(ApplicationStatus appStatus, boolean verbose) {
        ArrayList<String> rowValues = null;
        rowValues = verbose ? new ArrayList<String>(ApplicationStatus.verboseAttributes.length) : new ArrayList(ApplicationStatus.attributes.length);
        rowValues.add(appStatus.getAppName());
        rowValues.add(appStatus.getModuleName());
        rowValues.add(appStatus.getModuleType());
        rowValues.add(appStatus.getState());
        rowValues.add(appStatus.getParent());
        if (verbose) {
            rowValues.add(appStatus.getWebContextRoot());
            rowValues.add(Boolean.toString(appStatus.getRoutable()));
            rowValues.add(appStatus.getJGroupName());
            rowValues.add(appStatus.getJGroupProtocol());
        }
        return rowValues;
    }

    private static List fillInBindingValues(ApplicationStatus appStatus, boolean verbose) {
        ArrayList<String> rowValues = null;
        rowValues = verbose ? new ArrayList<String>(ApplicationStatus.verboseBindings.length) : new ArrayList(ApplicationStatus.bindings.length);
        rowValues.add(appStatus.getAppName());
        rowValues.add(appStatus.getModuleName());
        rowValues.add(appStatus.getWebContextRoot());
        rowValues.add(appStatus.getWebSite());
        if (verbose) {
            rowValues.add(Boolean.toString(appStatus.getPreload()));
            rowValues.add(Boolean.toString(appStatus.getShared()));
            rowValues.add(Boolean.toString(appStatus.getAccessLog()));
            rowValues.add(appStatus.getMaxInactivityTime());
        }
        return rowValues;
    }

    private static List getMaxColumnWidthFromMap(Map rowMap, String command, boolean verbose) {
        int rowSize = rowMap.size();
        int columnSize = 0;
        Iterator rowIter = rowMap.entrySet().iterator();
        if (rowIter.hasNext()) {
            List appAttributes = (List)rowIter.next().getValue();
            columnSize = appAttributes.size();
        }
        String[][] columnArrays = new String[columnSize][rowSize];
        int rowIndex = 0;
        rowIter = rowMap.entrySet().iterator();
        while (rowIter.hasNext()) {
            List appAttributes = (List)rowIter.next().getValue();
            for (int columnIndex = 0; columnIndex < appAttributes.size(); ++columnIndex) {
                String att = (String)appAttributes.get(columnIndex);
                if (att == null) {
                    att = "";
                }
                if (columnIndex == 0 && att.indexOf(":") != -1) {
                    att = att.substring(0, att.indexOf(":"));
                }
                columnArrays[columnIndex][rowIndex] = att;
            }
            ++rowIndex;
        }
        ArrayList<CustomizedOutputUtils> columnList = new ArrayList<CustomizedOutputUtils>(columnSize);
        for (int i = 0; i < columnSize; ++i) {
            String label = CommandOutputHelper.getLabelName(command, i, verbose);
            int maxColumnLength = label.length();
            for (int j = 0; j < rowSize; ++j) {
                if (columnArrays[i][j].length() <= maxColumnLength) continue;
                maxColumnLength = columnArrays[i][j].length();
            }
            columnList.add(new CustomizedOutputUtils(label, maxColumnLength, 'L'));
        }
        return columnList;
    }

    private static String getLabelName(String command, int i, boolean verbose) {
        String label = null;
        if (command.equals("listApplications")) {
            label = verbose ? ApplicationStatus.verboseAttributes[i] : ApplicationStatus.attributes[i];
        } else if (command.equals("listWebBindings")) {
            label = verbose ? ApplicationStatus.verboseBindings[i] : ApplicationStatus.bindings[i];
        }
        return label;
    }

    private static void printTitle(String headerInstance, String command, String webSiteName, PrintStream out) {
        if (!_showHeader) {
            return;
        }
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        if (command.equals("listApplications")) {
            CustomizedOutputUtils.printCustomizedTable("Applications in instance: " + headerInstance, out);
        } else if (command.equals("listWebBindings")) {
            if (webSiteName == null) {
                CustomizedOutputUtils.printCustomizedTable("Web bindings in instance: " + headerInstance, out);
            } else {
                CustomizedOutputUtils.printCustomizedTable("Web bindings in instance: " + headerInstance + " for " + webSiteName, out);
            }
        }
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
    }

    private static void printWebSiteNotExistError(String webSiteName, PrintStream out) {
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        CustomizedOutputUtils.printCustomizedTable("Error: The web-site " + webSiteName + " does not exist in this instance.", out);
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
    }

    private static void printTableHeader(List columnList, PrintStream out) {
        String bar = CommandOutputHelper.constructBar(columnList);
        String labelList = CommandOutputHelper.constructLabelList(columnList, out);
        CommandOutputHelper.printHeader("", bar, labelList, out);
    }

    private static String constructBar(List columnList) {
        StringBuffer bar = new StringBuffer();
        if (!_showHeader) {
            return bar.toString();
        }
        for (int i = 0; i < columnList.size(); ++i) {
            CustomizedOutputUtils col = (CustomizedOutputUtils)columnList.get(i);
            String lab = col.getLabel();
            int lablen = col.length != 0 ? col.length : lab.length();
            for (int j = 0; j < lablen; ++j) {
                bar = bar.append("-");
            }
            if (i + 1 >= columnList.size()) continue;
            bar = bar.append("-+-");
        }
        return bar.toString();
    }

    private static String constructLabelList(List columnList, PrintStream out) {
        StringBuffer labelList = new StringBuffer();
        if (!_showHeader) {
            return labelList.toString();
        }
        for (int i = 0; i < columnList.size(); ++i) {
            CustomizedOutputUtils col = (CustomizedOutputUtils)columnList.get(i);
            String lab = col.getLabel();
            labelList = col.length == 0 ? labelList.append(CustomizedOutputUtils.printCustomizedTable(lab, false, out)) : labelList.append(CustomizedOutputUtils.printCustomizedTable(lab, col.length, col.just, false, out));
            if (i + 1 >= columnList.size()) continue;
            labelList = labelList.append(CustomizedOutputUtils.printCustomizedTable(_fieldSep, false, out));
        }
        return labelList.toString();
    }

    private static void printHeader(String title, String bar, String labelList, PrintStream out) {
        if (title != null) {
            CustomizedOutputUtils.printCustomizedTable(_recSep, out);
            CustomizedOutputUtils.printCustomizedTable(title, out);
            CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        }
        CustomizedOutputUtils.printCustomizedTable(bar, out);
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        CustomizedOutputUtils.printCustomizedTable(labelList, out);
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        CustomizedOutputUtils.printCustomizedTable(bar, out);
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
    }

    private static void printRows(Map rowMap, List columnList, PrintStream out) {
        Iterator rowIter = rowMap.entrySet().iterator();
        while (rowIter.hasNext()) {
            Map.Entry oneRow = rowIter.next();
            List appAttributes = (List)oneRow.getValue();
            for (int j = 0; j < appAttributes.size(); ++j) {
                String att;
                if (j != 0) {
                    CustomizedOutputUtils.printCustomizedTable(_fieldSep, out);
                }
                if ((att = (String)appAttributes.get(j)) == null) {
                    att = "";
                }
                if (j == 0 && att.indexOf(":") != -1) {
                    att = att.substring(0, att.indexOf(":"));
                }
                CustomizedOutputUtils ou = (CustomizedOutputUtils)columnList.get(j);
                CustomizedOutputUtils.printCustomizedTable(att, ou, out);
            }
            CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        }
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
        CustomizedOutputUtils.printCustomizedTable(_recSep, out);
    }
}

