/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.io.File;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class UpdateEJBModuleCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-updateEJBModule";
    public static final String COMMANDMENU = "-updateEJBModule -appName <appname> -ejbModuleName <name> -file <path>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -updateEJBModule [<switch>]\n   - Replaces an existing EJB module with a new EJB JAR in the specified\n     application.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -ejbModuleName <name>       - Required  The name of the EJB JAR as defined\n                                           in application.xml.\n   -file <path>                - Required  The path of the new EJB JAR.\n\n";
    private String _appName = null;
    private String _filePath = null;
    private String _moduleName = null;

    public UpdateEJBModuleCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("updateEJBModule subcommand");
            if (command.equalsIgnoreCase("-appname")) {
                this._appName = this.getNextArgument("application name");
                continue;
            }
            if (command.equalsIgnoreCase("-ejbmodulename")) {
                this._moduleName = this.getNextArgument("ejb module name");
                continue;
            }
            if (command.equalsIgnoreCase("-file")) {
                this._filePath = this.getNextArgument("new ejb module file path");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_updateejbmoudle_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._appName, "-appName");
        this.checkArgIsNull(this._moduleName, "-moduleName");
        if (this._filePath == null) {
            this._filePath = this._moduleName;
        }
    }

    protected void doExecute() throws AdminCommandException {
        File packageFile = new File(this._filePath);
        if (!packageFile.exists()) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("unable_find_archive", new String[]{this._filePath}));
        }
        if (packageFile.isDirectory()) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("not_an_archive", new String[]{this._filePath}));
        }
        if (!this._filePath.endsWith(".jar")) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("not_a_jar_file", new String[]{this._filePath}));
        }
        try {
            this._j2eeDeplMgr.updateEJBModule(this._appName, this._moduleName, this._filePath);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("error_updateejbmodule", new String[]{e.getMessage()}));
        }
    }
}

