/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class TestDatabaseConnectionCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-testDatabaseConnection";
    static final String APPNAME = "-applicationName";
    static final String SQLSTMT = "-sqlStatement";
    static final String FACTORYCLASS = "-factoryClass";
    static final String USER = "-dbUser";
    static final String PASSWORD = "-dbPassword";
    static final String URL = "-url";
    static final String COMMANDMENU = "-testDatabaseConnection -factoryClass <factoryClass> -dbUser <dbUser> -dbPassword <dbPassword> \n                         -url <url> -sqlStatement <sqlStatement>";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDatabaseConnection\n   - Test a JDBC connection.\n\nValid switches are: \n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -factoryClass <factoryClass>                        - Required  The JDBC factory to test (instance of Driver, DataSource, ConnectionPoolDataSource, or XADataSource.\n   -dbUser <user>                                      - Required  The user to use.\n   -dbPassword <password>                              - Required  The password to use.\n   -url <url>                                          - Required  The URL to set on the JDBC factory.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n\n";
    String _applicationName;
    String _sqlStatement;
    String _factoryClass;
    String _user;
    String _password;
    String _url;

    public TestDatabaseConnectionCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("-testDatabaseConnection subcommand");
            if (command.equalsIgnoreCase(APPNAME)) {
                this._applicationName = this.getNextArgument("-applicationName ");
                continue;
            }
            if (command.equalsIgnoreCase(SQLSTMT)) {
                this._sqlStatement = this.getNextArgument("-sqlStatement ");
                continue;
            }
            if (command.equalsIgnoreCase(FACTORYCLASS)) {
                this._factoryClass = this.getNextArgument("-factoryClass ");
                continue;
            }
            if (command.equalsIgnoreCase(USER)) {
                this._user = this.getNextArgument("-dbUser ");
                continue;
            }
            if (command.equalsIgnoreCase(PASSWORD)) {
                this._password = this.getNextArgument("-dbPassword ");
                continue;
            }
            if (command.equalsIgnoreCase(URL)) {
                this._url = this.getNextArgument("-url ");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_testDatabaseConnection_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._sqlStatement, SQLSTMT);
        this.checkArgIsNull(this._factoryClass, FACTORYCLASS);
        this.checkArgIsNull(this._user, USER);
        this.checkArgIsNull(this._password, PASSWORD);
        this.checkArgIsNull(this._url, URL);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            System.out.println(this._j2eeDeplMgr.testDatabaseConnection(this._applicationName, this._sqlStatement, this._factoryClass, this._user, this._password, this._url));
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("testDatabaseConnection_error", new String[]{e.getMessage()}), e);
        }
    }
}

