/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandParser;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsage;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXClusterRuntimeException;

public class Oc4jAdminCmdline {
    public static void main(String[] args) {
        if (args == null || args.length == 0 || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-h")) {
            System.out.println(AdminCommandUsage.getUsage());
            return;
        }
        if (args[0].equalsIgnoreCase("-usage")) {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            String command = null;
            try {
                command = AdminCommandUtils.getNextArgument(arguments, "-usage");
                command = AdminCommandUtils.getNextArgument(arguments, "<command>");
                System.out.println(AdminCommandUsage.getUsage(command));
            }
            catch (AdminCommandException e) {
                System.err.println(e.getMessage());
                e.printStackTrace(System.err);
            }
            return;
        }
        Oc4jAdminCmdline.executeCommand(args);
        System.exit(0);
    }

    public static void executeCommand(String[] args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        String url = null;
        String usr = null;
        String pwd = null;
        boolean debug = false;
        try {
            Object command;
            if (AdminCommandUtils.readNextArgument(arguments).equals("-debug")) {
                AdminCommandUtils.getNextArgument(arguments, "-debug");
                debug = true;
                TraceLogger.setDefaultLevel((Level)Level.SEVERE);
            }
            url = AdminCommandUtils.getNextArgument(arguments, "<url>");
            usr = AdminCommandUtils.getNextArgument(arguments, "username");
            pwd = AdminCommandUtils.getNextArgument(arguments, "password");
            if (AdminCommandUsage.isExistingCommand(pwd)) {
                try {
                    command = pwd;
                    pwd = AdminCommandUtils.queryPasswordFromUser();
                    arguments.add(0, (String)command);
                }
                catch (IOException e) {
                    throw new AdminCommandException("Error reading password from the standard input.");
                }
                catch (AdminCommandException ace) {
                    throw ace;
                }
            }
            command = AdminCommandParser.parse(arguments);
            ((AdminCommandBase)command).execute(url, usr, pwd);
        }
        catch (AdminCommandUsageException e) {
            System.err.println("\n" + FormattingResourceBundle.DeploymentMessages.getString("admin_command_usage_error", new String[]{e.getMessage()}) + "\n\n" + FormattingResourceBundle.DeploymentMessages.getString("correct_usage", new String[]{AdminCommandUsage.getUsage(e.getCommand())}));
            System.exit(1);
        }
        catch (AdminCommandException ae) {
            if (debug) {
                ae.printStackTrace();
                for (Throwable tmp = ae.getCause(); tmp != null; tmp = tmp.getCause()) {
                    if (!(tmp instanceof JMXClusterRuntimeException)) continue;
                    Map causes = ((JMXClusterRuntimeException)tmp).getCauses();
                    Set keys = causes.keySet();
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        Throwable t = (Throwable)causes.get(it.next());
                        System.out.println("\nJMXClusterRuntimeException cause: ");
                        t.printStackTrace();
                    }
                }
            }
            System.err.println("\n" + ae.getMessage() + "\n");
            System.exit(1);
        }
    }
}

