/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import com.evermind.util.AdminProperties;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class DeployCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-deploy";
    public static final String COMMANDMENU = "-deploy -file <filename> -deploymentName <appname> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -deploy [<switch>]\n   - (Re)deploys an EAR, WAR, RAR or EJB JAR file. \n\nValid switches are:\n   -file <path>           - Required  The file path of the archive or\n                                      application directory to be deployed.\n   -deploymentName <name> - Required  The name to assign to the deployed \n                                      application. \n   -targetPath <path>     - Optional  The directory to deploy the archive to.\n                                      Default is the application-directory \n                                      defined in server.xml.\n   -parent <name>         - Optional  The name of the archive's parent \n                                      application. If omitted, sets the \n                                      'default' application as the parent.\n   -deploymentDirectory <path> \n                          - Optional  The directory containing the \n                                      OC4J-specific deployment descriptors\n                                      and generated files. Default is the \n                                      deployment-directory defined in \n                                      server.xml.\n   -removeArchive         - Optional  Enable removing the archive after the \n                                      application is deployed.\n   -enableIIOP            - Optional  Enable interoperability (IIOP) for the\n                                      application deployed.\n   -iiopClientJar <path>  - Optional  The client path to place the IIOP \n                                      client stubs for EJBs.\n   -nativeLibPath <path>  - Optional  Used for standalone RAR file deployment\n                                      only. The path to the native libraries\n                                      within the RAR.\n   -grantAllPermissions   - Optional  Used for standalone RAR file deployment\n                                      only. Grant all runtime permissions.\n   -contextRoot <root>    - Optional  Used for standalone WAR file deployment\n                                      only. The context root for the Web \n                                      module. If omitted, the -deploymentName\n                                      value is used.\n   -sequential [waitsec]  - Optional  Deploy the archive to each OC4J instance\n                                      within the cluster in sequence. If you\n                                      specify waitsec, admin_client waits waitsec\n                                      between deployments to the different \n                                      instances. If not included, the archive \n                                      is simultaneously deployed to all instances.\n   -bindAllWebApps [<web_site_name>]\n                          - Optional  Binds all WAR files within the EAR to\n                                      specified Web site. If omitted, modules\n                                      are bound to the 'default-web-site'.\n   -deploymentPlan <path> - Optional  Local deployment plan to config the app\n                                      when it is deployed.\n\n";
    private String _fileName = null;
    private String _appName = null;
    private Map _extraParams = new HashMap();
    private String _clientJarPath = null;
    private boolean _serialized = false;
    private String _deploymentPlanPath = null;
    private InputStream _deploymentPlanStream = null;

    public DeployCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String nextArg;
            String command = this.getNextArgument("deployment subcommand");
            if (command.equalsIgnoreCase("-file")) {
                this._fileName = this.getNextArgument("deployment -file filename");
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentname")) {
                this._appName = this.getNextArgument("deployment name");
                continue;
            }
            if (command.equalsIgnoreCase("-targetpath")) {
                this._extraParams.put("targetPath", this.getNextArgument("-targetPath argument"));
                continue;
            }
            if (command.equalsIgnoreCase("-parent")) {
                this._extraParams.put("parent", this.getNextArgument("-parent argument"));
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentdirectory")) {
                this._extraParams.put("deploymentDirectory", this.getNextArgument("-deploymentDirectory"));
                continue;
            }
            if (command.equalsIgnoreCase("-autoCreatetables")) {
                this._extraParams.put("autoCreateTables", this.getNextArgument("-autoCreateTables"));
                continue;
            }
            if (command.equalsIgnoreCase("-enableIIOP")) {
                this._extraParams.put("enableIIOP", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-removeArchive")) {
                this._extraParams.put("removeArchive", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-iiopclientjar")) {
                this._clientJarPath = this.getNextArgument("-iiopClientJar");
                this._extraParams.put("returnClientJar", "true");
                this._extraParams.put("iiopClientJarPath", this._clientJarPath);
                continue;
            }
            if (command.equalsIgnoreCase("-nativelibpath")) {
                this._extraParams.put("nativeLibPath", this.getNextArgument("-nativeLibPath"));
                continue;
            }
            if (command.equalsIgnoreCase("-grantallpermissions")) {
                this._extraParams.put("grantAllPermissions", "true");
                continue;
            }
            if (command.equalsIgnoreCase("-contextroot")) {
                this._extraParams.put("contextRoot", this.getNextArgument("-contextRoot"));
                continue;
            }
            if (command.equalsIgnoreCase("-sequential")) {
                nextArg = this.readNextArgument();
                if (nextArg != null && !nextArg.startsWith("-")) {
                    this._extraParams.put("sequentialDelay", this.getNextArgument("delay value in sequential option"));
                }
                this._serialized = true;
                continue;
            }
            if (command.equalsIgnoreCase("-bindallwebapps")) {
                nextArg = this.readNextArgument();
                if (nextArg == null || nextArg.startsWith("-")) {
                    this._extraParams.put("bindWebApp", "default-web-site");
                    continue;
                }
                this._extraParams.put("bindWebApp", this.getNextArgument("web site name for -bindAllWebApps"));
                continue;
            }
            if (command.equalsIgnoreCase("-deploymentPlan")) {
                this._deploymentPlanPath = this.getNextArgument("_deploymentPlan");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_deploy_switch", new String[]{command}), COMMANDNAME);
        }
        boolean donotundeploy = AdminProperties.getDoNotUndeployPrevious();
        this._extraParams.put("undeployPrevious", donotundeploy ? "false" : "true");
        this.checkArgIsNull(this._fileName, "-file");
        this.checkArgIsNull(this._appName, "-deploymentName");
        this.checkArgs();
    }

    protected void doExecute() throws AdminCommandException {
        File packageFile = new File(this._fileName);
        try {
            if (this._deploymentPlanStream != null) {
                this._j2eeDeplMgr.deploy(packageFile.getAbsolutePath(), this._appName, this._extraParams, this._deploymentPlanStream, this._serialized);
            } else if (this._deploymentPlanPath != null) {
                this._j2eeDeplMgr.deploy(packageFile.getAbsolutePath(), this._appName, this._extraParams, this._deploymentPlanPath, this._serialized);
            } else {
                this._j2eeDeplMgr.deploy(packageFile.getAbsolutePath(), this._appName, this._extraParams, this._serialized);
            }
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("deploy_error", new String[]{e.getMessage()}), e);
        }
    }

    private void checkArgs() {
        if (DeploymentUtils.isWar(this._fileName)) {
            if (this._deploymentPlanPath != null) {
                this._deploymentPlanStream = DeploymentUtils.findContextRootInDeploymentPlan(this._fileName, this._extraParams, this._deploymentPlanPath);
            }
            DeploymentUtils.findContextRootInArchive(this._fileName, this._extraParams);
            DeploymentUtils.setDefaultContextRoot(this._appName, this._extraParams);
        }
    }
}

