/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.HashMap;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class BindWebAppCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-bindWebApp";
    public static final String COMMANDMENU = "-bindWebApp -appName <appname> -webModuleName <name> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -bindWebApp  [<switch>]\n   - Binds the specified WAR to a specified Web site and/or context root.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -webModuleName <name>       - Required  The Web module name.\n   -webSiteName <name>         - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n   -contextRoot <contextRoot>  - Optional  Context root for the WAR file. \n                                           If omitted, the context root in \n                                           the parent application's \n                                           application.xml is used.\n   -shared <true/false>        - Optional  Allows application to be shared\n                                           between HTTP/HTTPS, defaults to\n                                           'false'.\n   -loadOnStartup <true/false> - Optional  Allows application to be loaded\n                                           on startup, defaults to 'true'.\n   -accessLog <true/false>     - Optional  Allows application to enable access\n                                           logging, defaults to 'true'.\n\n";
    private String _appName;
    private String _webName;
    private String _siteName;
    private String _root;
    private HashMap _optionalParams = null;
    public static final String LOAD_ON_STARTUP = "loadOnStartup";
    public static final String ACCESS_LOG = "accessLog";
    public static final String SHARED = "shared";

    public BindWebAppCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("bindWebApp subcommand");
            if (command.equalsIgnoreCase("-appname")) {
                this._appName = this.getNextArgument("appName");
                continue;
            }
            if (command.equalsIgnoreCase("-webmodulename")) {
                this._webName = this.getNextArgument("webModuleName");
                continue;
            }
            if (command.equalsIgnoreCase("-websitename")) {
                this._siteName = this.getNextArgument("webSiteName");
                continue;
            }
            if (command.equalsIgnoreCase("-contextroot")) {
                this._root = this.getNextArgument("contextRoot");
                continue;
            }
            if (command.equalsIgnoreCase("-loadOnStartup")) {
                this.putOptionalParams(LOAD_ON_STARTUP, this.getNextArgument(LOAD_ON_STARTUP));
                continue;
            }
            if (command.equalsIgnoreCase("-accessLog")) {
                this.putOptionalParams(ACCESS_LOG, this.getNextArgument(ACCESS_LOG));
                continue;
            }
            if (command.equalsIgnoreCase("-shared")) {
                this.putOptionalParams(SHARED, this.getNextArgument(SHARED));
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_bindwebapp_switch", new String[]{command}), COMMANDNAME);
        }
        if (this._siteName == null) {
            this._siteName = "default-web-site";
        }
        this.checkArgIsNull(this._appName, "-appName");
        this.checkArgIsNull(this._webName, "-webModuleName");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.bindWebApp(this._appName, this._webName, this._siteName, this._root, this._optionalParams);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("bindwebapp_error", new String[]{e.getMessage()}), e);
        }
    }

    private void putOptionalParams(String key, String value) {
        if (this._optionalParams == null) {
            this._optionalParams = new HashMap();
        }
        this._optionalParams.put(key, value);
    }
}

