/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import javax.management.MBeanException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;

public class AddWebSiteCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-addWebSite";
    public static final String COMMANDMENU = "-addWebSite -webSiteName <site-name> -protocol <protocol> -port <port> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addWebSite [<switch>]\n   - Add a new web site.\n\nValid switches are: \n  -webSiteName <site-name>     -Required The name of the new web site.\n  -protocol <protocol>         -Required The protocol of the new web site.\n  -port <port>                 -Required The port number of the web site.\n  -keystorePath <path>         -Optional filename including path of the keystore file.\n  -keystorePassword <password> -Optional password of the keystore file.\n  -sslProvider <class-name>    -Optional the third-party SSLServerSocketFactory\n                                         implementation if not use default.\n\n";
    private String _siteName = null;
    private String _protocol = null;
    private int _port = -1;
    private String _keystorePath = null;
    private String _keystorePassword = null;
    private String _sslProvider = null;

    public AddWebSiteCommand(List args) throws AdminCommandException {
        super(args);
        String portstr = null;
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("addWebSite subcommand");
            if (command.equalsIgnoreCase("-webSiteName")) {
                this._siteName = this.getNextArgument("webSiteName");
                continue;
            }
            if (command.equalsIgnoreCase("-protocol")) {
                this._protocol = this.getNextArgument("-protocol");
                continue;
            }
            if (command.equalsIgnoreCase("-port")) {
                portstr = this.getNextArgument("port");
                try {
                    this._port = Integer.parseInt(portstr);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("addwebsite_invalid_port", new String[]{portstr}), "addWebSite");
                }
            }
            if (command.equalsIgnoreCase("-keystorePath")) {
                this._keystorePath = this.getNextArgument("keystorePath");
                continue;
            }
            if (command.equalsIgnoreCase("-keystorePassword")) {
                this._keystorePassword = this.getNextArgument("keystorePassword");
                continue;
            }
            if (command.equalsIgnoreCase("-sslProvider")) {
                this._sslProvider = this.getNextArgument("sslProvider");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_addwebsite_switch", new String[]{command}), COMMANDNAME);
        }
        this.checkArgIsNull(this._siteName, "-webSiteName");
        this.checkArgIsNull(this._protocol, "-protocol");
        this.checkArgIsNull(portstr, "-port");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.addWebSite(this._siteName, this._protocol, this._port, this._keystorePath, this._keystorePassword, this._sslProvider);
            System.out.println("addWebSite success: added website " + this._siteName + " listening on port " + this._port + " using protocol " + this._protocol + ".");
        }
        catch (Exception e) {
            Exception root = this.getRootException(e);
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("addwebsite_error", new String[]{root.getMessage()}), root);
        }
    }

    protected Exception getRootException(Exception e) {
        Exception cause;
        Exception exp = e;
        while ((exp instanceof JMXRuntimeException || exp instanceof MBeanException) && (cause = (Exception)exp.getCause()) != null) {
            exp = cause;
        }
        return exp;
    }
}

