/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.core.ojdl.BufferedLogWriter;
import oracle.core.ojdl.BusStopLogWriterException;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LoggingException;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.RotationSupport;
import oracle.core.ojdl.Util;

public class BusStopLogWriter
extends BufferedLogWriter
implements RotationSupport {
    private static final String LOG_FILE_NAME = "log.xml";
    private static final String SEGMENT_FILE_PREFIX = "log";
    private static final String SEGMENT_FILE_SUFFIX = ".xml";
    private static final int MAX_TRIES = 1;
    private File m_logDir;
    private String m_canonicalPath;
    private File m_logFile;
    private boolean m_keepOpen = true;
    private FileOutputStream m_out;
    private long m_logSize;
    private long m_maxSegSize;
    private long m_maxSize;
    private boolean m_deleteFiles = true;
    private static final long FREQUENCY_UNIT = 60000L;
    private static final long MAX_FREQUENCY = 128849018820000L;
    private long m_baseTime = 0L;
    private long m_rotationFrequency = 128849018820000L;
    private long m_nextRotationTime = Long.MAX_VALUE;
    private long m_lastRotationTime;
    private int m_createCount = 0;
    private static Hashtable s_instances = new Hashtable();
    private static boolean isWin = System.getProperty("os.name").startsWith("Windows");

    private BusStopLogWriter(File file, long l, long l2, String string) throws BusStopLogWriterException {
        super(string);
        this.m_logDir = file;
        this.m_logFile = new File(this.m_logDir, LOG_FILE_NAME);
        this.m_maxSegSize = l > 0L ? l : Long.MAX_VALUE;
        this.m_maxSize = l2 > 0L ? l2 : Long.MAX_VALUE;
        this.m_createCount = 1;
        this.m_lastRotationTime = this.m_logFile.exists() ? this.m_logFile.lastModified() : System.currentTimeMillis();
        if (this.m_keepOpen) {
            try {
                this.m_out = this.getFileOutputStream();
            }
            catch (IOException iOException) {
                throw new BusStopLogWriterException(iOException);
            }
            this.m_logSize = this.m_logFile.length();
        }
    }

    public static BusStopLogWriter create(String string, long l, long l2, String string2) throws BusStopLogWriterException {
        String string3;
        if (l <= 0L) {
            throw new BusStopLogWriterException("Invalid argument: maximum segment size must be greater than zero.");
        }
        if (l2 <= 0L) {
            throw new BusStopLogWriterException("Invalid argument: maximum size must be greater than zero.");
        }
        if (l2 < l) {
            throw new BusStopLogWriterException("Invalid arguments: maximum segment size greater than maximum bus stop size");
        }
        if (string2 != null) {
            LogManager.getLogManager();
            if (LogManager.checkEncoding(string2) == null) {
                throw new BusStopLogWriterException("Invalid encoding: " + string2);
            }
        } else {
            string2 = LogManager.getLogManager().getEncoding();
        }
        File file = BusStopLogWriter.getBusStopDir(string);
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = file.getAbsolutePath();
        }
        BusStopLogWriter busStopLogWriter = (BusStopLogWriter)s_instances.get(string3);
        if (busStopLogWriter != null) {
            ++busStopLogWriter.m_createCount;
            return busStopLogWriter;
        }
        busStopLogWriter = new BusStopLogWriter(file, l, l2, string2);
        s_instances.put(string3, busStopLogWriter);
        busStopLogWriter.m_canonicalPath = string3;
        return busStopLogWriter;
    }

    public static BusStopLogWriter create(String string) throws BusStopLogWriterException {
        return BusStopLogWriter.create(string, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to close an already closed LogWriter"));
            return;
        }
        if (--this.m_createCount > 0) {
            this.flush();
            return;
        }
        super.close();
        try {
            try {
                if (this.m_keepOpen && this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException iOException) {
                this.handleException(iOException);
                Object var3_2 = null;
                this.m_out = null;
                this.m_logSize = 0L;
                this.m_logDir = null;
                this.m_logFile = null;
                s_instances.remove(this.m_canonicalPath);
                return;
            }
            Object var3_1 = null;
            this.m_out = null;
            this.m_logSize = 0L;
            this.m_logDir = null;
            this.m_logFile = null;
            s_instances.remove(this.m_canonicalPath);
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.m_out = null;
            this.m_logSize = 0L;
            this.m_logDir = null;
            this.m_logFile = null;
            s_instances.remove(this.m_canonicalPath);
            throw throwable;
        }
    }

    public String toString() {
        try {
            return this.getClass().getName() + ":" + this.m_logDir.getCanonicalPath();
        }
        catch (Exception exception) {
            return this.getClass().getName() + ":" + this.m_logDir.getAbsolutePath();
        }
    }

    protected void writeBytes(byte[] byArray, int n, int n2) {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to write to a closed LogWriter"));
            return;
        }
        try {
            long l = this.getLogSize();
            if (this.needRotation(l, n2)) {
                Vector vector = BusStopLogWriter.getSegmentFiles(this.m_logDir);
                long l2 = this.getTotalSize(l, vector);
                boolean bl = false;
                if (l2 + this.m_maxSegSize > this.m_maxSize) {
                    if (!this.m_deleteFiles) {
                        this.handleException(new LoggingException("Reached maximum log size"));
                        return;
                    }
                    bl = true;
                }
                if (this.rotate(l, vector) && bl) {
                    try {
                        this.deleteFiles(l2, vector);
                    }
                    catch (Exception exception) {
                        this.handleException(new LoggingException("cannot delete old segment file"));
                    }
                }
            }
            this.writeToStream(byArray, n, n2);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public synchronized void rotateLog() {
        if (!this.isOpened()) {
            this.handleException(new LoggingException("Attempt to operate on a closed LogWriter"));
            return;
        }
        try {
            this.rotate(this.getLogSize(), BusStopLogWriter.getSegmentFiles(this.m_logDir));
            this.m_logFile.createNewFile();
            if (this.m_keepOpen) {
                this.m_out = this.getFileOutputStream();
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public synchronized void setMaxSize(long l) {
        if (l > 0L && l >= this.getMaxSegmentSize()) {
            this.m_maxSize = l;
        }
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public synchronized void setMaxSegmentSize(long l) {
        if (l > 0L && l <= this.getMaxSize()) {
            this.m_maxSegSize = l;
        }
    }

    public long getMaxSegmentSize() {
        return this.m_maxSegSize;
    }

    public void setBaseRotationTime(long l) {
        this.m_baseTime = l;
        this.m_nextRotationTime = this.getNextRotationTime();
    }

    public long getBaseRotationTime() {
        return this.m_baseTime;
    }

    public void setRotationFrequency(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("frequency:" + n);
        }
        this.m_rotationFrequency = (long)n * 60000L;
        this.m_nextRotationTime = this.getNextRotationTime();
    }

    public int getRotationFrequency() {
        return (int)(this.m_rotationFrequency / 60000L);
    }

    public void setDeleteFiles(boolean bl) {
        this.m_deleteFiles = bl;
    }

    public boolean getDeleteFiles() {
        return this.m_deleteFiles;
    }

    public boolean getKeepOpen() {
        return this.m_keepOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeepOpen(boolean bl) {
        if (bl == this.m_keepOpen) {
            return;
        }
        if (this.m_keepOpen && this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
            finally {
                this.m_out = null;
                this.m_logSize = 0L;
            }
        }
        this.m_keepOpen = bl;
    }

    private boolean isOpened() {
        return this.m_logDir != null;
    }

    private FileOutputStream getFileOutputStream() throws IOException {
        return new FileOutputStream(this.m_logFile.getAbsolutePath(), true);
    }

    private void writeToStream(byte[] byArray, int n, int n2) throws IOException {
        FileOutputStream fileOutputStream;
        if (!this.m_keepOpen) {
            fileOutputStream = this.getFileOutputStream();
        } else {
            if (this.m_out == null) {
                this.m_out = this.getFileOutputStream();
            }
            fileOutputStream = this.m_out;
        }
        fileOutputStream.write(byArray, n, n2);
        this.m_logSize += (long)n2;
        if (!this.m_keepOpen) {
            fileOutputStream.close();
        }
    }

    private long getLogSize() {
        if (this.m_keepOpen && this.m_out != null) {
            return this.m_logSize;
        }
        return this.m_logFile.length();
    }

    private boolean needRotation(long l, int n) {
        if (l > 0L && l + (long)n > this.m_maxSegSize) {
            return true;
        }
        return System.currentTimeMillis() >= this.m_nextRotationTime;
    }

    private long getNextRotationTime() {
        if (this.m_rotationFrequency == 128849018820000L) {
            return Long.MAX_VALUE;
        }
        long l = this.m_baseTime + (this.m_lastRotationTime - this.m_baseTime) / this.m_rotationFrequency * this.m_rotationFrequency;
        if (this.m_baseTime <= this.m_lastRotationTime) {
            l += this.m_rotationFrequency;
        }
        return l > this.m_lastRotationTime ? l : Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rotate(long l, Vector vector) {
        if (!this.m_logFile.exists()) {
            return true;
        }
        if (this.m_keepOpen && this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
            finally {
                this.m_out = null;
                this.m_logSize = 0L;
            }
        }
        this.m_lastRotationTime = System.currentTimeMillis();
        boolean bl = !isWin ? this.rotate1(l, vector) : this.rotateNT(l, vector);
        if (bl) {
            this.m_lastRotationTime = System.currentTimeMillis();
            if (this.m_lastRotationTime >= this.m_nextRotationTime) {
                this.m_nextRotationTime = this.getNextRotationTime();
            }
        }
        return bl;
    }

    private boolean rotate1(long l, Vector vector) {
        int n;
        Vector vector2 = vector;
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        for (n = 0; n < 1; ++n) {
            String string = this.getNextSegmentName(vector2);
            if (string == null) {
                return false;
            }
            file = new File(this.m_logDir, string + SEGMENT_FILE_SUFFIX);
            try {
                bl = file.createNewFile();
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) break;
            if (this.m_logFile.length() < l) {
                return true;
            }
            vector2 = BusStopLogWriter.getSegmentFiles(this.m_logDir);
        }
        if (!bl) {
            this.handleException(new LoggingException("Failed to create segment file after 1 attempts " + file.getName()));
            return false;
        }
        for (n = 0; n < 1; ++n) {
            try {
                bl2 = this.m_logFile.renameTo(file);
            }
            catch (Exception exception) {
                this.handleException(exception);
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            if (this.m_logFile.length() >= l) continue;
            return true;
        }
        this.handleException(new LoggingException("Failed to rename log file after 1 attempts"));
        return false;
    }

    private boolean rotateNT(long l, Vector vector) {
        Vector vector2 = vector;
        boolean bl = false;
        boolean bl2 = false;
        File file = null;
        for (int i = 0; i < 1; ++i) {
            String string = this.getNextSegmentName(vector2);
            if (string == null) {
                return false;
            }
            file = new File(this.m_logDir, string + SEGMENT_FILE_SUFFIX);
            try {
                bl2 = this.m_logFile.renameTo(file);
            }
            catch (Exception exception) {
                this.debug("rename exception: " + exception);
                bl2 = false;
            }
            if (bl2) break;
            if (this.m_logFile.length() < l) {
                this.debug("renamed failed " + l);
                return true;
            }
            vector2 = BusStopLogWriter.getSegmentFiles(this.m_logDir);
        }
        if (!bl2) {
            this.handleException(new LoggingException("Failed to archive log file after 1 attempts " + file.getName()));
            return false;
        }
        return true;
    }

    private long getTotalSize(long l, Vector vector) {
        long l2 = l;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            File file = new File(this.m_logDir, string);
            l2 += file.length();
        }
        return l2;
    }

    private void deleteFiles(long l, Vector vector) {
        Util.sortLogFiles(vector);
        for (int i = 0; i < vector.size() && l + this.m_maxSegSize > this.m_maxSize; ++i) {
            File file = new File(this.m_logDir, (String)vector.elementAt(i));
            long l2 = file.length();
            l -= l2;
            if (file.delete()) {
                this.internalLog("Deleted log file: " + file.getName() + ", size = " + l2 + " bytes");
                continue;
            }
            this.debug("*** delete failed " + file.getName());
        }
    }

    private void internalLog(String string) {
        try {
            LogMessage logMessage = new LogMessage("Oracle", "OJDL", null, null, MessageType.NOTIFICATION, null, 16, this.getClass().getName(), null, null, null, null, null, null, string, null, null, null);
            String string2 = this.getFormatter().format(logMessage);
            byte[] byArray = string2.getBytes();
            this.writeToStream(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void handleException(Exception exception) {
        this.getExceptionHandler().onException(exception);
    }

    private static File getBusStopDir(String string) throws BusStopLogWriterException {
        File file = null;
        if (string == null) {
            throw new BusStopLogWriterException("Bus stop name is null");
        }
        file = new File(string);
        try {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new BusStopLogWriterException(string + " is not a directory");
                }
            } else if (!file.mkdirs()) {
                throw new BusStopLogWriterException("cannot create directory " + string);
            }
            if (!file.canWrite()) {
                throw new BusStopLogWriterException("cannot write to directory " + string);
            }
        }
        catch (SecurityException securityException) {
            throw new BusStopLogWriterException("access to bus stop " + string + " is denied");
        }
        return file;
    }

    private static Vector getSegmentFiles(File file) {
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (BusStopLogWriter.getSegmentNumber(stringArray[i]) <= 0L) continue;
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    static long getSegmentNumber(String string) {
        if (!string.startsWith(SEGMENT_FILE_PREFIX)) {
            return -1L;
        }
        int n = SEGMENT_FILE_PREFIX.length();
        int n2 = string.lastIndexOf(SEGMENT_FILE_SUFFIX);
        try {
            return Long.parseLong(string.substring(n, n2));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private String getNextSegmentName(Vector vector) {
        long l = 0L;
        for (int i = 0; i < vector.size(); ++i) {
            long l2 = BusStopLogWriter.getSegmentNumber((String)vector.elementAt(i));
            if (l2 <= l) continue;
            l = l2;
        }
        if (l == Long.MAX_VALUE) {
            this.handleException(new LoggingException("out of log file names"));
            return null;
        }
        return SEGMENT_FILE_PREFIX + (l + 1L);
    }
}

