/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.pojo.annotations.AccessType;
import com.intersys.pojo.annotations.CollectionType;
import com.intersys.pojo.annotations.RelationshipType;
import com.intersys.pojo.tools.objects.ClassMetadata;
import com.intersys.pojo.tools.objects.PropertyMetadata;
import com.intersys.pojo.tools.objects.RelationshipMetadata;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateHandler
extends DefaultHandler {
    private static final int COLLECTION_NONE = 0;
    private static final int COLLECTION_MAP = 1;
    private static final int COLLECTION_LIST = 2;
    private int isCollection;
    private AccessType accessType;
    private SAXParser saxParser;
    private HashMap<Class, ClassMetadata> classMetadata;
    private String className;
    private Class currentClass;
    private ClassMetadata classInfo;
    private Class currentEmbeddedClass = null;
    private ClassMetadata embeddedClassInfo = null;
    private PropertyMetadata propertyInfo;
    private String propertyName;
    private String packageName = null;

    public HibernateHandler(Class clazz) {
        this();
        this.currentClass = clazz;
    }

    public HibernateHandler() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            this.saxParser = sAXParserFactory.newSAXParser();
            this.classMetadata = new HashMap();
            this.isCollection = 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.accessType = AccessType.PROPERTY;
    }

    public HashMap<Class, ClassMetadata> parse(File file) throws Throwable {
        this.saxParser.parse(file, (DefaultHandler)this);
        return this.classMetadata;
    }

    public HashMap<Class, ClassMetadata> parse(String string) throws Throwable {
        this.saxParser.parse(string, (DefaultHandler)this);
        return this.classMetadata;
    }

    public HashMap<Class, ClassMetadata> parse(InputStream inputStream) throws Throwable {
        this.saxParser.parse(inputStream, (DefaultHandler)this);
        return this.classMetadata;
    }

    private void getClassInfo(Attributes attributes) throws ClassNotFoundException {
        this.classInfo = new ClassMetadata();
        this.classInfo.setAccessType(this.accessType);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                if (this.packageName != null) {
                    string2 = this.packageName + "." + string2;
                }
                if (this.currentClass == null) {
                    this.currentClass = Class.forName(string2);
                }
                this.classInfo.setClassName(string2);
                continue;
            }
            if (string.equals("table")) {
                this.classInfo.setSQLTableName(string2);
                continue;
            }
            if (!string.equals("proxy") && !string.equals("batch-size") && !string.equals("mutable") && !string.equals("dynamic-update") && !string.equals("polymorphism") && !string.equals("optimistic-lock") && !string.equals("dynamic-insert") && !string.equals("select-before-update") && !string.equals("discriminator-value") && !string.equals("select-before-update")) continue;
        }
    }

    private void getEmbeddedClassInfo(Attributes attributes) throws ClassNotFoundException {
        this.embeddedClassInfo = new ClassMetadata();
        this.classInfo.setAccessType(this.accessType);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1, string2.length());
                if (this.packageName != null) {
                    string3 = this.packageName + "." + string3;
                }
                this.currentEmbeddedClass = this.classForName(string3);
                this.embeddedClassInfo.setClassName(string3);
                this.embeddedClassInfo.setIsSerial();
                continue;
            }
            if (string.equals("table")) {
                this.embeddedClassInfo.setSQLTableName(string2);
                continue;
            }
            if (!string.equals("update") && !string.equals("insert")) continue;
        }
    }

    private void getMappingInfo(Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("package")) {
                this.packageName = string2;
                continue;
            }
            if (string.equals("auto-import")) continue;
            if (string.equals("default-access")) {
                if (!"field".equals(string2)) continue;
                this.accessType = AccessType.FIELD;
                continue;
            }
            if (!string.equals("default-cascade")) continue;
        }
    }

    private void getPropertyInfo(Attributes attributes) throws SAXException {
        this.propertyInfo = new PropertyMetadata();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                this.propertyInfo.setName(this.propertyName);
                continue;
            }
            if (string.equals("column")) {
                this.propertyInfo.setSQLColumnName(string2);
                continue;
            }
            if (!string.equals("not-null") && !string.equals("insert") && !string.equals("update") && !string.equals("unique")) continue;
        }
    }

    private void getIDInfo(Attributes attributes) throws SAXException {
        this.propertyInfo = new PropertyMetadata();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.classInfo.setDatabaseIDType(0);
                this.classInfo.setDatabaseID(string2);
                continue;
            }
            if (!string.equals("unsaved-value")) continue;
        }
    }

    private void getBagInfo(Attributes attributes) throws SAXException {
        this.propertyInfo = new PropertyMetadata();
        this.propertyInfo.setCollectionType(CollectionType.ARRAY);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getLocalName(i);
            String string2 = attributes.getValue(i);
            if (string.equals("name")) {
                this.propertyName = string2;
                this.propertyInfo.setName(this.propertyName);
                continue;
            }
            if (!string.equals("lazy") && !string.equals("inverse") && !string.equals("batch-size") && !string.equals("cascade") && !string.equals("outer-join")) continue;
        }
    }

    private void getRelationshipInfo(Attributes attributes, RelationshipType relationshipType) throws SAXException {
        String string = null;
        String string2 = null;
        if (this.isCollection == 0) {
            this.propertyInfo = new PropertyMetadata();
        }
        try {
            Object object;
            for (int i = 0; i < attributes.getLength(); ++i) {
                string = attributes.getLocalName(i);
                String string3 = attributes.getValue(i);
                if (string.equals("name")) {
                    this.propertyName = string3;
                    this.propertyInfo.setName(this.propertyName);
                    continue;
                }
                if (string.equals("unique") || string.equals("not-null") || string.equals("outer-join") || string.equals("insert") || string.equals("update") || !string.equals("class")) continue;
                string2 = string3;
            }
            if (string2 == null) {
                object = this.getPropertyKey(this.propertyName);
                Class<?> clazz = object instanceof Field ? ((Field)object).getType() : ((Method)object).getReturnType();
                string2 = clazz.getName();
            } else {
                if (string2.indexOf(".") == -1) {
                    string2 = this.packageName + "." + string2;
                }
                Class clazz = this.classForName(string2);
            }
            object = "";
            if (((String)object).equals("")) {
                // empty if block
            }
            RelationshipMetadata relationshipMetadata = new RelationshipMetadata(relationshipType, false, string2, (String)object);
            this.propertyInfo.setRelationship(relationshipMetadata);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            if (string2.equals("class")) {
                this.getClassInfo(attributes);
            } else if (string2.equals("property")) {
                this.getPropertyInfo(attributes);
            } else if (string2.equals("id")) {
                this.getIDInfo(attributes);
            } else if (string2.equals("bag") || string2.equals("map")) {
                this.isCollection = 1;
                this.getBagInfo(attributes);
            } else if (!string2.equals("key")) {
                if (string2.equals("one-to-many")) {
                    if (this.isCollection != 0) {
                        this.isCollection = 0;
                    }
                    this.getRelationshipInfo(attributes, RelationshipType.ONE_TO_MANY);
                } else if (string2.equals("many-to-one")) {
                    if (this.isCollection != 0) {
                        this.isCollection = 0;
                    }
                    this.getRelationshipInfo(attributes, RelationshipType.MANY_TO_ONE);
                } else if (string2.equals("component")) {
                    this.getEmbeddedClassInfo(attributes);
                } else if (!string2.equals("subclass") && string2.equals("hibernate-mapping")) {
                    this.getMappingInfo(attributes);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new SAXException(classNotFoundException);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SAXException(sAXException);
        }
    }

    private void dumpAttributes(String string, Attributes attributes) {
        System.out.println(string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            System.out.println(attributes.getLocalName(i) + "  " + attributes.getValue(i));
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (string2.equals("class")) {
                this.classMetadata.put(this.currentClass, this.classInfo);
                return;
            }
            if (string2.equals("property")) {
                if (this.embeddedClassInfo != null && this.currentEmbeddedClass != null) {
                    this.embeddedClassInfo.addPropertyMetadata(this.getEmbeddedPropertyKey(this.propertyName), this.propertyInfo);
                    return;
                } else {
                    this.classInfo.addPropertyMetadata(this.getPropertyKey(this.propertyName), this.propertyInfo);
                }
                return;
            }
            if (string2.equals("one-to-many") || string2.equals("many-to-one")) {
                this.propertyInfo.setName(this.propertyName);
                this.classInfo.addPropertyMetadata(this.getPropertyKey(this.propertyName), this.propertyInfo);
                return;
            }
            if (string2.equals("bag") || string2.equals("map")) {
                if (this.isCollection != 1) return;
                this.classInfo.addPropertyMetadata(this.getPropertyKey(this.propertyName), this.propertyInfo);
                return;
            }
            if (string2.equals("component")) {
                this.classMetadata.put(this.currentEmbeddedClass, this.embeddedClassInfo);
                this.propertyInfo = new PropertyMetadata();
                String string4 = this.embeddedClassInfo.getClassName();
                String string5 = string4.substring(string4.lastIndexOf(46) + 1, string4.length());
                string5 = string5.substring(0, 1).toLowerCase() + string5.substring(1, string5.length());
                this.propertyInfo.setName(string5);
                this.classInfo.addPropertyMetadata(this.getPropertyKey(string5), this.propertyInfo);
                this.currentEmbeddedClass = null;
                this.embeddedClassInfo = null;
                return;
            }
            if (!string2.equals("subclass") && !string2.equals("id")) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SAXException(exception);
        }
    }

    private Class classForName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, this.currentClass.getClassLoader());
    }

    private Member getPropertyKey(String string) throws Exception {
        return HibernateHandler.getPropertyKey(this.currentClass, string, this.accessType);
    }

    private Member getEmbeddedPropertyKey(String string) throws Exception {
        return HibernateHandler.getPropertyKey(this.currentEmbeddedClass, string, this.accessType);
    }

    private static Member getPropertyKey(Class clazz, String string, AccessType accessType) throws Exception {
        switch (accessType) {
            case PROPERTY: {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (!string.equals(propertyDescriptorArray[i].getName())) continue;
                    return propertyDescriptorArray[i].getReadMethod();
                }
                throw new IllegalStateException("No info for proeprty: " + string);
            }
            case FIELD: {
                return clazz.getDeclaredField(string);
            }
        }
        throw new IllegalStateException("No access type for current mapping.");
    }

    public static void main(String[] stringArray) throws Throwable {
        HibernateHandler hibernateHandler = new HibernateHandler();
        hibernateHandler.parse(stringArray[0]);
    }
}

