/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.SysList;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public final class OutStream {
    protected LogFileStream logFile;
    public SysList wire;
    private int protocolVersion = 41;
    protected OutputStream outputStream;

    public OutStream(OutputStream outputStream, LogFileStream logFileStream) {
        this.outputStream = outputStream;
        this.logFile = logFileStream;
        this.wire = new SysList();
    }

    protected void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public final synchronized void send(int n) throws SQLException {
        try {
            if (this.protocolVersion >= 32) {
                this.wire.dumpData(this.outputStream, n, this.logFile);
            } else {
                this.wire.dumpData(this.outputStream, n);
                if (this.logFile != null) {
                    this.logFile.dump(this.wire, 0, 1, null);
                }
            }
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getMessage(), "08S01", 461);
        }
    }

    protected final synchronized SysList setWire(SysList sysList) {
        SysList sysList2 = this.wire;
        this.wire = sysList;
        return sysList2;
    }
}

