/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStaticResultSet;
import com.intersys.jdbc.CacheUpdatableResultSet;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.FakeStream;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.Preparser;
import com.intersys.jdbc.RealStream;
import com.intersys.jdbc.SysList;
import com.intersys.jdbc.preparser.StatementTypes;
import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class CacheStatement
implements Statement {
    protected int maxRows = 0;
    protected boolean genericExecuteCalled = false;
    protected CacheConnection connection;
    protected CacheResultSet myResultSet = null;
    protected Vector columns;
    protected Vector parameters;
    protected int serverCursorNumber;
    protected int statementType;
    protected boolean fetchDone = false;
    protected InStream input;
    protected OutStream output;
    protected String sqlText;
    protected String originalSqlText;
    protected int hasReturnValue;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int fetchSize = 0;
    protected int parameterSets = 0;
    protected int batchCount = 0;
    protected SysList outputParameterList;
    protected SysList batch = null;
    protected String batchException = "none";
    protected boolean closed = false;
    protected int updateCnt;
    protected String autoGeneratedKeyColumn = null;
    protected boolean multipleResultSets = false;
    protected int queryTimeout = 0;
    protected String updatableRSTableName = null;
    protected String[] updatableRSColumnNames = null;
    protected static final int NO_RETURN_VALUE = 0;
    protected static final int IGNORE_RETURN_VALUE = 1;
    protected static final int HAS_RETURN_VALUE = 2;
    protected static final int NULL_RETURN_VALUE = 3;
    protected static final String BATCH_EXCEPTION_NONE = "none";
    protected static final String BATCH_EXCEPTION_QUERY = "query";
    protected static final String BATCH_EXCEPTION_SP = "stored procedure";
    protected static final int UPDATE = 0;
    protected static final int QUERY = 1;
    protected static final int CALL = 2;
    protected static final int SYNC_COMMIT = 3;
    protected static final int ASYNC_COMMIT = 4;
    protected static final int STREAMS_OFF = 5;
    protected static final int STREAMS_ON = 6;
    protected static final int CALLWITHRESULT = 7;
    protected static final int DDL_ALTER_DROP = 8;
    protected static final int DDL_OTHER = 9;
    protected static final int DIRECT_CALL_QUERY = 10;
    protected static final int DIRECT_CALL_UPDATE = 11;
    protected static final int PREPARED_CALL_QUERY = 12;
    protected static final int PREPARED_CALL_UPDATE = 13;

    CacheStatement(CacheConnection cacheConnection, int n, int n2, String string) throws SQLException {
        this.connection = cacheConnection;
        this.parameters = new Vector();
        try {
            this.input = new InStream(this.connection);
            this.output = new OutStream(this.connection.outputStream, this.connection.logFile);
            this.output.wire.setMaxItemSize(32000);
            this.output.setProtocolVersion(this.connection.protocolVersion);
            this.input.wire.setServerType(this.connection.isUnicodeServer, this.connection.serverLocale);
            this.output.wire.setServerType(this.connection.isUnicodeServer, this.connection.serverLocale);
        }
        catch (IOException iOException) {
            throw new SQLException("Communication link failure: " + iOException.getMessage(), "08S01", 461);
        }
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.serverCursorNumber = 0;
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = string;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (string.equals("**getQuickStatement**")) {
            this.columns = new Vector();
            this.myResultSet = new CacheResultSet(this);
            return this.myResultSet;
        }
        this.genericExecuteCalled = false;
        this.Query(string);
        this.myResultSet = this.createResultSet();
        this.updateCnt = -1;
        return this.myResultSet;
    }

    protected CacheResultSet createResultSet() throws SQLException {
        if (this.resultSetConcurrency == 1008) {
            return new CacheUpdatableResultSet(this);
        }
        if (this.resultSetType == 1004) {
            return new CacheStaticResultSet(this);
        }
        return new CacheResultSet(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Query(String string) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(string);
        }
        this.fetchDone = false;
        if (this.statementType != 1 && this.statementType != 2) {
            throw new SQLException("executeQuery called with a non-query", "24000", 24000);
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType != 10) {
                throw new SQLException("executeQuery called with a non-query", "24000", 24000);
            }
            return;
        }
        if (this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                if (this.resultSetType == 1004) {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_STATIC_CURSOR);
                } else {
                    this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_QUERY_EXECUTE);
                }
                this.writeParameters(this.output.wire);
                if (this.connection.protocolVersion > 38) {
                    this.output.wire.set(this.queryTimeout);
                    this.output.wire.set(this.maxRows);
                }
                this.output.send(this.connection.messageCount.getCount());
                this.handleError504(this.input.readHeader(this.serverCursorNumber, 0, 504));
            }
        } else {
            this.sendDirectQueryRequest(false);
        }
    }

    protected void handleError504(int n) throws SQLException {
        if (n == 404) {
            this.query404();
        } else if (n == 100) {
            this.fetchDone = true;
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectQueryRequest(boolean bl) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            if (this.resultSetType == 1004) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STATIC_CURSOR);
            } else {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_QUERY);
            }
            this.output.wire.setSQLText(this.sqlText, this.connection.protocolVersion);
            this.writeParameters(this.output.wire);
            if (this.connection.protocolVersion > 38) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            int n = this.input.readHeader(this.serverCursorNumber, 0, 100);
            if (bl) {
                this.verifyColumnInfo(this.input.wire);
            } else {
                this.columnInfo(this.input.wire);
            }
            this.parameterInfo(this.input.wire);
            if (this.connection.protocolVersion > 2 && this.resultSetType == 1003) {
                n = this.input.readHeader(this.serverCursorNumber, 0, 100);
            }
            if (n == 100) {
                this.fetchDone = true;
                this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, null, this.columns, this.parameters, this.statementType, this.hasReturnValue);
            } else {
                this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, this, this.columns, this.parameters, this.statementType, this.hasReturnValue);
            }
        }
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.genericExecuteCalled = false;
        this.Update(string);
        if (this.connection.protocolVersion < 14 || this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        return this.updateCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Update(String string) throws SQLException {
        if (!this.genericExecuteCalled) {
            this.cleanUp();
            this.preparse(string);
        }
        if (this.statementType == 1) {
            throw new SQLException("executeUpdate called with a query", "24000", 24000);
        }
        this.validateParameters();
        if (this.statementType == 2) {
            this.executeStoredProcedure();
            if (this.statementType == 10) {
                throw new SQLException("executeUpdate called with a query", "24000", 24000);
            }
            return;
        }
        if (this.statementType != 8 && this.statementType != 9 && this.getCachedInfo(this.sqlText)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.PREPARED_UPDATE_EXECUTE);
                if (this.connection.protocolVersion > 36) {
                    this.output.wire.set(this.autoGeneratedKeyColumn);
                }
                this.writeParameters(this.output.wire);
                if (this.connection.protocolVersion == 35) {
                    this.output.wire.set(this.autoGeneratedKeyColumn);
                }
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                    this.update404();
                }
            }
        } else {
            this.sendDirectUpdateRequest();
        }
        this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendDirectUpdateRequest() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_UPDATE);
            this.output.wire.setSQLText(this.sqlText, this.connection.protocolVersion);
            if (this.connection.protocolVersion > 36) {
                this.output.wire.set(this.autoGeneratedKeyColumn);
            }
            this.writeParameters(this.output.wire);
            if (this.connection.protocolVersion == 35) {
                this.output.wire.set(this.autoGeneratedKeyColumn);
            }
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 100);
            this.parameterInfo(this.input.wire);
            if (this.statementType != 8 && this.statementType != 9) {
                this.connection.addCachedPrepare(this.sqlText, this.serverCursorNumber, null, null, this.parameters, this.statementType, this.hasReturnValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.connection.protocolVersion >= 40 && this.connection.isOwner(this.serverCursorNumber, this)) {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.CLOSE_STATEMENT);
                this.output.send(this.connection.messageCount.getCount());
            }
        }
        this.fetchDone = false;
        this.genericExecuteCalled = false;
        this.maxRows = 0;
        this.fetchSize = 0;
        this.parameterSets = 0;
        this.batchCount = 0;
        this.batch = null;
        this.batchException = BATCH_EXCEPTION_NONE;
        if (this.parameters != null) {
            this.parameters.removeAllElements();
        }
        if (this.columns != null) {
            this.columns.removeAllElements();
        }
        if (this.myResultSet != null) {
            this.myResultSet.close();
        }
        if (!this.connection.isClosed()) {
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            this.connection.poolStatement(this);
        }
        this.updateCnt = 0;
        this.autoGeneratedKeyColumn = null;
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
        this.closed = true;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public int getMaxFieldSize() throws SQLException {
        return this.input.wire.getMaxFieldSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int n) throws SQLException {
        Object object = this.input;
        synchronized (object) {
            this.input.wire.setMaxFieldSize(n);
        }
        object = this.output;
        synchronized (object) {
            this.output.wire.setMaxFieldSize(n);
        }
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Invalid number of rows specified: " + n, "S1000");
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void cancel() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void setCursorName(String string) throws SQLException {
    }

    private synchronized boolean executeStoredProcedure() throws SQLException {
        if (this.getCachedInfo(this.sqlText)) {
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.storedProcedureUpdate();
                return false;
            }
            this.storedProcedureQuery();
            return true;
        }
        return this.directExecuteStoredProcedure(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean directExecuteStoredProcedure(boolean bl) throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.serverCursorNumber = ++this.connection.nextServerCursorNumber;
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.DIRECT_STORED_PROCEDURE);
            this.output.wire.set(this.sqlText);
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion > 38) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            this.input.readHeader(this.serverCursorNumber, 0, 100);
            this.processStoredProcedureMetaData(this.input.wire, true, bl);
            if (this.multipleResultSets) {
                return this.executeMultipleResultSets();
            }
            this.getOutputParameters();
            if (this.statementType == 0 || this.statementType == 11 || this.statementType == 13) {
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
                return false;
            }
            if (this.connection.protocolVersion > 2 && this.resultSetType == 1003) {
                this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
            }
            return true;
        }
    }

    protected void handleError100(int n) throws SQLException {
        if (n == 100) {
            this.fetchDone = true;
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
        } else {
            this.connection.markAsBeingExecuted(this.serverCursorNumber, this);
        }
    }

    public synchronized boolean execute(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        this.cleanUp();
        this.updateCnt = 0;
        this.preparse(string);
        this.genericExecuteCalled = true;
        if (this.statementType == 1) {
            this.Query(string);
            this.updateCnt = -1;
            return true;
        }
        if (this.statementType == 7) {
            throw new SQLException("No output parameters allowed");
        }
        if (this.statementType == 2) {
            if (this.executeStoredProcedure()) {
                return true;
            }
            if (this.connection.protocolVersion < 14 || this.parameterSets == 0) {
                this.updateCnt = this.input.wire.getInt();
            }
            return false;
        }
        this.Update(string);
        if (this.connection.protocolVersion < 14 || this.parameterSets == 0) {
            this.updateCnt = this.input.wire.getInt();
        }
        return false;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (!this.genericExecuteCalled || this.statementType != 1 && this.statementType != 10 && this.statementType != 12) {
            return null;
        }
        if (this.multipleResultSets) {
            if (this.myResultSet == null && this.updateCnt == -1) {
                return null;
            }
            this.columnInfo(this.input.wire);
        } else {
            this.genericExecuteCalled = false;
        }
        this.myResultSet = this.createResultSet();
        return this.myResultSet;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.statementType == 1 || this.statementType == 10 || this.statementType == 12) {
            return -1;
        }
        if (!this.multipleResultSets) {
            this.genericExecuteCalled = false;
        }
        int n = this.updateCnt;
        this.updateCnt = -1;
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    protected int getColumnType(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).type;
    }

    protected String getColumnName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).name;
    }

    protected String getColumnLabel(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).label;
    }

    protected String getColumnTableName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).tableName;
    }

    protected String getColumnSchemaName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).schema;
    }

    protected String getColumnCatalogName(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).catalog;
    }

    protected int getColumnPrecision(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).precision;
    }

    protected int getColumnScale(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).scale;
    }

    protected int getColumnNullable(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).nullable;
    }

    protected boolean isReadOnly(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isReadOnly;
    }

    protected boolean isAutoIncrement(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isAutoIncrement;
    }

    protected boolean isCaseSensitive(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isCaseSensitive;
    }

    protected boolean isCurrency(int n) {
        return ((Column)this.columns.elementAt((int)(n - 1))).isCurrency;
    }

    protected int getParameterMode(int n) {
        return ((Parameter)this.parameters.elementAt((int)n)).mode;
    }

    protected boolean isOutParameter(int n) {
        int n2 = ((Parameter)this.parameters.elementAt((int)n)).mode;
        return n2 == 2 || n2 == 4;
    }

    private void isNotDefaultOrReplaced(int n) throws SQLException {
        int n2 = ((Parameter)this.parameters.elementAt((int)n)).mode;
        if (n2 != 5 && n2 != 6) {
            throw new SQLException("Parameters not allowed in Statement class", "07001", 7001);
        }
    }

    private int getAbsolutePosition(int n) throws SQLException {
        --n;
        int n2 = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((Parameter)this.parameters.elementAt((int)i)).mode == 5) continue;
            if (n == n2) {
                return i;
            }
            ++n2;
        }
        throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
    }

    protected int getParameterTypeAbsolute(int n) throws SQLException {
        return ((Parameter)this.parameters.elementAt((int)this.getAbsolutePosition((int)n))).type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParameterModeAndScale(int n, int n2) {
        this.setParameterMode(n);
        Vector vector = this.parameters;
        synchronized (vector) {
            ((Parameter)this.parameters.elementAt((int)n)).scale = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParameterMode(int n) {
        Vector vector = this.parameters;
        synchronized (vector) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            parameter.mode = parameter.mode == 1 || parameter.mode == 2 ? 2 : 4;
            parameter.bound = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindParameter(int n) throws SQLException {
        Vector vector = this.parameters;
        synchronized (vector) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            if (parameter.mode != 5 && parameter.mode != 6) {
                parameter.bound = false;
                parameter.mode = 0;
                parameter.values.clear();
                parameter.whatever.clear();
            }
        }
    }

    protected synchronized void multipleResultSetsMetaData(SysList sysList, boolean bl) throws SQLException {
        this.multipleResultSets = true;
        if (!this.storedProcedureParameterInfo(sysList, bl)) {
            throw new SQLException("Parameter list mismatch", "07001", 7001);
        }
        this.statementType = this instanceof CacheCallableStatement ? 1 : (this instanceof CachePreparedStatement ? 12 : 10);
    }

    protected synchronized void processStoredProcedureMetaData(SysList sysList, boolean bl, boolean bl2) throws SQLException {
        this.statementType = sysList.getInt();
        if (this.statementType < 0) {
            if (this.statementType == -1) {
                this.multipleResultSetsMetaData(sysList, false);
            } else {
                this.multipleResultSetsMetaData(sysList, true);
            }
            return;
        }
        if (this.statementType % 2 == 1) {
            if (bl2) {
                this.verifyColumnInfo(sysList);
            } else {
                this.columnInfo(sysList);
            }
        }
        if (!this.storedProcedureParameterInfo(sysList, this.statementType > 1)) {
            if (bl && this.statementType % 2 == 1) {
                if (this.connection.protocolVersion > 2 && this.resultSetType == 1003) {
                    this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
                }
                this.input.wire.moveToEnd();
            }
            throw new SQLException("Parameter list mismatch", "07001", 7001);
        }
        if (this instanceof CacheCallableStatement) {
            this.statementType %= 2;
            return;
        }
        if (this instanceof CachePreparedStatement) {
            this.statementType = this.statementType % 2 == 1 ? 12 : 13;
            return;
        }
        this.statementType = this.statementType % 2 == 1 ? 10 : 11;
    }

    protected void columnInfo(SysList sysList) throws SQLException {
        int n = sysList.getInt();
        this.columns = new Vector(n);
        if (n <= 0) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            Column column = new Column();
            column.name = sysList.getString();
            column.type = sysList.getInt();
            if (column.type == 9) {
                column.type = 91;
            } else if (column.type == 10) {
                column.type = 92;
            } else if (column.type == 11) {
                column.type = 93;
            }
            column.precision = sysList.getInt();
            column.scale = sysList.getInt();
            column.nullable = sysList.getInt();
            column.label = sysList.getString();
            column.tableName = sysList.getString();
            if (this.connection.protocolVersion > 14) {
                column.schema = sysList.getString();
                column.catalog = sysList.getString();
            }
            if (this.connection.protocolVersion > 40) {
                String string = sysList.getString();
                column.isAutoIncrement = string.charAt(0) == '\u0001';
                column.isCaseSensitive = string.charAt(1) == '\u0001';
                column.isCurrency = string.charAt(2) == '\u0001';
                column.isReadOnly = string.charAt(3) == '\u0001';
            }
            this.columns.addElement(column);
        }
    }

    protected void verifyColumnInfo(SysList sysList) throws SQLException {
        boolean bl = false;
        int n = sysList.getInt();
        if (n != this.columns.size()) {
            bl = true;
        } else {
            for (int i = 0; i < n; ++i) {
                String string;
                Column column = (Column)this.columns.elementAt(i);
                boolean bl2 = bl = !column.name.equals(sysList.getString());
                if (bl) break;
                int n2 = sysList.getInt();
                if (n2 == 9) {
                    n2 = 91;
                } else if (n2 == 10) {
                    n2 = 92;
                } else if (n2 == 11) {
                    n2 = 93;
                }
                boolean bl3 = bl = n2 != column.type || column.precision != sysList.getInt() || column.scale != sysList.getInt() || column.nullable != sysList.getInt();
                if (bl) break;
                String string2 = sysList.getString();
                if (column.label == null) {
                    if (string2 != null) {
                        bl = true;
                    }
                } else {
                    boolean bl4 = bl = !column.label.equals(string2);
                }
                if (bl) break;
                String string3 = sysList.getString();
                if (column.tableName == null) {
                    if (string3 != null) {
                        bl = true;
                    }
                } else {
                    boolean bl5 = bl = !column.tableName.equals(string3);
                }
                if (bl) break;
                if (this.connection.protocolVersion > 14) {
                    string = sysList.getString();
                    if (column.schema == null) {
                        if (string != null) {
                            bl = true;
                        }
                    } else {
                        boolean bl6 = bl = !column.schema.equals(string);
                    }
                    if (!bl) {
                        String string4 = sysList.getString();
                        if (column.catalog == null) {
                            if (string4 != null) {
                                bl = true;
                            }
                        } else {
                            boolean bl7 = bl = !column.catalog.equals(string4);
                        }
                    }
                }
                if (bl) break;
                if (this.connection.protocolVersion <= 40) continue;
                string = sysList.getString();
                boolean bl8 = column.isAutoIncrement != (string.charAt(0) == '\u0001') || column.isCaseSensitive != (string.charAt(1) == '\u0001') || column.isCurrency != (string.charAt(2) == '\u0001') || column.isReadOnly != (string.charAt(3) == '\u0001') ? true : (bl = false);
                if (bl) break;
            }
        }
        if (bl) {
            throw new SQLException("Query/Stored Procedure recompiled: Result Set Mismatch", "S1093", 478);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean storedProcedureParameterInfo(SysList sysList, boolean bl) throws SQLException {
        int n;
        block13: {
            int n2;
            block16: {
                block18: {
                    block17: {
                        block14: {
                            block15: {
                                n = sysList.getInt();
                                n2 = this.parameters.size();
                                if (!(this instanceof CacheCallableStatement) && this.hasReturnValue == 1) {
                                    sysList.moveToEnd();
                                    return false;
                                }
                                if (n2 != n) break block14;
                                if (!bl || this.hasReturnValue != 2) break block15;
                                this.hasReturnValue = 2;
                                break block13;
                            }
                            if (!bl && this.hasReturnValue == 0) {
                                this.hasReturnValue = 0;
                                break block13;
                            } else if (n2 == 1 && n == 1 && this.getParameterMode(0) == 6 && this.hasReturnValue == 0 && bl) {
                                this.parameters.remove(0);
                                this.parameters.add(0, new Parameter());
                                this.hasReturnValue = 1;
                                break block13;
                            } else {
                                sysList.moveToEnd();
                                return false;
                            }
                        }
                        if (n2 != n + 1) break block16;
                        if (bl || this.hasReturnValue != 2) break block17;
                        this.hasReturnValue = 3;
                        break block13;
                    }
                    if ((n2 != 2 || n != 1) && (n2 != 1 || n != 0)) break block18;
                    if (this.getParameterMode(n2 - 1) != 6) {
                        sysList.moveToEnd();
                        return false;
                    }
                    if (bl && this.hasReturnValue == 2) {
                        this.parameters.remove(n2 - 1);
                        this.hasReturnValue = 2;
                        break block13;
                    } else if (!bl && this.hasReturnValue == 0) {
                        this.parameters.remove(n2 - 1);
                        this.hasReturnValue = 0;
                        break block13;
                    } else {
                        sysList.moveToEnd();
                        return false;
                    }
                }
                sysList.moveToEnd();
                return false;
            }
            if (n2 != n - 1) {
                sysList.moveToEnd();
                return false;
            }
            if (bl && this.hasReturnValue == 0) {
                this.parameters.add(0, new Parameter());
                this.hasReturnValue = 1;
            } else {
                sysList.moveToEnd();
                return false;
            }
        }
        this.readParameterData(sysList, n, true);
        return true;
    }

    protected void parameterInfo(SysList sysList) throws SQLException {
        int n = sysList.getInt();
        if (n != this.parameters.size()) {
            throw new SQLException("Invalid number of parameters", "07001", 7001);
        }
        this.readParameterData(sysList, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readParameterData(SysList sysList, int n, boolean bl) throws SQLException {
        Vector vector = this.parameters;
        synchronized (vector) {
            for (int i = 0; i < n; ++i) {
                Parameter parameter = (Parameter)this.parameters.elementAt(i);
                parameter.type = sysList.getInt();
                if (parameter.type == 9) {
                    parameter.type = 91;
                } else if (parameter.type == 10) {
                    parameter.type = 92;
                } else if (parameter.type == 11) {
                    parameter.type = 93;
                }
                parameter.precision = sysList.getInt();
                parameter.scale = sysList.getInt();
                parameter.nullable = sysList.getInt();
                if (!bl || this.connection.protocolVersion <= 30) continue;
                parameter.name = sysList.getString();
                sysList.getInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean getCachedInfo(String string) throws SQLException {
        boolean bl = false;
        CacheConnection.CachedPrepare cachedPrepare = null;
        HashMap hashMap = this.connection.cachedPrepares;
        synchronized (hashMap) {
            for (Object k : this.connection.cachedPrepares.keySet()) {
                cachedPrepare = (CacheConnection.CachedPrepare)this.connection.cachedPrepares.get(k);
                if (!string.equals(cachedPrepare.sqlText) || cachedPrepare.ownedBy != null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.connection.cachedPrepares.size() >= 500) {
                    this.connection.updateCache();
                }
                return false;
            }
            this.serverCursorNumber = cachedPrepare.serverCursorNumber;
            if (this.statementType == 2 || this.statementType == 7) {
                if (this.parameters.size() != cachedPrepare.parameters.size()) {
                    return false;
                }
                this.statementType = cachedPrepare.statementType;
                this.hasReturnValue = cachedPrepare.hasReturnValue;
                if (this.statementType == 1 || this.statementType == 12 || this.statementType == 10) {
                    this.columns = (Vector)cachedPrepare.columns.clone();
                }
            } else if (this.statementType == 1) {
                this.columns = (Vector)cachedPrepare.columns.clone();
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                ((Parameter)this.parameters.elementAt((int)i)).type = ((Parameter)cachedPrepare.parameters.elementAt((int)i)).type;
                ((Parameter)this.parameters.elementAt((int)i)).precision = ((Parameter)cachedPrepare.parameters.elementAt((int)i)).precision;
                ((Parameter)this.parameters.elementAt((int)i)).scale = ((Parameter)cachedPrepare.parameters.elementAt((int)i)).scale;
                ((Parameter)this.parameters.elementAt((int)i)).nullable = ((Parameter)cachedPrepare.parameters.elementAt((int)i)).nullable;
                ((Parameter)this.parameters.elementAt((int)i)).name = ((Parameter)cachedPrepare.parameters.elementAt((int)i)).name;
            }
            cachedPrepare.ownedBy = this;
            return true;
        }
    }

    protected Preparser preparseAddID(String string) throws SQLException {
        Preparser preparser = new Preparser(string, this.connection.delimitedIds == 1, true);
        try {
            preparser.preparse();
        }
        catch (Throwable throwable) {
            throw new SQLException("SQL preparser error:\n" + throwable.getMessage());
        }
        if (preparser.getStatementType() != 1) {
            this.originalSqlText = string;
            return preparser;
        }
        this.statementType = 1;
        this.updateParameters(preparser);
        this.sqlText = preparser.getPreparsedSQL();
        this.originalSqlText = string;
        return null;
    }

    protected void preparse(String string, int n, long l) throws SQLException {
        this.statementType = n;
        this.sqlText = string;
        int n2 = 1;
        while ((long)n2 < l) {
            this.parameters.addElement(new Parameter());
            ++n2;
        }
    }

    protected void preparse(String string) throws SQLException {
        Preparser preparser = null;
        CacheConnection.CachedSQL cachedSQL = (CacheConnection.CachedSQL)this.connection.prePreparseCache.get(string);
        if (cachedSQL != null && cachedSQL.resultSetConcurrency == this.resultSetConcurrency) {
            this.hasReturnValue = cachedSQL.hasReturnValue;
            this.parameters = (Vector)cachedSQL.parameters.clone();
            this.sqlText = cachedSQL.sqlText;
            this.statementType = cachedSQL.statementType;
            return;
        }
        if (this.resultSetConcurrency == 1008 && (preparser = this.preparseAddID(string)) == null) {
            return;
        }
        try {
            if (preparser == null) {
                preparser = new Preparser(string, this.connection.delimitedIds == 1, false);
                preparser.preparse();
            }
            this.statementType = 0;
            switch (preparser.getStatementType()) {
                case 0: {
                    this.statementType = 0;
                    this.sqlText = string;
                    return;
                }
                case 1: {
                    this.statementType = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    this.statementType = 0;
                    break;
                }
                case 5: {
                    this.statementType = 2;
                    this.hasReturnValue = 0;
                    break;
                }
                case 6: {
                    this.statementType = 7;
                    this.hasReturnValue = 2;
                    break;
                }
                case 12: {
                    this.statementType = 4;
                    break;
                }
                case 11: {
                    this.statementType = 3;
                    break;
                }
                case 13: {
                    this.statementType = 5;
                    break;
                }
                case 14: {
                    this.statementType = 6;
                    break;
                }
                case 9: {
                    this.statementType = 8;
                    this.sqlText = string;
                    return;
                }
                case 10: {
                    this.statementType = 9;
                    this.sqlText = string;
                    return;
                }
            }
            this.updateParameters(preparser);
            this.sqlText = preparser.getPreparsedSQL();
            this.connection.addPrePreparseCache(string, this.sqlText, this.statementType, this.hasReturnValue, this.parameters, this.resultSetConcurrency);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new SQLException("SQL preparser error:\n" + throwable.getMessage());
        }
    }

    protected void updateParameters(Preparser preparser) {
        if (preparser.getParametersCount() == 0) {
            return;
        }
        block5: for (StatementTypes.Parameter parameter : preparser.getParameters()) {
            switch (parameter.type) {
                case '?': {
                    this.parameters.addElement(new Parameter());
                    continue block5;
                }
                case 'd': {
                    this.parameters.addElement(new Parameter(6));
                    continue block5;
                }
                case 'c': {
                    this.parameters.addElement(new Parameter(parameter.value));
                    continue block5;
                }
            }
            throw new Error("Should not have gotten here...");
        }
    }

    protected void validateParameters() throws SQLException {
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.isNotDefaultOrReplaced(i);
        }
    }

    protected synchronized void writeParameters(SysList sysList) throws SQLException {
        int n = this.parameterSets;
        if (this.parameterSets == 0) {
            n = 1;
        }
        sysList.set(n);
        if (this.connection.protocolVersion > 2) {
            sysList.set(this.parameters.size());
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.parameters.size(); ++j) {
                Parameter parameter = (Parameter)this.parameters.elementAt(j);
                if (parameter.mode == 5) {
                    sysList.setParameter(parameter.values.elementAt(0));
                    continue;
                }
                if (parameter.mode == 6) {
                    sysList.setUndefined();
                    continue;
                }
                if (parameter.whatever.elementAt(i) == null) {
                    if (parameter.values.elementAt(i) instanceof StreamWrapper) {
                        sysList.setParameter(this.sendStream(j, (StreamWrapper)parameter.values.elementAt(i)));
                        continue;
                    }
                    sysList.setParameter(parameter.values.elementAt(i));
                    continue;
                }
                sysList.setParameter(parameter.values.elementAt(i), parameter.whatever.elementAt(i));
            }
        }
    }

    protected synchronized Object sendStream(int n, StreamWrapper streamWrapper) throws SQLException {
        int n2 = streamWrapper.length;
        int n3 = ((Parameter)this.parameters.elementAt((int)n)).type;
        try {
            int n4;
            if (streamWrapper.type != 4 && (n4 = ((InputStream)streamWrapper.data).available()) > 0 && (n2 < 0 || n2 > n4)) {
                n2 = n4;
            }
            if ((n4 = this.output.wire.getMaxFieldSize()) != 0 && n2 > n4) {
                n2 = n4;
            }
            if (n2 == 0) {
                return "";
            }
            if (n3 != -1 && n3 != -4) {
                return FakeStream.sendStream(streamWrapper.data, n2, streamWrapper.type);
            }
            return RealStream.sendStream(this.connection, streamWrapper.data, n2, streamWrapper.type, n3, this.serverCursorNumber);
        }
        catch (IOException iOException) {
            throw new SQLException("Error writing stream: " + iOException.getMessage());
        }
    }

    protected synchronized void cleanUp() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
        if (this.serverCursorNumber != 0) {
            this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
        }
        if (this.parameters != null) {
            this.parameters.removeAllElements();
        }
        this.updatableRSTableName = null;
        this.updatableRSColumnNames = null;
    }

    protected synchronized void query404() throws SQLException {
        this.connection.cachedPrepares.remove(new Integer(this.serverCursorNumber));
        this.validateParameters();
        if (this instanceof CacheCallableStatement || this.statementType == 12) {
            this.directExecuteStoredProcedure(true);
        } else {
            this.sendDirectQueryRequest(true);
        }
    }

    protected synchronized void update404() throws SQLException {
        this.connection.cachedPrepares.remove(new Integer(this.serverCursorNumber));
        this.validateParameters();
        if (this instanceof CacheCallableStatement || this.statementType == 13) {
            this.directExecuteStoredProcedure(false);
        } else {
            this.sendDirectUpdateRequest();
        }
    }

    protected synchronized void getOutputParameters() throws SQLException {
        int n = this.input.wire.getCurrentOffset();
        for (int i = 0; i < this.parameters.size(); ++i) {
            try {
                if (this.isOutParameter(i)) {
                    this.input.wire.nextUnlessUndefined();
                    continue;
                }
                this.input.wire.next();
                continue;
            }
            catch (SQLException sQLException) {
                if (sQLException instanceof SysList.NoMoreDataException) continue;
                throw sQLException;
            }
        }
        if (this.hasReturnValue == 3) {
            this.outputParameterList = this.input.wire.getOutputParameterList(n, 1);
            this.hasReturnValue = 2;
        } else {
            this.outputParameterList = this.input.wire.getOutputParameterList(n, 0);
        }
    }

    protected synchronized void updateResultSet() throws SQLException {
        this.Query(this.originalSqlText);
        this.resultSetConcurrency = 1008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void storedProcedureUpdate() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_UPDATE_EXECUTE);
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion > 38) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                this.update404();
            } else {
                this.getOutputParameters();
                this.connection.markAsNotBeingExecuted(this.serverCursorNumber, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void storedProcedureQuery() throws SQLException {
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.STORED_PROCEDURE_QUERY_EXECUTE);
            this.writeStoredProcedureParameters();
            if (this.connection.protocolVersion > 38) {
                this.output.wire.set(this.queryTimeout);
                this.output.wire.set(this.maxRows);
            }
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.serverCursorNumber, 0, 504) == 404) {
                this.handleError504(404);
                this.getOutputParameters();
                return;
            }
            this.getOutputParameters();
            if (this.connection.protocolVersion > 2) {
                this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
            }
        }
    }

    protected synchronized void writeStoredProcedureParameters() throws SQLException {
        int n = 0;
        if (this.parameterSets != 0) {
            this.output.wire.set(this.parameterSets);
            if (this.connection.protocolVersion > 2) {
                this.output.wire.set(this.parameters.size());
            }
            for (int i = 0; i < this.parameterSets; ++i) {
                while (n < this.parameters.size()) {
                    Parameter parameter = (Parameter)this.parameters.elementAt(n);
                    if (parameter.values.elementAt(i) instanceof StreamWrapper) {
                        this.output.wire.setParameter(this.sendStream(n, (StreamWrapper)parameter.values.elementAt(i)));
                    } else {
                        this.output.wire.setParameter(parameter.values.elementAt(i));
                    }
                    ++n;
                }
            }
            return;
        }
        this.output.wire.set(1);
        if (this.hasReturnValue != 0) {
            n = 1;
        }
        if (this.connection.protocolVersion > 2) {
            this.output.wire.set(this.parameters.size() - n);
        }
        while (n < this.parameters.size()) {
            Parameter parameter = (Parameter)this.parameters.elementAt(n);
            if (parameter.mode == 4 || parameter.mode == 6) {
                this.output.wire.setUndefined();
            } else if (parameter.values.elementAt(0) instanceof StreamWrapper) {
                this.output.wire.setParameter(this.sendStream(n, (StreamWrapper)parameter.values.elementAt(0)));
            } else {
                this.output.wire.setParameter(parameter.values.elementAt(0));
            }
            ++n;
        }
    }

    protected int getAbsoluteParameterIndex(int n) throws SQLException {
        if (n > this.parameters.size()) {
            throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        if (this.hasReturnValue == 1) {
            n3 = 1;
            n2 = 1;
        } else {
            --n4;
        }
        while (n3 < this.parameters.size()) {
            if (((Parameter)this.parameters.elementAt((int)n3)).mode != 5) {
                if (n2 == n4) {
                    return n3;
                }
                ++n2;
            }
            ++n3;
        }
        throw new SQLException("Invalid parameter number: " + n, "S1093", 466);
    }

    private int[] computeUpdateCount(Vector vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    protected static void debug(String string) {
        System.out.println(string);
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("Unsupported fetch direction", "IM001");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        int n2 = this.getMaxRows();
        if (n < 0 || n2 != 0 && n > n2) {
            throw new SQLException("Invalid number of rows specified: " + n, "S1000");
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public synchronized void addBatch(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.batchException != BATCH_EXCEPTION_NONE) {
            return;
        }
        this.cleanUp();
        this.preparse(string);
        if (this.statementType == 1) {
            this.batchException = BATCH_EXCEPTION_QUERY;
            return;
        }
        if (this.statementType == 2 || this.statementType == 7) {
            this.batchException = BATCH_EXCEPTION_SP;
            return;
        }
        ++this.batchCount;
        this.validateParameters();
        if (this.batchCount == 1) {
            this.batch = new SysList();
            this.batch.setMaxItemSize(32000);
            this.batch.setServerType(this.connection.isUnicodeServer, this.connection.serverLocale);
            this.batch.writeHeader(0, CacheConnection.EXECUTE_STATEMENT_BATCH);
            this.batch.writeBatchCount(-1);
        }
        this.batch.setSQLText(this.sqlText, this.connection.protocolVersion);
        this.writeParameters(this.batch);
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this instanceof CachePreparedStatement) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.unbindParameter(i);
            }
            this.parameterSets = 0;
            return;
        }
        this.batchCount = 0;
        this.batch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this instanceof CachePreparedStatement) {
            return this.executePreparedStatementBatch();
        }
        if (this.batchCount == 0) {
            if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
                throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, new int[0]);
            }
            return new int[0];
        }
        Vector<Integer> vector = new Vector<Integer>();
        SQLException sQLException = null;
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            SysList sysList = this.output.setWire(this.batch);
            this.output.wire.writeBatchCount(this.batchCount);
            this.output.send(this.connection.messageCount.getCount());
            try {
                this.input.readHeader(0, 0, 100);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            this.output.setWire(sysList);
            int n = this.batchCount;
            this.batchCount = 0;
            if (this.connection.protocolVersion < 14) {
                int n2 = this.input.wire.getInt();
                for (int i = 0; i < n2; ++i) {
                    vector.add(new Integer(1));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n3 = this.input.wire.getInt();
                    if (n3 == -3) {
                        if (sQLException != null) {
                            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.computeUpdateCount(vector));
                        }
                        throw new BatchUpdateException(this.computeUpdateCount(vector));
                    }
                    vector.add(new Integer(n3));
                }
            }
        }
        if (!this.batchException.equals(BATCH_EXCEPTION_NONE)) {
            throw new BatchUpdateException("Statement.addBatch called with a " + this.batchException, "24000", 24000, this.computeUpdateCount(vector));
        }
        if (sQLException != null) {
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), this.computeUpdateCount(vector));
        }
        this.batch = null;
        return this.computeUpdateCount(vector);
    }

    protected synchronized int[] executePreparedStatementBatch() throws SQLException {
        int n;
        if (this.parameterSets == 0) {
            return new int[0];
        }
        for (n = 0; n < this.parameters.size(); ++n) {
            if (!this.isOutParameter(n)) continue;
            throw new SQLException("INOUT/OUT parameters not permitted", "S1000");
        }
        try {
            ((CachePreparedStatement)this).executeUpdate();
        }
        catch (SQLException sQLException) {
            int[] nArray = new int[this.parameterSets];
            for (n = 0; n < this.parameterSets; ++n) {
                nArray[n] = -3;
            }
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
        }
        int n2 = this.parameterSets;
        this.parameterSets = 0;
        int[] nArray = new int[n2];
        int n3 = 0;
        if (this.connection.protocolVersion < 14) {
            n3 = this.input.wire.getInt();
            for (n = 0; n < n3; ++n) {
                nArray[n] = 1;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                nArray[n] = this.input.wire.getInt();
                if (nArray[n] == -3) continue;
                ++n3;
            }
        }
        if (n3 < n2) {
            throw new BatchUpdateException(nArray);
        }
        this.clearBatch();
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (this.connection.protocolVersion < 39 || !this.multipleResultSets) {
            return false;
        }
        if (this.closed) {
            throw new SQLException("This Statement object is closed", "08003");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n < 1 || n > 3) {
            throw new SQLException("Invalid flag value: " + n, "S1000");
        }
        if (n == 2) {
            throw new SQLException("KEEP_CURRENT_RESULT not supported", "IM001");
        }
        if (this.myResultSet != null) {
            this.myResultSet.close();
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_MORE_RESULTS);
            this.output.wire.set(n);
            this.output.send(this.connection.messageCount.getCount());
            int n2 = this.input.readHeader(this.serverCursorNumber, 0, 100);
            int n3 = this.input.wire.getInt();
            if (n3 >= 0) {
                this.updateCnt = n3;
                this.myResultSet = null;
                return false;
            }
            if (n3 == -1) {
                this.fetchDone = n2 == 100;
                return true;
            }
            if (n3 == -2) {
                this.updateCnt = -1;
                this.genericExecuteCalled = true;
                return false;
            }
            throw new SQLException("Invalid result type value: " + n3, "S1000");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (this.connection == null || this.connection.isClosed()) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.autoGeneratedKeyColumn == null) {
            this.columns = new Vector();
            return new CacheResultSet(this);
        }
        if (this.statementType != 0) {
            throw new SQLException("Not an INSERT statement", "S1000");
        }
        Object object = this.connection.messageCount;
        synchronized (object) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.GET_AUTO_GENERATED_KEYS);
            this.output.send(this.connection.messageCount.getCount());
            if (this.input.readHeader(this.serverCursorNumber, 0, 100) != 100) {
                throw new SQLException("Error retrieving auto-generated keys", "S1000");
            }
            this.fetchDone = true;
        }
        if (this.input.wire.isEnd()) {
            this.columns = new Vector();
            return new CacheResultSet(this);
        }
        this.columns = new Vector(1);
        if (this.connection.protocolVersion < 39) {
            object = new Column();
            ((Column)object).type = 4;
            ((Column)object).name = "";
            ((Column)object).precision = 10;
            ((Column)object).scale = 0;
            ((Column)object).nullable = 0;
            ((Column)object).label = "";
            ((Column)object).tableName = "";
            ((Column)object).schema = "";
            ((Column)object).catalog = "";
            this.columns.addElement(object);
        }
        if (this.connection.protocolVersion > 38) {
            this.columnInfo(this.input.wire);
        }
        return new CacheResultSet(this);
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        this.autoGeneratedKeyColumn = n == 1 ? "-1" : null;
        return this.executeUpdate(string);
    }

    public boolean execute(String string, int n) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        this.autoGeneratedKeyColumn = n == 1 ? "-1" : null;
        return this.execute(string);
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(nArray[0]);
        return this.executeUpdate(string);
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = Integer.toString(nArray[0]);
        return this.execute(string);
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = stringArray[0];
        return this.executeUpdate(string);
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.connection.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        this.autoGeneratedKeyColumn = stringArray[0];
        return this.execute(string);
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    protected boolean executeMultipleResultSets() throws SQLException {
        this.fetchDone = false;
        this.validateParameters();
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.serverCursorNumber, CacheConnection.EXECUTE_MULTIPLE_RESULT_SETS);
            this.writeStoredProcedureParameters();
            this.output.send(this.connection.messageCount.getCount());
            this.handleError100(this.input.readHeader(this.serverCursorNumber, 0, 100));
            this.getOutputParameters();
            int n = this.input.wire.getInt();
            if (n >= 0) {
                this.updateCnt = n;
                return false;
            }
            if (n == -1) {
                return true;
            }
            if (n == -2) {
                this.updateCnt = -1;
                return true;
            }
            throw new SQLException("Invalid result type value: " + n, "S1000");
        }
    }

    final class Parameter
    extends Descriptor {
        protected static final int UNKNOWN = 0;
        protected static final int INPUT = 1;
        protected static final int INPUT_OUTPUT = 2;
        protected static final int OUTPUT = 4;
        protected static final int REPLACED_LITERAL = 5;
        protected static final int DEFAULT_PARAMETER = 6;
        protected Vector values;
        protected int mode;
        protected boolean bound;
        protected Vector whatever;

        Parameter() {
            this.mode = 0;
            this.values = new Vector();
            this.whatever = new Vector();
            this.bound = false;
        }

        Parameter(Object object) {
            this.mode = 5;
            this.values = new Vector();
            this.whatever = new Vector();
            this.values.addElement(object);
            this.whatever.addElement(null);
        }

        Parameter(int n) {
            this.mode = 6;
            this.values = new Vector();
            this.whatever = new Vector();
        }

        protected void bind(Object object, Object object2, int n) throws SQLException {
            int n2;
            if (n == 0) {
                this.values.clear();
                this.whatever.clear();
            }
            if (n + 1 < (n2 = this.values.size()) || n2 < n) {
                throw new SQLException("Not all parameters bound for this set", "S1000");
            }
            if (n == n2) {
                this.values.addElement(object);
                this.whatever.addElement(object2);
            } else {
                this.values.setElementAt(object, n2 - 1);
                this.whatever.setElementAt(object2, n2 - 1);
            }
            this.bound = true;
            this.mode = this.mode == 4 || this.mode == 2 ? 2 : 1;
        }
    }

    final class Column
    extends Descriptor {
        protected String label;
        protected String tableName;
        protected String schema = "";
        protected String catalog = "";
        protected boolean isAutoIncrement = false;
        protected boolean isCaseSensitive = false;
        protected boolean isCurrency;
        protected boolean isReadOnly = false;

        Column() {
        }
    }

    final class StreamWrapper {
        protected Object data;
        protected int type;
        protected int length;

        StreamWrapper(Object object, int n, int n2) {
            this.data = object;
            this.type = n;
            this.length = n2;
        }
    }
}

