/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.QuickEmbeddedObject;
import com.intersys.classes.CacheGeneric;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.classes.RelationshipObject;
import com.intersys.objects.CacheClassCastException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheModifier;
import com.intersys.pojo.runtime.DetachedObjectsManager;
import com.intersys.pojo.runtime.ObjectFactory;
import com.intersys.pojo.runtime.PojoOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CacheRootObject
extends CacheGeneric
implements ObjectHandle {
    private static final Object NOT_FOUND = new Object();
    private static boolean USE_FIELD_MAP = true;
    private static Map fieldMap = null;
    private static String CACHE_CLASS_NAME = "%Library.RegisteredObject";
    protected CacheObject mInternal;
    private static final int CHAR_STREAM_BUFFER_LEN = 8192;
    private static final char[] CHAR_STREAM_BUFFER = new char[8192];
    private static final int BYTE_STREAM_BUFFER_LEN = 8192;
    private static final byte[] BYTE_STREAM_BUFFER = new byte[8192];

    protected CacheRootObject(CacheObject cacheObject) throws CacheException {
        this.mInternal = cacheObject;
        cacheObject.increaseCount();
    }

    public final int getOref() throws ObjectClosedException {
        return this.mInternal.getOref();
    }

    public String toString() {
        try {
            return String.valueOf(this.getZRef());
        }
        catch (CacheException cacheException) {
            return "<Closed Object>";
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheRootObject)) {
            return false;
        }
        CacheRootObject cacheRootObject = (CacheRootObject)object;
        return this.mInternal.equals(cacheRootObject.mInternal) && ((Object)this.getDatabase()).equals(cacheRootObject.getDatabase());
    }

    public final Database getDatabase() {
        return this.mInternal.getDatabase();
    }

    public static String getCacheClassName() {
        return CACHE_CLASS_NAME;
    }

    public Object getField(String string) throws CacheException {
        boolean bl;
        String string2;
        CacheField cacheField;
        if (!USE_FIELD_MAP) {
            throw new CacheException("Not supported method");
        }
        if (fieldMap == null) {
            fieldMap = new HashMap();
        }
        if ((cacheField = (CacheField)fieldMap.get(string2 = this.mInternal.getCacheClass().getName() + ':' + string)) == null) {
            this.setUpField();
            cacheField = (CacheField)fieldMap.get(string2);
            if (cacheField == null) {
                throw new CacheException("No field with name " + string + " in class " + this.mInternal.getCacheClass().getName());
            }
        }
        int n = (bl = CacheModifier.isLiteral(cacheField.getModifiers())) ? 0 : 1;
        Dataholder dataholder = this.mInternal.getProperty(cacheField.getII(), cacheField.getJJ(), n, string);
        if (bl) {
            return dataholder.getObject(cacheField.getJavaTypeName());
        }
        CacheObject cacheObject = dataholder.getCacheObject();
        if (cacheObject == null) {
            return null;
        }
        return cacheObject.newJavaInstance();
    }

    public String getString(String string) throws CacheException {
        String string2;
        CacheField cacheField;
        if (!USE_FIELD_MAP) {
            throw new CacheException("Not supported method");
        }
        if (fieldMap == null) {
            fieldMap = new HashMap();
        }
        if ((cacheField = (CacheField)fieldMap.get(string2 = this.mInternal.getCacheClass().getName() + ':' + string)) == null) {
            this.setUpField();
            cacheField = (CacheField)fieldMap.get(string2);
            if (cacheField == null) {
                throw new CacheException("No field with name " + string + " in class " + this.mInternal.getCacheClass().getName());
            }
        }
        Dataholder dataholder = this.mInternal.getProperty(cacheField.getII(), cacheField.getJJ(), 0, string);
        return dataholder.getString();
    }

    private void setUpField() throws CacheException {
        CacheClass cacheClass = this.mInternal.getCacheClass();
        String string = cacheClass.getName();
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            String string2 = string + ':' + cacheFieldArray[i].getName();
            System.out.println("Adding: " + string2);
            fieldMap.put(string2, cacheFieldArray[i]);
        }
    }

    public ObjectHandle castTo(CacheClass cacheClass) throws CacheException {
        CacheClass cacheClass2 = this.mInternal.getCacheClass();
        if (!cacheClass.isAssignableFrom(cacheClass2)) {
            throw new CacheClassCastException(cacheClass2, cacheClass);
        }
        if (cacheClass.getJavaClass().isAssignableFrom(this.getClass())) {
            return this;
        }
        return (ObjectHandle)cacheClass.newInstance(this.mInternal);
    }

    public final void _close() throws CacheException {
        this.getDatabase().closeObject(this.getOref());
    }

    public int hashCode() {
        if (this.mInternal == null) {
            return 1;
        }
        return this.mInternal.hashCode();
    }

    protected Object getUserData() {
        return this.mInternal.getUserData();
    }

    protected void setUserData(Object object) {
        this.mInternal.setUserData(object);
    }

    protected void changeInternal(CacheObject cacheObject) {
        this.mInternal = cacheObject;
    }

    public CacheObject getProxy() {
        return this.mInternal;
    }

    public Object detach(boolean bl) throws Exception {
        HashMap hashMap = new HashMap();
        Object object = this.findPojo(this, true, hashMap, bl);
        return object;
    }

    protected Object detach(Map map, boolean bl) throws Exception {
        int n;
        CacheClass cacheClass = this.mInternal.getCacheClass();
        String string = cacheClass.getJavaPojoName();
        if (string == null) {
            throw new CacheException("POJO projection is not defned for class: " + cacheClass.getName());
        }
        ClassLoader classLoader = ((SysDatabase)this.getDatabase()).getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        Class<?> clazz = Class.forName(string, true, classLoader);
        Object object = this.objectFactory().newPOJO(clazz, cacheClass, this, bl);
        map.put(this, object);
        int n2 = n = bl ? 0 : 100;
        if (!ObjectFactory.isProxy(object)) {
            this.copyTo(object, true, cacheClass, classLoader, map, n);
        }
        return object;
    }

    public void copyTo(Object object, Map map, boolean bl) throws Exception {
        int n = bl ? 0 : 100;
        this.copyTo(object, map, n);
    }

    public void swizzleOneLevel(Object object) throws Exception {
        HashMap hashMap = new HashMap();
        this.copyTo(object, hashMap, 1);
    }

    private void copyTo(Object object, Map map, int n) throws Exception {
        map.put(this, object);
        ClassLoader classLoader = ((SysDatabase)this.getDatabase()).getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        CacheClass cacheClass = this.mInternal.getCacheClass();
        this.copyTo(object, false, cacheClass, classLoader, map, n);
    }

    public void attach(Object object, boolean bl) throws Exception {
        this.copyFrom(object, bl, new HashSet());
    }

    private boolean isFieldTransient(CacheField cacheField) {
        return cacheField.isCalculated() || cacheField.isTransient() && !cacheField.isCollection();
    }

    protected void copyFrom(Object object, boolean bl, Set set) throws CacheException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        CacheField cacheField;
        int n;
        if (set != null) {
            set.add(object);
        }
        CacheClass cacheClass = this.mInternal.getCacheClass();
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (n = 0; n < cacheFieldArray.length; ++n) {
            cacheField = cacheFieldArray[n];
            if (this.isFieldTransient(cacheField) || !this.preSave(cacheField)) continue;
            this.copyField(object, bl, set, cacheField);
        }
        for (n = 0; n < cacheFieldArray.length; ++n) {
            cacheField = cacheFieldArray[n];
            if (this.isFieldTransient(cacheField) || this.preSave(cacheField)) continue;
            this.copyField(object, bl, set, cacheField);
        }
    }

    private boolean preSave(CacheField cacheField) throws CacheException {
        return cacheField.isRequired();
    }

    private void copyField(Object object, boolean bl, Set set, CacheField cacheField) throws CacheException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, NoSuchFieldException {
        Object object2;
        Object object3 = object2 = cacheField.isStream() ? this.getStreamValue(object, cacheField.getJavaName()) : PojoOperations.getValue(object, cacheField.getJavaName(), this.manager());
        if (cacheField.isLiteral()) {
            cacheField.set(this, object2);
        } else if (cacheField.isRelationship()) {
            this.ensureSaved();
            RelationshipObject relationshipObject = (RelationshipObject)cacheField.get(this);
            List list = relationshipObject.asList();
            List list2 = (List)object2;
            this.copyRelationshipListFrom(list2, list, bl, cacheField, set);
        } else if (cacheField.isList()) {
            List list = (List)cacheField.get(this);
            List list3 = object2 != null && object2.getClass().isArray() ? PojoOperations.arrayToList(object2) : (List)object2;
            if (cacheField.isListOfDatatypes()) {
                list.clear();
                if (list3 != null) {
                    list.addAll(list3);
                }
            } else if (cacheField.isElementPersistent()) {
                this.copyPersistentListFrom(list3, list, bl, set);
            } else {
                this.copySerialListFrom(list3, list);
            }
        } else if (cacheField.isArray()) {
            Map map = (Map)cacheField.get(this);
            Map map2 = (Map)object2;
            if (cacheField.isArrayOfDatatypes()) {
                map.clear();
                if (map2 != null) {
                    map.putAll(map2);
                }
            } else if (cacheField.isElementPersistent()) {
                this.copyPersistentArrayFrom(map2, map, bl, set);
            } else {
                this.copySerialArrayFrom(map2, map);
            }
        } else if (cacheField.isSerial()) {
            if (object2 == null) {
                cacheField.set(this, null);
            } else {
                CacheRootObject cacheRootObject = (CacheRootObject)cacheField.get(this);
                if (cacheRootObject != null) {
                    cacheRootObject.copyFrom(object2, bl, set);
                } else {
                    cacheField.set(this, this.copySerial(object2));
                }
            }
        } else if (cacheField.getType().isPersistent()) {
            this.copyPersistentField(cacheField, object2, bl, set);
        } else if (cacheField.isStream()) {
            cacheField.set(this, object2);
        } else {
            throw new CacheException("Can not merge in fieled " + cacheField.getName() + " in Cache class " + cacheField.getDeclaringCacheClass().getName());
        }
    }

    private void copyTo(Object object, boolean bl, CacheClass cacheClass, ClassLoader classLoader, Map map, int n) throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = n < 2;
        if (n != 1 && !this.pojoUpdateRequired(object, bl2)) {
            return;
        }
        CacheField[] cacheFieldArray = cacheClass.getFields();
        for (int i = 0; i < cacheFieldArray.length; ++i) {
            Object object2;
            Object object3;
            Object object4;
            CacheField cacheField = cacheFieldArray[i];
            if (this.isFieldTransient(cacheField)) continue;
            Object object5 = cacheField.get(this);
            String string = cacheField.getJavaName();
            if (cacheField.isLiteral()) {
                object4 = this.classForName(cacheField.getJavaTypeName(), classLoader);
                this.setValue(object, string, object5, (Class)object4);
                continue;
            }
            if (cacheField.isList()) {
                this.processListProperty(object, cacheField, string, classLoader, object5, map, bl2);
                continue;
            }
            if (cacheField.isRelationship()) {
                object4 = (List)PojoOperations.getValue(object, string, this.manager());
                if (object4 == null) {
                    object3 = this.classForName(cacheField.getJavaTypeName(), classLoader);
                    object4 = this.objectFactory().newList((Class)object3);
                    this.setValue(object, string, object4, (Class)object3);
                }
                object3 = (RelationshipObject)object5;
                object2 = ((RelationshipObject)object3).asList();
                this.copyList((List)object2, (List)object4, cacheField.isListOfDatatypes(), map, bl2);
                continue;
            }
            if (cacheField.isArray()) {
                object4 = (Map)PojoOperations.getValue(object, string, this.manager());
                if (object4 == null) {
                    object3 = cacheField.getJavaTypeName();
                    if (object3 == null || ((String)object3).startsWith("com.intersys")) {
                        object3 = Map.class.getName();
                    }
                    object2 = this.classForName((String)object3, classLoader);
                    object4 = this.objectFactory().newMap((Class)object2);
                    this.setValue(object, string, object4, (Class)object2);
                }
                object3 = (Map)object5;
                this.copyMap((Map)object3, (Map)object4, cacheField.isArrayOfDatatypes(), map, bl2);
                continue;
            }
            if (cacheField.isStream()) {
                object4 = this.getStreamJavaType(object, cacheField);
                this.setStreamValue(object, string, object5, (Class)object4);
                continue;
            }
            if (!(object5 instanceof CacheRootObject)) continue;
            object4 = this.getJavaType(object, cacheField);
            object3 = (CacheRootObject)object5;
            object2 = this.findPojo((CacheRootObject)object3, bl, map, bl2);
            if (n == 1 && ObjectFactory.isProxy(object2)) {
                ((CacheRootObject)object3).copyTo(object2, map, true);
            }
            if (object2 == NOT_FOUND) {
                this.mergeInto(object, string, (CacheRootObject)object3, (Class)object4, map, bl2);
                continue;
            }
            this.setValue(object, string, object2, (Class)object4);
        }
        if (this instanceof Persistent) {
            this.setPojoId(object);
        }
        this.clearState();
    }

    private void processListProperty(Object object, CacheField cacheField, String string, ClassLoader classLoader, Object object2, Map map, boolean bl) throws Exception {
        List<Object> list;
        Object object3 = PojoOperations.getValue(object, string, this.manager());
        List list2 = (List)object2;
        if (object3 instanceof List) {
            list = (List<Object>)object3;
        } else if (object3 == null) {
            Class clazz;
            String string2 = cacheField.getJavaTypeName();
            if (string2 == null || string2.startsWith("com.intersys")) {
                string2 = List.class.getName();
            }
            if ((clazz = this.classForName(string2, classLoader)).isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2.isPrimitive()) {
                    this.setPrimitiveArray(object, string, list2, clazz, clazz2);
                    return;
                }
                Object[] objectArray = (Object[])Array.newInstance(clazz2, list2.size());
                this.setValue(object, string, objectArray, clazz);
                list = Arrays.asList(objectArray);
            } else {
                list = this.objectFactory().newList(clazz);
                this.setValue(object, string, list, clazz);
            }
        } else if (object3.getClass().isArray()) {
            list = PojoOperations.arrayToList(object3);
        } else {
            throw new IllegalArgumentException("Unsupported type for List property " + object.getClass().getName() + "." + string + ": " + object3.getClass().getName());
        }
        this.copyList(list2, list, cacheField.isListOfDatatypes(), map, bl);
    }

    private void setPrimitiveArray(Object object, String string, List list, Class clazz, Class clazz2) throws Exception {
        int n = list.size();
        Object object2 = Array.newInstance(clazz2, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object2, i, list.get(i));
        }
        this.setValue(object, string, object2, clazz);
    }

    private Class classForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (Float.TYPE.getName().equals(string)) {
            return Float.TYPE;
        }
        if (Double.TYPE.getName().equals(string)) {
            return Double.TYPE;
        }
        if (Integer.TYPE.getName().equals(string)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(string)) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(string)) {
            return Short.TYPE;
        }
        if (Byte.TYPE.getName().equals(string)) {
            return Byte.TYPE;
        }
        if (Boolean.TYPE.getName().equals(string)) {
            return Boolean.TYPE;
        }
        return this.manager().classForName(string, classLoader);
    }

    private void copyPersistentField(CacheField cacheField, Object object, boolean bl, Set set) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, CacheException {
        if (object == null) {
            cacheField.set(this, null);
            return;
        }
        Persistent persistent = (Persistent)cacheField.get(this);
        Persistent persistent2 = this.copyPersistentFrom(persistent, object, bl, set, false);
        if (!persistent2.equals(persistent)) {
            cacheField.set(this, (Object)persistent2);
        }
    }

    private Persistent copyPersistentFrom(Persistent persistent, Object object, boolean bl, Set set, boolean bl2) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, CacheException {
        Id id;
        if (object == null) {
            return null;
        }
        boolean bl3 = false;
        Persistent persistent2 = this.findProxy(object);
        Id id2 = id = persistent2 == null ? null : persistent2.getId();
        if (persistent == null) {
            bl3 = true;
        } else {
            Id id3 = persistent.getId();
            if (id3 == null || !id3.equals(id)) {
                bl3 = true;
            }
        }
        if (bl3) {
            boolean bl4 = false;
            if (persistent2 == null) {
                CacheClass cacheClass = this.cacheClassFor(object);
                persistent2 = (Persistent)cacheClass.newInstance((String)null);
                if (!bl2) {
                    bl4 = true;
                }
            }
            if (bl && !set.contains(object)) {
                persistent2.copyFrom(object, bl, set);
            }
            if (bl4) {
                this.manager().register(persistent2, object);
            }
            return persistent2;
        }
        if (bl && !set.contains(object)) {
            persistent.copyFrom(object, bl, set);
        }
        return persistent;
    }

    private CacheClass cacheClassFor(Object object) throws CacheException {
        SysDatabase sysDatabase = (SysDatabase)this.getDatabase();
        try {
            String string = (String)object.getClass().getField("CACHE_CLASS_NAME").get(null);
            CacheClass cacheClass = sysDatabase.getCacheClass(string);
            return cacheClass;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        DetachedObjectsManager detachedObjectsManager = this.manager();
        String string = ObjectFactory.getOriginalClass(object).getName();
        try {
            CacheClass cacheClass = detachedObjectsManager.findCacheClassForPOJO(string);
            return cacheClass;
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Can not find Cache class corresponding to Java class " + string);
        }
    }

    private Persistent findProxy(Object object) throws CacheException {
        return this.manager().findProxy(object, false);
    }

    private void copyPersistentListFrom(List list, List list2, boolean bl, Set set) throws CacheException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        list2.clear();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            Persistent persistent = this.copyPersistentFrom(null, e, bl, set, false);
            list2.add(persistent);
        }
    }

    private void copyRelationshipListFrom(List list, List list2, boolean bl, CacheField cacheField, Set set) throws CacheException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        String string = cacheField.getInverseFieldName();
        CacheClass cacheClass = this.getDatabase().getCacheClass(cacheField.getElementTypeName());
        CacheField cacheField2 = cacheClass.getField(string);
        list2.clear();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            Persistent persistent = this.copyPersistentFrom(null, e, bl, set, false);
            cacheField2.set(persistent, (Object)this);
            if (persistent.getId() == null) {
                this.manager().register(persistent, e);
            }
            list2.add(persistent);
        }
    }

    private void copySerialListFrom(List list, List list2) throws CacheException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException, InvocationTargetException {
        list2.clear();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            Object object = this.copySerial(e);
            list2.add(object);
        }
    }

    private void copyPersistentArrayFrom(Map map, Map map2, boolean bl, Set set) throws CacheException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        map2.clear();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            Persistent persistent = this.copyPersistentFrom(null, v, bl, set, false);
            map2.put(entry.getKey(), persistent);
        }
    }

    private void copySerialArrayFrom(Map map, Map map2) throws CacheException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        map2.clear();
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            Object object = this.copySerial(v);
            map2.put(entry.getKey(), object);
        }
    }

    private Object copySerial(Object object) throws CacheException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        CacheClass cacheClass = this.cacheClassFor(object);
        CacheRootObject cacheRootObject = (CacheRootObject)cacheClass.newInstance("");
        cacheRootObject.copyFrom(object, true, null);
        return cacheRootObject;
    }

    private Object copyStream(Object object, Object object2) throws CacheException {
        if (object instanceof InputStream) {
            if (object2 instanceof OutputStream) {
                this.readStreamToAnotherStream((InputStream)object, (OutputStream)object2);
                return null;
            }
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                byte[] byArray = this.readStreamToByteArray((InputStream)object);
                if (clazz.isAssignableFrom(byte[].class)) {
                    return byArray;
                }
                if (clazz.isAssignableFrom(String.class)) {
                    return new String(byArray);
                }
                throw new CacheException("Do not know how to set stream.");
            }
            throw new SystemError("Unknown type: " + object2.getClass().getName());
        }
        if (object instanceof Reader) {
            if (object2 instanceof Writer) {
                this.readStreamToAnotherStream((Reader)object, (Writer)object2);
                return null;
            }
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                String string = this.readStreamToCharArray((Reader)object);
                if (clazz.isAssignableFrom(byte[].class)) {
                    return string.getBytes();
                }
                if (clazz.isAssignableFrom(char[].class)) {
                    return string.toCharArray();
                }
                if (clazz.isAssignableFrom(String.class)) {
                    return string;
                }
                throw new CacheException("Do not know how to set stream.");
            }
            throw new SystemError("Unknown type: " + object2.getClass().getName());
        }
        throw new SystemError("Unknown type: " + object.getClass().getName());
    }

    private byte[] readStreamToByteArray(InputStream inputStream) throws CacheException {
        try {
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n > 0) {
                int n3 = inputStream.read(byArray, n2, n);
                n -= n3;
                n2 += n3;
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    private String readStreamToCharArray(Reader reader) throws CacheException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 8192;
            char[] cArray = new char[n2];
            while (reader.ready() && (n = reader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readStreamToAnotherStream(InputStream inputStream, OutputStream outputStream) throws CacheException {
        try {
            while (inputStream.available() > 0) {
                byte[] byArray = BYTE_STREAM_BUFFER;
                // MONITORENTER : BYTE_STREAM_BUFFER
                int n = inputStream.read(BYTE_STREAM_BUFFER);
                if (n < 0) {
                    // MONITOREXIT : byArray
                    return;
                }
                outputStream.write(BYTE_STREAM_BUFFER, 0, n);
                // MONITOREXIT : byArray
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readStreamToAnotherStream(Reader reader, Writer writer) throws CacheException {
        try {
            while (reader.ready()) {
                char[] cArray = CHAR_STREAM_BUFFER;
                // MONITORENTER : CHAR_STREAM_BUFFER
                int n = reader.read(CHAR_STREAM_BUFFER);
                if (n < 0) {
                    // MONITOREXIT : cArray
                    return;
                }
                writer.write(CHAR_STREAM_BUFFER, 0, n);
                // MONITOREXIT : cArray
            }
            return;
        }
        catch (IOException iOException) {
            throw new CacheException(iOException, "Failed to read stream.");
        }
    }

    private void copyList(List list, List list2, boolean bl, Map map, boolean bl2) throws Exception {
        int n;
        if (list.size() != list2.size()) {
            list2.clear();
            if (bl) {
                list2.addAll(list);
                return;
            }
            for (n = 0; n < list.size(); ++n) {
                list2.add(null);
            }
        }
        n = 0;
        for (Object e : list) {
            HashMap hashMap;
            if (e instanceof CacheRootObject) {
                hashMap = this.findPojo((CacheRootObject)e, true, map, bl2);
                list2.set(n, hashMap);
            } else if (e instanceof List) {
                hashMap = new ArrayList();
                this.copyList((List)e, (List)((Object)hashMap), false, map, bl2);
                list2.set(n, hashMap);
            } else if (e instanceof Map) {
                hashMap = new HashMap();
                this.copyMap((Map)e, hashMap, false, map, bl2);
                list2.set(n, hashMap);
            } else {
                list2.set(n, e);
            }
            ++n;
        }
    }

    private void copyMap(Map map, Map map2, boolean bl, Map map3, boolean bl2) throws Exception {
        map2.clear();
        if (bl) {
            map2.putAll(map);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                HashMap hashMap;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v instanceof CacheRootObject) {
                    hashMap = this.findPojo((CacheRootObject)v, true, map3, bl2);
                    map2.put(k, hashMap);
                    continue;
                }
                if (v instanceof List) {
                    hashMap = new ArrayList();
                    this.copyList((List)v, (List)((Object)hashMap), false, map3, bl2);
                    map2.put(k, hashMap);
                    continue;
                }
                if (v instanceof Map) {
                    hashMap = new HashMap();
                    this.copyMap((Map)v, hashMap, false, map3, bl2);
                    map2.put(k, hashMap);
                    continue;
                }
                map2.put(k, v);
            }
        }
    }

    private Object findPojo(CacheRootObject cacheRootObject, boolean bl, Map map, boolean bl2) throws Exception {
        if (cacheRootObject == null) {
            return null;
        }
        Object object = map.get(cacheRootObject);
        if (object != null) {
            return object;
        }
        object = this.manager().findPOJO(cacheRootObject, bl2);
        if (object != null) {
            if (!bl2 || !ObjectFactory.isProxy(object)) {
                cacheRootObject.copyTo(object, map, bl2);
            }
            return object;
        }
        if (bl) {
            return cacheRootObject.detach(map, bl2);
        }
        return NOT_FOUND;
    }

    private void mergeInto(Object object, String string, CacheRootObject cacheRootObject, Class clazz, Map map, boolean bl) throws Exception {
        Object object2 = PojoOperations.getValue(object, string, this.manager());
        if (object2 == null || !this.same(object, cacheRootObject)) {
            this.setValue(object, string, cacheRootObject.detach(map, bl), clazz);
        } else {
            cacheRootObject.copyTo(object2, map, bl);
        }
    }

    private boolean same(Object object, CacheRootObject cacheRootObject) throws CacheException {
        if (object == null) {
            return cacheRootObject == null;
        }
        if (cacheRootObject == null) {
            return false;
        }
        if (!(cacheRootObject instanceof Persistent)) {
            return false;
        }
        Id id = ((Persistent)cacheRootObject).getId();
        if (id == null) {
            return false;
        }
        Serializable serializable = null;
        try {
            serializable = PojoOperations.getPojoId(object, this.cacheClassFor(object));
        }
        catch (Exception exception) {
            throw new CacheException(exception, "Failed to get Id of a POJO");
        }
        return id.equals(serializable);
    }

    private Class getStreamJavaType(Object object, CacheField cacheField) throws CacheException {
        String string = cacheField.getJavaTypeName();
        if (string != null && string.startsWith("com.intersys.classes")) {
            return null;
        }
        return this.getJavaType(object, cacheField);
    }

    private Class getJavaType(Object object, CacheField cacheField) throws CacheException {
        String string = cacheField.getJavaName();
        try {
            Method method = null;
            method = PojoOperations.getGetter(object, string, this.manager());
            return method.getReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return PojoOperations.getField(object, string).getType();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (cacheField.isStream()) {
                    return null;
                }
                throw new CacheException("Neither accessor method nor field is found for property " + string);
            }
        }
    }

    private void setPojoId(Object object) throws CacheException {
        Persistent persistent = (Persistent)this;
        Id id = persistent.getId();
        String string = id == null ? null : id.toString();
        PojoOperations.setPojoId(object, (Serializable)((Object)string), this.cacheClassFor(object), this.manager());
    }

    private Object tryConvertValue(Class clazz, Object object) {
        if (object == null) {
            return object;
        }
        if (clazz.isPrimitive()) {
            return object;
        }
        throw new IllegalArgumentException("Can not convert value " + object + " of type " + object.getClass().getName() + " to type " + clazz.getName());
    }

    private void setValue(Object object, String string, Object object2, Class clazz) throws IllegalAccessException, InvocationTargetException, CacheException {
        Class<?> clazz2 = object.getClass();
        try {
            String string2 = "set" + string;
            Method method = this.getMethod(clazz2, string2, new Class[]{clazz});
            if (!clazz.isInstance(object2)) {
                this.tryConvertValue(clazz, object2);
            }
            method.invoke(object, object2);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = PojoOperations.getField(object, string);
                field.setAccessible(true);
                if (object2 != null || !field.getType().isPrimitive()) {
                    if (!field.getType().isInstance(object2)) {
                        object2 = this.tryConvertValue(field.getType(), object2);
                    }
                    field.set(object, object2);
                }
                return;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (string.equals("_Version")) {
                    PojoOperations.setConcurrencyControlVersion(object, object2);
                    return;
                }
                throw new CacheException("Neither accessor method nor field is found for property " + object.getClass().getName() + "." + string);
            }
        }
    }

    protected void ensureSaved() throws CacheException {
        if (this instanceof Persistent) {
            Persistent persistent = (Persistent)this;
            if (persistent.getOid() == null || persistent.getOid().undefined()) {
                persistent.save(false);
            }
            return;
        }
        if (this.mInternal instanceof QuickEmbeddedObject) {
            ((QuickEmbeddedObject)this.mInternal).ensureSaved();
        }
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        return this.manager().getMethod(clazz, string, classArray);
    }

    private void setStreamValue(Object object, String string, Object object2, Class clazz) throws IllegalAccessException, InvocationTargetException, CacheException {
        try {
            String string2 = string + "Out";
            Method method = PojoOperations.getGetter(object, string2, this.manager());
            Object object3 = method.invoke(object, new Object[0]);
            this.copyStream(object2, object3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object4 = this.copyStream(object2, clazz);
            this.setValue(object, string, object4, clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof NullPointerException) {
                return;
            }
            throw invocationTargetException;
        }
    }

    private Object getStreamValue(Object object, String string) throws IllegalAccessException, InvocationTargetException, CacheException {
        try {
            String string2 = string + "In";
            Method method = PojoOperations.getGetter(object, string2, this.manager());
            return method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return PojoOperations.getValue(object, string, this.manager());
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof NullPointerException) {
                return null;
            }
            throw invocationTargetException;
        }
    }

    private DetachedObjectsManager manager() {
        SysDatabase sysDatabase = (SysDatabase)this.getDatabase();
        DetachedObjectsManager detachedObjectsManager = sysDatabase.getDetachedObjectsManager();
        return detachedObjectsManager;
    }

    private ObjectFactory objectFactory() {
        return this.manager().getObjectFactory();
    }

    protected void clearState() {
        this.getProxy().clearState();
    }

    protected boolean pojoUpdateRequired(Object object, boolean bl) {
        int n = this.getProxy().getState();
        if ((n & 0xF) != 0) {
            return true;
        }
        try {
            if (this.manager().findPOJO(this, bl) == object) {
                return false;
            }
        }
        catch (Exception exception) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInternal(boolean bl) throws CacheException {
        Database database;
        if (this.mInternal == null) {
            throw new ObjectClosedException(null, "Object has been already released");
        }
        Database database2 = database = this.getDatabase();
        synchronized (database2) {
            if (this.mInternal.isClosed()) {
                return;
            }
            if (bl) {
                ((AbstractCacheObject)this.mInternal).decreaseCountImmediately();
            } else {
                this.mInternal.decreaseCount();
            }
            this.mInternal = null;
        }
    }

    public void assertNeverClosed() throws CacheException {
        this.mInternal.assertNotClosed(true);
    }

    public void cancelNeverClosedAssertion() throws CacheException {
        this.mInternal.assertNotClosed(false);
    }

    public void release() throws CacheException {
        this.releaseInternal(false);
    }

    protected void finalize() throws Throwable {
        if (this.mInternal != null) {
            this.releaseInternal(false);
        }
        super.finalize();
    }
}

