/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.oldmetadata.QuickCacheClassFactory;
import com.intersys.cache.quick.ChidTableClass;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheClassNew;
import com.intersys.cache.quick.QuickDBAdapter;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheField;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class QuickDatabase
extends LightDatabase {
    private ReadOnlyDatabase mMetadataConnection = null;
    private static final boolean NEW_METADATA_ALLOWED = true;
    private int mReflectionVersion;

    public QuickDatabase(String string, String string2, String string3) throws CacheException {
        this.mURL = ConnectionUtils.createURLString(string);
        CacheConnection cacheConnection = ConnectionUtils.staticInitConnection(this.mURL, string2, string3);
        this.amIConnectionOwner = true;
        this.initClientDatabase(cacheConnection);
    }

    protected QuickDatabase(Connection connection) throws CacheException {
        super(connection);
    }

    protected final void onInitDatabase(Connection connection) throws CacheException {
        CacheConnection cacheConnection = connection instanceof CacheConnection ? (CacheConnection)connection : JDBCAdapter.getCacheConnection(connection);
        this.mAdapter = new QuickDBAdapter(cacheConnection);
        this.mInfo = new ObjectServerInfo();
        ((JDBCAdapter)((Object)this.myAdapter())).setupServerInfo(this.mInfo);
        this.mProcess = this.mInfo.processNumber;
        cacheConnection.registerDatabase().register(this);
        this.mReflectionVersion = ((JDBCAdapter)((Object)this.myAdapter())).getReflectionVersion();
    }

    protected Iterator getResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
        return new CacheResultSetIterator(resultSet, tableBasedClass, n);
    }

    protected int getKeyColumn(String string) throws CacheException {
        if (this.useNewMetadata()) {
            return super.getKeyColumn(string);
        }
        Integer n = (Integer)this.mElementKeyMap.get(string);
        if (n != null) {
            return n;
        }
        JDBCAdapter.TableInfo tableInfo = this.getTableColumnNumbers(string, false);
        JDBCAdapter.TableColumnInfo tableColumnInfo = (JDBCAdapter.TableColumnInfo)tableInfo.get("element_key");
        if (tableColumnInfo == null) {
            throw new CacheException("Failed to determine column number for element_key in table " + string);
        }
        int n2 = tableColumnInfo.columnForSet - 2;
        this.mElementKeyMap.put(string, new Integer(n2));
        return n2;
    }

    public JDBCAdapter.TableInfo getTableColumnNumbers(String string, boolean bl) throws CacheServerException, SystemError {
        return ((JDBCAdapter)((Object)this.myAdapter())).getTableColumnNumbers(string, bl);
    }

    public JDBCAdapter.TableInfo getSerialState(String string) throws CacheServerException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getSerialStateInfo(string);
    }

    public static JDBCAdapter.TableInfo getEmptyTableInfo() {
        return JDBCAdapter.TableInfo.getEmpty();
    }

    public String getInverseRelated(String string, String string2) throws CacheServerException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getInverseRelated(string, string2);
    }

    protected static boolean isSysOrefSupported() {
        return true;
    }

    protected void removeFromCache(int n) {
    }

    protected byte[] getClassMethods(String string) throws CacheException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getClassMethods(string);
    }

    protected byte[] getQueryProcInfo(String string, String string2) throws CacheException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getQueryProcInfo(string, string2);
    }

    protected String getJavaPackage(String string) throws CacheException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getJavaPackage(string);
    }

    public String getClassType(String string) throws CacheException {
        return ((JDBCAdapter)((Object)this.myAdapter())).getClassType(string);
    }

    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        if (this.mMetadataConnection == null) {
            this.mMetadataConnection = new ReadOnlyDatabase(this.myConnection(), (SysDatabase)this, true);
            return this.mMetadataConnection;
        }
        return this.mMetadataConnection.getReadOnlyDatabase();
    }

    public JDBCAdapter getAdapter() {
        return (JDBCAdapter)((Object)this.myAdapter());
    }

    protected boolean serverSupportsBulk() {
        if (this.mInfo.getMajorObjectVersion() < 5) {
            return false;
        }
        if (this.mInfo.getMajorObjectVersion() > 5) {
            return true;
        }
        if (this.mInfo.getMinorObjectVersion() >= 1) {
            return true;
        }
        return this.mInfo.getMajorObjectBuildNumber() > 1909;
    }

    protected boolean commaSeparatedCollectionsInRS() {
        if (this.mInfo.getMajorObjectVersion() > 5) {
            return false;
        }
        return this.mInfo.getMinorObjectVersion() < 1;
    }

    protected final boolean isServerUnicode() {
        return ((CacheConnection)this.myConnection()).isServerUnicode();
    }

    protected final String getServerLocale() {
        return ((CacheConnection)this.myConnection()).getServerLocale();
    }

    protected void onClose() {
        ((CacheConnection)this.mAdapter.getConnection()).registerDatabase().unregister(this);
    }

    public int getReflectionVersion() {
        return this.mReflectionVersion;
    }

    private boolean useNewMetadata() {
        boolean bl = this.getReflectionVersion() >= 10;
        return bl;
    }

    public TableBasedClass createQuickCacheClass(String string, boolean bl) throws CacheException {
        if (this.useNewMetadata()) {
            return new QuickCacheClassNew(this, string, bl, false);
        }
        return QuickCacheClassFactory.createQuickCacheClass(this, string);
    }

    public TableBasedClass createQuickCacheClassByTable(String string, boolean bl) throws CacheException {
        if (this.useNewMetadata()) {
            return new QuickCacheClassNew(this, string, bl, true);
        }
        return QuickCacheClassFactory.createQuickCacheClassByTable(this, string);
    }

    protected TableBasedClass createQuickCacheClass(ColumnBasedField columnBasedField) throws CacheException {
        TableBasedClass tableBasedClass;
        if (this.useNewMetadata()) {
            QuickCacheClassNew quickCacheClassNew = (QuickCacheClassNew)this.getCacheClass(columnBasedField.getElementTypeName());
            tableBasedClass = new ChidTableClass((LightDatabase)this, quickCacheClassNew, columnBasedField.getChildTableMetadata(), columnBasedField.getCollectionType());
        } else {
            tableBasedClass = this.createQuickCacheClass(columnBasedField.getElementTypeName(), columnBasedField.getChildTableName(), columnBasedField.getCollectionType());
        }
        this.mClassMap.put(columnBasedField.getChildTableName(), tableBasedClass);
        return tableBasedClass;
    }

    public TableBasedClass createQuickCacheClass(String string, String string2, int n) throws CacheException {
        if (this.useNewMetadata()) {
            throw new CacheException("Never should have been called.");
        }
        return QuickCacheClassFactory.createQuickCacheClass(this, string, string2, n);
    }

    public CacheField createCacheField(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        if (this.useNewMetadata()) {
            throw new UnsupportedOperationException("Never should have been called.");
        }
        return QuickCacheClassFactory.createCacheField(this, string, string2, string3, string4, n, n2, n3);
    }

    public int transactionLevel() throws CacheException {
        CacheConnection cacheConnection = (CacheConnection)this.myConnection();
        int n = 0;
        try {
            n = cacheConnection.getAutoCommit() ? 0 : 1;
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to determine transaction level.");
        }
        return n;
    }

    private class CacheResultSetIterator
    extends LightDatabase.ResultSetIterator {
        public CacheResultSetIterator(ResultSet resultSet, TableBasedClass tableBasedClass, int n) {
            super(resultSet, tableBasedClass, n);
        }

        protected Object getWire() throws SQLException {
            return ((CacheResultSet)this.mRS).getWire();
        }
    }
}

