/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickPersistentObject;
import com.intersys.cache.quick.QuickReaderObject;
import com.intersys.cache.quick.QuickStreamObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.RelationshipObject;
import com.intersys.jdbc.QuickStatement;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QuickCacheObject
implements CacheObject {
    protected static Object UNCHANGED = QuickStatement.UNCHANGED_OBJECT;
    protected TableBasedClass mClass;
    private Object mUserData;
    private int mCount;
    private boolean mAssertNotClosed = false;
    protected int mState;

    protected QuickCacheObject(TableBasedClass tableBasedClass) {
        this.mClass = tableBasedClass;
        this.mCount = 0;
    }

    public CacheObject getMe() {
        return this;
    }

    public String getTypeName() {
        return this.mClass.getName();
    }

    public int getOref() throws ObjectClosedException {
        Id id;
        try {
            id = this.getId();
        }
        catch (CacheException cacheException) {
            id = null;
        }
        if (id == null) {
            return 0;
        }
        try {
            return Integer.parseInt(id.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public final Object getZRef() {
        return new ZRef();
    }

    public SysDatabase getDatabase() {
        if (this.mClass == null) {
            return null;
        }
        return this.mClass.getDatabase();
    }

    public void setCacheClass(CacheClass cacheClass) throws CacheException {
        throw new CacheException("Call to setCacheClass not allowed in this implementation of CacheObject");
    }

    public CacheClass getCacheClass() {
        return this.mClass;
    }

    public Id getId() throws CacheException {
        return null;
    }

    public Oid getOid() throws CacheException {
        return null;
    }

    public void delete() throws CacheException {
        this.getDatabase().deleteObject(this.getOid());
    }

    public boolean isClosed() {
        return this.mCount <= 0;
    }

    public void forceClose() throws CacheException {
        ((LightDatabase)this.getDatabase()).closeObject(this.getOid());
        this.mCount = 0;
    }

    public void increaseReferenceCount() throws CacheException {
        throw new ReferenceCountingException("This is not a reference counting object");
    }

    public void decreaseReferenceCount() throws CacheException {
        throw new ReferenceCountingException("This is not a reference counting object");
    }

    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        Dataholder dataholder;
        if (string.endsWith("Get") && (dataholder = this.checkIfCalculatedProperty(string, n)) != null) {
            return dataholder;
        }
        throw new CacheException("Not supported feature. Use full Database implementation.");
    }

    private Dataholder checkIfCalculatedProperty(String string, int n) throws CacheException {
        CacheField cacheField = this.mClass.isGetterForCalculatedProperty(string);
        if (cacheField != null) {
            return this.getProperty(cacheField.getII(), cacheField.getJJ(), n, cacheField.getName());
        }
        return null;
    }

    public Object newJavaInstance() throws CacheException {
        return this.newJavaInstance(false);
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        return cacheClass.newInstance(this, bl);
    }

    public void setUserData(Object object) {
        this.mUserData = object;
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void increaseCount() throws CacheException {
        ++this.mCount;
    }

    public void decreaseCount() throws CacheException {
        --this.mCount;
        if (this.mCount == 0 && this.getOid() != null) {
            if (this.mAssertNotClosed) {
                String string = "Object " + this.toString() + " registered for assetrion and is being closed";
                CacheException cacheException = new CacheException(string);
                cacheException.printStackTrace();
                throw cacheException;
            }
            ((LightDatabase)this.getDatabase()).closeObject(this.getOid());
        }
    }

    public void assertNotClosed(boolean bl) throws CacheException {
        this.mAssertNotClosed = bl;
    }

    public String toOrefString() throws CacheException {
        return this.getZRef().toString();
    }

    public boolean equals(Object object) {
        Id id;
        if (!(object instanceof QuickCacheObject)) {
            return false;
        }
        try {
            id = this.getId();
        }
        catch (CacheException cacheException) {
            id = null;
        }
        if (id == null) {
            return object == this;
        }
        QuickCacheObject quickCacheObject = (QuickCacheObject)object;
        try {
            return this.mClass.equals(quickCacheObject.mClass) && id.equals(quickCacheObject.getId());
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object valueToSave(ColumnBasedField columnBasedField, Object object, boolean bl) throws CacheException {
        if (object == null) return null;
        if (object.equals(UNCHANGED)) return null;
        if (columnBasedField.isEmbedded()) {
            return null;
        }
        Dataholder dataholder = (Dataholder)object;
        LightDatabase lightDatabase = (LightDatabase)this.getDatabase();
        Object object2 = dataholder.getObject();
        int n = columnBasedField.getCollectionType();
        if (n == 32) {
            QuickStreamObject quickStreamObject = (QuickStreamObject)object2;
            return lightDatabase.wrapBinaryStream(quickStreamObject.getInForSetting());
        }
        if (n == 64) {
            QuickReaderObject quickReaderObject = (QuickReaderObject)object2;
            return lightDatabase.wrapCharacterStream(quickReaderObject.getInForSetting());
        }
        if (n != 0) {
            Object object3 = dataholder.getCollection();
            String string = columnBasedField.getChildTableName();
            if (string != null) {
                Id id;
                if (!lightDatabase.isClassRegistered(string) && !columnBasedField.isRelationship()) {
                    lightDatabase.createQuickCacheClass(columnBasedField);
                }
                if ((id = this.getId()) == null) {
                    return UNCHANGED;
                }
                if (n == 8) {
                    lightDatabase.saveChildList(string, id.toString(), (List)object3, bl);
                    return null;
                } else if (n == 21) {
                    List list = ((RelationshipObject)object3).asList();
                    this.saveOMRelationship(columnBasedField, list, bl);
                    return null;
                } else if (n == 19) {
                    List list = ((RelationshipObject)object3).asList();
                    this.savePCRelationship(list, bl);
                    return null;
                } else {
                    if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                    lightDatabase.saveChildArray(string, id.toString(), (Map)object3, bl);
                }
                return null;
            }
            if (columnBasedField.isElementPersistent()) {
                if (columnBasedField.isList()) {
                    return lightDatabase.wrapRefList((List)object3, bl);
                }
                if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                return lightDatabase.wrapRefArray((Map)object3, bl);
            }
            if (columnBasedField.isElementSerial()) {
                if (columnBasedField.isList()) {
                    return lightDatabase.wrapSerialList((List)object3);
                }
                if (n != 1) throw new CacheException("Unsupported collection type: " + n);
                return lightDatabase.wrapSerialArray((Map)object3);
            }
            if (!columnBasedField.isElementDatatype()) throw new CacheException("Unsupported collection element type");
            if (columnBasedField.isList()) {
                if (!"%Library.Currency".equals(columnBasedField.getElementTypeName())) return lightDatabase.wrapPrimList((List)object3);
                object3 = this.scaleCurrency((List)object3);
                return lightDatabase.wrapPrimList((List)object3);
            }
            if (n != 1) throw new CacheException("Unsupported collection type: " + n);
            if (!"%Library.Currency".equals(columnBasedField.getElementTypeName())) return lightDatabase.wrapPrimArray((Map)object3);
            object3 = this.scaleCurrency((Map)object3);
            return lightDatabase.wrapPrimArray((Map)object3);
        }
        if (columnBasedField.isObject()) {
            if (dataholder.getType() == 1028) {
                return dataholder.getString();
            }
            CacheObject cacheObject = dataholder.getCacheObject();
            if (cacheObject == null) {
                return dataholder;
            }
            if (!this.getDatabase().equals(cacheObject.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + cacheObject + " object from another database: " + cacheObject.getDatabase() + " in " + this.getDatabase());
            }
            object2 = cacheObject.getId();
            if (!bl) {
                if (object2 != null) return object2.toString();
            }
            cacheObject.save(bl);
            object2 = cacheObject.getId();
            return object2.toString();
        }
        if (object2 != null) return object2;
        return dataholder;
    }

    private List scaleCurrency(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (Object object : list) {
            if (object instanceof BigDecimal) {
                object = ((BigDecimal)object).setScale(4, 4);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private Map scaleCurrency(Map map) {
        HashMap hashMap = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof BigDecimal) {
                object = ((BigDecimal)object).setScale(4, 4);
            }
            hashMap.put(entry.getKey(), object);
        }
        return hashMap;
    }

    public Object getSerialState(Object object) throws CacheException {
        throw new CacheException("Object of class " + this.mClass.getName() + " is not serializable");
    }

    private void savePCRelationship(List list, boolean bl) throws CacheException {
        for (RegisteredObject registeredObject : list) {
            if (!this.getDatabase().equals(registeredObject.getDatabase())) {
                throw new CacheException("Attempt to save persistent " + registeredObject + " object from another database: " + registeredObject.getDatabase() + " in " + this.getDatabase());
            }
            TableBasedClass tableBasedClass = (TableBasedClass)registeredObject.getCacheClass();
            ColumnBasedField columnBasedField = (ColumnBasedField)tableBasedClass.getParentField();
            QuickPersistentObject quickPersistentObject = (QuickPersistentObject)registeredObject.getProxy();
            quickPersistentObject.setProperty(columnBasedField, new Dataholder(this), true);
            quickPersistentObject.save(bl);
        }
    }

    private void saveOMRelationship(ColumnBasedField columnBasedField, List list, boolean bl) throws CacheException {
        block11: {
            block9: {
                boolean bl2;
                String string;
                SysDatabase sysDatabase;
                block10: {
                    String string2 = columnBasedField.getInverseFieldName();
                    sysDatabase = this.getDatabase();
                    string = null;
                    boolean bl3 = true;
                    boolean bl4 = true;
                    bl2 = true;
                    for (Object object : list) {
                        if (!sysDatabase.equals(((CacheRootObject)object).getDatabase())) {
                            throw new CacheException("Attempt to save persistent " + object + " object from another database: " + ((CacheRootObject)object).getDatabase() + " in " + this.getDatabase());
                        }
                        QuickPersistentObject quickPersistentObject = (QuickPersistentObject)((CacheRootObject)object).getProxy();
                        TableBasedClass tableBasedClass = (TableBasedClass)((RegisteredObject)object).getCacheClass();
                        ColumnBasedField columnBasedField2 = (ColumnBasedField)tableBasedClass.getField(string2);
                        quickPersistentObject.setProperty(columnBasedField2, new Dataholder(this), true);
                        if (!bl3) continue;
                        if (quickPersistentObject.getId() == null) {
                            bl4 = false;
                        } else {
                            bl2 = false;
                        }
                        if (quickPersistentObject.inSave) {
                            bl3 = false;
                        }
                        if (!bl4 && !bl2) {
                            bl3 = false;
                        }
                        if (string == null) {
                            string = tableBasedClass.getName();
                            continue;
                        }
                        if (string.equals(tableBasedClass.getName())) continue;
                        bl3 = false;
                    }
                    if (bl4 && bl2) {
                        bl3 = false;
                    }
                    if (!bl3) break block9;
                    if (!bl4) break block10;
                    sysDatabase.saveObjects(string, list);
                    break block11;
                }
                if (!bl2) break block11;
                sysDatabase.createObjects(string, list);
                break block11;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = ((RegisteredObject)iterator.next()).getProxy();
                object.save(bl);
            }
        }
    }

    public int getState() {
        return this.mState;
    }

    public void clearState() {
        this.mState = 65280;
    }

    public void setStateReadDirty() {
        this.mState |= 0xFF01;
    }

    public class ZRef {
        public String getClassName() throws CacheException {
            return QuickCacheObject.this.getCacheClass().getName();
        }

        public String getIdString() throws CacheException {
            Id id = QuickCacheObject.this.getId();
            if (id == null) {
                return null;
            }
            return id.toString();
        }

        public String toString() {
            try {
                return this.getIdString() + "@" + this.getClassName();
            }
            catch (CacheException cacheException) {
                return cacheException.toString();
            }
        }
    }
}

