/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.oldmetadata.AbstractCacheClass;
import com.intersys.cache.oldmetadata.FieldIterator;
import com.intersys.cache.oldmetadata.JDBCCacheQueryInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheQueryDefinition;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public abstract class JDBCCacheClass
extends AbstractCacheClass {
    private Map mQueryMap = null;
    private JDBCAdapter mAdapter;
    private SysDatabase mDB;
    protected byte[] mProperties = null;
    protected CacheClass[] mSuperClasses;
    private CacheQueryDefinition[] mQueries;

    public JDBCCacheClass(String string, JDBCAdapter jDBCAdapter, SysDatabase sysDatabase) {
        super(string);
        this.mAdapter = jDBCAdapter;
        this.mDB = sysDatabase;
    }

    public CacheField[] getFields() throws CacheException {
        Vector vector = this.getFieldsAsVector();
        CacheField[] cacheFieldArray = new CacheField[vector.size()];
        cacheFieldArray = vector.toArray(cacheFieldArray);
        return cacheFieldArray;
    }

    protected Vector getFieldsAsVector() throws CacheException {
        this.checkProperties();
        Vector vector = new Vector();
        FieldIterator fieldIterator = new FieldIterator(this.getDatabase(), this.mProperties);
        while (fieldIterator.hasNext()) {
            vector.add(fieldIterator.next());
        }
        return vector;
    }

    public CacheQueryDefinition[] getQueries() throws CacheException {
        Object object;
        Iterator iterator;
        if (this.mQueries != null) {
            return this.mQueries;
        }
        byte[] byArray = this.mAdapter.getClassQueries(this.mTypeName);
        if (byArray == null) {
            throw new CacheServerException("Failed to get queries for class " + this.getName());
        }
        if (this.mQueryMap == null) {
            this.mQueryMap = new HashMap();
        }
        try {
            Object object2 = SysListProxy.createSysList(byArray);
            iterator = SysListProxy.getWrappedItem(object2);
            object = new Dataholder(4096, iterator);
            this.getDatabase().parseStatus((Dataholder)object);
            while (!SysListProxy.atEnd(object2)) {
                String string = SysListProxy.getString(object2);
                String string2 = SysListProxy.getString(object2);
                int n = SysListProxy.getInteger(object2);
                JDBCCacheQueryInfo jDBCCacheQueryInfo = new JDBCCacheQueryInfo(this.getDatabase(), this, string, string2, n);
                this.mQueryMap.put(string, jDBCCacheQueryInfo);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get queries for class " + this.getName());
        }
        this.mQueries = new CacheQueryDefinition[this.mQueryMap.size()];
        int n = 0;
        iterator = this.mQueryMap.values().iterator();
        while (iterator.hasNext()) {
            this.mQueries[n] = object = (CacheQueryDefinition)iterator.next();
            ++n;
        }
        return this.mQueries;
    }

    protected static CacheClass[] parseSuperClassses(byte[] byArray, String string, SysDatabase sysDatabase) throws CacheException {
        if (byArray == null) {
            return new CacheClass[0];
        }
        Object object = SysListProxy.createSysList(byArray);
        Vector<CacheClass> vector = new Vector<CacheClass>();
        boolean bl = false;
        int n = 0;
        while (!SysListProxy.atEnd(object)) {
            CacheClass cacheClass;
            String string2;
            try {
                string2 = SysListProxy.getString(object);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Can not determine a superclass for Cache class " + string);
            }
            if (string2 == null || string2.equals("")) {
                bl = true;
            }
            if ((cacheClass = sysDatabase.getCacheClass(string2)) == null) {
                throw new InvalidClassException("Can not determine a superclass with  name \"" + string2 + "\" for Cache class " + string);
            }
            vector.add(cacheClass);
            ++n;
        }
        if (bl && vector.size() == 1) {
            throw new InvalidClassException("Empty superclass for Cache class " + string);
        }
        CacheClass[] cacheClassArray = new CacheClass[vector.size()];
        cacheClassArray = vector.toArray(cacheClassArray);
        return cacheClassArray;
    }

    public CacheQueryDefinition getQuery(String string) throws CacheException {
        if (this.mQueryMap == null) {
            this.mQueryMap = new HashMap();
        }
        CacheQueryDefinition cacheQueryDefinition = null;
        Object v = this.mQueryMap.get(string);
        if (v == null) {
            cacheQueryDefinition = new JDBCCacheQueryInfo(this.getDatabase(), this.mAdapter, this, string);
            this.mQueryMap.put(string, cacheQueryDefinition);
        } else {
            cacheQueryDefinition = (CacheQueryDefinition)v;
        }
        return cacheQueryDefinition;
    }

    protected void checkProperties() throws CacheException {
        if (this.mProperties == null) {
            this.mProperties = this.mAdapter.getClassProperties(this.mTypeName);
            if (this.mProperties == null) {
                throw new InvalidClassException(this.getName(), "Class " + this.getName() + " not found in Cache");
            }
        }
    }

    public CacheClass[] getCacheSuperclasses() throws CacheException {
        if (this.mSuperClasses == null) {
            byte[] byArray = this.mAdapter.getClassAncestors(this.mTypeName);
            this.mSuperClasses = JDBCCacheClass.parseSuperClassses(byArray, this.getName(), this.mDB);
        }
        return this.mSuperClasses;
    }

    public SysDatabase getDatabase() {
        return this.mDB;
    }

    protected void setAdapter(JDBCAdapter jDBCAdapter) {
        this.mAdapter = jDBCAdapter;
    }

    public String getJavaPackage() throws CacheException {
        int n;
        String string = this.mAdapter.getJavaPackage(this.mTypeName);
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            return string;
        }
        if (Character.isDigit(string.charAt(0)) && (n = string.indexOf(58)) > 0) {
            try {
                int n2 = Integer.parseInt(string.substring(0, n));
                String string2 = string.substring(n + 1);
                throw new InvalidClassException(null, this.getName(), string2, n2, null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new CacheException("Bad package returned for class " + this.getName() + ": " + string);
    }
}

