/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.oldmetadata;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.MethodHelper;
import com.intersys.classes.CacheGeneric;
import com.intersys.classes.Persistent;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.InvalidMethodException;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassInfo;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.TableMetadata;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public abstract class AbstractCacheClass
implements CacheClass {
    private static final String SYS_CLASSES_PACKAGE = "com.intersys.classes.";
    private static final String[] SYS_CLASSES = new String[]{"AbstractArray", "com.intersys.classes.AbstractList", "com.intersys.classes.ArrayOfDataTypes", "com.intersys.classes.ArrayOfObjects", "com.intersys.classes.ArrayOfObjectsWithClassName", "com.intersys.classes.ListOfDataTypes", "com.intersys.classes.ListOfObjects", "com.intersys.classes.ListOfObjectsWithClassName", "com.intersys.classes.ResultSet"};
    private static final int SYS_CLASSES_NAME_POS = "com.intersys.classes.".length();
    protected static CacheClass SERIAL_CLASS = null;
    protected static CacheClass PERSISTENT_CLASS = null;
    protected static CacheClass JGW_PROXY_CLASS = null;
    protected String mTypeName = null;
    private Class mJavaClass = null;
    private Class mSysJavaClass = null;
    private String mJavaClassName = null;
    private Constructor mJavaConstructor = null;
    private boolean mVerified = false;
    protected Boolean mSerial = null;
    protected Boolean mPersistent = null;

    public AbstractCacheClass(String string) {
        this.mTypeName = string;
        this.mJavaClass = null;
    }

    public final String getName() {
        return this.mTypeName;
    }

    public final String getJavaClassName() throws CacheException {
        if (this.mJavaClassName == null) {
            this.mJavaClassName = this.getCollectionClassName();
            if (this.mJavaClassName == null && this.getName().equals("%Library.BigInt")) {
                this.mJavaClassName = "java.lang.Long";
            }
            if (this.mJavaClassName == null) {
                String string = this.getJavaPackage();
                this.mJavaClassName = string + '.' + this.getShortName();
            }
        }
        return this.mJavaClassName;
    }

    private Class getSysJavaClass() throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.getJavaClassName(), false);
        }
        if (this.mSysJavaClass == null) {
            return this.mJavaClass;
        }
        return this.mSysJavaClass;
    }

    public Class getJavaClass() throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.getJavaClassName(), false);
        }
        return this.mJavaClass;
    }

    public Class getJavaClass(boolean bl) throws CacheException {
        if (this.mJavaClass == null) {
            this.setJavaClass(this.getJavaClassName(), bl);
        }
        return this.mJavaClass;
    }

    public void setJavaClass(String string, boolean bl) throws CacheException {
        if (this.mJavaClass != null) {
            throw new SystemError("Attempt to change java class name.");
        }
        SysDatabase sysDatabase = this.getDatabase();
        sysDatabase.addClass(this, string);
        ClassLoader classLoader = sysDatabase.getClassLoader();
        try {
            this.mJavaClass = classLoader == null ? Class.forName(string) : Class.forName(string, false, classLoader);
            this.setSysJavaClass(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (!bl) {
                throw new CacheException(classNotFoundException, "Unable to find Java class for Cache class " + this.getName());
            }
            this.mJavaClass = this.isPersistent() ? Persistent.class : RegisteredObject.class;
            return;
        }
    }

    private void setSysJavaClass(String string) throws ClassNotFoundException {
        if (Arrays.binarySearch(SYS_CLASSES, string) < 0) {
            return;
        }
        string = "com.intersys.classes.Sys" + string.substring(SYS_CLASSES_NAME_POS);
        this.mSysJavaClass = Class.forName(string);
    }

    public boolean isPersistent() throws CacheException {
        if (this.mPersistent == null) {
            if (Persistent.getCacheClassName().equals(this.getName())) {
                this.mPersistent = Boolean.TRUE;
            } else if (SerialObject.getCacheClassName().equals(this.getName())) {
                this.mPersistent = Boolean.FALSE;
            } else {
                AbstractCacheClass.checkPersistentClass(this.getDatabase());
                this.mPersistent = new Boolean(PERSISTENT_CLASS.isAssignableFrom(this));
            }
        }
        return this.mPersistent;
    }

    public boolean isSerial() throws CacheException {
        if (this.mSerial == null) {
            if (SerialObject.getCacheClassName().equals(this.getName())) {
                this.mSerial = Boolean.TRUE;
            } else if (Persistent.getCacheClassName().equals(this.getName())) {
                this.mSerial = Boolean.FALSE;
            } else {
                AbstractCacheClass.checkPersistentClass(this.getDatabase());
                this.mSerial = new Boolean(SERIAL_CLASS.isAssignableFrom(this));
            }
        }
        return this.mSerial;
    }

    public boolean isJavaClassSet() {
        return this.mJavaClass != null;
    }

    public Object openObject(Id id) throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        CacheObject cacheObject = sysDatabase.openCacheObject(this.getName(), id.toString());
        return this.newInstance(cacheObject, true);
    }

    public Object openObject(Oid oid) throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        CacheObject cacheObject = sysDatabase.openCacheObject(this.getName(), oid.getData());
        return this.newInstance(cacheObject, true);
    }

    public void deleteObject(Id id) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKey createKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKey createKey(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKey createBestCandidateKey() throws CacheException {
        throw new UnsupportedOperationException("Method createBestCandidateKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public Object newInstance(String string) throws CacheException {
        this.getJavaClass(true);
        CacheObject cacheObject = this.getDatabase().newCacheObject(this.getName(), string);
        return this.newInstance(cacheObject, true);
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return this.newInstance(cacheObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        if (this.isExternallyMapped()) {
            Object object = cacheObject.getZRef();
            Object object2 = this.getDatabase().getExternalObject(object);
            if (object2 == null) {
                throw new CacheException("Externally mapped object of class " + this.getName() + " and handle " + object + " not found.");
            }
            if (cacheObject instanceof AbstractCacheObject) {
                ((AbstractCacheObject)cacheObject).increaseCount();
                ((AbstractCacheObject)cacheObject).decreaseCount();
            }
            return object2;
        }
        Constructor constructor = this.getJavaConstructor(bl);
        try {
            Object[] objectArray = this;
            synchronized (this) {
                if (!this.mVerified) {
                    this.verifyClass();
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                constructor.setAccessible(true);
                objectArray = new Object[]{cacheObject};
                Object t = constructor.newInstance(objectArray);
                return t;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new CacheException(throwable, "Exception during call to invoke of " + this);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SystemError(illegalAccessException, "Exception during call to invoke of " + this);
        }
        catch (InstantiationException instantiationException) {
            throw new SystemError(instantiationException, "Exception during call to invoke of " + this);
        }
    }

    public Object createClientObject() throws CacheException {
        CacheObject cacheObject = this.getDatabase().newClientObject(this.getName());
        return this.newInstance(cacheObject, true);
    }

    public final boolean isVerified() {
        return this.mVerified;
    }

    public void verifyClass() throws CacheException {
        block5: {
            if (Logger.debugOn()) {
                Logger.out.println("Loading class " + this.getName() + "[" + this.getJavaClassName() + "]");
            }
            try {
                CacheGeneric.checkFieldsLimited(this.getDatabase(), this.getName(), this.getSysJavaClass());
            }
            catch (IllegalAccessException illegalAccessException) {
                if (Logger.debugOn()) {
                    Logger.out.println("Exception occured while verifying class " + this.getName() + ". Class unverified.");
                    illegalAccessException.printStackTrace(Logger.out);
                }
            }
            catch (SecurityException securityException) {
                if (!Logger.debugOn()) break block5;
                Logger.out.println("Exception occured while verifying class " + this.getName() + ". Class unverified.");
                securityException.printStackTrace(Logger.out);
            }
        }
        this.mVerified = true;
    }

    public CacheMethod getMethod(String string, CacheClassInfo[] cacheClassInfoArray) throws CacheException {
        String string2 = cacheClassInfoArray != null ? MethodHelper.constructSignature(string, Arrays.asList(cacheClassInfoArray).iterator(), false) : string;
        CacheMethod cacheMethod = this.getMethod(string2);
        if (cacheMethod != null) {
            return cacheMethod;
        }
        CacheMethod[] cacheMethodArray = this.getMethods();
        String string3 = "";
        for (int i = 0; i < cacheMethodArray.length; ++i) {
            if (!cacheMethodArray[i].getName().equals(string)) continue;
            string3 = string3 + cacheMethodArray[i] + "\n";
        }
        if (string3.equals("")) {
            string3 = "No method with name " + string + " in class " + this.getName();
        } else {
            String string4 = string + "(";
            if (cacheClassInfoArray != null) {
                for (int i = 0; i < cacheClassInfoArray.length; ++i) {
                    string4 = string4 + cacheClassInfoArray[i].getName();
                    if (i >= cacheClassInfoArray.length - 1) continue;
                    string4 = string4 + ",";
                }
            }
            string4 = string4 + ")";
            string3 = "Method " + string4 + " not found in class " + this.getName() + " Possible variants are: \n" + string3;
        }
        throw new InvalidMethodException(this.getDatabase(), this.getName(), string, string3);
    }

    public CacheClass getSuperclass() throws CacheException {
        CacheClass[] cacheClassArray = this.getCacheSuperclasses();
        if (cacheClassArray.length > 0) {
            return cacheClassArray[cacheClassArray.length - 1];
        }
        return null;
    }

    public boolean isAssignableFrom(CacheClassInfo cacheClassInfo) throws CacheException {
        if (this.equals(cacheClassInfo)) {
            return true;
        }
        CacheClass[] cacheClassArray = cacheClassInfo.getCacheSuperclasses();
        for (int i = 0; i < cacheClassArray.length; ++i) {
            if (!this.isAssignableFrom(cacheClassArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractCacheClass)) {
            return false;
        }
        AbstractCacheClass abstractCacheClass = (AbstractCacheClass)object;
        return this.mTypeName.equals(abstractCacheClass.getName());
    }

    public String toString() {
        return this.getName();
    }

    protected String getShortName() {
        int n = this.mTypeName.lastIndexOf(46);
        if (n < 0) {
            return this.mTypeName;
        }
        return this.mTypeName.substring(n + 1);
    }

    protected String getCollectionClassName() throws CacheException {
        if (!this.serverUsesNewCollections()) {
            return null;
        }
        CacheClass cacheClass = this.getDatabase().getCacheClass(Persistent.getCacheClassName());
        if (cacheClass.isAssignableFrom(this)) {
            return null;
        }
        CacheClass cacheClass2 = this.getDatabase().getCacheClass("%Collection.AbstractListOfDT");
        if (cacheClass2.isAssignableFrom(this)) {
            return "com.intersys.classes.ListOfDataTypes";
        }
        cacheClass2 = this.getDatabase().getCacheClass("%Collection.AbstractArrayOfDT");
        if (cacheClass2.isAssignableFrom(this)) {
            return "com.intersys.classes.ArrayOfDataTypes";
        }
        cacheClass2 = this.getDatabase().getCacheClass("%Collection.AbstractListOfObj");
        if (cacheClass2.isAssignableFrom(this)) {
            return "com.intersys.classes.ListOfObjects";
        }
        cacheClass2 = this.getDatabase().getCacheClass("%Collection.AbstractArrayOfObj");
        if (cacheClass2.isAssignableFrom(this)) {
            return "com.intersys.classes.ArrayOfObjects";
        }
        return null;
    }

    private boolean serverUsesNewCollections() throws CacheException {
        ObjectServerInfo objectServerInfo = this.getDatabase().getServerInfo();
        if (objectServerInfo.getMajorObjectVersion() > 5) {
            return true;
        }
        if (objectServerInfo.getMajorObjectVersion() < 5) {
            return false;
        }
        return objectServerInfo.getMinorObjectVersion() >= 1;
    }

    private Constructor getJavaConstructor(boolean bl) throws CacheException {
        if (this.mJavaConstructor == null) {
            try {
                Class clazz = this.getJavaClass(bl);
                Class[] classArray = new Class[]{CacheObject.class};
                this.mJavaConstructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SystemError(noSuchMethodException, "Exception during call to invoke of " + this);
            }
        }
        return this.mJavaConstructor;
    }

    protected static void checkPersistentClass(Database database) throws CacheException {
        if (PERSISTENT_CLASS == null) {
            PERSISTENT_CLASS = database.getCacheClass(Persistent.getCacheClassName());
        }
        if (SERIAL_CLASS == null) {
            SERIAL_CLASS = database.getCacheClass(SerialObject.getCacheClassName());
        }
    }

    protected abstract SysDatabase getDatabase();

    public boolean isExternallyMapped() throws CacheException {
        SysDatabase sysDatabase = this.getDatabase();
        if (!sysDatabase.hasObjectMapper()) {
            return false;
        }
        if (JGW_PROXY_CLASS == null) {
            JGW_PROXY_CLASS = sysDatabase.getCacheClass("EnsLib.JavaGateway.JavaGatewayProxy");
        }
        boolean bl = JGW_PROXY_CLASS.isAssignableFrom(this);
        return bl;
    }

    public boolean eagerFetchRequiredForPOJO() throws CacheException {
        throw new UnsupportedOperationException("Method eagerFetchRequiredForPOJO() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKey createPrimaryKey() throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKey createPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public Object openByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean deleteObjectByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean deleteObjectByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByPrimaryKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public int getClassTypeId() {
        throw new UnsupportedOperationException("Method getClassTypeId is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean hasDeleteIdMethod() {
        throw new UnsupportedOperationException("Method hasDeleteIdMethod() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean hasExistsIdMethod() {
        throw new UnsupportedOperationException("Method hasExistsIdMethod() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean hasOpenIdMethod() {
        throw new UnsupportedOperationException("Method hasOpenIdMethod() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean hasOpenMethod() {
        throw new UnsupportedOperationException("Method hasOpenMethod() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public boolean isChild() {
        throw new UnsupportedOperationException("Method isChild() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public String getParentClassName() {
        throw new UnsupportedOperationException("Method getParentClassName() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public TableMetadata getSQLTableMetadata() {
        throw new UnsupportedOperationException("Method getChildTableMetadata() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKeyInfo[] getAvailableCandidateKeys() throws CacheException {
        throw new UnsupportedOperationException("Method getAvailableCandidateKeys() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKeyInfo getBestCandidateKey() throws CacheException {
        throw new UnsupportedOperationException("Method getBestCandidateKey() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CandidateKeyInfo getKeyInfo(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getKeyInfo() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public CacheSerialStorageMetadata getSerialStateInfo() {
        throw new UnsupportedOperationException("Method getSerialStateInfo() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public String getSchemaName() {
        throw new UnsupportedOperationException("Method getSchemaName() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }

    public int getRowIdJDBCCode() {
        throw new UnsupportedOperationException("Method getRowIdJDBCCode() is not implemented in class com.intersys.cache.oldmetadata.AbstractCacheClass");
    }
}

