/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jdbcutil;

import com.intersys.cache.jdbcutil.RDBMSAdapter;
import com.intersys.cache.jdbcutil.SQLReservedWords;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.SystemError;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeMap;

public class JDBCAdapter
extends RDBMSAdapter {
    protected static final String helperReflectClass = "%Library.CPPStoredProc";
    private int mReflectVersion = -1;
    private static String versionString = "{ ? = call %Library.CPPStoredProc_getVersion( ) }";
    private static String classAncestorsString = "{ ? = call %Library.CPPStoredProc_getSupers( ? ) }";
    private CallableStatement mClassAncestorsCommand;
    private static String javaPackageString = "{ ? = call %Library.CPPStoredProc_getJavaPackage( ? ) }";
    private CallableStatement mJavaPackageCommand;
    private static String queryProcInfoString = "{ ? = call %Library.CPPStoredProc_getQueryProcInfo( ? , ? ) }";
    private static String queryNewInfoString = "{ ? = call %Library.CPPStoredProc_getQueryInfo( ? , ? ) }";
    private CallableStatement mQueryProcInfoCommand;
    private static String classMethodsString = null;
    private CallableStatement mClassMethodsCommand;
    private static String classPropertiesString = null;
    private CallableStatement mClassPropertiesCommand;
    private static String classQueriesString = "{ ? = call %Library.CPPStoredProc_getClassQueries( ? , ? ) }";
    private CallableStatement mClassQueriesCommand;
    private static String tableInfoString = "{ call %Library.SQLCatalog_SQLFields ( ? ) }";
    private CallableStatement mTableInfoCommand;
    private static String classTypeString = "{ ? = call %Library.CPPStoredProc_getClassType ( ? ) }";
    private CallableStatement mClassTypeCommand;
    private static String serialStateString = "{ ? = call %Library.CPPStoredProc_getSerialState ( ? ) }";
    private CallableStatement mSerialStateCommand;
    private static final String mInverseString = "{ ? = call %Library.CPPStoredProc_getInverse( ? , ? ) }";
    private CallableStatement mInverseStatement = null;
    private static final boolean mAllowOldMetadata = false;

    public JDBCAdapter(Connection connection) throws CacheException {
        super(connection);
    }

    private synchronized void initReflectionVersion() throws CacheServerException {
        block6: {
            if (this.mReflectVersion >= 0) {
                return;
            }
            try {
                try {
                    CallableStatement callableStatement = JDBCAdapter.prepareCall(this.mConnection, versionString);
                    callableStatement.registerOutParameter(1, 4);
                    this.execute(callableStatement, versionString);
                    this.mReflectVersion = callableStatement.getInt(1);
                    callableStatement.close();
                }
                catch (CacheServerException cacheServerException) {
                    int n = cacheServerException.getCode();
                    if (n == 428) {
                        this.mReflectVersion = 1;
                        break block6;
                    }
                    throw cacheServerException;
                }
            }
            catch (SQLException sQLException) {
                throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
            }
        }
    }

    private synchronized void initClassPropertiesStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mClassPropertiesCommand != null) {
            return;
        }
        int n = this.getReflectionVersion();
        classPropertiesString = "{ ? = call %Library.CPPStoredProc";
        classPropertiesString = n > 4 ? classPropertiesString + "_getClassProperties( ? , ?, ? ) }" : classPropertiesString + "_getClassProperties( ? , ?) }";
        try {
            this.mClassPropertiesCommand = JDBCAdapter.prepareCall(this.mConnection, classPropertiesString);
            this.mClassPropertiesCommand.registerOutParameter(1, -2);
            this.mClassPropertiesCommand.setInt(3, 2);
            if (n > 4) {
                this.mClassPropertiesCommand.setInt(4, 0);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initClassAncestorsStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mClassAncestorsCommand != null) {
            return;
        }
        try {
            this.mClassAncestorsCommand = JDBCAdapter.prepareCall(this.mConnection, classAncestorsString);
            this.mClassAncestorsCommand.registerOutParameter(1, -2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initQueryProcInfoStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mQueryProcInfoCommand != null) {
            return;
        }
        try {
            if (this.getReflectionVersion() > 3) {
                queryProcInfoString = queryNewInfoString;
            }
            this.mQueryProcInfoCommand = JDBCAdapter.prepareCall(this.mConnection, queryProcInfoString);
            this.mQueryProcInfoCommand.registerOutParameter(1, -2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initJavaPackageStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mJavaPackageCommand != null) {
            return;
        }
        try {
            this.mJavaPackageCommand = JDBCAdapter.prepareCall(this.mConnection, javaPackageString);
            this.mJavaPackageCommand.registerOutParameter(1, 12);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initClassMethodsStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mClassMethodsCommand != null) {
            return;
        }
        int n = this.getReflectionVersion();
        classMethodsString = "{ ? = call %Library.CPPStoredProc";
        classMethodsString = n > 4 ? classMethodsString + "_getClassMethods( ? , ?, ? ) }" : classMethodsString + "_getClassMethods( ? , ?) }";
        try {
            this.mClassMethodsCommand = JDBCAdapter.prepareCall(this.mConnection, classMethodsString);
            this.mClassMethodsCommand.registerOutParameter(1, -2);
            this.mClassMethodsCommand.setInt(3, 2);
            if (n > 4) {
                this.mClassMethodsCommand.setInt(4, 0);
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initClassQueriesStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mClassQueriesCommand != null) {
            return;
        }
        try {
            this.mClassQueriesCommand = JDBCAdapter.prepareCall(this.mConnection, classQueriesString);
            this.mClassQueriesCommand.registerOutParameter(1, -2);
            this.mClassQueriesCommand.setInt(3, 2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to initilize connection to Cache Server", sQLException));
        }
    }

    private synchronized void initTableInfoStatement() throws CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mTableInfoCommand != null) {
            return;
        }
        this.mTableInfoCommand = JDBCAdapter.prepareCall(this.mConnection, tableInfoString);
    }

    private synchronized void initClassTypeStatement() throws SQLException, CacheServerException, SystemError {
        if (this.getReflectionVersion() >= 10) {
            throw new SystemError("This method should not be called with new MD.");
        }
        if (this.mClassTypeCommand != null) {
            return;
        }
        if (this.getReflectionVersion() < 6) {
            return;
        }
        this.mClassTypeCommand = JDBCAdapter.prepareCall(this.mConnection, classTypeString);
        this.mClassTypeCommand.registerOutParameter(1, 12);
    }

    private synchronized void initSerialStateStatement() throws CacheServerException, SQLException {
        if (this.mSerialStateCommand != null) {
            return;
        }
        if (this.getReflectionVersion() < 6) {
            return;
        }
        this.mSerialStateCommand = JDBCAdapter.prepareCall(this.mConnection, serialStateString);
        this.mSerialStateCommand.registerOutParameter(1, -2);
    }

    public synchronized int getReflectionVersion() throws CacheServerException {
        if (this.mReflectVersion <= 0) {
            this.initReflectionVersion();
        }
        return this.mReflectVersion;
    }

    public synchronized String getClassType(String string) throws CacheServerException, SystemError {
        if (this.getReflectionVersion() < 6) {
            return null;
        }
        try {
            if (this.mClassTypeCommand == null) {
                this.initClassTypeStatement();
            }
            this.mClassTypeCommand.setString(2, string);
            this.execute(this.mClassTypeCommand, classTypeString);
            return this.mClassTypeCommand.getString(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed get Class Type for class " + string);
        }
    }

    public synchronized byte[] getSerialState(String string) throws CacheServerException {
        if (this.getReflectionVersion() < 6) {
            return null;
        }
        try {
            if (this.mSerialStateCommand == null) {
                this.initSerialStateStatement();
            }
            this.mSerialStateCommand.setString(2, string);
            this.execute(this.mSerialStateCommand, serialStateString);
            return this.mSerialStateCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed get Serial State for class " + string);
        }
    }

    public synchronized byte[] getClassProperties(String string) throws CacheServerException, SystemError {
        if (this.mClassPropertiesCommand == null) {
            this.initClassPropertiesStatement();
        }
        try {
            this.mClassPropertiesCommand.setString(2, string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        this.execute(this.mClassPropertiesCommand, classPropertiesString);
        try {
            return this.mClassPropertiesCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, classPropertiesString));
        }
    }

    public synchronized TableInfo getTableColumnNumbers(String string, boolean bl) throws CacheServerException, SystemError {
        if (this.mTableInfoCommand == null) {
            this.initTableInfoStatement();
        }
        try {
            this.mTableInfoCommand.setString(1, string);
            ResultSet resultSet = this.mTableInfoCommand.executeQuery();
            int n = resultSet.findColumn("FIELD_NAME");
            int n2 = resultSet.findColumn("COLUMN_NUMBER");
            int n3 = resultSet.findColumn("HIDDEN");
            int n4 = resultSet.findColumn("COLLECTION_TYPE");
            int n5 = resultSet.findColumn("REFERENCE_CLASS");
            int n6 = resultSet.findColumn("DATATYPE");
            int n7 = resultSet.findColumn("ELEMENT_TYPE");
            TableInfo tableInfo = new TableInfo();
            boolean bl2 = true;
            String string2 = null;
            int n8 = 1;
            while (resultSet.next()) {
                String string3 = resultSet.getString(n);
                int n9 = resultSet.getInt(n2);
                String string4 = resultSet.getString(n3);
                boolean bl3 = string4.equalsIgnoreCase("YES");
                if (n8 == 1 && string3.equalsIgnoreCase("ID")) {
                    bl2 = false;
                }
                TableColumnInfo tableColumnInfo = new TableColumnInfo();
                if (bl2) {
                    switch (n9) {
                        case 0: {
                            tableColumnInfo.columnForSet = 1;
                            break;
                        }
                        case 1: {
                            tableColumnInfo.columnForSet = 0;
                            break;
                        }
                        default: {
                            tableColumnInfo.columnForSet = n9;
                            break;
                        }
                    }
                } else {
                    tableColumnInfo.columnForSet = n9 - 1;
                }
                if ("x__classname".equals(string3)) {
                    tableColumnInfo.columnForGet = n8++;
                    if (!bl2) {
                        // empty if block
                    }
                } else if (bl3) {
                    tableColumnInfo.columnForGet = -10;
                    if (bl) {
                        ++n8;
                    }
                } else {
                    tableColumnInfo.columnForGet = n8++;
                }
                String string5 = SQLReservedWords.isReserved(string3) ? "\"" + string + '.' + string3 + "\"" : string + '.' + string3;
                string2 = string2 == null ? string5 : string2 + "," + string5;
                tableColumnInfo.collectionType = resultSet.getString(n4);
                tableColumnInfo.referenceClass = tableColumnInfo.collectionType != null ? resultSet.getString(n6) : resultSet.getString(n5);
                tableColumnInfo.elementType = resultSet.getString(n7);
                tableInfo.put(string3, tableColumnInfo);
            }
            tableInfo.setSQL(string2);
            tableInfo.setColumnCount(n8 - 1);
            tableInfo.setIsChild(bl2);
            return tableInfo;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get column number for table " + string);
        }
    }

    public synchronized TableInfo getSerialStateInfo(String string) throws CacheServerException {
        byte[] byArray = this.getSerialState(string);
        if (byArray == null) {
            return null;
        }
        try {
            Object object = SysListProxy.createSysList(byArray, false);
            TableInfo tableInfo = new TableInfo();
            tableInfo.setSQL(null);
            tableInfo.setIsChild(true);
            int n = 0;
            while (!SysListProxy.atEnd(object)) {
                String string2 = SysListProxy.getString(object);
                TableColumnInfo tableColumnInfo = new TableColumnInfo();
                tableColumnInfo.columnForSet = n;
                tableColumnInfo.columnForGet = n;
                String string3 = SysListProxy.getString(object);
                if (string3 != null) {
                    tableColumnInfo.collectionType = string3.toUpperCase();
                }
                tableInfo.put(string2, tableColumnInfo);
                ++n;
            }
            tableInfo.setColumnCount(n - 1);
            return tableInfo;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to get serial state for class " + string);
        }
    }

    public synchronized byte[] getClassAncestors(String string) throws CacheServerException, SystemError {
        if (this.mClassAncestorsCommand == null) {
            this.initClassAncestorsStatement();
        }
        try {
            this.mClassAncestorsCommand.setString(2, string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        this.execute(this.mClassAncestorsCommand, classAncestorsString);
        try {
            return this.mClassAncestorsCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, classAncestorsString));
        }
    }

    public synchronized byte[] getQueryProcInfo(String string, String string2) throws CacheServerException, SystemError {
        if (this.mQueryProcInfoCommand == null) {
            this.initQueryProcInfoStatement();
        }
        try {
            this.mQueryProcInfoCommand.setString(2, string);
            this.mQueryProcInfoCommand.setString(3, string2);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        String string3 = queryProcInfoString + "[" + string + "," + string2 + "]";
        this.execute(this.mQueryProcInfoCommand, string3);
        try {
            return this.mQueryProcInfoCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, string3));
        }
    }

    public synchronized String getJavaPackage(String string) throws CacheServerException, SystemError {
        if (this.mJavaPackageCommand == null) {
            this.initJavaPackageStatement();
        }
        try {
            this.mJavaPackageCommand.setString(2, string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        this.execute(this.mJavaPackageCommand, javaPackageString);
        try {
            return this.mJavaPackageCommand.getString(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, javaPackageString));
        }
    }

    public synchronized byte[] getClassMethods(String string) throws CacheServerException, SystemError {
        if (this.mClassMethodsCommand == null) {
            this.initClassMethodsStatement();
        }
        try {
            this.mClassMethodsCommand.setString(2, string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        this.execute(this.mClassMethodsCommand, classMethodsString);
        try {
            return this.mClassMethodsCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, classMethodsString));
        }
    }

    public synchronized byte[] getClassQueries(String string) throws CacheServerException, SystemError {
        if (this.mClassQueriesCommand == null) {
            this.initClassQueriesStatement();
        }
        try {
            this.mClassQueriesCommand.setString(2, string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.parametersErrorText(sQLException));
        }
        this.execute(this.mClassQueriesCommand, classQueriesString);
        try {
            return this.mClassQueriesCommand.getBytes(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(JDBCAdapter.resultErrorText(sQLException, classQueriesString));
        }
    }

    public void close(boolean bl) throws CacheServerException {
        try {
            if (this.mClassPropertiesCommand != null) {
                this.mClassPropertiesCommand.close();
            }
            if (this.mClassAncestorsCommand != null) {
                this.mClassAncestorsCommand.close();
            }
            if (this.mJavaPackageCommand != null) {
                this.mJavaPackageCommand.close();
            }
            if (this.mQueryProcInfoCommand != null) {
                this.mQueryProcInfoCommand.close();
            }
            if (this.mClassMethodsCommand != null) {
                this.mClassMethodsCommand.close();
            }
            if (this.mClassQueriesCommand != null) {
                this.mClassQueriesCommand.close();
            }
            if (this.mTableInfoCommand != null) {
                this.mTableInfoCommand.close();
            }
            if (this.mCountCommand != null) {
                this.mCountCommand.close();
            }
            if (this.mClassTypeCommand != null) {
                this.mClassTypeCommand.close();
            }
            if (this.mSerialStateCommand != null) {
                this.mSerialStateCommand.close();
            }
            if (this.mInverseStatement != null) {
                this.mInverseStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, JDBCAdapter.sqlErrorText("Failed to close prepared statements: ", sQLException));
        }
        super.close(bl);
    }

    public static CacheConnection getCacheConnection(Connection connection) throws CacheServerException {
        if (connection instanceof CacheConnection) {
            return (CacheConnection)connection;
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("**getQuickStatement**");
            CacheConnection cacheConnection = (CacheConnection)resultSet.getObject("**CacheConnection**");
            if (cacheConnection == null) {
                throw new CacheServerException("JDBC Connection object used is not obtained through Cache driver");
            }
            return cacheConnection;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to obtain Cache Driver Connection. Probably JDBC Connection object used is not obtained through Cache driver");
        }
    }

    public ResultSet getCacheResultSet(String string) throws CacheServerException {
        CacheConnection cacheConnection = JDBCAdapter.getCacheConnection(this.mConnection);
        try {
            return cacheConnection.getCacheResultSet(string);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to create java.sql.ResultSet by oref " + string);
        }
    }

    protected static String parametersErrorText(SQLException sQLException) {
        return JDBCAdapter.sqlErrorText("Failed to set parameters.", sQLException);
    }

    protected static String resultErrorText(SQLException sQLException, String string) {
        return JDBCAdapter.sqlErrorText("Failed to get the result of executing " + string, sQLException);
    }

    public void setupServerInfo(ObjectServerInfo objectServerInfo) throws CacheException {
        try {
            CacheConnection cacheConnection = (CacheConnection)this.mConnection;
            DatabaseMetaData databaseMetaData = cacheConnection.getMetaData();
            objectServerInfo.cacheSystemVersion = databaseMetaData.getDatabaseProductName();
            objectServerInfo.cacheObjectVersion = databaseMetaData.getDatabaseProductVersion();
            String string = "Cache Objects Version";
            if (objectServerInfo.cacheObjectVersion.startsWith(string)) {
                objectServerInfo.cacheObjectVersion = objectServerInfo.cacheObjectVersion.substring(string.length());
            }
            objectServerInfo.cacheObjectVersion = objectServerInfo.cacheObjectVersion.trim();
            objectServerInfo.protocolClientVersion = objectServerInfo.protocolServerVersion = databaseMetaData.getDriverVersion();
            objectServerInfo.connectionInfo = databaseMetaData.getURL();
            objectServerInfo.isUnicode = cacheConnection.isServerUnicode();
            objectServerInfo.locale = objectServerInfo.isUnicode ? "UTF-8" : cacheConnection.getServerLocale();
            objectServerInfo.namespace = cacheConnection.getCatalog();
            if (objectServerInfo.namespace == null) {
                String string2 = objectServerInfo.connectionInfo;
                int n = string2.indexOf("//");
                int n2 = string2.indexOf(47, n + 2);
                int n3 = string2.indexOf(47, n2 + 1);
                objectServerInfo.namespace = n3 > 0 ? string2.substring(n2 + 1, n3) : string2.substring(n2 + 1);
            }
            objectServerInfo.processNumber = cacheConnection.getCacheJobID();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Can not determine server metadata");
        }
        objectServerInfo.clientVersionSupported = true;
        objectServerInfo.systemOrefsSupported = true;
    }

    public synchronized String getInverseRelated(String string, String string2) throws CacheServerException {
        try {
            if (this.mInverseStatement == null) {
                this.mInverseStatement = this.mConnection.prepareCall(mInverseString);
                this.mInverseStatement.registerOutParameter(1, 12);
            }
            this.mInverseStatement.setString(2, string);
            this.mInverseStatement.setString(3, string2);
            this.execute(this.mInverseStatement, "{ ? = call %Library.CPPStoredProc_getInverse( ? , ? ) }[" + string + "," + string2 + "]");
            return this.mInverseStatement.getString(1);
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to determine inverse for relationship " + string2 + " in class " + string);
        }
    }

    public static class TableInfo
    extends TreeMap {
        private int mColumnCount;
        private String mSql;
        private boolean mIsChild;

        public static TableInfo getEmpty() {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setSQL(null);
            tableInfo.setColumnCount(0);
            tableInfo.setIsChild(true);
            return tableInfo;
        }

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public String getSQL() {
            return this.mSql;
        }

        public boolean isChild() {
            return this.mIsChild;
        }

        protected void setColumnCount(int n) {
            this.mColumnCount = n;
        }

        protected void setSQL(String string) {
            this.mSql = string;
        }

        protected void setIsChild(boolean bl) {
            this.mIsChild = bl;
        }

        public TableColumnInfo getTableColumnInfo(String string) {
            return (TableColumnInfo)this.get(string);
        }
    }

    public static class TableColumnInfo {
        public static final int HIDDEN_COLUMN = -10;
        public static final int UNDEFINED_COLUMN = -1;
        public int columnForGet;
        public int columnForSet;
        public String collectionType;
        public String referenceClass;
        public String internalType;
        public String elementType;

        public TableColumnInfo() {
            this.columnForGet = -1;
            this.columnForSet = -1;
        }

        public TableColumnInfo(int n, int n2) {
            this.columnForGet = n;
            this.columnForSet = n2;
        }
    }
}

