/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.CacheObject;
import com.intersys.cache.DatabaseWithReferenceMap;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.CacheIface;
import com.intersys.cache.jbind.CacheLAZY;
import com.intersys.cache.jbind.CacheProcessor;
import com.intersys.cache.jbind.CustomMsgDBAdapter;
import com.intersys.cache.jbind.DBAdapter;
import com.intersys.cache.jbind.JBindCacheClassNew;
import com.intersys.cache.jbind.JBindCacheObject;
import com.intersys.cache.jbind.MessagePrinter;
import com.intersys.cache.jbind.ReadOnlyDatabase;
import com.intersys.cache.jbind.ServerOutputProcessor;
import com.intersys.cache.jbind.StatisticObject;
import com.intersys.cache.jbind.Statistics;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.JDBCAdapter;
import com.intersys.cache.jdbcutil.ParseUtils;
import com.intersys.cache.oldmetadata.JBindCacheClass;
import com.intersys.cache.oldmetadata.JBindCacheField;
import com.intersys.cache.quick.QuickDatabase;
import com.intersys.classes.ListOfObjects;
import com.intersys.classes.ObjectHandle;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ObjectFactory;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheMultiException;
import com.intersys.objects.CacheNullValueException;
import com.intersys.objects.CacheProtocolUpdatedException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheUnsupportedProtocolException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.DatabaseExistsException;
import com.intersys.objects.Id;
import com.intersys.objects.InvalidClassException;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class JBindDatabase
extends DatabaseWithReferenceMap
implements ObjectFactory {
    private static final double PROTOCOL_505 = 2.12;
    private static final int OID_FOR_STATIC_CALLS = -1;
    private static final boolean NEW_METADATA_ALLOWED = true;
    private double mServerVersion;
    private double mAgreedVersion;
    private int mReflectionVersion;
    private Statistics m_statistics;
    private CacheIface m_cache;
    private Set mMessageListeners;
    private String mConnectionString;
    private boolean isConnectionOpen = false;
    private boolean amIConnectionOwner = true;
    private DBAdapter mAdapter;
    private Map mSensetiveObjectsSet;
    private Object mClosedOrefs;
    private boolean cachingOnCloseEnabled = true;
    private Object mSetList;
    private ServerOutputProcessor mServerOutputProcessor;
    private Set debugCacheSet;
    private static Map databases = null;
    private int mRefCount = 0;
    private boolean mCheckDeps = true;
    private int mTransactionLevel = 0;

    public JBindDatabase(String string, String string2, String string3, int n, boolean bl) throws CacheException {
        Connection connection = this.initConnection(string, string2, string3);
        try {
            this.initClientDatabase(connection, n, bl);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to initialize connection to Cache.");
        }
    }

    public JBindDatabase(String string, String string2, String string3, int n) throws CacheException {
        this(string, string2, string3, n, ConnectionUtils.determineStatisticsUsage());
    }

    public JBindDatabase(String string, String string2, String string3) throws CacheException {
        this(string, string2, string3, -1, ConnectionUtils.determineStatisticsUsage());
    }

    private JBindDatabase(Connection connection) throws CacheException {
        this.amIConnectionOwner = false;
        if (!(connection instanceof CacheConnection)) {
            connection = CustomMsgDBAdapter.getCacheConnection(connection);
        }
        try {
            this.mConnectionString = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Can not determine Connection URL");
        }
        try {
            this.initClientDatabase(connection, -1, ConnectionUtils.determineStatisticsUsage());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to initialize connection to Cache.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JBindDatabase getDatabase(Connection connection) throws CacheException {
        Connection connection2 = connection;
        synchronized (connection2) {
            if (!(connection instanceof CacheConnection)) {
                connection = CustomMsgDBAdapter.getCacheConnection(connection);
            }
            if (databases == null || !databases.containsKey(connection)) {
                return new JBindDatabase(connection);
            }
            JBindDatabase jBindDatabase = (JBindDatabase)databases.get(connection);
            try {
                long l = ((CacheConnection)connection).getCacheJobID();
                long l2 = jBindDatabase.mProcess;
                if (l != l2) {
                    return new JBindDatabase(connection);
                }
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Attempt to use closed connection to construct Database");
            }
            ++jBindDatabase.mRefCount;
            if (Logger.debugOn()) {
                Logger.out.println("Increased ref count for Database " + jBindDatabase.mProcess + " it is now " + jBindDatabase.mRefCount);
            }
            return jBindDatabase;
        }
    }

    public int getCacheType() {
        if (this.m_cache == null) {
            return 0;
        }
        return this.m_cache.getType();
    }

    public void printStatistics() {
        if (this.m_statistics != null) {
            this.m_statistics.print();
        }
    }

    public void printStatistics(PrintStream printStream) {
        if (this.m_statistics != null) {
            this.m_statistics.print(printStream);
        }
    }

    public CacheClass getCacheClass(String string) throws CacheException {
        if (string == null) {
            throw new InvalidClassException("Class can not be null");
        }
        CacheClass cacheClass = this.getCacheClassIfLoaded(string);
        if (cacheClass == null) {
            if (this.useNewMetadata()) {
                return new JBindCacheClassNew(this, string, this.mCheckDeps, false);
            }
            return new JBindCacheClass(this, string);
        }
        if (cacheClass instanceof JBindCacheClass) {
            ((JBindCacheClass)cacheClass).incrementReferences();
        } else if (cacheClass instanceof JBindCacheClassNew) {
            ++((JBindCacheClassNew)cacheClass).mReferences;
        }
        return cacheClass;
    }

    public CacheClass getCacheClassByTable(String string) throws CacheException {
        if (string == null) {
            throw new InvalidClassException("Class can not be null");
        }
        CacheClass cacheClass = this.getCacheClassIfLoadedByTable(string);
        if (cacheClass == null) {
            if (this.useNewMetadata()) {
                return new JBindCacheClassNew(this, string, this.mCheckDeps, true);
            }
            String string2 = ParseUtils.tableName2className(string);
            return new JBindCacheClass(this, string2);
        }
        if (cacheClass instanceof JBindCacheClass) {
            ((JBindCacheClass)cacheClass).incrementReferences();
        } else if (cacheClass instanceof JBindCacheClassNew) {
            ++((JBindCacheClassNew)cacheClass).mReferences;
        }
        return cacheClass;
    }

    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        return this.getReadOnlyDatabase(false);
    }

    public ReadOnlyDatabase getReadOnlyDatabase(boolean bl) throws CacheException {
        return new ReadOnlyDatabase((CustomMsgDBAdapter)this.myAdapter(), (SysDatabase)this, bl);
    }

    public PreparedStatement prepareStatement(String string) throws CacheException {
        return this.myAdapter().prepareStatement(string);
    }

    public Statement createStatement() throws CacheException {
        return this.myAdapter().createStatement();
    }

    public CallableStatement prepareCall(String string) throws CacheException {
        return this.myAdapter().prepareCall(string);
    }

    public Object getListBuffer(int n, int n2, int n3) throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Getting list buffer for " + n + " [" + n2 + ',' + n3 + ']');
        }
        byte[] byArray = this.myAdapter().getListElements(n, n2, n3);
        return SysListProxy.createSysList(byArray, false);
    }

    public boolean isCollectionPutSupported() {
        if (this.myAdapter().isNewServer()) {
            return this.mAgreedVersion >= 2.09;
        }
        return this.mAgreedVersion >= 2.16;
    }

    public void putListElements(int n, Collection collection) throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Adding " + collection.size() + " elements to list " + n);
        }
        this.myAdapter().putListElements(n, collection);
    }

    public void putArrayElements(int n, Map map) throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Putting " + map.size() + " elements into array " + n);
        }
        this.myAdapter().putArrElements(n, map);
    }

    public void putObjListElements(int n, Collection collection) throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println("Adding " + collection.size() + " object elements to list " + n);
        }
        try {
            Object object = SysListProxy.createSysList(byArray);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, collection.size());
            for (ObjectHandle objectHandle : collection) {
                SysListProxy.setInteger(object, objectHandle.getOref());
            }
            byArray = this.myAdapter().putObjListElements(object);
            object = SysListProxy.createSysList(byArray);
            if (SysListProxy.getInteger(object) != 1) {
                throw new CacheServerException("Invalid server response");
            }
            this.mServerOutputProcessor.evalResultList(object);
            this.evalCache(object, null, false);
        }
        catch (SQLException sQLException) {
            throw new CacheException("Failed to send objects to server  to add to list " + n);
        }
    }

    public void putObjArrayElements(int n, Map map) throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println("Putting " + map.size() + " object elements into array " + n);
        }
        try {
            Object object = SysListProxy.createSysList(byArray);
            SysListProxy.skipAll(object);
            SysListProxy.setInteger(object, n);
            SysListProxy.setInteger(object, map.size());
            for (Map.Entry entry : map.entrySet()) {
                ObjectHandle objectHandle = (ObjectHandle)entry.getValue();
                SysListProxy.setInteger(object, objectHandle.getOref());
                Dataholder dataholder = Dataholder.create(entry.getKey());
                dataholder.stuff(object);
            }
            byArray = this.myAdapter().putObjArrElements(object);
            object = SysListProxy.createSysList(byArray);
            if (SysListProxy.getInteger(object) != 1) {
                throw new CacheServerException("Invalid server response");
            }
            this.mServerOutputProcessor.evalResultList(object);
            this.evalCache(object, null, false);
        }
        catch (SQLException sQLException) {
            throw new CacheException("Failed to send objects to server  to add to list " + n);
        }
    }

    public Object getArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Getting array buffer for " + n + " [" + string + ',' + n2 + ',' + n3 + ']');
        }
        byte[] byArray = this.myAdapter().getArrayElements(n, string, n2, n3);
        return SysListProxy.createSysList(byArray, false);
    }

    public Object getObjectListBuffer(int n, int n2, int n3) throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println("Getting list buffer for " + n + " [" + n2 + ',' + n3 + ']');
        }
        byArray = this.myAdapter().getObjectListElements(byArray, n, n2, n3);
        return this.afterGetObjectBuffer(byArray);
    }

    public Object getObjectArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println("Getting array buffer for " + n + " [" + string + ',' + n2 + ',' + n3 + ']');
        }
        byArray = this.myAdapter().getObjectArrayElements(byArray, n, string, n2, n3);
        return this.afterGetObjectBuffer(byArray);
    }

    private Object afterGetObjectBuffer(byte[] byArray) {
        Object object = SysListProxy.createSysList(byArray, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        return object;
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive) {
        this.registerSensitiveObject(cacheServerSensitive, (Set)null);
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, ObjectHandle objectHandle) {
        HashSet<ObjectHandle> hashSet = new HashSet<ObjectHandle>();
        hashSet.add(objectHandle);
        this.registerSensitiveObject(cacheServerSensitive, hashSet);
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(new Integer(n));
        this.registerSensitiveObject(cacheServerSensitive, hashSet);
    }

    public synchronized void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, Set set) {
        if (this.mSensetiveObjectsSet == null) {
            this.mSensetiveObjectsSet = new HashMap();
        }
        this.mSensetiveObjectsSet.put(cacheServerSensitive, set);
    }

    public synchronized boolean unRegisterSensitiveObject(CacheServerSensitive cacheServerSensitive) {
        if (this.mSensetiveObjectsSet == null) {
            return false;
        }
        return this.mSensetiveObjectsSet.remove(cacheServerSensitive) != null;
    }

    public boolean isLowLevelConnectionClosed() throws CacheException {
        return this.mAdapter.isConnectionClosed();
    }

    void insertStatisticObject(int n, String string) {
        if (this.m_statistics != null) {
            this.m_statistics.insertObject(n, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataholder[] runMethod(int n, String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n2) throws CacheException {
        Dataholder[] dataholderArray2;
        int n3;
        boolean bl = n2 == 1;
        boolean bl2 = n2 != 3;
        byte[] byArray = this.beforeServerCall(n);
        if (Logger.debugOn()) {
            Logger.out.print(this.mProcess + ": running method " + string + "<" + n + ">." + string2 + " (");
            for (n3 = 0; n3 < dataholderArray.length; ++n3) {
                Logger.out.print("" + dataholderArray[n3]);
                if (n3 >= dataholderArray.length - 1) continue;
                Logger.out.print(", ");
            }
            Logger.out.println(")");
        }
        n3 = this.isProtocol505() ? 1 : 2;
        for (int i = 0; i < dataholderArray.length; ++i) {
            if (dataholderArray[i].getType() != 1026 || dataholderArray[i].getObject() == null || this.equals(dataholderArray[i].getCacheObject().getDatabase())) continue;
            throw new CacheException("Argument #" + (i + 1) + " in call to method " + string2 + " is not open on the server.");
        }
        byte[] byArray2 = this.myAdapter().runMethod(n, string, string2, nArray, dataholderArray, bl2, byArray, bl, n3);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Returned from method " + string + "<" + n + ">." + string2);
        }
        Object object = SysListProxy.createSysList(byArray2, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        String string3 = "Error processing return values from method " + string + "<" + n + ">." + string2;
        if (this.isProtocol505()) {
            Object object2;
            try {
                object2 = SysListProxy.getSysList(object);
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, string3);
            }
            this.mServerOutputProcessor.evalResultList(object);
            dataholderArray2 = this.mServerOutputProcessor.evalMethodReturn505(object2, dataholderArray, nArray, bl, string3);
            this.evalCache(object, null, false);
        } else {
            Object object3;
            try {
                object3 = SysListProxy.getString(object);
                if (object3 != null && ((String)object3).length() > 0) {
                    throw new SystemError("Empty string was expected in server output" + (String)object3);
                }
            }
            catch (SQLException sQLException) {
                throw new SystemError("Empty string was expected in server output");
            }
            this.mServerOutputProcessor.evalResultList(object);
            object3 = this;
            synchronized (object3) {
                this.evalCache(object, null, true);
                dataholderArray2 = this.mServerOutputProcessor.evalMethodReturnA(object, dataholderArray, nArray, n2, string3);
                if (this.m_cache != null) {
                    this.m_cache.clearTempMap();
                }
            }
        }
        if (dataholderArray2.length > 0 && Logger.debugOn()) {
            Logger.out.print(this.mProcess + ": Return values from method " + string + "<" + n + ">." + string2 + ": [");
            for (int i = 0; i < dataholderArray2.length - 1; ++i) {
                Logger.out.print(dataholderArray2[i] + ", ");
            }
            Logger.out.println(dataholderArray2[dataholderArray2.length - 1] + "]");
        }
        return dataholderArray2;
    }

    protected Dataholder getServerObject(Object object, boolean bl) throws SQLException, CacheException {
        OrefInfo orefInfo = JBindDatabase.parseReturnedOref(object);
        CacheObject cacheObject = null;
        if (orefInfo != null && orefInfo.oref != 0) {
            cacheObject = this.onGetFromServer(orefInfo.oref, orefInfo.className);
            if (bl && this.m_cache != null) {
                this.m_cache.checkIfInTempMap((JBindCacheObject)cacheObject);
            }
        }
        Dataholder dataholder = new Dataholder(1026, cacheObject);
        return dataholder;
    }

    public Dataholder[] runClassMethod(String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        return this.runMethod(-1, string, string2, nArray, dataholderArray, n);
    }

    protected Dataholder deleteObjectByOID(byte[] byArray, int n) throws CacheException {
        if (n < 0) {
            n = 1;
        }
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Deleting object with id: " + new String(byArray) + ", concurrency = " + n);
        }
        byte[] byArray2 = this.myAdapter().deleteObj(byArray, n);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Deleting done.");
        }
        Object object = SysListProxy.createSysList(byArray2, false);
        this.mServerOutputProcessor.evalServerErrors(object);
        try {
            return new Dataholder(4096, SysListProxy.getWrappedItem(object));
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to interpet server return");
        }
    }

    private synchronized byte[] beforeServerCall(int n) throws CacheException {
        Object object;
        if (this.m_statistics != null) {
            object = this.m_statistics.getObject(n);
            ((StatisticObject)object).clearLocalCalls();
            ((StatisticObject)object).incrementCacheCalls();
        }
        this.closeDiscardedObjects(false);
        try {
            SysListProxy.clearList(this.mSetList);
            if (this.m_cache != null) {
                this.m_cache.putData(this.mSetList);
                this.addClosedOrefs();
            }
            object = SysListProxy.getBinaryData(this.mSetList);
            return object;
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to prepare input for server call");
        }
    }

    private final void addClosedOrefs() throws SQLException, CacheException {
        Object object = this.prepareFlushReferenceCountList();
        if (object == null) {
            SysListProxy.setInteger(this.mSetList, 0);
        } else {
            int n = SysListProxy.countItems(object);
            SysListProxy.setInteger(this.mSetList, n / 2);
            SysListProxy.concatenate(this.mSetList, object);
            SysListProxy.clearList(this.mClosedOrefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheObject openObjectByOID(Oid oid, int n, int n2) throws CacheException {
        byte[] byArray;
        byte[] byArray2 = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Opening object " + oid.getClassName() + "<" + oid.getId().toString() + ">");
        }
        Object object = databases;
        synchronized (object) {
            byArray = this.myAdapter().openObj(oid.getData(), n, n2, byArray2);
        }
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Done opening object " + oid.getClassName() + "<" + oid.getId().toString() + ">");
        }
        object = SysListProxy.createSysList(byArray, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        CacheObject cacheObject = null;
        try {
            Object object2 = SysListProxy.getSysList(object);
            this.mServerOutputProcessor.evalResultList(object);
            JBindDatabase jBindDatabase = this;
            synchronized (jBindDatabase) {
                this.evalCache(object, null, true);
                cacheObject = this.getOpenedObject(object2, oid, null);
                if (this.m_cache != null) {
                    this.m_cache.clearTempMap();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to open object of class " + oid.getClassName() + " with id " + oid.getId().toString());
        }
        catch (CacheException cacheException) {
            int n3 = cacheException.getCode();
            String string = cacheException.getMessage();
            string = "Failed to open object of class " + oid.getClassName() + " with id " + oid.getId().toString() + "; error code " + n3;
            throw new CacheException(string, n3, cacheException);
        }
        if (cacheObject == null) {
            throw new CacheException("Failed to open object of class " + oid.getClassName() + " with id " + oid.getId().toString() + " for unknown reason");
        }
        return cacheObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheObject openObjectByID(String string, String string2, int n, int n2) throws CacheException {
        byte[] byArray;
        byte[] byArray2 = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Opening object by id " + string + "<" + string2 + ">");
        }
        Object object = databases;
        synchronized (object) {
            byArray = this.myAdapter().openIdObj(string, string2, n, n2, byArray2);
        }
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": Done opening object " + string + "<" + string2 + ">");
        }
        object = SysListProxy.createSysList(byArray, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        CacheObject cacheObject = null;
        try {
            Object object2 = SysListProxy.getSysList(object);
            this.mServerOutputProcessor.evalResultList(object);
            JBindDatabase jBindDatabase = this;
            synchronized (jBindDatabase) {
                this.evalCache(object, null, true);
                cacheObject = this.getOpenedObject(object2, null, string2);
                if (this.m_cache != null) {
                    this.m_cache.clearTempMap();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to open object of class " + string + " with id " + string2);
        }
        catch (CacheException cacheException) {
            int n3 = cacheException.getCode();
            String string3 = cacheException.getMessage();
            string3 = "Failed to open object of class " + string + " with id " + string2 + "; error code " + n3;
            throw new CacheException(string3, n3, cacheException);
        }
        if (cacheObject == null) {
            throw new CacheException("Failed to open object of class " + string + " with id " + string2 + " for unknown reason");
        }
        return cacheObject;
    }

    private static OrefInfo parseReturnedOref(Object object) throws SQLException {
        String string = SysListProxy.getString(object);
        if (string == null || string.length() == 0) {
            return null;
        }
        return JBindDatabase.parseOrefString(string);
    }

    protected static OrefInfo parseOrefString(String string) {
        int n = string.indexOf(64);
        int n2 = Integer.parseInt(string.substring(0, n));
        if (n2 <= 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        return new OrefInfo(n2, string2);
    }

    private CacheObject getOpenedObject(Object object, Oid oid, String string) throws SQLException, CacheException {
        OrefInfo orefInfo = JBindDatabase.parseReturnedOref(object);
        if (orefInfo == null) {
            return null;
        }
        if (oid == null) {
            oid = new Oid(string, orefInfo.className);
        }
        CacheObject cacheObject = this.onGetFromServer(orefInfo.oref, orefInfo.className);
        JBindCacheObject jBindCacheObject = (JBindCacheObject)cacheObject.getMe();
        if (this.m_cache != null) {
            this.m_cache.checkIfInTempMap(jBindCacheObject);
        }
        if (this.m_cache != null && !jBindCacheObject.isOidSet()) {
            jBindCacheObject.setOid(oid);
        }
        return cacheObject;
    }

    Dataholder getProperty(int n, int n2, int n3, int n4, String string) throws CacheException {
        Object object;
        if (!this.inCache(n)) {
            if (Logger.getDebugCache()) {
                this.checkNotInCache(n);
            }
            return this.getFromCache(n, string, n4);
        }
        if (Logger.getDebugCache()) {
            this.checkInCache(n);
        }
        if (this.m_statistics != null) {
            object = this.m_statistics.getObject(n);
            ((StatisticObject)object).incrementLocalCalls();
            ((StatisticObject)object).incrementJavaCalls();
        }
        if ((object = this.m_cache.getProperty(n, n2, n3, n4, string)) != null) {
            return object;
        }
        return this.getFromCache(n, string, n4);
    }

    void setProperty(int n, int n2, int n3, int n4, int n5, String string, Dataholder dataholder) throws CacheException {
        if (!this.inCache(n) || n2 < 0) {
            if (n5 == 1 && dataholder.getType() != 512) {
                dataholder = new Dataholder(512, dataholder.getInteger());
            }
            this.setInCacheMsg(n, string, n5 == 1, dataholder);
        } else {
            if (this.m_statistics != null) {
                StatisticObject statisticObject = this.m_statistics.getObject(n);
                statisticObject.incrementLocalCalls();
                statisticObject.incrementJavaCalls();
            }
            this.m_cache.setProperty(n, n2, n3, n4, n5, string, dataholder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject newCacheObject(String string) throws CacheException {
        CacheClass cacheClass = this.getCacheClass(string);
        Object object = cacheClass;
        synchronized (object) {
            if (!cacheClass.isVerified()) {
                cacheClass.verifyClass();
            }
        }
        object = new int[0];
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, "%New", (int[])object, dataholderArray, 1);
        return dataholderArray2[0].getCacheObject();
    }

    public CacheObject newClientObject(String string) throws CacheException {
        SysDatabase sysDatabase = this.getLightDatabase();
        return sysDatabase.newClientObject(string);
    }

    public CacheObject deserializeObject(String string, byte[] byArray) throws CacheException {
        SysDatabase sysDatabase = this.getLightDatabase();
        return sysDatabase.deserializeObject(string, byArray);
    }

    public CacheObject deserializeObject(String string, Object object) throws CacheException {
        SysDatabase sysDatabase = this.getLightDatabase();
        return sysDatabase.deserializeObject(string, object);
    }

    public Object deserialize(Object object) throws SQLException {
        try {
            QuickDatabase quickDatabase = (QuickDatabase)this.getLightDatabase();
            return quickDatabase.deserialize(object);
        }
        catch (CacheException cacheException) {
            throw new SQLException(cacheException.getMessage());
        }
    }

    public final SysDatabase getLightDatabase() throws CacheException {
        SysDatabase sysDatabase = (SysDatabase)CacheDatabase.getLightDatabase(this.myAdapter().getConnection());
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader != null && classLoader != Thread.currentThread().getContextClassLoader()) {
            sysDatabase.setClassLoader(classLoader);
        }
        return sysDatabase;
    }

    public CacheObject openByKey(String string, CandidateKey candidateKey, int n) throws CacheException {
        String string2 = candidateKey.getOpenMethodName();
        int n2 = candidateKey.getLength();
        Dataholder[] dataholderArray = new Dataholder[n2 + 2];
        candidateKey.fillArguments(dataholderArray);
        dataholderArray[n2] = new Dataholder(n);
        dataholderArray[n2 + 1] = Dataholder.create(null);
        int[] nArray = new int[]{n2 + 2};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, string2, nArray, dataholderArray, 1);
        this.parseStatus(dataholderArray2[1]);
        return dataholderArray2[0].getCacheObject();
    }

    public void setConnectionOwner(boolean bl) {
        this.amIConnectionOwner = bl;
    }

    private String keyToId(String string, CandidateKey candidateKey) throws CacheException {
        String string2 = candidateKey.getObjectName() + "Exists";
        int n = candidateKey.getLength();
        Dataholder[] dataholderArray = new Dataholder[n + 1];
        candidateKey.fillArguments(dataholderArray);
        dataholderArray[n] = Dataholder.create(null);
        int[] nArray = new int[]{n + 1};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, string2, nArray, dataholderArray, 0);
        boolean bl = dataholderArray2[0].getBooleanValue();
        if (!bl) {
            return null;
        }
        return dataholderArray2[1].getString();
    }

    public boolean deleteObject(String string, CandidateKey candidateKey) throws CacheException {
        String string2 = this.keyToId(string, candidateKey);
        if (string2 == null) {
            return false;
        }
        this.deleteObject(string, new Id(string2));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheObject newCacheObject(String string, String string2) throws CacheException {
        CacheClass cacheClass = this.getCacheClass(string);
        Object object = cacheClass;
        synchronized (object) {
            if (!cacheClass.isVerified()) {
                cacheClass.verifyClass();
            }
        }
        object = new int[0];
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(string2)};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, "%New", (int[])object, dataholderArray, 1);
        return dataholderArray2[0].getCacheObject();
    }

    public String getConnectionString() {
        if (this.mConnectionString != null) {
            return this.mConnectionString;
        }
        return this.myAdapter().getConnection().toString();
    }

    void increaseServerReferenceCount(int n) throws CacheException {
        if (this.findInMap(n) != null) {
            return;
        }
        try {
            this.myAdapter().increaseServerReferenceCount(n);
        }
        catch (CacheException cacheException) {
            if (Logger.debugOn()) {
                Logger.out.println(this.mProcess + ": Failed to increase ref count for oref " + n);
            }
            throw cacheException;
        }
    }

    public void processObjectBuffer(Object object, Object object2, CacheServerSensitive cacheServerSensitive) throws CacheException {
        this.mServerOutputProcessor.evalResultList(object2);
        this.evalCache(object2, cacheServerSensitive, false);
    }

    protected void removeFromCache(int n) throws SystemError {
        if (this.m_cache != null) {
            this.m_cache.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
        if (this.cachingOnCloseEnabled) {
            Object object = this.mClosedOrefs;
            synchronized (object) {
                try {
                    SysListProxy.setInteger(this.mClosedOrefs, n);
                    SysListProxy.setInteger(this.mClosedOrefs, n2);
                }
                catch (SQLException sQLException) {
                    throw new SystemError(sQLException, "Failed to decrease ref count");
                }
            }
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": preparing to decrease " + "server ref " + "count for oref " + n + " by " + n2);
            }
            return;
        }
        if (this.isLowLevelConnectionClosed()) {
            return;
        }
        if (n2 > 0) {
            try {
                if (Logger.getDebugReferenceCountLevel() > 0) {
                    Logger.out.println(this.mProcess + ": decreasing server ref " + "count for oref " + n + " by " + n2);
                }
                this.myAdapter().decreaseServerReferenceCount(n, n2);
            }
            catch (CacheServerException cacheServerException) {
                String string = "Failed to decrease reference count for oref " + n + " by " + n2;
                if (Logger.getDebugReferenceCountLevel() > 0) {
                    Logger.out.println(this.mProcess + ": ERROR: " + string + ". Reason: " + cacheServerException.getMessage());
                }
                throw new ReferenceCountingException(cacheServerException, string);
            }
        }
    }

    public CacheField createCacheField(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        return new JBindCacheField(this, string, string2, string3, string4, n, n2, n3);
    }

    public void setProfileOn(int n) {
        this.myAdapter().setProfileOn(n);
    }

    public void setProfileOff(int n) {
        this.myAdapter().setProfileOff(n);
    }

    public long getServerTime() {
        return this.mAdapter.getServerTime();
    }

    public int getNumberOfServerCalls() {
        return this.mAdapter.getNumberServerCalls();
    }

    public long getServerTime(int n) {
        return this.mAdapter.getServerTime(n);
    }

    public int getNumberOfServerCalls(int n) {
        return this.mAdapter.getNumberServerCalls(n);
    }

    private Object prepareFlushReferenceCountList() throws CacheException {
        if (this.mClosedOrefs == null) {
            return null;
        }
        try {
            SysListProxy.rewind(this.mClosedOrefs);
            if (SysListProxy.atEnd(this.mClosedOrefs)) {
                if (Logger.getDebugReferenceCountLevel() > 1) {
                    Logger.out.println(this.mProcess + ": Empty flush list.");
                }
                return null;
            }
            if (Logger.getDebugReferenceCountLevel() > 1) {
                Logger.out.println(this.mProcess + ": " + JBindDatabase.listOfReferencesToString(this.mClosedOrefs));
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Error preparing closed refs list");
        }
        return this.mClosedOrefs;
    }

    private static String listOfReferencesToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            SysListProxy.rewind(object);
            while (!SysListProxy.atEnd(object)) {
                int n = SysListProxy.getInteger(object);
                int n2 = SysListProxy.getInteger(object);
                stringBuffer.append("(" + n + "," + n2 + ")");
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Failed to write list (" + exception + ")" + stringBuffer.toString();
        }
    }

    protected CacheObject createCacheObjectByOref(String string, int n) throws CacheException {
        return new JBindCacheObject(this, string, n);
    }

    public void sendBinaryStream(String string, InputStream inputStream, int n) throws CacheException {
        this.myAdapter().sendBinaryStream(string, inputStream, n);
    }

    public void sendCharacterStream(String string, Reader reader, int n) throws CacheException {
        this.myAdapter().sendCharacterStream(string, reader, n);
    }

    private void evalCache(Object object, CacheServerSensitive cacheServerSensitive, boolean bl) throws CacheException {
        if (this.m_cache != null) {
            this.m_cache.getData(object, this.mSensetiveObjectsSet, cacheServerSensitive, bl);
        }
    }

    private Dataholder getFromCache(int n, String string, int n2) throws CacheException {
        boolean bl = n2 == 1;
        byte[] byArray = this.beforeServerCall(n);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": getting property <" + n + ">." + string);
        }
        byte[] byArray2 = this.myAdapter().getProperty(byArray, n, string, bl);
        if (Logger.debugOn()) {
            Logger.out.print(this.mProcess + ": got the property <" + n + ">." + string);
        }
        try {
            Object object = SysListProxy.createSysList(byArray2, false);
            SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
            Object object2 = SysListProxy.getSysList(object);
            this.mServerOutputProcessor.evalResultList(object);
            Dataholder dataholder = bl ? this.getServerObject(object2, false) : new Dataholder(4096, SysListProxy.getWrappedItem(object2));
            if (Logger.debugOn()) {
                Logger.out.println(". value = " + dataholder);
            }
            this.evalCache(object, null, false);
            return dataholder;
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to process result of getting property " + string + " of oref " + n);
        }
    }

    private void setInCacheMsg(int n, String string, boolean bl, Dataholder dataholder) throws CacheException {
        byte[] byArray = this.beforeServerCall(n);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": setting property <" + n + ">." + string + " to " + dataholder.getObject());
        }
        byte[] byArray2 = this.myAdapter().setProperty(byArray, n, string, bl, dataholder);
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": set the property <" + n + ">." + string);
        }
        Object object = SysListProxy.createSysList(byArray2, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        try {
            SysListProxy.skip(object, 1);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to process result of getting property " + string + " of oref " + n);
        }
        this.mServerOutputProcessor.evalResultList(object);
        this.evalCache(object, null, false);
    }

    private boolean inCache(int n) throws SystemError {
        if (this.m_cache == null) {
            return false;
        }
        return this.m_cache.find(n);
    }

    protected void addObjectToMap(int n, CacheObject cacheObject) throws ReferenceCountingException {
        super.addObjectToMap(n, cacheObject);
    }

    private void checkInCache(int n) throws CacheException {
        Integer n2;
        if (!Logger.getDebugCache()) {
            throw new SystemError("method checkCache can be called only in debug mode");
        }
        if (this.debugCacheSet == null) {
            this.debugCacheSet = new HashSet();
        }
        if (!this.debugCacheSet.contains(n2 = new Integer(n))) {
            this.debugCacheSet.add(n2);
        }
    }

    private void checkNotInCache(int n) throws CacheException {
        if (!Logger.getDebugCache()) {
            throw new SystemError("method checkCache can be called only in debug mode");
        }
        if (this.debugCacheSet == null) {
            return;
        }
        Integer n2 = new Integer(n);
        if (this.debugCacheSet.contains(n2)) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was removed from cache.");
        }
    }

    private void notifyDestroySensitiveObjects() throws CacheException {
        if (this.mSensetiveObjectsSet == null) {
            return;
        }
        for (CacheServerSensitive cacheServerSensitive : this.mSensetiveObjectsSet.keySet()) {
            cacheServerSensitive.onDatabaseDestroy();
        }
        this.mSensetiveObjectsSet = null;
    }

    public void closeObject(Object object) throws CacheException {
        OrefInfo orefInfo;
        if (object instanceof String) {
            orefInfo = JBindDatabase.parseOrefString((String)object);
        } else if (object instanceof OrefInfo) {
            orefInfo = (OrefInfo)object;
        } else {
            throw new CacheException("Unknown type of Internal Object reference");
        }
        this.closeObject(orefInfo.oref);
    }

    public void onConnectionClosed() {
        if (Logger.debugOn()) {
            Logger.out.println(this.mProcess + ": " + this.toString() + ": Connection closed event received.");
        }
        try {
            this.mRefCount = 0;
            this.close();
        }
        catch (Exception exception) {
            ConnectionUtils.processErrorOnConnectionClose(exception, this, this.mProcess);
        }
    }

    public synchronized Map close() throws CacheException {
        --this.mRefCount;
        if (!ConnectionUtils.processCloseDatabase(this, this.mRefCount, this.mProcess)) {
            return this.getCopyOfMap();
        }
        this.notifyDestroySensitiveObjects();
        return super.close();
    }

    public void closeAllObjects(boolean bl) throws CacheException {
        super.closeAllObjects();
        if (bl) {
            this.sync();
        }
    }

    public void flush() throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Synchronizing application state.");
        }
        this.sync();
    }

    private void sync() throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        byArray = this.myAdapter().sync(byArray);
        Object object = SysListProxy.createSysList(byArray);
        try {
            Object object2 = SysListProxy.getSysList(object);
            if (object2 != null && !SysListProxy.atEnd(object2)) {
                throw new SystemError("Invalid server response: " + object2);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Invalid server response.");
        }
        this.mServerOutputProcessor.evalResultList(object);
        this.evalCache(object, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Map forceClose() throws CacheException {
        Object object;
        Object object2;
        Vector<Throwable> vector = new Vector<Throwable>();
        if (!this.isConnectionOpen) {
            throw new CacheException("Attempt to close already closed Database " + this.toString());
        }
        try {
            ((CacheConnection)this.mAdapter.getConnection()).registerDatabase().unregister(this);
            SysListProxy.clearList(this.mSetList);
            if (this.m_cache != null) {
                this.m_cache.putData(this.mSetList);
            }
            if ((object2 = this.prepareFlushReferenceCountList()) == null) {
                SysListProxy.setInteger(this.mSetList, 0);
            } else {
                int n = SysListProxy.countItems(object2);
                SysListProxy.setInteger(this.mSetList, n / 2);
                SysListProxy.concatenate(this.mSetList, object2);
                SysListProxy.clearList(this.mClosedOrefs);
            }
        }
        catch (SQLException sQLException) {
            vector.add(sQLException);
        }
        object2 = new TreeMap();
        byte[] byArray = null;
        try {
            byArray = SysListProxy.getBinaryData(this.mSetList);
            object = databases;
            synchronized (object) {
                if (Logger.debugOn()) {
                    Logger.out.println("Sending request to server to close Database " + this.mProcess + ": " + this.toString());
                }
                int n = this.m_cache != null ? this.m_cache.getType() : 0;
                byArray = this.myAdapter().destroyDb(this.m_cache != null, n, byArray);
                Object v = databases.remove(this.myAdapter().getConnection());
                if (!v.equals(this)) {
                    vector.add(new SystemError("Wrong database was in databases map"));
                }
                if (Logger.debugOn()) {
                    Logger.out.println("Done closing Database " + this.mProcess + ": " + this.toString());
                }
            }
        }
        catch (Throwable throwable) {
            vector.add(throwable);
        }
        if (byArray != null) {
            Object object3;
            object = new String(byArray);
            boolean bl = ((String)object).equalsIgnoreCase("OK");
            if (!bl) {
                object3 = SysListProxy.createSysList(byArray, false);
                this.mServerOutputProcessor.evalClosingErrros(object3, vector);
                bl = true;
            } else {
                object3 = SysListProxy.createSysList();
            }
            if (!bl) {
                vector.add(new CacheException("Error closing database, status: " + (String)object));
            }
            while (bl && object3 != null && !SysListProxy.atEnd(object3)) {
                try {
                    Integer n = SysListProxy.getIntegerWrapper(object3);
                    String string = SysListProxy.getString(object3);
                    object2.put(n, string);
                }
                catch (Throwable throwable) {
                    vector.add(throwable);
                    bl = false;
                }
            }
        }
        try {
            this.isConnectionOpen = false;
            this.mAdapter.close(this.amIConnectionOwner);
        }
        catch (Throwable throwable) {
            vector.add(throwable);
        }
        if (!vector.isEmpty()) {
            int n = vector.size();
            throw new CacheMultiException(n + " exception(s) occured during closing Database " + this.mProcess + ": " + this.toString(), vector);
        }
        return object2;
    }

    protected void finalize() throws Throwable {
        if (!this.isConnectionOpen) {
            return;
        }
        this.close();
    }

    private synchronized Connection initConnection(String string, String string2, String string3) throws CacheException {
        this.amIConnectionOwner = true;
        this.mConnectionString = ConnectionUtils.createURLString(string);
        return ConnectionUtils.staticInitConnection(this.mConnectionString, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initClientDatabase(Connection connection, int n, boolean bl) throws CacheException, SQLException {
        if (databases == null) {
            databases = Collections.synchronizedMap(new HashMap());
        }
        this.cachingOnCloseEnabled = ConnectionUtils.determineCacheOnClose();
        this.mMessageListeners = new HashSet();
        this.mMessageListeners.add(new MessagePrinter());
        if (bl) {
            this.m_statistics = new Statistics();
            this.m_statistics.insertObject(-1, "Static");
        } else {
            this.m_statistics = null;
        }
        if (n < 0) {
            n = ConnectionUtils.determineCacheType();
        }
        Map map = databases;
        synchronized (map) {
            if (databases.containsKey(connection)) {
                throw new DatabaseExistsException(0);
            }
            this.mAdapter = new CustomMsgDBAdapter(connection);
            this.isConnectionOpen = true;
            byte[] byArray = this.myAdapter().initDb(n > 0, n);
            Object object = SysListProxy.createSysList(byArray);
            this.mInfo.clientVersionSupported = SysListProxy.getBoolean(object);
            this.mServerVersion = SysListProxy.getDouble(object);
            this.mAgreedVersion = this.myAdapter().getVersion();
            if (this.mServerVersion < this.mAgreedVersion) {
                this.mAgreedVersion = this.mServerVersion;
            }
            this.mInfo.protocolServerVersion = String.valueOf(this.mServerVersion);
            this.mInfo.protocolClientVersion = String.valueOf(this.myAdapter().getVersion());
            if (this.mServerVersion < 2.08) {
                throw new CacheUnsupportedProtocolException(this.mInfo);
            }
            this.mInfo.isUnicode = SysListProxy.getBoolean(object);
            this.mInfo.namespace = SysListProxy.getString(object);
            this.mInfo.connectionInfo = this.mConnectionString;
            this.mInfo.cacheSystemVersion = SysListProxy.getString(object);
            this.mInfo.cacheObjectVersion = SysListProxy.getString(object);
            this.mInfo.locale = this.mInfo.isUnicode ? "UTF-8" : ((CacheConnection)connection).getServerLocale();
            switch (n) {
                case 1: {
                    this.m_cache = new CacheProcessor(this, this.mInfo.isUnicode, this.mInfo.locale);
                    break;
                }
                case 2: {
                    this.m_cache = new CacheLAZY(this, this.mInfo.isUnicode, this.mInfo.locale);
                    break;
                }
                case 0: {
                    this.m_cache = null;
                    break;
                }
                default: {
                    throw new CacheException("Unknown cache type: " + n);
                }
            }
            if (this.m_cache != null) {
                if (this.mAgreedVersion > 2.13) {
                    this.m_cache.setOidSent(true);
                }
                if (this.mAgreedVersion >= 3.02) {
                    this.m_cache.setRecieveChangedNodesOnly(true);
                }
            }
            long l = -1L;
            long l2 = -1L;
            try {
                l = ((CacheConnection)connection).getCacheJobID();
            }
            catch (SQLException sQLException) {
                throw new CacheException(sQLException, "Attempt to use closed connection to construct Database");
            }
            catch (ClassCastException classCastException) {
                l = -1L;
            }
            if (!SysListProxy.atEnd(object)) {
                l2 = SysListProxy.getLong(object);
            }
            if (l > 0L && l2 > 0L && l != l2) {
                throw new SystemError("Inconsistent process number: JDBC returned " + l + " cppAPi returned " + l2);
            }
            this.mInfo.processNumber = this.mProcess = l > 0L ? l : l2;
            if (!this.mInfo.clientVersionSupported) {
                throw new CacheUnsupportedProtocolException(this.mInfo);
            }
            if (Logger.debugOn()) {
                Logger.out.println("Opened Database " + this.mProcess + ": " + this.toString());
            }
            ++this.mRefCount;
            databases.put(connection, this);
            if (this.m_cache == null) {
                this.cachingOnCloseEnabled = false;
            }
        }
        if (this.mServerVersion > this.myAdapter().getVersion() + 0.001 && !ConnectionUtils.determineObsoleteProtocolOK()) {
            throw new CacheProtocolUpdatedException(this);
        }
        this.mSetList = SysListProxy.createSysList();
        SysListProxy.setServerLocale(this.mSetList, this.mInfo.isUnicode, this.mInfo.locale);
        this.mClosedOrefs = SysListProxy.createSysList();
        this.mServerOutputProcessor = new ServerOutputProcessor(this);
        this.mReflectionVersion = this.myAdapter().getReflectionVersion();
        if (this.useNewMetadata()) {
            this.mCheckDeps = ConnectionUtils.determineUpdateUserClasses() >= 0;
        }
        ((CacheConnection)connection).registerDatabase().register(this);
    }

    public void transactionStart() throws CacheException {
        this.transactionControl(1);
    }

    public void transactionCommit() throws CacheException {
        this.transactionControl(2);
    }

    public void transactionRollback() throws CacheException {
        this.transactionControl(3);
    }

    private void transactionControl(int n) throws CacheException {
        if (Logger.debugOn()) {
            Logger.out.println("Transaction control: " + n);
        }
        this.transactionMsg(n);
        this.mTransactionLevel = n;
    }

    private int transactionMsg(int n) throws CacheException {
        byte[] byArray = this.beforeServerCall(-1);
        byArray = this.myAdapter().transactionControl(byArray, n);
        Object object = SysListProxy.createSysList(byArray, false);
        SysListProxy.setServerLocale(object, this.mInfo.isUnicode, this.mInfo.locale);
        int n2 = -1;
        try {
            if (n == 4) {
                n2 = SysListProxy.getInteger(object);
            } else {
                SysListProxy.skip(object, 1);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to parse return data");
        }
        this.mServerOutputProcessor.evalResultList(object);
        this.evalCache(object, null, false);
        return n2;
    }

    public int transactionLevel() throws CacheException {
        int n = this.transactionMsg(4);
        if (n != this.mTransactionLevel) {
            if (Logger.debugOn()) {
                Logger.out.println("Transaction level changed from: " + this.mTransactionLevel + " to " + n);
            }
            this.mTransactionLevel = n;
        }
        return this.mTransactionLevel;
    }

    public int parseStatus(StatusCode statusCode) throws CacheException {
        if (!statusCode.isError()) {
            return statusCode.getCode();
        }
        byte[] byArray = statusCode.getBytes();
        return this.decomposeStatusMsg(byArray);
    }

    public int parseStatus(Dataholder dataholder) throws CacheException {
        try {
            int n = dataholder.getIntValue();
            if (n != 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (CacheNullValueException cacheNullValueException) {
            // empty catch block
        }
        byte[] byArray = dataholder.getBinary();
        return this.decomposeStatusMsg(byArray);
    }

    private int decomposeStatusMsg(byte[] byArray) throws CacheException {
        byte[] byArray2 = this.myAdapter().decomposeStatus(byArray);
        Object object = SysListProxy.createSysList(byArray2);
        this.mServerOutputProcessor.evalServerErrors(object);
        try {
            Integer n = SysListProxy.getIntegerWrapper(object);
            if (n == null) {
                return 1;
            }
            String string = SysListProxy.getString(object);
            throw new CacheException(string, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to decompose status " + object);
        }
    }

    public int getReflectionVersion() {
        return this.mReflectionVersion;
    }

    public JBindCacheObject find(int n) throws SystemError {
        return (JBindCacheObject)this.findInMap(n);
    }

    public Iterator openByQuery(String string, String string2) throws CacheException {
        String string3 = this.getCacheClass(string).getFullSQLTableName();
        String string4 = ParseUtils.sqlForOpenyQuery(string3, string2);
        return this.openObjectsByQuery(string, string4, null);
    }

    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        String string3 = this.getCacheClass(string).getFullSQLTableName();
        String string4 = ParseUtils.sqlForOpenyQuery(string3, string2);
        return this.openObjectsByQuery(string, string4, objectArray);
    }

    public Iterator openByQuery(String string) throws CacheException {
        return this.openByQuery(string, (Object[])null);
    }

    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        String string2 = ParseUtils.retrieveTableNameFromQuery(string);
        CacheClass cacheClass = this.getCacheClassByTable(string2);
        String string3 = cacheClass.getName();
        return this.openObjectsByQuery(string3, string, objectArray);
    }

    private Iterator openObjectsByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        Dataholder dataholder;
        Object object;
        byte[] byArray = this.beforeServerCall(-1);
        if (Logger.debugOn()) {
            Logger.out.print("Opening objects of class " + string + " by query \"" + string2 + "\"");
            if (objectArray != null && objectArray.length > 0) {
                Logger.out.print(" [");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        Logger.out.print(',');
                    }
                    Logger.out.print(objectArray[i]);
                }
                Logger.out.println("]");
            } else {
                Logger.out.println(" []");
            }
        }
        byArray = this.myAdapter().bulkLoad(byArray, string, string2, objectArray);
        Object object2 = SysListProxy.createSysList(byArray, false);
        SysListProxy.setServerLocale(object2, this.mInfo.isUnicode, this.mInfo.locale);
        try {
            object = SysListProxy.getSysList(object2);
            this.mServerOutputProcessor.evalResultList(object2);
            dataholder = this.getServerObject(object, false);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Error opening objects by query \"" + string2 + "\"");
        }
        this.evalCache(object2, null, false);
        if (Logger.debugOn()) {
            Logger.out.println("Returned list with oref " + dataholder.getString());
        }
        object = dataholder.getCacheObject();
        ListOfObjects listOfObjects = (ListOfObjects)object.newJavaInstance();
        listOfObjects.setAutoLoad(true);
        return listOfObjects.iterator();
    }

    public void createObjects(String string, Collection collection) throws CacheException {
        throw new CacheException("This feature is not implemented yet. It is only implemented in Light Database now.");
    }

    public void saveObjects(String string, Collection collection) throws CacheException {
        throw new CacheException("This feature is not implemented yet. It is only implemented in Light Database now.");
    }

    public ResultSet getCacheResultSet(String string) throws CacheException {
        return this.myAdapter().getCacheResultSet(string);
    }

    public void setConsoleOutput(PrintStream printStream) {
        for (Object e : this.mMessageListeners) {
            if (!(e instanceof MessagePrinter)) continue;
            ((MessagePrinter)e).setStream(printStream);
        }
    }

    public boolean addListener(EventListener eventListener) {
        if (eventListener instanceof CacheServerSensitive) {
            this.registerSensitiveObject((CacheServerSensitive)eventListener);
            return true;
        }
        return this.mMessageListeners.add(eventListener);
    }

    public boolean removeListener(EventListener eventListener) {
        return this.mMessageListeners.remove(eventListener);
    }

    protected Iterator messageListneres() {
        return this.mMessageListeners.iterator();
    }

    protected double getProtocolVersion() {
        return this.mAgreedVersion;
    }

    public boolean isLightConnection() {
        return false;
    }

    protected boolean isProtocol505() {
        if (!this.myAdapter().isNewServer()) {
            return true;
        }
        return this.mAgreedVersion < 2.12;
    }

    private DBAdapter myAdapter() {
        if (this.isConnectionOpen) {
            return this.mAdapter;
        }
        throw new RuntimeException("Database connection is not open.");
    }

    public JDBCAdapter getAdapter() {
        return (JDBCAdapter)((Object)this.myAdapter());
    }

    private boolean useNewMetadata() {
        boolean bl = this.getReflectionVersion() >= 10;
        return bl;
    }

    protected static class OrefInfo {
        public int oref;
        public String className;

        public OrefInfo(int n, String string) {
            this.oref = n;
            this.className = string;
        }
    }
}

