/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.WeakValuesHashMap;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.pojo.runtime.ObjectFactory;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class DetachedCacheManager {
    private boolean mWeakValuesMap;
    private Map mProxyToPojo;
    private Map mPojoToProxy;
    protected Database mDB;
    private PreparedStatement mFindCacheClassNameStatement;
    private Map mJavaCacheClassMap;
    private int mCacheType;

    public DetachedCacheManager(Database database) {
        this.mDB = database;
        this.mWeakValuesMap = false;
        this.mCacheType = 0;
    }

    public void setCacheType(int n) {
        if (this.mCacheType < 0) {
            throw new IllegalStateException("Can not change Client Cache Type. Caches are already initialized.");
        }
        this.mCacheType = n;
    }

    public int getCacheType() {
        if (this.mCacheType < 0) {
            if (this.mWeakValuesMap) {
                return 16;
            }
            return 32;
        }
        return this.mCacheType;
    }

    public synchronized Object findPOJO(CacheRootObject cacheRootObject, boolean bl) throws Exception {
        if (this.mProxyToPojo == null) {
            return null;
        }
        if (!(cacheRootObject instanceof Persistent)) {
            return null;
        }
        Persistent persistent = (Persistent)cacheRootObject;
        Oid oid = persistent.getOid();
        Object v = this.mProxyToPojo.get(oid);
        if (bl) {
            return v;
        }
        if (v == null || ObjectFactory.isProxy(v)) {
            return null;
        }
        return v;
    }

    protected synchronized Persistent findProxyInMemory(Object object) throws CacheException {
        if (this.mPojoToProxy == null) {
            return null;
        }
        Oid oid = (Oid)this.mPojoToProxy.get(object);
        if (oid == null) {
            return null;
        }
        return (Persistent)Persistent._open(this.mDB, oid);
    }

    public synchronized void register(Persistent persistent, Object object) throws CacheException {
        Oid oid;
        if (this.mProxyToPojo == null) {
            this.initMaps();
        }
        if ((oid = persistent.getOid()) == null || oid.undefined()) {
            persistent.save();
            oid = persistent.getOid();
        }
        this.mPojoToProxy.put(object, oid);
        this.mProxyToPojo.put(oid, object);
        persistent.getProxy().setStateReadDirty();
    }

    public CacheClass findCacheClassForPOJO(String string) throws CacheException, SQLException, ClassNotFoundException {
        String string2;
        if (this.mFindCacheClassNameStatement == null) {
            this.initFind();
        }
        if ((string2 = (String)this.mJavaCacheClassMap.get(string)) != null) {
            return this.mDB.getCacheClass(string2);
        }
        this.mFindCacheClassNameStatement.setString(1, string);
        this.mFindCacheClassNameStatement.setString(2, string);
        ResultSet resultSet = this.mFindCacheClassNameStatement.executeQuery();
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
            CacheClass cacheClass = this.mDB.getCacheClass(string2);
            this.mJavaCacheClassMap.put(string, string2);
            return cacheClass;
        }
        throw new ClassNotFoundException("No Cache class found that corresponds to Java class " + string);
    }

    private void initFind() throws CacheException {
        String string = "select name from %Dictionary.ClassDefinition where (clientname = ?) OR (clientname IS NULL and name = ?)";
        this.mFindCacheClassNameStatement = this.mDB.prepareStatement(string);
        this.mJavaCacheClassMap = new HashMap();
    }

    public Object purge(Object object) throws SystemError {
        if (this.mPojoToProxy == null) {
            return null;
        }
        Object v = this.mPojoToProxy.get(object);
        if (v != null) {
            Object v2 = this.mProxyToPojo.get(v);
            if (!object.equals(v2)) {
                throw new SystemError("Inconsistency in Maps");
            }
            this.mPojoToProxy.remove(object);
            this.mProxyToPojo.remove(v);
        }
        return v;
    }

    public synchronized void clear() {
        if (this.mProxyToPojo != null) {
            this.mProxyToPojo.clear();
        }
        if (this.mPojoToProxy != null) {
            this.mPojoToProxy.clear();
        }
        if (this.mJavaCacheClassMap != null) {
            this.mJavaCacheClassMap.clear();
        }
    }

    public void close() {
        if (this.mWeakValuesMap) {
            this.mProxyToPojo.put(WeakValuesHashMap.TERMINATE, null);
        }
    }

    protected void reportWeakStatistics(PrintStream printStream) {
        if (this.mWeakValuesMap) {
            this.mProxyToPojo.put(WeakValuesHashMap.REPORT, printStream);
        }
    }

    protected boolean isProfileOn() {
        return false;
    }

    private void initMaps() {
        boolean bl;
        if (this.mCacheType == 16) {
            bl = true;
        } else if (this.mCacheType == 32) {
            bl = false;
        } else {
            String string = System.getProperty("com.intersys.cache.pojo");
            bl = false;
            if (string != null) {
                if (string.equalsIgnoreCase("strong")) {
                    bl = false;
                } else if (string.equalsIgnoreCase("weak")) {
                    bl = true;
                } else {
                    throw new IllegalArgumentException("Unkown POJO Cache Type: " + string + ". Allowed values: " + "\"weak\" or \"strong\".");
                }
            }
        }
        if (bl) {
            this.mPojoToProxy = new WeakHashMap();
            this.mProxyToPojo = WeakValuesHashMap.create(this.isProfileOn());
            this.mWeakValuesMap = true;
        } else {
            this.mPojoToProxy = new HashMap();
            this.mProxyToPojo = new HashMap();
        }
    }
}

