/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.NodeBTMLogger;
import com.eg.jtm.NodeMethodInfo;
import com.eg.jtm.NodePropsManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeURLPatternData {
    String pName;
    boolean modified = false;
    public double[] sumOf;
    public double[] numOf;
    private ArrayList<NodeMethodInfo> SlowURLsList = null;
    private ArrayList<NodeMethodInfo> ErrorURLsList = null;
    private ArrayList<NodeMethodInfo> AllURLsList = null;
    private ArrayList<NodeMethodInfo> HealthyTHREADList = null;
    private ArrayList<NodeMethodInfo> SlowTHREADsList = null;
    private ArrayList<NodeMethodInfo> ErrorTHREADsList = null;
    private ArrayList<NodeMethodInfo> StalledURLsList = null;
    private ArrayList<NodeMethodInfo> StalledTHREADsList = null;
    protected static String logPrefix = "NodeURLPatternData";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    static final double defaultValue = 0.0;
    NodePropsManager nodePropsManager;

    public NodeURLPatternData(String pName, NodePropsManager nodePropsManager) {
        this.pName = pName;
        this.modified = false;
        this.nodePropsManager = nodePropsManager;
        int length = nodePropsManager.getSubCompNameLength();
        this.sumOf = new double[length];
        this.numOf = new double[length];
    }

    public ArrayList<NodeMethodInfo> getAllURLsList() {
        return this.AllURLsList;
    }

    public ArrayList<NodeMethodInfo> getHealthyThreadList() {
        return this.HealthyTHREADList;
    }

    public ArrayList<NodeMethodInfo> getSlowURLsList() {
        return this.SlowURLsList;
    }

    public ArrayList<NodeMethodInfo> getErrorURLsList() {
        return this.ErrorURLsList;
    }

    public ArrayList<NodeMethodInfo> getSlowTHREADsList() {
        return this.SlowTHREADsList;
    }

    public ArrayList<NodeMethodInfo> getErrorTHREADsList() {
        return this.ErrorTHREADsList;
    }

    public ArrayList<NodeMethodInfo> getStalledURLsList() {
        return this.StalledURLsList;
    }

    public ArrayList<NodeMethodInfo> getStalledTHREADsList() {
        return this.StalledTHREADsList;
    }

    public void cleanStalledURLsList() {
        this.StalledURLsList = null;
    }

    public void cleanStalledTHREADsList() {
        this.StalledTHREADsList = null;
    }

    public void cleanAllURLsList() {
        this.AllURLsList = null;
    }

    public void cleanHealthyThreadList() {
        this.HealthyTHREADList = null;
    }

    public void cleanSlowURLsList() {
        this.SlowURLsList = null;
    }

    public void cleanErrorURLsList() {
        this.ErrorURLsList = null;
    }

    public void cleanSlowTHREADsList() {
        this.SlowTHREADsList = null;
    }

    public void cleanErrorTHREADsList() {
        this.ErrorTHREADsList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHashtables(int subCompIndex, double time, double count) {
        if (time >= 0.0) {
            NodeURLPatternData nodeURLPatternData = this;
            synchronized (nodeURLPatternData) {
                this.sumOf[subCompIndex] = this.sumOf[subCompIndex] + time;
                this.numOf[subCompIndex] = this.numOf[subCompIndex] + count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreadTimingHashtables(int subCompIndex, double time, double count) {
        NodeURLPatternData nodeURLPatternData = this;
        synchronized (nodeURLPatternData) {
            this.sumOf[subCompIndex] = this.sumOf[subCompIndex] + time;
            this.numOf[subCompIndex] = this.numOf[subCompIndex] + count;
        }
    }

    private void parseMinfoAndCalc(NodeMethodInfo Minfo) {
        ArrayList slowSQLTime = (ArrayList)Minfo.getProperties().remove("SlowSQLTime");
        if (slowSQLTime != null) {
            double count = 0.0;
            double total_time = 0.0;
            int i = 0;
            while (i < slowSQLTime.size()) {
                Double sqlExeTime = (Double)slowSQLTime.get(i);
                double exclTime = sqlExeTime;
                if (exclTime >= this.nodePropsManager.getSQLExecCutOff()) {
                    count += 1.0;
                    total_time += exclTime;
                }
                ++i;
            }
            this.updateHashtables(4, total_time, count);
        }
    }

    void SortedAddToURLList(ArrayList URLsList, NodeMethodInfo MI2Add, String URLSubcompName, int MaxURLs) {
        NodeMethodInfo thisMinfo;
        double MI2Add_ExecTime = MI2Add.getExecutionTime();
        int i = 0;
        while (i < URLsList.size()) {
            thisMinfo = (NodeMethodInfo)URLsList.get(i);
            if ((double)thisMinfo.getExecutionTime() < MI2Add_ExecTime) break;
            ++i;
        }
        URLsList.add(i, MI2Add);
        if (URLsList.size() > MaxURLs && (thisMinfo = (NodeMethodInfo)URLsList.remove(URLsList.size() - 1)) != null) {
            thisMinfo.clearURLTree();
        }
    }

    private void storeAllURLInfo(NodeMethodInfo MI2Add, String callType) {
        NodeBTMLogger.nodeLogger.debug("{} Added the following Healthy URL to All urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
        NodeBTMLogger.nodeLogger.debug("{} , {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
        if (callType.equalsIgnoreCase("Web")) {
            if (this.AllURLsList == null) {
                this.AllURLsList = new ArrayList();
            }
            this.SortedAddToURLList(this.AllURLsList, MI2Add, "ALL_URLS", this.nodePropsManager.getHelathyURLs());
        } else if (callType.equals("Thread")) {
            if (this.HealthyTHREADList == null) {
                this.HealthyTHREADList = new ArrayList();
            }
            this.SortedAddToURLList(this.HealthyTHREADList, MI2Add, "ALL_URLS", this.nodePropsManager.getHelathyURLs());
        }
    }

    private boolean storeURLIfNeeded(NodeMethodInfo MI2Add, boolean firstNode, String requestType) {
        double urlExecutionTime = MI2Add.getExecutionTime();
        if (!MI2Add.isSlowURL() && !MI2Add.isErrorURL() && !MI2Add.isStalled() || !(urlExecutionTime >= 0.0)) {
            return false;
        }
        if (MI2Add.isErrorURL()) {
            int maxErrorUrls = this.nodePropsManager.getMaxErrorURLs();
            if (requestType.equals("Web")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following ERROR URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug(String.valueOf(loggerDispStr) + MI2Add.getTree(true));
                if (this.ErrorURLsList == null) {
                    this.ErrorURLsList = new ArrayList();
                }
                this.updateHashtables(2, urlExecutionTime, 1.0);
                if (firstNode) {
                    System.out.println("error url started");
                    this.updateHashtables(7, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.ErrorURLsList, MI2Add, "ERROR_URLS", maxErrorUrls);
            } else if (requestType.equals("Thread")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following ERROR URL to error urls list for pattern ", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug("{} {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
                if (this.ErrorTHREADsList == null) {
                    this.ErrorTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.ErrorTHREADsList, MI2Add, "ERROR_URLS", maxErrorUrls);
            }
        } else if (MI2Add.isStalled()) {
            int maxStalledUrls = this.nodePropsManager.getMaxStalledURLs();
            if (requestType.equals("Web")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following STALLED URL to stalled urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug("{} {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
                if (this.StalledURLsList == null) {
                    this.StalledURLsList = new ArrayList();
                }
                this.updateHashtables(3, urlExecutionTime, 1.0);
                if (firstNode) {
                    System.out.println("Stalled url started");
                    this.updateHashtables(8, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.StalledURLsList, MI2Add, "STALLED_URLS", maxStalledUrls);
            } else if (requestType.equals("Thread")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following STALLED URL to stalled urls list for pattern {} ", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug("{} {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
                if (this.StalledTHREADsList == null) {
                    this.StalledTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.StalledTHREADsList, MI2Add, "STALLED_URLS", maxStalledUrls);
            }
        } else if (MI2Add.isSlowURL()) {
            int maxSlowUrls = this.nodePropsManager.getMaxSlowURLs();
            if (requestType.equals("Web")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following SLOW URL to slow urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug("{} {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
                if (this.SlowURLsList == null) {
                    this.SlowURLsList = new ArrayList();
                }
                this.updateHashtables(1, urlExecutionTime, 1.0);
                if (firstNode) {
                    System.out.println("SlowURL started");
                    this.updateHashtables(6, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.SlowURLsList, MI2Add, "SLOW_URLS", maxSlowUrls);
            } else if (requestType.equals("Thread")) {
                NodeBTMLogger.nodeLogger.debug("{} Added the following SLOW URL to slow urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                NodeBTMLogger.nodeLogger.debug("{} {}", (Object)loggerDispStr, (Object)MI2Add.getTree(true));
                if (this.SlowTHREADsList == null) {
                    this.SlowTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.SlowTHREADsList, MI2Add, "SLOW_URLS", maxSlowUrls);
            }
        }
        return true;
    }

    public void updateAllUrlCount(NodeMethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        NodeBTMLogger.nodeLogger.debug("{} updateAllUrlCount URL -: {}  Execution Time is :", new Object[]{loggerDispStr, rootMI.getRawURL(), rootMI.getExecutionTime()});
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equalsIgnoreCase("Web")) {
            this.updateHashtables(0, rootMI.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
        }
        if (rootMI.isSQLPresent()) {
            this.parseMinfoAndCalc(rootMI);
        }
        if (this.nodePropsManager.isTraceHealthyURL()) {
            this.storeAllURLInfo(rootMI, callType);
        } else {
            rootMI.clearURLTree();
        }
    }

    public void addStalledURLInfo(NodeMethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equals("Web")) {
            double urlExecutionTime = rootMI.getExecutionTime();
            this.updateHashtables(0, urlExecutionTime, 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
            if (rootMI.isSQLPresent()) {
                this.parseMinfoAndCalc(rootMI);
            }
        }
        boolean isStored = this.storeURLIfNeeded(rootMI, firstNode, callType);
    }

    public void addURLInfo(NodeMethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equals("Web")) {
            this.updateHashtables(0, rootMI.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
        }
        if (rootMI.isSQLPresent()) {
            this.parseMinfoAndCalc(rootMI);
        }
        boolean isStored = this.storeURLIfNeeded(rootMI, firstNode, callType);
    }

    private void updateThreadDiagonosis(long cpuTime, long blockedTime, long waitedTime) {
        if (cpuTime >= 0L) {
            this.updateThreadTimingHashtables(9, cpuTime, 1.0);
        }
        if (blockedTime >= 0L) {
            this.updateThreadTimingHashtables(10, blockedTime, 1.0);
        }
        if (waitedTime >= 0L) {
            this.updateThreadTimingHashtables(11, waitedTime, 1.0);
        }
    }
}

