/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDatabaseInfo
extends BaseDatabaseInfo {
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    private static final String MARIA_URL_PREFIX = "jdbc:mariadb://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:mysql://";
    private static final String DEFAULT_PORT = "3306";

    public MySqlDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> mysqlDetails = new Hashtable<String, String>();
        mysqlDetails.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            mysqlDetails.put("SERVERNAME", this.jdbcUrl);
            mysqlDetails.put("DATABASENAME", "-");
            mysqlDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            mysqlDetails.put("SERVERNAME", this.jdbcUrl);
            mysqlDetails.put("DATABASENAME", "-");
            mysqlDetails.put("PORTNUMBER", "-");
        } else {
            mysqlDetails.put("SERVERNAME", this.hostName);
            mysqlDetails.put("DATABASENAME", this.databaseName);
            mysqlDetails.put("PORTNUMBER", this.portNo);
        }
        return mysqlDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(MYSQL_URL_PREFIX)) {
                String hostPortDbString = maker.after(MYSQL_URL_PREFIX).before("?").value().trim();
                String propertyString = maker.next().value();
                this.logger.warn("[" + this.dbType + "  - parseUrl] propertyString :" + propertyString);
                int socket_index = propertyString.indexOf("socketfactory");
                int named_pipe = propertyString.indexOf("namedpipepath");
                if (socket_index > -1 || named_pipe > -1) {
                    this.isParsingFailure = true;
                } else {
                    this.parseConnectionUrl(hostPortDbString);
                }
            } else if (normalizedUrl.startsWith(MARIA_URL_PREFIX)) {
                String hostPortDbString = maker.after(MARIA_URL_PREFIX).before("?").value().trim();
                this.parseConnectionUrl(hostPortDbString);
                this.dbType = "Maria_server";
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + "  - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
    }

    private void parseConnectionUrl(String hostPortDbString) {
        this.logger.debug("[" + this.dbType + "  - parseUrl] hostPortDbString :" + hostPortDbString);
        int slash_index = hostPortDbString.indexOf("/");
        if (slash_index >= 0) {
            String databaseString = hostPortDbString.substring(slash_index + 1);
            hostPortDbString = hostPortDbString.substring(0, slash_index);
            this.logger.debug("[" + this.dbType + "  - parseUrl] databaseString :" + databaseString);
            this.databaseName = databaseString != null && databaseString.length() > 0 ? databaseString : "-";
        }
        if (hostPortDbString != null) {
            int comma_index = hostPortDbString.indexOf(",");
            int brace_index = hostPortDbString.indexOf(")");
            int equal_index = hostPortDbString.indexOf("=");
            int at_index = hostPortDbString.indexOf("@");
            if (comma_index > 0 || brace_index > 0 || equal_index > 0 || at_index > 0) {
                this.logger.debug("[" + this.dbType + "  - parseUrl]. It is cluster or other kind of JDBC Url");
                this.isParsingFailure = true;
            } else {
                this.assignHostNameAndPort(hostPortDbString, DEFAULT_PORT);
            }
        }
        if (this.portNo == null) {
            this.portNo = DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        this.logger.debug("[" + this.dbType + "  - parseConnectionUrl] hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:mysql://localhost:3306/HerongDB?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://:3306/HerongDB?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://localhost/HerongDB?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://localhost:3310/?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://localhost/?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://:3361/?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql:///HerongDB?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql:///?user=Herong&password=TopSecret";
        jdbcUrl = "jdbc:mysql://root:root@192.168.8.252:3306/priyadb";
        MySqlDatabaseInfo dbInfo = new MySqlDatabaseInfo(jdbcUrl, "MySql_server", null);
        Hashtable<String, String> result = dbInfo.getDBInfo();
        System.out.println(" result :" + result);
    }
}

