/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.APMLanguage;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.NodeBTMLogger;
import com.eg.jtm.IBMDb2DatabaseInfo;
import com.eg.jtm.InformixDatabaseInfo;
import com.eg.jtm.MsSqlDatabaseInfo;
import com.eg.jtm.MySqlDatabaseInfo;
import com.eg.jtm.OracleDatabaseInfo;
import com.eg.jtm.OtherDatabaseInfo;
import com.eg.jtm.PostGresDatabaseInfo;
import com.eg.jtm.SapHanaDatabaseInfo;
import com.eg.jtm.SybaseDatabaseInfo;
import com.eg.org.slf4j.Logger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseUtils {
    private static final String DRIVER_NAME = "DRIVER_NAME";
    private static final String DRIVER_VERSION = "DRIVER_VERSION";
    private static final String JDBC_URL = "JDBC_URL";
    private static final String getDBInfo = "getDBInfo";
    private static final String UNKNOWN = "UNKNOWN";
    private static final HashMap<String, String> DB_MAPPING = new HashMap();
    private static final HashMap<String, Class<?>> PARSER = new HashMap();

    static {
        DB_MAPPING.put("sqlserver", "MS_sql_server");
        DB_MAPPING.put("sybase", "SybaseDb_Server");
        DB_MAPPING.put("oracle", "Oracle_server");
        DB_MAPPING.put("mysql", "MySql_server");
        DB_MAPPING.put("mysqlx", "MySql_server");
        DB_MAPPING.put("mariadb", "Maria_server");
        DB_MAPPING.put("db2", "IBM_Db2_server");
        DB_MAPPING.put("as400", "IBM_Db2_server");
        DB_MAPPING.put("postgresql", "PostGres");
        DB_MAPPING.put("informix-sqli", "Informix_server");
        DB_MAPPING.put("informix-direct", "Informix_server");
        DB_MAPPING.put("informix", "Informix_server");
        DB_MAPPING.put("sap", "SAP_HANA");
        DB_MAPPING.put("hsqldb", "HyperSQL");
        DB_MAPPING.put("derby", "Derby");
        DB_MAPPING.put("h2", "H2");
        DB_MAPPING.put("hive", "Apache Hive");
        DB_MAPPING.put("db2j", "IBM Cloudscape server");
        DB_MAPPING.put("ids", "IBM Informix Datasource");
        DB_MAPPING.put("ibmdb", "IBM Data Server");
        PARSER.put("Oracle_server", OracleDatabaseInfo.class);
        PARSER.put("MS_sql_server", MsSqlDatabaseInfo.class);
        PARSER.put("Sybase_server", SybaseDatabaseInfo.class);
        PARSER.put("MySql_server", MySqlDatabaseInfo.class);
        PARSER.put("Maria_server", MySqlDatabaseInfo.class);
        PARSER.put("IBM_Db2_server", IBMDb2DatabaseInfo.class);
        PARSER.put("Informix_server", InformixDatabaseInfo.class);
        PARSER.put("PostGres", PostGresDatabaseInfo.class);
        PARSER.put("SAP_HANA", SapHanaDatabaseInfo.class);
        PARSER.put("HyperSQL", OtherDatabaseInfo.class);
        PARSER.put("Derby", OtherDatabaseInfo.class);
        PARSER.put("H2", OtherDatabaseInfo.class);
        PARSER.put("Apache Hive", OtherDatabaseInfo.class);
        PARSER.put("IBM Cloudscape server", OtherDatabaseInfo.class);
        PARSER.put("IBM Informix Datasource", OtherDatabaseInfo.class);
        PARSER.put("IBM Data Server", OtherDatabaseInfo.class);
        PARSER.put(UNKNOWN, OtherDatabaseInfo.class);
    }

    public static Hashtable<String, String> getDBInfo(String jdbcUrl, String driverName, String driverVersion, Logger logger, APMLanguage apmLanguage) {
        Hashtable dataBaseTable = new Hashtable();
        if (jdbcUrl != null && jdbcUrl.length() > 0) {
            if (logger == null) {
                logger = apmLanguage == APMLanguage.JAVA ? JavaBTMLogger.btmLogger : (apmLanguage == APMLanguage.NODEJS ? NodeBTMLogger.nodeLogger : AgentStartupLogger.logger);
            }
            String lowerCaseUrl = jdbcUrl.toLowerCase();
            StringTokenizer urlTokenizer = new StringTokenizer(lowerCaseUrl, ":");
            int total = urlTokenizer.countTokens();
            logger.debug("[DataBaseUtils - getDBInfo] - Tokens :" + total);
            boolean foundServerType = false;
            String server_type = null;
            if (total >= 2) {
                String firstToken = urlTokenizer.nextToken();
                if (!firstToken.equals("jdbc") && (server_type = DB_MAPPING.get(firstToken)) != null) {
                    foundServerType = true;
                }
                if (!foundServerType) {
                    String secondToken = urlTokenizer.nextToken();
                    server_type = DB_MAPPING.get(secondToken);
                    if (server_type == null) {
                        String thirdToken;
                        if (total >= 3 && (server_type = DB_MAPPING.get(thirdToken = urlTokenizer.nextToken())) != null) {
                            foundServerType = true;
                        }
                    } else {
                        foundServerType = true;
                    }
                }
            }
            if (foundServerType) {
                logger.info("Found Database Server type ? " + foundServerType + " SERVER_TYPE :" + server_type);
            } else {
                server_type = UNKNOWN;
                logger.info("Not able to found Database Server type, considering " + server_type + " type");
            }
            Class<?> clazz = null;
            try {
                clazz = PARSER.get(server_type);
                Object infoObject = clazz.getConstructor(String.class, String.class, Logger.class).newInstance(jdbcUrl, server_type, logger);
                Method getDBInfoMethod = clazz.getMethod(getDBInfo, new Class[0]);
                getDBInfoMethod.setAccessible(true);
                Object resultObject = getDBInfoMethod.invoke(infoObject, new Object[0]);
                if (resultObject != null) {
                    dataBaseTable = (Hashtable)resultObject;
                }
                logger.info("Database Details - JDBC URL :" + jdbcUrl + " ==> " + dataBaseTable);
            }
            catch (Exception e) {
                logger.warn("[DataBaseUtils] - getDBInfo , Exception occurs while trying to parse JDBC Url", (Throwable)e);
                dataBaseTable.put((String)"SERVERTYPE", (String)UNKNOWN);
                dataBaseTable.put((String)"SERVERNAME", (String)jdbcUrl);
                dataBaseTable.put((String)"DATABASENAME", (String)"-");
                dataBaseTable.put((String)"PORTNUMBER", (String)"-");
            }
        }
        logger.info("DataBaseUtils.getDBInfo :" + dataBaseTable);
        return dataBaseTable;
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:as400://example.com;libraries=LIB1;Database=S12345;socket timeout=30000";
        Hashtable<String, String> result = DataBaseUtils.getDBInfo(jdbcUrl, null, null, null, APMLanguage.JAVA);
        System.out.println(" Result :" + result);
    }
}

