/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm.util;

import com.eg.apm.util.QueryInfo;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum QueryParser {
    DML("^(\\s|\\t|\\n)*(select|delete).+\\s+(from)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(4));
        }
    }
    ,
    DML_INSERT("^(\\s|\\t|\\n)*(insert)\\s+(into)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(4));
        }
    }
    ,
    DML_UPDATE("^(\\s|\\t|\\n)*(update)\\s+([^\\s,(;]*).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(3));
        }
    }
    ,
    DDL("^(\\s|\\t|\\n)*(create|drop)\\s+(procedure|database|table).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(3));
        }
    }
    ,
    ALTER("^(\\s|\\t|\\n)*(alter)\\s+([^\\s]*).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(3));
        }
    }
    ,
    DML_PROC("^(\\s|\\t|\\n)*(call|execute)\\s+([^\\s(,]*).*"){

        protected QueryInfo createQueryInfo(Matcher matcher) {
            return new QueryInfo(matcher.group(), matcher.group(2), matcher.group(3));
        }
    };

    private final Pattern p;

    private QueryParser(String string2) {
        this.p = Pattern.compile(string2, 34);
    }

    protected abstract QueryInfo createQueryInfo(Matcher var1);

    private Pattern getQueryPattern() {
        return this.p;
    }

    public static QueryInfo getQueryInfo(String string) {
        if (string == null) {
            throw new RuntimeException("query is null[QueryParser] : " + string);
        }
        for (QueryParser queryParser : EnumSet.allOf(QueryParser.class)) {
            Matcher matcher = queryParser.getQueryPattern().matcher(string);
            if (!matcher.find()) continue;
            return queryParser.createQueryInfo(matcher);
        }
        return new QueryInfo(string, string.split(" ")[0], "QUERY");
    }

    public static String standardizeQuery(String string) {
        string = string.replaceAll("(\\t|\\n)+", " ");
        string = string.replaceAll("\\,", ", ");
        string = string.replaceAll("\\s+", " ");
        string = string.replaceAll("/\\*.+\\*/", "");
        return string;
    }
}

