/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMNodeComponentIDRepository;
import com.eg.apm.APMNodeQueue;
import com.eg.apm.APMNodeWorker;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.NodeBTMDataParser;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.NodeMethodInfo;
import com.eg.jtm.NodeThreadPoolManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeClientSocketHandler
implements Runnable {
    private Socket clientSocket;
    private String logPrefix = " [" + this.getClass().getName() + "] ";
    private static int threadCounter = 1;
    private static boolean sendConfig = true;
    private String clientSocketAddress;
    private Boolean ackSync = new Boolean(true);
    private boolean runThis = true;
    private NodeThreadPoolManager threadPool = null;
    public NodeBTMDataParser dataParser = new NodeBTMDataParser();
    private APMFileOperations apm = new APMFileOperations();

    public NodeClientSocketHandler(Socket clientSocket) {
        try {
            this.threadPool = NodeThreadPoolManager.getInstance();
            this.clientSocket = clientSocket;
            this.clientSocketAddress = clientSocket.getInetAddress() + ":" + clientSocket.getPort();
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to initialize ClientSocketHandler object {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public NodeClientSocketHandler(Socket clientSocket, APMNodeQueue<Object> myQueue2) {
        try {
            this.clientSocket = clientSocket;
            Thread thread = new Thread(new APMNodeWorker(myQueue2));
            thread.setContextClassLoader(null);
            thread.setDaemon(true);
            thread.setName("Agent_Worker");
            thread.start();
            this.clientSocketAddress = clientSocket.getInetAddress() + ":" + clientSocket.getPort();
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to initialize ClientSocketHandler object {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    @Override
    public void run() {
        block31: {
            this.clientSocketAddress = this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort();
            if (this.clientSocket == null) {
                return;
            }
            BufferedReader inputStream = null;
            ObjectOutputStream outputStream = null;
            AgentStartupLogger.logger.debug("{} ClientSocketHandler is started : {}", (Object)this.logPrefix, (Object)this.clientSocket);
            try {
                try {
                    String inputLine;
                    inputStream = this.getDataInputStream();
                    String instr = "";
                    int counter = 0;
                    String componentID = "";
                    String type = "";
                    while ((inputLine = inputStream.readLine()) != null && this.runThis) {
                        HashMap props;
                        if (counter == 4 && (type.equals("cpu_dump") || type.equals("memory_dump"))) {
                            AgentStartupLogger.logger.debug("{} Going to write the file into the disk, type : {}", (Object)this.logPrefix, (Object)type);
                            String filePath = this.apm.GZipAndWriteFile(type, inputLine);
                            inputLine = String.valueOf(type) + ":-:" + filePath;
                            AgentStartupLogger.logger.debug("{} File saved path : {}", (Object)this.logPrefix, (Object)filePath);
                        }
                        instr = String.valueOf(instr) + inputLine + "\n";
                        if (counter == 0) {
                            componentID = inputLine.split(":-:")[1];
                            AgentStartupLogger.logger.debug("{} component id : {}", (Object)this.logPrefix, (Object)componentID);
                        }
                        if (counter == 1) {
                            type = inputLine.split(":-:")[1];
                        }
                        AgentStartupLogger.logger.debug("{} counter : {}  inputLine : {}", new Object[]{this.logPrefix, counter, inputLine});
                        if (++counter != 5) continue;
                        this.threadPool.submitTask(instr);
                        HashMap changedParams = new HashMap();
                        if (APMNodeComponentIDRepository.isNewPropsAvailable(String.valueOf(componentID) + "-" + "NodeELTest")) {
                            props = APMNodeComponentIDRepository.getNewProps(String.valueOf(componentID) + "-" + "NodeELTest");
                            changedParams.putAll(props);
                            AgentStartupLogger.logger.info("{} props.toString()=> {} ", (Object)this.logPrefix, (Object)props.toString());
                        } else {
                            AgentStartupLogger.logger.info("{} New props are not avilable for node {}", (Object)this.logPrefix, (Object)componentID);
                        }
                        if (APMNodeComponentIDRepository.isNewPropsAvailable(String.valueOf(componentID) + "-" + "NodeCPUTest")) {
                            props = APMNodeComponentIDRepository.getNewProps(String.valueOf(componentID) + "-" + "NodeCPUTest");
                            changedParams.putAll(props);
                            AgentStartupLogger.logger.info("{} New props are   available for NodeCPUTest : {}", (Object)this.logPrefix, (Object)props.toString());
                        } else {
                            AgentStartupLogger.logger.debug("{} New props are not available for NodeCPUTest : {}", (Object)componentID);
                        }
                        if (APMNodeComponentIDRepository.isNewPropsAvailable(String.valueOf(componentID) + "-" + "NodeMemoryTest")) {
                            props = APMNodeComponentIDRepository.getNewProps(String.valueOf(componentID) + "-" + "NodeMemoryTest");
                            changedParams.putAll(props);
                            AgentStartupLogger.logger.debug(" {} New props are available for NodeMemoryTest : {}", (Object)this.logPrefix, (Object)props.toString());
                        } else {
                            AgentStartupLogger.logger.debug("{} New props are not available for NodeMemoryTest : {}", (Object)this.logPrefix, (Object)componentID);
                        }
                        if (changedParams.size() > 0) {
                            try {
                                JSONObject propsJson = new JSONObject(changedParams);
                                OutputStream out = this.clientSocket.getOutputStream();
                                out.write(propsJson.toJSONString().getBytes());
                                out.flush();
                                AgentStartupLogger.logger.info("{} params send it to the Node server succesfully {}", (Object)this.logPrefix, (Object)propsJson.toJSONString());
                            }
                            catch (Exception err) {
                                AgentStartupLogger.logger.error("{} Error while parse nodejs changed props json {} ", (Object)this.logPrefix, (Object)err);
                            }
                        }
                        instr = "";
                        counter = 0;
                    }
                }
                catch (Exception e) {
                    AgentStartupLogger.logger.error("{} Unble to read BTM data  - clientSocketAddress  :- {}", (Object)this.logPrefix, (Object)e);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                        this.closeServerSocket();
                    }
                    catch (Exception e2) {
                        AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection :- {} , {} ", new Object[]{this.logPrefix, this.clientSocketAddress, e2});
                    }
                    AgentStartupLogger.logger.trace(" Client Connection count : {}", (Object)(++threadCounter));
                    break block31;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    this.closeServerSocket();
                }
                catch (Exception e) {
                    AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection :- {} , {} ", new Object[]{this.logPrefix, this.clientSocketAddress, e});
                }
                AgentStartupLogger.logger.trace(" Client Connection count : {}", (Object)(++threadCounter));
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                this.closeServerSocket();
            }
            catch (Exception e) {
                AgentStartupLogger.logger.error("{} Unable to close clientSocket Connection :- {} , {} ", new Object[]{this.logPrefix, this.clientSocketAddress, e});
            }
            AgentStartupLogger.logger.trace(" Client Connection count : {}", (Object)(++threadCounter));
        }
    }

    private void removeConfingsFromRepository(String ACKmsg) {
        String data = ACKmsg.replace("ACK4BTM_!;-;!", "");
        String[] ackMsgs = data.split("!;-;!");
        String nodeID = ackMsgs[0];
        int i = 0;
        while (i < ackMsgs.length) {
            String ack = ackMsgs[i];
            if (ack.length() > 0) {
                if (ack.equalsIgnoreCase("BTM_PROPS_OK")) {
                    APMNodeComponentIDRepository.unregisterProps(nodeID);
                } else if (ack.equalsIgnoreCase("KBTM_PROPS_OK")) {
                    APMNodeComponentIDRepository.unregisterProps("K_" + nodeID);
                } else if (ack.equalsIgnoreCase("BTM_THRESH_OK")) {
                    APMNodeComponentIDRepository.unregisterThreshold(nodeID);
                } else if (ack.equalsIgnoreCase("KBTM_THRESH_OK")) {
                    APMNodeComponentIDRepository.unregisterThreshold("K_" + nodeID);
                } else if (ack.equalsIgnoreCase("OFFLOAD_CONFIG_OK")) {
                    APMNodeComponentIDRepository.removeTestOffloadConfig(nodeID);
                }
            }
            ++i;
        }
    }

    private void updateAPMDiscoveryIniFile(String subject, String variable, String value) {
        IniFile inifile = null;
        try {
            try {
                inifile = EgApmFilesSync.getInstance(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH, true);
                inifile.setValue(subject, variable, value);
                AgentStartupLogger.logger.info("{} Adding Component {}  details under subject -> {} ", new Object[]{this.logPrefix, variable, subject});
            }
            catch (Exception e) {
                AgentStartupLogger.logger.error("{} Unable to update {} , {}", new Object[]{this.logPrefix, BTMConstants.APM_DISCOVERY_FILEPATH, e});
                if (inifile != null) {
                    inifile.saveFile();
                    EgApmFilesSync.releaseInstance(inifile);
                }
            }
        }
        finally {
            if (inifile != null) {
                inifile.saveFile();
                EgApmFilesSync.releaseInstance(inifile);
            }
        }
    }

    private BufferedReader getDataInputStream() {
        BufferedReader bis = null;
        try {
            bis = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to get  ObjectInputStream ", (Object)this.logPrefix, (Object)e);
        }
        return bis;
    }

    private ObjectOutputStream getDataOutputStream() {
        ObjectOutputStream outputstream = null;
        try {
            outputstream = new ObjectOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputstream;
    }

    private void IsAnyDataAvailableToSend(String nodeID, ObjectOutputStream outputStream, Object obj) {
        if (obj instanceof NodeMethodInfo) {
            NodeMethodInfo info = null;
            ArrayList<HashMap> dataToSend = new ArrayList<HashMap>();
            info = (NodeMethodInfo)obj;
            if (APMNodeComponentIDRepository.isNewThresholdAvailable(nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getNewThreshold(nodeID));
            }
            if (APMNodeComponentIDRepository.isNewThresholdAvailable("K_" + nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getNewThreshold("K_" + nodeID));
            }
            if (APMNodeComponentIDRepository.isNewPropsAvailable(nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getNewProps(nodeID));
            }
            if (APMNodeComponentIDRepository.isNewPropsAvailable("K_" + nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getNewProps("K_" + nodeID));
            }
            if (APMNodeComponentIDRepository.isTestOffloadConfigAvailable(nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getComponentWithTestOffloadConfig(nodeID));
            }
            this.sendData(dataToSend, outputStream, nodeID);
            dataToSend = null;
        } else {
            ArrayList<HashMap> dataToSend = new ArrayList<HashMap>();
            if (APMNodeComponentIDRepository.isTestOffloadConfigAvailable(nodeID)) {
                dataToSend.add(APMNodeComponentIDRepository.getComponentWithTestOffloadConfig(nodeID));
            }
            this.sendData(dataToSend, outputStream, nodeID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(ArrayList dataToSend, ObjectOutputStream outputStream, String nodeID) {
        AgentStartupLogger.logger.trace(String.valueOf(this.logPrefix) + " is ok to sendConfig : " + sendConfig);
        if (dataToSend.size() == 0) {
            this.sendResponseToBTMjar("OK", outputStream, nodeID);
            return;
        }
        if (sendConfig) {
            Boolean bl = this.ackSync;
            synchronized (bl) {
                if (sendConfig) {
                    dataToSend.add("OK");
                    this.sendResponseToBTMjar(dataToSend, outputStream, nodeID);
                    sendConfig = false;
                }
            }
        } else {
            this.sendResponseToBTMjar("OK", outputStream, nodeID);
        }
    }

    private void sendResponseToBTMjar(Object message, ObjectOutputStream outputStream, String nodeID) {
        try {
            if (message == null) {
                return;
            }
            outputStream.writeObject(message);
            outputStream.flush();
            AgentStartupLogger.logger.debug("{} Agent sent message {} to node id=> {}  - {} : {}", new Object[]{this.logPrefix, message.toString(), nodeID, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Exception in sendResponseToClientSocketConnection() while sending response to client socket  : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private boolean validateNodeID(String nodeID, ObjectOutputStream outputStream) {
        if (nodeID.startsWith("DISCOVER_ME")) {
            return true;
        }
        String newName = APMNodeComponentIDRepository.getNewComponentName(nodeID);
        if (newName != null) {
            this.sendResponseToBTMjar("COMPONENT_RENAMED!;-;!" + newName, outputStream, nodeID);
            this.sleep(1000L);
            return true;
        }
        if (!APMNodeComponentIDRepository.isSiteIdAvailable(nodeID)) {
            this.sendResponseToBTMjar("UNMONITORED HOST", outputStream, nodeID);
            AgentStartupLogger.logger.warn("{} NodeID: {} not managed in eG Manager (or) [Key] Java Business Transaction Test(s) is not configured[included] in eG Manager", (Object)this.logPrefix, (Object)nodeID);
            this.sleep(3000L);
            return false;
        }
        if (APMNodeComponentIDRepository.isSiteIdAvailable(nodeID) && !APMNodeComponentIDRepository.isOffloadComponentID(nodeID)) {
            AgentStartupLogger.logger.info("{} Registering new Offload NodeID:{} into Agent offload table", (Object)this.logPrefix, (Object)nodeID);
            APMNodeComponentIDRepository.registerIntoOffloadComponentIDTable(nodeID);
            APMNodeComponentIDRepository.unRegisterFromNonOffloadComponentIDTable(nodeID);
        }
        return true;
    }

    private void handlePingMsgWithNodeID(String lineData, ObjectOutputStream outputStream) {
        String[] data = lineData.split("!;-;!");
        String pingMsg = data[0];
        String offloadNodeID = data[1];
        if (pingMsg.equalsIgnoreCase("OFFLOAD - PING") && this.validateNodeID(offloadNodeID, outputStream)) {
            this.sendResponseToBTMjar("OFFLOAD - PONG!;-;!OK", outputStream, offloadNodeID);
            this.sleep(2000L);
        }
    }

    private void sleep(Long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            AgentStartupLogger.logger.info("unable to put thread to sleep ", (Object)this.logPrefix);
        }
    }

    private void closeServerSocket() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                AgentStartupLogger.logger.debug("{} , {} Connection closed", (Object)this.logPrefix, (Object)this.clientSocketAddress);
                this.clientSocket = null;
            }
        }
        catch (IOException e) {
            AgentStartupLogger.logger.error("{} , {} Unable to close connection", (Object)this.logPrefix, (Object)this.clientSocketAddress);
        }
    }

    public void setRunThis(boolean runThis) {
        this.runThis = runThis;
        if (!this.runThis) {
            AgentStartupLogger.logger.trace("{}  closing {} ", (Object)this.logPrefix, (Object)this.clientSocketAddress);
            this.closeServerSocket();
        }
    }
}

