/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.jtm.BTMConstants;
import java.util.Vector;

public class ApmConfigManager {
    private IniFile apmFileObj;
    private long lastModifiedTime;
    private long lastSize;
    private static final String apmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH;
    private static final String APM = new String("APM");
    private static final String APM_DISCOVERY = "APM_DISCOVERY";
    private static final String loggerPrefix = "[ApmConfigManager] ";
    private static final String CLEANUP_TIME_UNIT = "CLEANUP_TIME_UNIT";
    private static final String APM_DISCOVERY_INI_CLEANUP = "APM_DISCOVERY_INI_CLEANUP";
    private static final String APM_DISCOVERY_AUTO_DELETE = "APM_DISCOVERY_AUTO_DELETE";
    private static final String DELETE_DURATION_FOR_CONTAINER_APPS = "Delete_Duration_For_Container_Apps";
    private static final String DELETE_DURATION_FOR_NONCONTAINER_APPS = "Delete_Duration_For_NonContainer_Apps";
    private static final String NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS = "NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS";
    private static final String NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS = "NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS";
    private static final String SAVE_DELETED_DETAILS_TO_TEMP_FILE = "SAVE_DELETED_DETAILS_TO_TEMP_FILE";
    private static final String CLEANUP_CHECK_INTERVAL = "CLEANUP_CHECK_INTERVAL";
    private static final String CLEANUP_ENABLED = "CLEANUP_ENABLED";
    private long discoveryContributorSleepTime = 15000L;
    private long appflowDataContributorSleepTime = 15000L;
    private boolean isAPMMonitoringEnabled = false;
    private boolean isManageByCustomPort = false;
    private boolean isManageByCustomPortForDocker = false;
    private boolean createBTMJarZipFile = false;
    private boolean isSaveDetailsOnTempFile = false;
    private static final long ONE_MIN = 60000L;
    private static final long FIFTEEN_SECONDS = 15000L;
    private static long managedComponentsReUploadTime = 21600000L;
    private String cleanupSymbol = "s";
    private boolean isUnitHH = false;
    private boolean isIniCleanUpEnabled = false;
    private long cleanUpInterval = 6L;
    private long maxTimeToDeleteContainerApps = 15L;
    private long maxTimeToDeleteNonContainerApps = 1440L;
    private long notManagedContainerDeleteThreshold = 6L;
    private long notManagedNonContainerDeleteThreshold = 24L;
    private static ApmConfigManager instance = null;

    private ApmConfigManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApmConfigManager getInstance() {
        if (instance != null) return instance;
        Class<ApmConfigManager> clazz = ApmConfigManager.class;
        synchronized (ApmConfigManager.class) {
            if (instance != null) return instance;
            instance = new ApmConfigManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.apmFileObj = new IniFile(apmIniFile);
        this.updateConfigs();
        if (ApmDemoInfo.isDemoMode(true)) {
            ApmDemoInfo.initDemoMode();
            this.updateDemoConfigs();
        }
        this.printConfigs();
    }

    private void printConfigs() {
        APMDiscoveryLogger.discoveryLogger.debug(" {} isApmMonitoringEnabled : {}, discoveryContributorSleepTime : {}, appflowDataContributorSleepTime : {}, useCustomPortsToManage : {}, useCustomPortsToManageDockerComponents : {}, createBTMJarZipFile : {}", new Object[]{loggerPrefix, this.isAPMMonitoringEnabled, this.discoveryContributorSleepTime, this.appflowDataContributorSleepTime, this.isManageByCustomPort, this.isManageByCustomPortForDocker, this.createBTMJarZipFile});
        APMDiscoveryLogger.discoveryLogger.debug(" {} isIniCleanUpEnabled : {}, isSaveDetailsOnTempFile : {}, cleanupSymbol : {}, isUnitHH : {} , cleanUpInterval : {}, deleteDurationContainerApps : {}, deleteDurationNonContainerApps : {}, notManagedContainerDeleteThreshold : {}, notManagedNonContainerDeleteThreshold : {} ", new Object[]{loggerPrefix, this.isIniCleanUpEnabled, this.isSaveDetailsOnTempFile, this.cleanupSymbol, this.isUnitHH, this.cleanUpInterval, this.maxTimeToDeleteContainerApps, this.maxTimeToDeleteNonContainerApps, this.notManagedContainerDeleteThreshold, this.notManagedNonContainerDeleteThreshold});
        APMDiscoveryLogger.discoveryLogger.debug(" {} managedComponentsReUploadTime : {}, ", (Object)loggerPrefix, (Object)managedComponentsReUploadTime);
    }

    public void updateDemoConfigs() {
        this.discoveryContributorSleepTime = ApmDemoInfo.getDiscoveryContributorSleepTime();
        this.appflowDataContributorSleepTime = ApmDemoInfo.getAppflowDataContributorSleepTime();
    }

    private void updateConfigs() {
        this.discoveryContributorSleepTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM, "APMDiscoveryContributorSleepTime", 60000L, 15000L, APMDiscoveryLogger.discoveryLogger);
        this.appflowDataContributorSleepTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM, "APMAppflowDataContributorSleepTime", 60000L, 15000L, APMDiscoveryLogger.discoveryLogger);
        this.isAPMMonitoringEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM, "APM_Monitoring");
        this.isManageByCustomPort = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Manage_Components_With_Custom_Ports");
        this.isManageByCustomPortForDocker = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY, "Manage_Components_With_Custom_Ports_In_Docker");
        this.createBTMJarZipFile = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM, "CreateBTMJarZipFileOnAgent");
        managedComponentsReUploadTime = APMUtils.getAndValidateLongValue(this.apmFileObj, APM_DISCOVERY, "Discovery_ReUpload_Time", 60000L, managedComponentsReUploadTime, APMDiscoveryLogger.discoveryLogger);
        String string = this.apmFileObj.getValue(APM_DISCOVERY_AUTO_DELETE, DELETE_DURATION_FOR_CONTAINER_APPS);
        this.assignContainerDeleteDuration(string);
        String string2 = this.apmFileObj.getValue(APM_DISCOVERY_AUTO_DELETE, DELETE_DURATION_FOR_NONCONTAINER_APPS);
        this.assignNonContainerDeleteDuration(string2);
        this.cleanUpInterval = APMUtils.getAndValidateLongValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, CLEANUP_CHECK_INTERVAL, 1L, 6L, APMDiscoveryLogger.discoveryLogger);
        String string3 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, CLEANUP_TIME_UNIT).trim();
        this.assignCleanupDetails(string3);
        String string4 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, NOTMANAGED_DELETE_THRESHOLD_FOR_CONTAINER_SERVERS).trim();
        this.assignNotManagedContainerDeleteThreshold(string4);
        String string5 = this.apmFileObj.getValue(APM_DISCOVERY_INI_CLEANUP, NOTMANAGED_DELETE_THRESHOLD_FOR_NONCONTAINER_SERVERS).trim();
        this.assignNotManagedNonContainerDeleteThreshold(string5);
        this.isSaveDetailsOnTempFile = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, SAVE_DELETED_DETAILS_TO_TEMP_FILE);
        this.isIniCleanUpEnabled = APMUtils.getAndValidateBooleanValue(this.apmFileObj, APM_DISCOVERY_INI_CLEANUP, CLEANUP_ENABLED);
        this.transferApmIniToCleanUpIni();
    }

    private void transferApmIniToCleanUpIni() {
        String string = "Apm_Discovery_Cleanup";
        String string2 = this.getValue("APM_DISCOVERY_CLEANUP", string);
        IniFile iniFile = new IniFile(BTMConstants.EG_APM_DISCOVERY_CLEANUP_INI);
        String string3 = iniFile.getValue("APM_DISCOVERY_CLEANUP", string);
        APMDiscoveryLogger.discoveryLogger.debug(" apmIniLogCleanUpflag : {}", (Object)string2);
        APMDiscoveryLogger.discoveryLogger.debug(" logCleanUpflag : {} ", (Object)string3);
        if (string2.length() > 0 && !string2.equalsIgnoreCase(string3)) {
            JavaTransactionFlowUtility.addToIniFile(BTMConstants.EG_APM_DISCOVERY_CLEANUP_INI, "APM_DISCOVERY_CLEANUP", string, string2);
        }
    }

    private void assignCleanupDetails(String string) {
        this.isUnitHH = false;
        if (string != null && string.length() > 0 && (string.equalsIgnoreCase("HH") || string.equalsIgnoreCase("MM"))) {
            this.cleanupSymbol = "m";
            if (string.equalsIgnoreCase("HH")) {
                this.isUnitHH = true;
            }
        } else {
            this.cleanupSymbol = "s";
        }
    }

    private void assignContainerDeleteDuration(String string) {
        this.maxTimeToDeleteContainerApps = 15L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.maxTimeToDeleteContainerApps = l;
        }
    }

    private void assignNonContainerDeleteDuration(String string) {
        this.maxTimeToDeleteNonContainerApps = 1440L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.maxTimeToDeleteNonContainerApps = l;
        }
    }

    private void assignNotManagedContainerDeleteThreshold(String string) {
        this.notManagedContainerDeleteThreshold = 6L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.notManagedContainerDeleteThreshold = l;
        }
    }

    private void assignNotManagedNonContainerDeleteThreshold(String string) {
        this.notManagedNonContainerDeleteThreshold = 24L;
        long l = this.getResult(string);
        if (l > 0L) {
            this.notManagedNonContainerDeleteThreshold = l;
        }
    }

    private long getResult(String string) {
        long l = -1L;
        if (string != null && string.length() > 0) {
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public long getDiscoveryContributorSleepTime() {
        return this.discoveryContributorSleepTime;
    }

    public long getAppflowDataContributorSleepTime() {
        return this.appflowDataContributorSleepTime;
    }

    public long getDiscoveryDataReUploadTime() {
        return managedComponentsReUploadTime;
    }

    public boolean isAPMMonitoringEnabled() {
        return this.isAPMMonitoringEnabled;
    }

    public boolean isManageByCustomPort() {
        return this.isManageByCustomPort;
    }

    public boolean isSaveDetailsOnTempFile() {
        return this.isSaveDetailsOnTempFile;
    }

    public boolean isCleanUpEnabled() {
        return this.isIniCleanUpEnabled;
    }

    public boolean isManageByCustomPortForDocker() {
        return this.isManageByCustomPortForDocker;
    }

    private long lastModified() {
        return IniFile.getLastModified(apmIniFile);
    }

    private long lastSize() {
        return IniFile.getLastSize(apmIniFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && l2 == this.lastSize) {
            return false;
        }
        String string = APM;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && l2 == this.lastSize) {
                return false;
            }
            this.init();
            return true;
        }
    }

    private void setValue(String string, String string2, String string3) {
        this.apmFileObj.setValue(string, string2, string3);
    }

    private String getValue(String string, String string2) {
        return this.apmFileObj.getValue(string, string2);
    }

    private String[] getVariables(String string) {
        return this.apmFileObj.getVariables(string);
    }

    private Vector getValues(String string) {
        return this.apmFileObj.getAllValues(string);
    }

    private String[] getLinesUnderSubject(String string) {
        return this.apmFileObj.getLinesUnderSubject(string);
    }

    public String getCleanupSymbol() {
        return this.cleanupSymbol;
    }

    public boolean isUnitHH() {
        return this.isUnitHH;
    }

    public long getDeleteDurationContainerApps() {
        return this.maxTimeToDeleteContainerApps;
    }

    public long getDeleteDurationNonContainerApps() {
        return this.maxTimeToDeleteNonContainerApps;
    }

    public long getUnManagedDeleteThresholdContainerApps() {
        return this.notManagedContainerDeleteThreshold;
    }

    public long getUnManagedDeleteThresholdNonContainerApps() {
        return this.notManagedNonContainerDeleteThreshold;
    }

    public boolean createBTMJarZipFile() {
        return this.createBTMJarZipFile;
    }

    public long getCleanUpInterval() {
        return this.cleanUpInterval;
    }
}

