/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.EgSpecsInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgServerGroupBean {
    private File infogroupFile;
    private String infogroupFileName;
    private IniFile infogroupFilePtr;
    public long lastModifiedTime;
    public long lastSize;
    public long newTime;
    public long length;
    EgSpecsInfo specs = null;
    public static String subject1 = "THRESH_POLICY_MAPPING";
    public static String subject2 = "THRESHOLDPOLICIES";
    public ConcurrentHashMap policyValueCache = new ConcurrentHashMap();
    public ConcurrentHashMap policyTestCache = new ConcurrentHashMap();
    public ConcurrentHashMap serverGroupCache = new ConcurrentHashMap();
    public ConcurrentHashMap thresh_policy_mapping = new ConcurrentHashMap();
    public ConcurrentHashMap serverGroupMap = new ConcurrentHashMap();
    public ConcurrentHashMap varvalmap = new ConcurrentHashMap();
    public String[] allsubjects = null;

    private Vector removeDuplicates(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return vector;
        }
        HashSet hashSet = new HashSet(vector);
        vector.clear();
        vector.addAll(hashSet);
        return vector;
    }

    private void loadCache() {
        Object object;
        int n;
        String[] stringArray;
        this.thresh_policy_mapping.clear();
        String[] stringArray2 = this.infogroupFilePtr.getVariables(subject1);
        Vector vector = this.infogroupFilePtr.getAllValues(subject1);
        for (int i = 0; i < stringArray2.length; ++i) {
            this.thresh_policy_mapping.put(stringArray2[i], (String)vector.get(i));
        }
        this.serverGroupMap.clear();
        Enumeration enumeration = this.varvalmap.keys();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            arrayList.add(stringArray);
        }
        stringArray = this.infogroupFilePtr.getSubjects();
        this.allsubjects = stringArray;
        for (n = 0; n < stringArray.length; ++n) {
            object = this.infogroupFilePtr.getVariables(stringArray[n]);
            Vector vector2 = this.infogroupFilePtr.getAllValues(stringArray[n]);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(object);
            arrayList2.add(vector2);
            this.varvalmap.put(stringArray[n], arrayList2);
            arrayList.remove(stringArray[n]);
            if (stringArray[n].equals(subject1) || stringArray[n].equals(subject2)) continue;
            for (int i = 0; i < ((String[])object).length; ++i) {
                String string = (String)vector2.get(i);
                Vector<String> vector3 = (Vector<String>)this.serverGroupMap.get(string);
                if (vector3 == null) {
                    vector3 = new Vector<String>();
                }
                if (!vector3.contains(stringArray[n])) {
                    vector3.add(stringArray[n]);
                }
                this.serverGroupMap.put(string, vector3);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (String)arrayList.get(n);
            this.varvalmap.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgServerGroupBean(String string) {
        String string2 = subject1;
        synchronized (string2) {
            if (string.equals("agent")) {
                this.infogroupFileName = new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egInfoGroupFile);
                this.infogroupFile = new File(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egInfoGroupFile);
            } else {
                this.infogroupFileName = new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egInfoGroupFile);
                this.infogroupFile = new File(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egInfoGroupFile);
                this.specs = new EgSpecsInfo("manager");
            }
            this.infogroupFilePtr = new IniFile(this.infogroupFileName, true);
            this.lastModifiedTime = IniFile.getLastModified(this.infogroupFileName);
            this.lastSize = IniFile.getLastSize(this.infogroupFileName);
            this.policyValueCache = new ConcurrentHashMap();
            this.policyTestCache = new ConcurrentHashMap();
            this.serverGroupCache = new ConcurrentHashMap();
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgServerGroupBean() {
        String string = subject1;
        synchronized (string) {
            this.infogroupFileName = new String(EgInstallInfo.getInstallDir() + "/manager/config/eg_infogroup.ini");
            this.infogroupFilePtr = new IniFile(this.infogroupFileName, true);
            this.infogroupFile = new File(EgInstallInfo.getInstallDir() + "/manager/config/eg_infogroup.ini");
            this.lastModifiedTime = IniFile.getLastModified(this.infogroupFileName);
            this.lastSize = IniFile.getLastSize(this.infogroupFileName);
            this.specs = new EgSpecsInfo("manager");
            this.policyValueCache = new ConcurrentHashMap();
            this.policyTestCache = new ConcurrentHashMap();
            this.serverGroupCache = new ConcurrentHashMap();
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = IniFile.getLastModified(this.infogroupFileName);
        long l2 = IniFile.getLastSize(this.infogroupFileName);
        if (l == this.lastModifiedTime && this.lastSize == l2) {
            return false;
        }
        String string = subject1;
        synchronized (string) {
            this.newTime = IniFile.getLastModified(this.infogroupFileName);
            this.length = IniFile.getLastSize(this.infogroupFileName);
            if (this.newTime == this.lastModifiedTime && this.lastSize == this.length) {
                return false;
            }
            this.lastModifiedTime = this.newTime;
            this.lastSize = this.length;
            this.infogroupFilePtr = new IniFile(this.infogroupFileName, true);
            this.policyValueCache.clear();
            this.policyTestCache.clear();
            this.serverGroupCache.clear();
            this.loadCache();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String string = subject1;
        synchronized (string) {
            if (this.infogroupFile == null) {
                this.infogroupFile = new File(this.infogroupFileName);
            }
            this.newTime = IniFile.getLastModified(this.infogroupFileName);
            this.length = IniFile.getLastSize(this.infogroupFileName);
            this.lastModifiedTime = this.newTime;
            this.lastSize = this.length;
            this.infogroupFilePtr = new IniFile(this.infogroupFileName, true);
            this.policyValueCache.clear();
            this.policyTestCache.clear();
            this.serverGroupCache.clear();
            this.loadCache();
        }
    }

    public String getValue(String string, String string2) {
        this.checkForUpdate();
        Object var3_3 = null;
        ArrayList arrayList = (ArrayList)this.varvalmap.get(string);
        if (arrayList == null) {
            return "";
        }
        String[] stringArray = (String[])arrayList.get(0);
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        Vector vector = (Vector)arrayList.get(1);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            String string3 = (String)vector.get(i);
            return string3;
        }
        return "";
    }

    public Vector getAllValues(String string) {
        this.checkForUpdate();
        ArrayList arrayList = (ArrayList)this.varvalmap.get(string);
        if (arrayList == null) {
            return new Vector();
        }
        Vector vector = (Vector)arrayList.get(1);
        return vector;
    }

    public ArrayList getAllValues(String[] stringArray) {
        this.checkForUpdate();
        ArrayList arrayList = new ArrayList();
        Vector vector = null;
        for (int i = 0; i < stringArray.length; ++i) {
            vector = this.getAllValues(stringArray[i]);
            if (vector == null) {
                vector = new Vector();
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    public ArrayList getAllValues(ArrayList arrayList) {
        this.checkForUpdate();
        ArrayList arrayList2 = new ArrayList();
        Vector vector = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            vector = this.getAllValues((String)arrayList.get(i));
            if (vector == null) {
                vector = new Vector();
            }
            arrayList2.add(vector);
        }
        return arrayList2;
    }

    public ArrayList getAllValues(Vector vector) {
        this.checkForUpdate();
        ArrayList arrayList = new ArrayList();
        Vector vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            vector2 = this.getAllValues((String)vector.get(i));
            if (vector2 == null) {
                vector2 = new Vector();
            }
            arrayList.add(vector2);
        }
        return arrayList;
    }

    public ArrayList getAllValues(Vector vector, IniFile iniFile) {
        ArrayList arrayList = new ArrayList();
        Vector vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            vector2 = iniFile.getAllValues((String)vector.get(i));
            if (vector2 == null) {
                vector2 = new Vector();
            }
            arrayList.add(vector2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setValue(String string, String string2, String string3) {
        this.checkForUpdate();
        boolean bl = false;
        String string4 = subject1;
        synchronized (string4) {
            bl = this.infogroupFilePtr.setValue(string, string2, string3);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServerGroups() {
        this.checkForUpdate();
        Object var1_1 = null;
        String string = subject1;
        synchronized (string) {
            return this.allsubjects;
        }
    }

    public ArrayList getServerGroups(boolean bl) {
        String[] stringArray = this.getServerGroups();
        if (stringArray != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(subject1) || stringArray[i].equals(subject2)) continue;
                arrayList.add(stringArray[i]);
            }
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteValue(String string, String string2) {
        this.checkForUpdate();
        String string3 = subject1;
        synchronized (string3) {
            this.infogroupFilePtr.deleteValue(string, string2);
        }
    }

    public ArrayList getAllVariables(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new ArrayList();
        }
        this.checkForUpdate();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            ArrayList arrayList2 = (ArrayList)this.varvalmap.get(stringArray[i]);
            if (arrayList2 == null || (stringArray2 = (String[])arrayList2.get(0)) == null) continue;
            arrayList.add(stringArray2);
        }
        return arrayList;
    }

    public ArrayList getAllVariables(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return new ArrayList();
        }
        this.checkForUpdate();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray;
            ArrayList arrayList3 = (ArrayList)this.varvalmap.get((String)arrayList.get(i));
            if (arrayList3 == null || (stringArray = (String[])arrayList3.get(0)) == null) continue;
            arrayList2.add(stringArray);
        }
        return arrayList2;
    }

    public ArrayList getAllVariables(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return new ArrayList();
        }
        this.checkForUpdate();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray;
            ArrayList arrayList2 = (ArrayList)this.varvalmap.get((String)vector.get(i));
            if (arrayList2 == null || (stringArray = (String[])arrayList2.get(0)) == null) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public ArrayList getAllVariables(Vector vector, IniFile iniFile) {
        if (vector == null || vector.size() == 0) {
            return new ArrayList();
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = null;
        for (int i = 0; i < vector.size(); ++i) {
            stringArray = iniFile.getVariables((String)vector.get(i));
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public String[] getVariables(String string, boolean bl) {
        ArrayList arrayList;
        if (bl) {
            this.checkForUpdate();
        }
        if ((arrayList = (ArrayList)this.varvalmap.get(string)) == null) {
            return new String[0];
        }
        String[] stringArray = (String[])arrayList.get(0);
        return stringArray;
    }

    public String[] getVariables(String string) {
        return this.getVariables(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile() {
        String string = subject1;
        synchronized (string) {
            this.infogroupFilePtr.saveFile();
        }
        this.init();
    }

    public void setValueForGroupSection(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            string4 = string + "#" + string5;
            this.setValue(string3, string4, string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteGroupSection(String string) {
        String string2 = subject1;
        synchronized (string2) {
            this.infogroupFilePtr.deleteSubject(string);
        }
    }

    public Vector getComponentNames(String string) {
        Vector vector = null;
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            vector = this.getAllValues(string);
        }
        return vector;
    }

    public Vector getComponentNamesWithType(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    public String getServerType(String string) {
        String string2;
        block0: {
            int n;
            String[] stringArray = this.getVariables(string);
            string2 = "";
            if (stringArray == null || stringArray.length <= 0 || (n = 0) >= stringArray.length) break block0;
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "#");
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public TreeSet getAllComponents() {
        String[] stringArray = this.getServerGroups();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null && stringArray.length > 0) {
            ArrayList arrayList = this.getAllVariables(stringArray);
            ArrayList arrayList2 = this.getAllValues(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = (String[])arrayList.get(i);
                Vector vector = (Vector)arrayList2.get(i);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string = (String)vector.get(j);
                    treeSet.add(string);
                }
            }
        }
        return treeSet;
    }

    public TreeSet getAllComponentsWithType() {
        String[] stringArray = this.getServerGroups();
        TreeSet<String> treeSet = new TreeSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        if (arrayList.contains("THRESHOLDPOLICIES")) {
            arrayList.remove("THRESHOLDPOLICIES");
        }
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList arrayList2 = this.getAllVariables(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                String[] stringArray2 = (String[])arrayList2.get(i);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    treeSet.add(stringArray2[j]);
                }
            }
        }
        return treeSet;
    }

    public TreeSet getManagedCompOfSType(String string) {
        String[] stringArray = this.getServerGroups();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            ArrayList arrayList = this.getAllVariables(stringArray);
            ArrayList arrayList2 = this.getAllValues(stringArray);
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = (String[])arrayList.get(i);
                Vector vector = (Vector)arrayList2.get(i);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].startsWith(string)) continue;
                    treeSet.add((String)vector.get(j));
                }
            }
        }
        return treeSet;
    }

    public TreeSet getManagedCompWithTypeOfSType(String string) {
        String[] stringArray = this.getServerGroups();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        if (arrayList.contains("THRESHOLDPOLICIES")) {
            arrayList.remove("THRESHOLDPOLICIES");
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            ArrayList arrayList2 = this.getAllVariables(arrayList);
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = (String[])arrayList2.get(i);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray2[j].startsWith(string)) continue;
                    treeSet.add(stringArray2[j]);
                }
            }
        }
        return treeSet;
    }

    public synchronized void setThresholdPolicy(String string, String string2, String string3, String string4) {
        String string5 = string + ':' + string2;
        this.setValue(string4, string5, string3);
    }

    public Vector getAllPolicyName(String string) {
        String[] stringArray = this.getVariables(string);
        Vector<String> vector = new Vector<String>();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                stringTokenizer.nextToken();
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public synchronized void deletePolicyName(String string, String string2) {
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string2)) continue;
                this.deleteValue(string, stringArray[i]);
                break;
            }
        }
    }

    public String getPolicyNameToDelete(String string, String string2) {
        String string3 = "";
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!string4.equals(string2)) continue;
                string3 = stringArray[i];
                break;
            }
        }
        return string3;
    }

    public String getTestNameForPolicy(String string) {
        String[] stringArray = this.getVariables(subject2);
        String string2 = "";
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(string)) break;
            }
        }
        return string2;
    }

    public String getPolicyValue(String string) {
        String string2 = (String)this.policyValueCache.get(string);
        if (string2 != null) {
            return string2;
        }
        String[] stringArray = this.getVariables(subject2);
        Vector vector = this.getAllValues(subject2);
        String string3 = "";
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (!string4.equals(string)) continue;
                string3 = (String)vector.get(i);
                break;
            }
        }
        this.policyValueCache.put(string, string3);
        return string3;
    }

    public synchronized void setPolicyToServerGroup(String string, String string2, String string3, String string4) {
        String string5 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken() + "#" + string2;
            this.setValue(string, string5, string3);
        }
    }

    public synchronized void setPolicyToServerGroup1(String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                string6 = string7 + "#" + string2 + "#" + stringTokenizer2.nextToken();
                this.setValue(string, string6, string3);
            }
        }
    }

    public synchronized void deletePolicy(String string, String string2) {
        String[] stringArray = this.getVariables(string);
        Vector vector = this.getAllValues(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.get(i);
                if (!string3.equals(string2)) continue;
                this.deleteValue(string, stringArray[i]);
            }
        }
    }

    public synchronized void deleteServerGroup(String string, String string2) {
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "#");
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string2)) continue;
                this.deleteValue(string, stringArray[i]);
            }
        }
    }

    public synchronized void deleteMappingEntryForPolicy(String string, String string2, String string3) {
        Vector vector = this.getVariablesForPolicyName(string, string2);
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string4 = (String)vector.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "#");
                if (string3.equalsIgnoreCase("All")) {
                    boolean bl2 = bl = stringTokenizer.countTokens() == 2;
                }
                if (string3.equalsIgnoreCase("Specific")) {
                    boolean bl3 = bl = stringTokenizer.countTokens() == 3;
                }
                if (!bl) continue;
                this.deleteValue(string, string4);
            }
        }
    }

    public String getMappingEntryForPolicyToDelete(String string, String string2, String string3) {
        String string4 = "";
        Vector vector = this.getVariablesForPolicyName(string, string2);
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string5 = (String)vector.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string5, "#");
                if (string3.equalsIgnoreCase("All")) {
                    boolean bl2 = bl = stringTokenizer.countTokens() == 2;
                }
                if (string3.equalsIgnoreCase("Specific")) {
                    boolean bl3 = bl = stringTokenizer.countTokens() == 3;
                }
                if (!bl) continue;
                string4 = string5;
            }
        }
        return string4;
    }

    public ArrayList getMappingAllEntryForPolicyToDelete(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = this.getVariablesForPolicyName(string, string2);
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string4 = (String)vector.get(i);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "#");
                if (string3.equalsIgnoreCase("All")) {
                    boolean bl2 = bl = stringTokenizer.countTokens() == 2;
                }
                if (string3.equalsIgnoreCase("Specific")) {
                    boolean bl3 = bl = stringTokenizer.countTokens() == 3;
                }
                if (!bl) continue;
                arrayList.add(string4);
            }
        }
        if (arrayList != null) {
            return arrayList;
        }
        return null;
    }

    public Vector getVariablesForPolicyName(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getVariables(string);
        Vector vector2 = this.getAllValues(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector2.get(i);
                if (!string3.equals(string2)) continue;
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    public Vector getAllPolicy(String string) {
        String[] stringArray = this.getVariables(string);
        Vector vector = this.getAllValues(string);
        Vector vector2 = new Vector();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.get(i);
                vector2.add(string2);
            }
        }
        vector2 = this.removeDuplicates(vector2);
        return vector2;
    }

    public Vector getServerGroupForPolicy(String string) {
        Vector vector = new Vector();
        String[] stringArray = this.getVariables(subject1);
        Vector vector2 = this.getAllValues(subject1);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector2.get(i);
                if (!string.equals(string2)) continue;
                String string3 = stringArray[i].substring(0, stringArray[i].indexOf("#"));
                vector.add(string3);
            }
        }
        vector = this.removeDuplicates(vector);
        return vector;
    }

    public TreeSet getManagedServerGroups(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf("#"));
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    public TreeSet getManagedInfosForPolicy(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(subject1);
        Vector vector = this.getAllValues(subject1);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer;
                String string2 = (String)vector.get(i);
                if (!string2.equals(string) || (stringTokenizer = new StringTokenizer(stringArray[i], "#")).countTokens() <= 2) continue;
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                treeSet.add(stringTokenizer.nextToken());
            }
        }
        return treeSet;
    }

    public TreeSet getManagedInfosForPolicy(String string, ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0 || string == null || string.equals("")) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(subject1);
        Vector vector = this.getAllValues(subject1);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                StringTokenizer stringTokenizer;
                String string3 = (String)vector.get(i);
                if (!string3.equals(string) || (stringTokenizer = new StringTokenizer(stringArray[i], "#")).countTokens() <= 2 || arrayList.indexOf(string2 = stringTokenizer.nextToken()) <= -1) continue;
                stringTokenizer.nextToken();
                treeSet.add(stringTokenizer.nextToken());
            }
        }
        return treeSet;
    }

    public String getPolicyForTest(String string, String string2) {
        String string3 = string + '#' + string2;
        String string4 = "";
        String string5 = (String)this.thresh_policy_mapping.get(string3);
        if (string5 == null || string5.length() == 0) {
            for (String string6 : this.thresh_policy_mapping.keySet()) {
                if (!string6.equals(string3)) continue;
                string4 = (String)this.thresh_policy_mapping.get(string6);
                break;
            }
        } else {
            string4 = string5;
        }
        return string4;
    }

    public String getPolicyForTest(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        string5 = string3 != null && !string3.equals("") ? string + '#' + string2 + '#' + string3 : string + '#' + string2;
        String string6 = (String)this.thresh_policy_mapping.get(string5);
        if (string6 != null) {
            string4 = string6;
        }
        return string4;
    }

    public Vector getAllPolicies() {
        String[] stringArray = this.getVariables(subject2);
        Vector<String> vector = new Vector<String>();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                stringTokenizer.nextToken();
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public Vector getAllServerGroups() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getServerGroups();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(subject2) || stringArray[i].equals(subject1)) continue;
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    public Vector getAllServerGroups(IniFile iniFile) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = iniFile.getSubjects();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(subject2) || stringArray[i].equals(subject1)) continue;
                vector.add(stringArray[i]);
            }
        }
        return vector;
    }

    public Vector getAllManagedComponents() {
        Vector vector = this.getAllServerGroups();
        Vector<String> vector2 = new Vector<String>();
        if (vector != null && vector.size() > 0) {
            ArrayList arrayList = this.getAllVariables(vector);
            ArrayList arrayList2 = this.getAllValues(vector);
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                String[] stringArray = (String[])arrayList.get(i);
                Vector vector3 = (Vector)arrayList2.get(i);
                if (stringArray == null || stringArray.length <= 0) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    vector2.add((String)vector3.get(j));
                }
            }
        }
        return vector2;
    }

    public Vector getServerGroup(String string) {
        return this.getServerGroup(string, true);
    }

    public Vector getServerGroup(String string, boolean bl) {
        Vector vector = null;
        if (bl) {
            vector = (Vector)this.serverGroupCache.get(string);
        }
        if (vector != null) {
            return vector;
        }
        String string2 = "";
        boolean bl2 = false;
        if (string.indexOf(58) > 0) {
            bl2 = true;
            string2 = string;
        } else {
            string2 = string + ':';
        }
        if (bl2) {
            Vector vector2 = (Vector)this.serverGroupMap.get(string);
            if (vector2 == null) {
                vector2 = new Vector();
            }
            if (bl && vector2.size() > 0) {
                this.serverGroupCache.put(string, vector2);
            }
            return vector2;
        }
        Vector vector3 = new Vector();
        Enumeration enumeration = this.serverGroupMap.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector4;
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2) || (vector4 = (Vector)this.serverGroupMap.get(string3)) == null || vector4.size() <= 0) continue;
            int n = vector4.size();
            for (int i = 0; i < n; ++i) {
                String string4 = (String)vector4.get(i);
                vector3.add(string4);
            }
        }
        vector3 = this.removeDuplicates(vector3);
        if (bl && vector3.size() > 0) {
            this.serverGroupCache.put(string, vector3);
        }
        return vector3;
    }

    public Vector getServerGroup(String string, String string2, boolean bl) {
        return this.getServerGroup(string, string2, bl, true);
    }

    public Vector getServerGroup(String string, String string2, boolean bl, boolean bl2) {
        Vector vector = this.getServerGroup(string, string2, bl, "", bl2);
        return vector;
    }

    public Vector getServerGroup(String string, String string2, boolean bl, String string3) {
        return this.getServerGroup(string, string2, bl, string3, true);
    }

    public Vector getServerGroup(String string, String string2, boolean bl, String string3, boolean bl2) {
        if (bl) {
            Vector vector = this.getServerGroup(string);
            if (vector == null || vector.size() == 0) {
                return vector;
            }
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = (String)vector.get(i);
                String string5 = this.getPolicyForTest(string4, string2, string3);
                if (string5 == null || string5.length() <= 0) continue;
                vector2.add(string4);
            }
            vector2 = this.removeDuplicates(vector2);
            return vector2;
        }
        String string6 = string + '#' + string2;
        Vector vector = null;
        if (bl2 && (vector = (Vector)this.serverGroupCache.get(string6)) != null) {
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        int n = string.indexOf(58);
        String string7 = "";
        string7 = n > -1 ? string.substring(0, n + 1) : string + ":";
        ArrayList arrayList = this.getServerGroups(true);
        String string8 = "";
        boolean bl3 = false;
        int n2 = arrayList.size();
        String[] stringArray = this.getVariables(subject1);
        String string9 = "#" + string7;
        Vector vector3 = new Vector();
        ArrayList arrayList2 = this.getAllVariables(arrayList);
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = (String[])arrayList2.get(i);
            int n3 = stringArray2.length;
            String string10 = (String)arrayList.get(i) + '#' + string2;
            for (int j = 0; j < n3; ++j) {
                String string11 = stringArray2[j];
                if (!string9.equals(string11 = string11.substring(string11.indexOf("#"), string11.indexOf(":") + 1)) || stringArray == null) continue;
                for (int k = 0; k < stringArray.length; ++k) {
                    if (stringArray[k].indexOf(string10) <= -1) continue;
                    String string12 = (String)arrayList.get(i);
                    vector3.add(string12);
                }
            }
        }
        vector3 = this.removeDuplicates(vector3);
        if (bl2 && vector3.size() > 0) {
            this.serverGroupCache.put(string6, vector3);
        }
        return vector3;
    }

    public Vector getServerGroup(String string, String string2, String string3, boolean bl) {
        return this.getServerGroup(string, string2, string3, bl, true);
    }

    public Vector getServerGroup(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (bl) {
            Vector vector = this.getServerGroup(string);
            if (vector == null || vector.size() == 0) {
                return vector;
            }
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = (String)vector.get(i);
                String string5 = this.getPolicyForTest(string4, string2, string3);
                if (string5 == null || string5.length() <= 0) continue;
                vector2.add(string4);
            }
            vector2 = this.removeDuplicates(vector2);
            return vector2;
        }
        String string6 = string + '#' + string2 + '#' + string3;
        Vector vector = null;
        if (bl2 && (vector = (Vector)this.serverGroupCache.get(string6)) != null) {
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        int n = string.indexOf(58);
        String string7 = "";
        string7 = n > -1 ? string.substring(0, n + 1) : string;
        ArrayList arrayList = this.getServerGroups(true);
        String string8 = "";
        boolean bl3 = false;
        int n2 = arrayList.size();
        String[] stringArray = this.getVariables(subject1);
        String string9 = '#' + string7;
        Vector vector3 = new Vector();
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = this.getVariables((String)arrayList.get(i));
            int n3 = stringArray2.length;
            String string10 = (String)arrayList.get(i) + '#' + string2 + '#' + string3;
            for (int j = 0; j < n3; ++j) {
                if (stringArray2[j].indexOf(string9) < 0 || stringArray == null) continue;
                for (int k = 0; k < stringArray.length; ++k) {
                    if (!stringArray[k].equals(string10)) continue;
                    String string11 = (String)arrayList.get(i);
                    vector3.add(string11);
                }
            }
        }
        vector3 = this.removeDuplicates(vector3);
        if (bl2 && vector3.size() > 0) {
            this.serverGroupCache.put(string6, vector3);
        }
        return vector3;
    }

    public TreeSet getTestColnComponentsForServerType() {
        String[] stringArray = this.getVariables(subject1);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        TreeSet<String> treeSet = new TreeSet<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "#");
                string = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                boolean bl = this.specs.isPortRelevantForTest(string2);
                String[] stringArray2 = this.getVariables(string);
                Vector vector = this.getAllValues(string);
                if (stringArray2 == null || stringArray2.length <= 0) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    string4 = (String)vector.get(j);
                    if (!bl) {
                        string5 = string4.substring(0, string4.indexOf(58));
                        string4 = string5 + ":NULL";
                    }
                    string3 = string2 + ':' + string4;
                    treeSet.add(string3);
                }
            }
        }
        return treeSet;
    }

    public void deleteUnmanagedComponent(String string) {
        this.deleteUnmanagedComponentFromInfoGroup(string);
    }

    public void deleteUnmanagedComponentFromInfoGroup(String string) {
        String string2 = "";
        string2 = string.indexOf(58) > 0 ? string : string + ":";
        boolean bl = false;
        IniFile iniFile = EgConfigFilesSync.getInstance(this.infogroupFileName);
        Vector vector = this.getAllServerGroups(iniFile);
        int n = vector.size();
        if (vector != null && !vector.isEmpty()) {
            ArrayList arrayList = this.getAllVariables(vector, iniFile);
            ArrayList arrayList2 = this.getAllValues(vector, iniFile);
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector.get(i);
                String[] stringArray = (String[])arrayList.get(i);
                Vector vector2 = (Vector)arrayList2.get(i);
                if (stringArray != null && stringArray.length > 0) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        String[] stringArray2;
                        String string4 = (String)vector2.get(j);
                        if (!string4.startsWith(string2)) continue;
                        iniFile.deleteValue(string3, stringArray[j]);
                        Vector vector3 = this.getAllServerGroups(iniFile);
                        if (!vector3.contains(string3) && (stringArray2 = iniFile.getVariables(subject1)) != null && stringArray2.length > 0) {
                            int n2 = stringArray2.length;
                            for (int k = 0; k < n2; ++k) {
                                StringTokenizer stringTokenizer = new StringTokenizer(stringArray2[k], "#");
                                String string5 = stringTokenizer.nextToken();
                                if (!string5.equals(string3)) continue;
                                iniFile.deleteValue(subject1, stringArray2[k]);
                            }
                        }
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
            }
        }
        iniFile.saveFile();
        EgConfigFilesSync.releaseInstance(iniFile);
        this.checkForUpdate();
    }

    public boolean isServerGroupAndPolicyMapped(String string) {
        boolean bl = false;
        TreeSet treeSet = this.getManagedServerGroups(subject1);
        Vector vector = this.getAllPolicy(subject1);
        if (treeSet.contains(string) || vector.contains(string)) {
            bl = true;
        }
        return bl;
    }

    public TreeSet getAllManagedInfosForTest(String string) {
        String string2 = "";
        String string3 = "";
        TreeSet<String> treeSet = new TreeSet<String>();
        String[] stringArray = this.getVariables(subject1);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "#");
                int n = stringTokenizer.countTokens();
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(string) || n != 3) continue;
                string3 = stringTokenizer.nextToken();
                treeSet.add(string3);
            }
        }
        return treeSet;
    }

    public String getThresholdsFromInfoGroupIni(String string, boolean bl) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = new String();
        if (string.indexOf("#") > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            string5 = stringTokenizer.nextToken();
            int n = string5.indexOf(":");
            string2 = string5.substring(0, n);
            string3 = string5.substring(n + 1);
            string4 = stringTokenizer.nextToken();
        } else {
            int n = string.indexOf(":");
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        boolean bl2 = this.specs.isPortRelevantForTest(string2);
        Vector vector = null;
        vector = string4 != null && string4.length() > 0 ? this.getServerGroup(string3, string2, string4, bl2) : this.getServerGroup(string3, string2, bl2);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        string9 = (String)vector.get(0);
        String string11 = this.getValue(subject1, string9 + "#" + string2);
        if (string4 != null && string4.length() > 0 && ((string11 = this.getValue(subject1, string9 + "#" + string2 + "#" + string4)) == null || string11.trim().length() == 0)) {
            string11 = this.getValue(subject1, string9 + "#" + string2);
        }
        string10 = this.getPolicyValue(string11);
        return string10;
    }

    public Vector getPolicyNamesForTest(String string) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getVariables(subject2);
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], ":");
                String string2 = stringTokenizer.nextToken();
                if (!string2.equalsIgnoreCase(string)) continue;
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public boolean isServerAssociatedToTest(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = this.specs.isPortRelevantForTest(string2);
        Vector vector2 = this.getServerGroup(string, string2, bl2);
        Vector vector3 = this.getPolicyNamesForTest(string2);
        if (vector2 == null || vector2.size() == 0) {
            return bl;
        }
        if (vector3 == null || vector3.size() == 0) {
            return bl;
        }
        for (int i = 0; i < vector3.size(); ++i) {
            String string3 = (String)vector3.get(i);
            Vector vector4 = this.getServerGroupForPolicy(string3);
            if (vector4 == null || vector4.size() <= 0) continue;
            for (int j = 0; j < vector4.size(); ++j) {
                String string4 = (String)vector4.get(j);
                vector.add(string4);
            }
        }
        if (vector != null && vector.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public TreeSet getManagedInfos(String string, String string2) {
        String[] stringArray = this.getVariables(subject1);
        Vector vector = this.getAllValues(subject1);
        TreeSet<String> treeSet = new TreeSet<String>();
        String string3 = string + "#" + string2;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(string3) <= -1) continue;
                treeSet.add((String)vector.get(i));
            }
            return treeSet;
        }
        return treeSet;
    }

    public static void main(String[] stringArray) {
    }

    public Vector getServerGroupUI(String string, String string2, boolean bl) {
        if (bl) {
            Vector vector = this.getServerGroup(string);
            if (vector == null || vector.size() == 0) {
                return vector;
            }
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.get(i);
                String string4 = this.getPolicyForUI(string3, string2);
                if (string4 == null || string4.length() <= 0) continue;
                vector2.add(string3);
            }
            vector2 = this.removeDuplicates(vector2);
            return vector2;
        }
        String string5 = string + '#' + string2;
        Vector vector = null;
        vector = (Vector)this.serverGroupCache.get(string5);
        if (vector != null) {
            if (vector.size() == 0) {
                return null;
            }
            return vector;
        }
        int n = string.indexOf(58);
        String string6 = "";
        string6 = n > -1 ? string.substring(0, n + 1) : string;
        ArrayList arrayList = this.getServerGroups(true);
        String string7 = "";
        boolean bl2 = false;
        int n2 = arrayList.size();
        String[] stringArray = this.getVariables(subject1);
        String string8 = '#' + string6;
        Vector vector3 = new Vector();
        ArrayList arrayList2 = this.getAllVariables(arrayList);
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = (String[])arrayList2.get(i);
            int n3 = stringArray2.length;
            String string9 = (String)arrayList.get(i) + '#' + string2;
            for (int j = 0; j < n3; ++j) {
                if (stringArray2[j].indexOf(string8) <= -1 || stringArray == null) continue;
                for (int k = 0; k < stringArray.length; ++k) {
                    if (stringArray[k].indexOf(string9) <= -1) continue;
                    String string10 = (String)arrayList.get(i);
                    vector3.add(string10);
                }
            }
        }
        if ((vector3 = this.removeDuplicates(vector3)).size() > 0) {
            this.serverGroupCache.put(string5, vector3);
        }
        return vector3;
    }

    public String getPolicyForUI(String string, String string2) {
        String string3 = string + '#' + string2;
        String string4 = "";
        String string5 = (String)this.thresh_policy_mapping.get(string3);
        if (string5 == null || string5.length() == 0) {
            for (String string6 : this.thresh_policy_mapping.keySet()) {
                if (!string6.startsWith(string3)) continue;
                string4 = (String)this.thresh_policy_mapping.get(string6);
                break;
            }
        } else {
            string4 = string5;
        }
        return string4;
    }

    public boolean isServerAssociatedToTestUI(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = this.specs.isPortRelevantForTest(string2);
        Vector vector2 = this.getServerGroupUI(string, string2, bl2);
        Vector vector3 = this.getPolicyNamesForTest(string2);
        if (vector2 == null || vector2.size() == 0) {
            return bl;
        }
        if (vector3 == null || vector3.size() == 0) {
            return bl;
        }
        for (int i = 0; i < vector3.size(); ++i) {
            String string3 = (String)vector3.get(i);
            Vector vector4 = this.getServerGroupForPolicy(string3);
            if (vector4 == null || vector4.size() <= 0) continue;
            for (int j = 0; j < vector4.size(); ++j) {
                String string4 = (String)vector4.get(j);
                vector.add(string4);
            }
        }
        if (vector != null && vector.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isAlarmPolicyAssociatedWithRules(String string) {
        this.checkForUpdate();
        Vector vector = null;
        vector = this.getAllValues(subject2);
        if (vector == null || vector.size() == 0) {
            return false;
        }
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = (String)vector.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                stringTokenizer2.nextToken();
                string2 = stringTokenizer2.nextToken();
                if (string2 == null || !string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    public TreeMap getThresholdRuleUsingAlarmPolicy(String string) {
        this.checkForUpdate();
        TreeMap<String, TreeMap> treeMap = new TreeMap<String, TreeMap>();
        String[] stringArray = null;
        Vector vector = null;
        stringArray = this.getVariables(subject2);
        vector = this.getAllValues(subject2);
        if (stringArray == null || stringArray.length == 0) {
            return treeMap;
        }
        if (vector == null || vector.size() == 0) {
            return treeMap;
        }
        String string2 = "";
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            TreeMap treeMap2;
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = stringArray[i];
            String string5 = (String)vector.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = new StringTokenizer(stringTokenizer.nextToken(), ":");
                string2 = ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                ((StringTokenizer)object).nextToken();
                string3 = ((StringTokenizer)object).nextToken();
                if (string3 == null || !string3.equals(string)) continue;
                arrayList.add(string2);
            }
            object = string4;
            String string6 = ((String)object).substring(0, ((String)object).indexOf(":"));
            String string7 = ((String)object).substring(((String)object).indexOf(":") + 1);
            if (arrayList.size() <= 0) continue;
            if (treeMap.containsKey(string7)) {
                treeMap2 = (TreeMap)treeMap.get(string7);
                treeMap2.put(string6, arrayList);
                treeMap.put(string7, treeMap2);
                continue;
            }
            treeMap2 = new TreeMap();
            treeMap2.put(string6, arrayList);
            treeMap.put(string7, treeMap2);
        }
        return treeMap;
    }

    public ArrayList getAssociatedPolicyForServerGroup(String string) {
        String[] stringArray = this.getVariables(subject1);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (string == null || !stringArray[i].startsWith(string + "#")) continue;
                arrayList.add(stringArray[i] + "=" + this.getValue(subject1, stringArray[i]));
            }
        }
        return arrayList;
    }

    public String getPolicyForServerGroups(String string) {
        String[] stringArray = this.getVariables(subject1);
        String string2 = "";
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (string == null || !stringArray[i].startsWith(string + "#")) continue;
                string2 = string2 + ", " + this.getValue(subject1, stringArray[i]);
            }
            if (string2 != null && string2.startsWith(",")) {
                string2 = string2.substring(1);
            }
        }
        return string2;
    }

    public ArrayList getThreshEntriesForAgent(ArrayList arrayList) {
        int n;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = arrayList.size();
        if (arrayList == null || n2 == 0) {
            return arrayList2;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (n = 0; n < n2; ++n) {
            string = (String)arrayList.get(n);
            Vector vector = this.getServerGroup(string);
            if (vector == null || vector.size() == 0) continue;
            for (int i = 0; i < vector.size(); ++i) {
                string2 = (String)vector.get(i);
                String[] stringArray = this.infogroupFilePtr.getVariables(string2);
                Vector vector2 = this.infogroupFilePtr.getAllValues(string2);
                if (!arrayList2.contains("[" + string2 + "]")) {
                    arrayList2.add("[" + string2 + "]");
                    for (int j = 0; j < stringArray.length; ++j) {
                        arrayList2.add(stringArray[j] + "=" + (String)vector2.get(j));
                    }
                }
                ArrayList arrayList6 = this.getAssociatedPolicyForServerGroup(string2);
                for (int j = 0; j < arrayList6.size(); ++j) {
                    string3 = (String)arrayList6.get(j);
                    if (arrayList3.contains(string3)) continue;
                    arrayList3.add(string3);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "#");
                    int n3 = stringTokenizer.countTokens();
                    if (n3 == 2) {
                        stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken().replace('=', ':');
                    } else if (n3 == 3) {
                        stringTokenizer.nextToken();
                        string4 = stringTokenizer.nextToken() + ":";
                        String string5 = stringTokenizer.nextToken();
                        string4 = string4 + string5.substring(string5.indexOf("=") + 1);
                    }
                    if (arrayList5.contains(string4)) continue;
                    arrayList4.add(string4 + "=" + this.infogroupFilePtr.getValue(subject2, string4));
                    arrayList5.add(string4);
                }
            }
        }
        n2 = arrayList3.size();
        if (arrayList3 != null && n2 > 0) {
            arrayList2.add("[" + subject1 + "]");
            for (n = 0; n < n2; ++n) {
                arrayList2.add((String)arrayList3.get(n));
            }
        }
        n2 = arrayList4.size();
        if (arrayList4 != null && n2 > 0) {
            arrayList2.add("[" + subject2 + "]");
            for (n = 0; n < n2; ++n) {
                arrayList2.add((String)arrayList4.get(n));
            }
        }
        return arrayList2;
    }
}

