/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgDbaseInfo {
    private IniFile dbaseFilePtr;
    private File dbaseFile;
    private long lastModifiedTime;
    private long lastSize;
    private String whoami;
    private String dbaseFileName;
    private static String defaultTablesSection = "DEF_TABLES";
    private static String dynamicTablesSection = "DYN_TABLES";
    private static String partitionTablesSection = "PARTITIONED_TABLES";
    private static String configTestFieldSizeSection = "CONFIG_TEST_FIELD_SIZE";
    private static String mgrDetailsSection = "MANAGER_DETAILS";

    public static void main(String[] stringArray) {
        EgDbaseInfo egDbaseInfo = new EgDbaseInfo("manager");
    }

    public EgDbaseInfo(String string) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.dbaseFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDbaseConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDbaseConfigFile);
        egConfigInfo = null;
        this.dbaseFile = new File(this.dbaseFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, false);
    }

    public EgDbaseInfo(String string, boolean bl) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.dbaseFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDbaseConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDbaseConfigFile);
        egConfigInfo = null;
        this.dbaseFile = new File(this.dbaseFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, bl);
    }

    public long lastModified() {
        if (this.whoami.equals("agent")) {
            return this.dbaseFile.lastModified();
        }
        return IniFile.getLastModified(this.dbaseFileName);
    }

    public long lastSize() {
        if (this.whoami.equals("agent")) {
            return this.dbaseFile.length();
        }
        return IniFile.getLastSize(this.dbaseFileName);
    }

    public synchronized boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && this.lastSize == l2) {
            return false;
        }
        this.lastModifiedTime = l;
        this.lastSize = l2;
        this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        return true;
    }

    public void release() {
        this.dbaseFilePtr = null;
    }

    public void init() {
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, false);
    }

    public String[] getDefaultTables() {
        return this.dbaseFilePtr.getVariables(defaultTablesSection);
    }

    public String[] getDynamicTables() {
        return this.dbaseFilePtr.getVariables(dynamicTablesSection);
    }

    public String[] getPartitionTables() {
        return this.dbaseFilePtr.getVariables(partitionTablesSection);
    }

    public void addDynamicTable(String string) {
        this.addDynamicTable(string, null);
    }

    public void addDynamicTable(String string, String string2) {
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, true);
        this.dbaseFilePtr.setValue(dynamicTablesSection, string, "true");
        if (string2 != null && string2.trim().length() != 0) {
            this.dbaseFilePtr.setValue(partitionTablesSection, string, string2);
        }
        this.dbaseFilePtr.saveFile();
        this.dbaseFile = new File(this.dbaseFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.dbaseFilePtr = new IniFile(this.dbaseFileName);
    }

    public boolean updatePartitionedDate(String string, String string2) {
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, true);
        if (this.dbaseFilePtr == null) {
            return false;
        }
        try {
            this.dbaseFilePtr.deleteValue(partitionTablesSection, string);
            this.dbaseFilePtr.setValue(partitionTablesSection, string, string2);
            this.dbaseFilePtr.saveFile();
            this.dbaseFile = new File(this.dbaseFileName);
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void removeDynamicTable(String string) {
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, true);
        this.dbaseFilePtr.deleteValue(dynamicTablesSection, string);
        this.dbaseFilePtr.saveFile();
        this.dbaseFile = new File(this.dbaseFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.dbaseFilePtr = new IniFile(this.dbaseFileName);
    }

    public void removePartitionEntry(String string) {
        this.dbaseFilePtr = new IniFile(this.dbaseFileName, true);
        this.dbaseFilePtr.deleteValue(partitionTablesSection, string);
        this.dbaseFilePtr.saveFile();
        this.dbaseFile = new File(this.dbaseFileName);
        this.lastModifiedTime = this.lastModified();
        this.lastSize = this.lastSize();
        this.dbaseFilePtr = new IniFile(this.dbaseFileName);
    }

    public String getPartitionedDate(String string) {
        String string2 = this.dbaseFilePtr.getValue(partitionTablesSection, string);
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        return string2;
    }

    public int getConfigTestFieldSize(String string) {
        String string2 = this.dbaseFilePtr.getValue(configTestFieldSizeSection, string);
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.dbaseFilePtr.getValue(configTestFieldSizeSection, "Default");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("[EgDbaseInfo]Invalid config test field size entry for " + string);
            return 512;
        }
    }

    public Hashtable getConfigTestFieldSize() {
        String[] stringArray = this.dbaseFilePtr.getVariables(configTestFieldSizeSection);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < n; ++i) {
            String string = this.dbaseFilePtr.getValue(configTestFieldSizeSection, stringArray[i]);
            if (string == null || string.trim().length() <= 0) continue;
            try {
                hashtable.put(stringArray[i], new Integer(string));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashtable;
    }

    public boolean isTableExistInDB(String string) {
        String string2 = this.dbaseFilePtr.getValue(dynamicTablesSection, string);
        return string2 != null && string2.length() != 0;
    }

    public boolean isDefaultTableExistInDB(String string) {
        String string2 = this.dbaseFilePtr.getValue(defaultTablesSection, string);
        return string2 != null && string2.length() != 0;
    }

    public String getManagerVersion() {
        String string = this.dbaseFilePtr.getValue(mgrDetailsSection, "ManagerVersion");
        if (string == null || string.length() == 0) {
            return "";
        }
        return string;
    }

    public String getDefaultFileGroupName() {
        return this.dbaseFilePtr.getValue("FILEGROUP_NAME_MAPPPING", "default");
    }

    public String getFileGroupName(String string) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.dbaseFilePtr.getVariables("FILEGROUP_NAME_MAPPPING");
        Vector vector = this.dbaseFilePtr.getAllValues("FILEGROUP_NAME_MAPPPING");
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 != null && string3.indexOf(",") != -1) {
                if (string3.indexOf(string) != -1) {
                    n = i;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                continue;
            }
            arrayList.add(string3);
        }
        if (arrayList != null && arrayList.size() > 0 && arrayList.contains(string)) {
            String string4 = string2 = n == -1 ? this.dbaseFilePtr.getValue("FILEGROUP_NAME_MAPPPING", string) : (String)vector.get(n);
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.getDefaultFileGroupName();
        }
        return string2;
    }
}

