/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XCmdGeneric {
    String machine;
    String remoteCmd;
    private static String installDir = EgInstallInfo.getInstallDir();
    private static Vector currentlyExecuting = new Vector();
    private static Vector syncVector = new Vector();
    private static long retryPeriod = 250L;
    private static long timeOut = 5L * EgConfigInfo.msecPerMin;
    private static Vector times = new Vector();
    private static long lastCheck = 0L;
    private static long timeCheckPeriod = 3L * EgConfigInfo.msecPerMin;
    private static long threadTimeOut = 5L * EgConfigInfo.msecPerMin;
    private static int maxRetries = 3;
    private static int xcmdTimeOut = 120;
    private static Hashtable cmdTimeCache = new Hashtable();
    private static Hashtable cmdOutputCache = new Hashtable();
    private long xcmdOutputCacheTime = 30000L;
    private static long maxWaitTime = 60000L;
    private static long cacheCleanup = 15L * EgConfigInfo.msecPerMin;
    private static long lastCleanupTime = System.currentTimeMillis();
    private static boolean win32CheckDone = false;
    private boolean useWin32 = false;
    private static boolean isit64agent = false;
    private static ArrayList netbioslist = new ArrayList();
    private static boolean java15Version = System.getProperty("java.version").compareTo("1.5") > 0;
    public static Hashtable failedTargets = new Hashtable();
    public static long failedTargetTimeout = EgConfigInfo.msecPerMin * 12L;
    private static Hashtable latestScriptAvailHash = new Hashtable();

    public XCmdGeneric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCache() {
        long l = System.currentTimeMillis();
        if (l - lastCleanupTime > cacheCleanup) {
            String string = installDir;
            synchronized (string) {
                l = System.currentTimeMillis();
                if (l - lastCleanupTime > cacheCleanup) {
                    cmdTimeCache = new Hashtable();
                    cmdOutputCache = new Hashtable();
                    lastCleanupTime = l;
                }
            }
        }
    }

    private boolean inCache(String string) {
        long l;
        Long l2 = (Long)cmdTimeCache.get(string);
        if (l2 == null) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        return l3 - (l = l2.longValue()) < this.xcmdOutputCacheTime;
    }

    private ArrayList getFromCache(String string) {
        ArrayList arrayList = (ArrayList)cmdOutputCache.get(string);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(String string, ArrayList arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
            String string2 = installDir;
            synchronized (string2) {
                cmdTimeCache.put(string, new Long(System.currentTimeMillis() + 7L * EgConfigInfo.msecPerMin));
                cmdOutputCache.put(string, arrayList);
            }
            return;
        }
        String string3 = installDir;
        synchronized (string3) {
            cmdTimeCache.put(string, new Long(System.currentTimeMillis()));
            cmdOutputCache.put(string, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCmdGeneric(String string) {
        String string2;
        double d;
        this.machine = string;
        IniFile iniFile = new IniFile(installDir + "/agent/config/eg_tests.ini");
        String string3 = iniFile.getValue("AGENT_SETTINGS", "xCmdTimeOut");
        this.remoteCmd = string3 == null || string3.length() <= 0 ? "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " /R " : ((xcmdTimeOut = Integer.parseInt(string3)) > 0 ? "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " " + " /T:" + xcmdTimeOut + " /R " : "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " /R ");
        string3 = iniFile.getValue("AGENT_SETTINGS", "xCmdCacheTime");
        iniFile = null;
        if (string3 != null && string3.length() > 0) {
            try {
                this.xcmdOutputCacheTime = Long.parseLong(string3) * 1000L;
            }
            catch (Exception exception) {
                this.xcmdOutputCacheTime = 30000L;
            }
        }
        if ((double)timeOut < (d = 1.5 * (double)xcmdTimeOut * 1000.0)) {
            timeOut = (long)d;
        }
        if ((double)threadTimeOut < d) {
            threadTimeOut = (long)d;
        }
        if (!win32CheckDone) {
            string2 = installDir;
            synchronized (string2) {
                if (!win32CheckDone) {
                    win32CheckDone = true;
                    File file = new File(installDir + "/bin/eGRemote32.exe");
                    isit64agent = file.exists();
                }
            }
        }
        if (isit64agent) {
            string2 = installDir;
            synchronized (string2) {
                if (netbioslist.contains(this.machine)) {
                    this.remoteCmd = XCmdGeneric.replaceAll(this.remoteCmd, "eGRemote.exe", "eGRemote32.exe");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCmdGeneric(String string, String string2, String string3) {
        this.machine = string;
        IniFile iniFile = new IniFile(installDir + "/agent/config/eg_tests.ini");
        String string4 = iniFile.getValue("AGENT_SETTINGS", "xCmdTimeOut");
        iniFile = null;
        this.remoteCmd = string4 == null || string4.length() <= 0 ? "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " /user:" + string2 + " /pwd:" + string3 + " /R " : ((xcmdTimeOut = Integer.parseInt(string4)) > 0 ? "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " /user:" + string2 + " /pwd:" + string3 + " " + " /T:" + xcmdTimeOut + " /R " : "cmd.exe /c " + installDir + "/bin/eGRemote.exe \\\\" + this.machine + " /user:" + string2 + " /pwd:" + string3 + " /R ");
        double d = 1.5 * (double)xcmdTimeOut * 1000.0;
        if ((double)timeOut < d) {
            timeOut = (long)d;
        }
        if ((double)threadTimeOut < d) {
            threadTimeOut = (long)d;
        }
        if (!win32CheckDone) {
            String string5 = installDir;
            synchronized (string5) {
                if (!win32CheckDone) {
                    win32CheckDone = true;
                    File file = new File(installDir + "/bin/eGRemote32.exe");
                    isit64agent = file.exists();
                }
            }
        }
        if (isit64agent && netbioslist.contains(this.machine)) {
            this.remoteCmd = XCmdGeneric.replaceAll(this.remoteCmd, "eGRemote.exe", "eGRemote32.exe");
        }
    }

    public static void main(String[] stringArray) {
        XCmdGeneric xCmdGeneric = new XCmdGeneric("192.168.10.41", "egtester", "egurkha");
        System.out.println(xCmdGeneric.executeRemoteCommand("ipconfig"));
    }

    private void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean checkFailed(String string) {
        Long l = (Long)failedTargets.get(string);
        if (l != null) {
            long l2 = l;
            long l3 = System.currentTimeMillis();
            if (l3 - l2 <= failedTargetTimeout) {
                System.out.println("Failed target! - " + string);
                return true;
            }
            failedTargets.remove(string);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startExecution(String string) {
        if (XCmdGeneric.checkFailed(this.machine)) {
            return false;
        }
        long l = System.currentTimeMillis();
        while (true) {
            long l2;
            if ((l2 = System.currentTimeMillis()) - l > maxWaitTime) {
                System.out.println("################# waited too long - giving up " + this.machine + " " + string);
                return false;
            }
            if (currentlyExecuting.contains(this.machine)) {
                this.sleep(retryPeriod);
                if (!XCmdGeneric.checkFailed(this.machine)) continue;
                return false;
            }
            if (XCmdGeneric.checkFailed(this.machine)) {
                return false;
            }
            if (EgMainAgent.maxParalleleGRemote >= 0L && (long)currentlyExecuting.size() > EgMainAgent.maxParalleleGRemote) {
                this.sleep(retryPeriod);
                if (!XCmdGeneric.checkFailed(this.machine)) continue;
                return false;
            }
            if (!(currentlyExecuting.contains(this.machine) || EgMainAgent.maxParalleleGRemote >= 0L && (long)currentlyExecuting.size() >= EgMainAgent.maxParalleleGRemote)) {
                Vector vector = syncVector;
                synchronized (vector) {
                    if (XCmdGeneric.checkFailed(this.machine)) {
                        return false;
                    }
                    if (!(currentlyExecuting.contains(this.machine) || EgMainAgent.maxParalleleGRemote >= 0L && (long)currentlyExecuting.size() >= EgMainAgent.maxParalleleGRemote)) {
                        currentlyExecuting.add(this.machine);
                        times.add(new Long(System.currentTimeMillis()));
                        break;
                    }
                }
            }
            if (XCmdGeneric.checkFailed(this.machine)) {
                return false;
            }
            this.sleep(retryPeriod);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doneExecution() {
        Vector vector = syncVector;
        synchronized (vector) {
            int n = currentlyExecuting.indexOf(this.machine);
            if (n >= 0) {
                currentlyExecuting.remove(n);
                times.remove(n);
            }
        }
        long l = System.currentTimeMillis();
        if (l - lastCheck > timeCheckPeriod) {
            Vector vector2 = syncVector;
            synchronized (vector2) {
                if (l - lastCheck > timeCheckPeriod) {
                    lastCheck = l;
                    for (int i = 0; i < times.size(); ++i) {
                        Long l2 = (Long)times.get(i);
                        if (l - l2 <= timeOut) continue;
                        times.remove(i);
                        currentlyExecuting.remove(i);
                        --i;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommand(String string) {
        ArrayList arrayList;
        String string2 = this.remoteCmd + "\"" + string + "\"";
        this.checkCache();
        if (this.inCache(string2) && (arrayList = this.getFromCache(string2)) != null) {
            return arrayList;
        }
        arrayList = new ArrayList();
        for (int i = 0; i < maxRetries; ++i) {
            ArrayList arrayList2;
            if (!this.startExecution(string2)) {
                return new ArrayList();
            }
            if (this.inCache(string2) && (arrayList2 = this.getFromCache(string2)) != null) {
                this.doneExecution();
                return arrayList2;
            }
            arrayList = this.runRemoteCommands(string2);
            arrayList2 = new ArrayList();
            if ((arrayList = this.processResults(arrayList, arrayList2)) != null) break;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList = new ArrayList();
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                break;
            }
            if (i != maxRetries - 1) {
                this.doneExecution();
                this.sleep(250 * (i + 1));
            } else {
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
            }
            arrayList = new ArrayList();
            System.out.println("-------------------------------------------------");
            System.out.println("The command " + string2 + " failed!!!. Trying again ...");
            System.out.println("-------------------------------------------------");
            if (!this.useWin32) continue;
            string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
            String string3 = installDir;
            synchronized (string3) {
                if (!netbioslist.contains(this.machine)) {
                    netbioslist.add(this.machine);
                }
                continue;
            }
        }
        this.addToCache(string2, arrayList);
        this.doneExecution();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommandWithCopy(String string) {
        ArrayList arrayList;
        String string2 = this.remoteCmd + string;
        this.checkCache();
        if (this.inCache(string2) && (arrayList = this.getFromCache(string2)) != null) {
            return arrayList;
        }
        arrayList = null;
        for (int i = 0; i < maxRetries; ++i) {
            ArrayList arrayList2;
            if (!this.startExecution(string2)) {
                return new ArrayList();
            }
            if (this.inCache(string2) && (arrayList2 = this.getFromCache(string2)) != null) {
                this.doneExecution();
                return arrayList2;
            }
            arrayList = this.runRemoteCommands(string2);
            arrayList2 = new ArrayList();
            if ((arrayList = this.processResults(arrayList, arrayList2)) != null) break;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList = new ArrayList();
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                break;
            }
            if (i != maxRetries - 1) {
                this.doneExecution();
                this.sleep(250 * (i + 1));
            } else {
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
            }
            arrayList = new ArrayList();
            System.out.println("-------------------------------------------------");
            System.out.println("The command " + string2 + " failed!!!. Trying again ...");
            System.out.println("-------------------------------------------------");
            if (!this.useWin32) continue;
            string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
            String string3 = installDir;
            synchronized (string3) {
                if (!netbioslist.contains(this.machine)) {
                    netbioslist.add(this.machine);
                }
                continue;
            }
        }
        this.addToCache(string2, arrayList);
        this.doneExecution();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommand(String string, long l) {
        ArrayList arrayList;
        String string2 = this.remoteCmd + "\"" + string + "\"";
        this.checkCache();
        if (this.inCache(string2) && (arrayList = this.getFromCache(string2)) != null) {
            return arrayList;
        }
        arrayList = null;
        for (int i = 0; i < maxRetries; ++i) {
            ArrayList arrayList2;
            if (!this.startExecution(string2)) {
                return new ArrayList();
            }
            if (this.inCache(string2) && (arrayList2 = this.getFromCache(string2)) != null) {
                this.doneExecution();
                return arrayList2;
            }
            arrayList = this.runRemoteCommands(string2, l);
            arrayList2 = new ArrayList();
            if ((arrayList = this.processResults(arrayList, arrayList2)) != null) break;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList = new ArrayList();
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                break;
            }
            if (i != maxRetries - 1) {
                this.doneExecution();
                this.sleep(250 * (i + 1));
            } else {
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
            }
            arrayList = new ArrayList();
            System.out.println("-------------------------------------------------");
            System.out.println("The command " + string2 + " failed!!!. Trying again ...");
            System.out.println("-------------------------------------------------");
            if (!this.useWin32) continue;
            string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
            String string3 = installDir;
            synchronized (string3) {
                if (!netbioslist.contains(this.machine)) {
                    netbioslist.add(this.machine);
                }
                continue;
            }
        }
        this.addToCache(string2, arrayList);
        this.doneExecution();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommandWithCopy(String string, long l) {
        ArrayList arrayList;
        String string2 = this.remoteCmd + string;
        this.checkCache();
        if (this.inCache(string2) && (arrayList = this.getFromCache(string2)) != null) {
            return arrayList;
        }
        arrayList = null;
        for (int i = 0; i < maxRetries; ++i) {
            ArrayList arrayList2;
            if (!this.startExecution(string2)) {
                return new ArrayList();
            }
            if (this.inCache(string2) && (arrayList2 = this.getFromCache(string2)) != null) {
                this.doneExecution();
                return arrayList2;
            }
            arrayList = this.runRemoteCommands(string2, l);
            arrayList2 = new ArrayList();
            if ((arrayList = this.processResults(arrayList, arrayList2)) != null) break;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList = new ArrayList();
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                break;
            }
            if (i != maxRetries - 1) {
                this.doneExecution();
                this.sleep(250 * (i + 1));
            } else {
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
            }
            arrayList = new ArrayList();
            System.out.println("-------------------------------------------------");
            System.out.println("The command " + string2 + " is failed!!!!. Try again");
            System.out.println("-------------------------------------------------");
            if (!this.useWin32) continue;
            string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
            String string3 = installDir;
            synchronized (string3) {
                if (!netbioslist.contains(this.machine)) {
                    netbioslist.add(this.machine);
                }
                continue;
            }
        }
        this.addToCache(string2, arrayList);
        this.doneExecution();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommand(String string, boolean bl) {
        block21: {
            String string2 = this.remoteCmd + "\"" + string + "\"";
            if (!bl) {
                ArrayList arrayList = null;
                for (int i = 0; i < maxRetries; ++i) {
                    if (!this.startExecution(string2)) {
                        return new ArrayList();
                    }
                    arrayList = this.runRemoteCommands(string2);
                    this.doneExecution();
                    ArrayList arrayList2 = new ArrayList();
                    arrayList = this.processResults(arrayList, arrayList2);
                    if (arrayList != null) {
                        return arrayList;
                    }
                    if (arrayList2 != null && arrayList2.size() > 0) {
                        arrayList = new ArrayList();
                        failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                        break;
                    }
                    if (i != maxRetries - 1) {
                        this.sleep(250 * (i + 1));
                    } else {
                        failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                    }
                    arrayList = new ArrayList();
                    System.out.println("-------------------------------------------------");
                    System.out.println("The command " + string2 + " failed !!!!. Try again");
                    System.out.println("-------------------------------------------------");
                    if (!this.useWin32) continue;
                    string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
                    String string3 = installDir;
                    synchronized (string3) {
                        if (!netbioslist.contains(this.machine)) {
                            netbioslist.add(this.machine);
                        }
                        continue;
                    }
                }
                return arrayList;
            }
            BufferedReader bufferedReader = null;
            Process process = null;
            Runtime runtime = null;
            try {
                System.out.println("xcmd with runtime exec $$$$$$$$$$$$$$$$$$$");
                runtime = Runtime.getRuntime();
                process = runtime.exec(string2);
                bufferedReader = java15Version ? new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string4 = bufferedReader.readLine();
                if (string4 != null) {
                    // empty if block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bufferedReader.close();
                process.destroy();
            }
            catch (Exception exception) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (process == null) break block21;
                try {
                    process.destroy();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommand(String string, ArrayList arrayList, boolean bl) {
        block22: {
            String string2 = this.remoteCmd + "\"" + string + "\"";
            String string3 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = string3 + " \" " + arrayList.get(i) + "\"";
            }
            string2 = string2 + string3;
            if (!bl) {
                ArrayList arrayList2 = null;
                for (int i = 0; i < maxRetries; ++i) {
                    if (!this.startExecution(string2)) {
                        return new ArrayList();
                    }
                    arrayList2 = this.runRemoteCommands(string2);
                    this.doneExecution();
                    ArrayList arrayList3 = new ArrayList();
                    arrayList2 = this.processResults(arrayList2, arrayList3);
                    if (arrayList2 != null) {
                        return arrayList2;
                    }
                    if (arrayList3 != null && arrayList3.size() > 0) {
                        arrayList2 = new ArrayList();
                        failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                        break;
                    }
                    if (i != maxRetries - 1) {
                        this.sleep(250 * (i + 1));
                    } else {
                        failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                    }
                    arrayList2 = new ArrayList();
                    System.out.println("-------------------------------------------------");
                    System.out.println("The command " + string2 + " failed !!!!. Try again");
                    System.out.println("-------------------------------------------------");
                    if (!this.useWin32) continue;
                    string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
                    String string4 = installDir;
                    synchronized (string4) {
                        if (!netbioslist.contains(this.machine)) {
                            netbioslist.add(this.machine);
                        }
                        continue;
                    }
                }
                return arrayList2;
            }
            BufferedReader bufferedReader = null;
            Process process = null;
            Runtime runtime = null;
            try {
                runtime = Runtime.getRuntime();
                process = runtime.exec(string2);
                bufferedReader = java15Version ? new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string5 = bufferedReader.readLine();
                if (string5 != null) {
                    // empty if block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bufferedReader.close();
                process.destroy();
            }
            catch (Exception exception) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (process == null) break block22;
                try {
                    process.destroy();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList executeRemoteCommand(String string, ArrayList arrayList) {
        ArrayList arrayList2;
        String string2 = this.remoteCmd + "\"" + string + "\"";
        String string3 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string3 = string3 + " \" " + arrayList.get(i) + "\"";
        }
        string2 = string2 + string3;
        this.checkCache();
        if (this.inCache(string2) && (arrayList2 = this.getFromCache(string2)) != null) {
            return arrayList2;
        }
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < maxRetries; ++i) {
            ArrayList arrayList4;
            if (!this.startExecution(string2)) {
                return new ArrayList();
            }
            if (this.inCache(string2) && (arrayList4 = this.getFromCache(string2)) != null) {
                this.doneExecution();
                return arrayList4;
            }
            arrayList3 = this.runRemoteCommands(string2);
            arrayList4 = new ArrayList();
            if ((arrayList3 = this.processResults(arrayList3, arrayList4)) != null) break;
            if (arrayList4 != null && arrayList4.size() > 0) {
                arrayList3 = new ArrayList();
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
                break;
            }
            if (i != maxRetries - 1) {
                this.doneExecution();
                this.sleep(250 * (i + 1));
            } else {
                failedTargets.put(this.machine, new Long(System.currentTimeMillis()));
            }
            arrayList3 = new ArrayList();
            System.out.println("-------------------------------------------------");
            System.out.println("The command " + string2 + " failed!!!. Trying again ...");
            System.out.println("-------------------------------------------------");
            if (!this.useWin32) continue;
            string2 = XCmdGeneric.replaceAll(string2, "eGRemote.exe", "eGRemote32.exe");
            String string4 = installDir;
            synchronized (string4) {
                if (!netbioslist.contains(this.machine)) {
                    netbioslist.add(this.machine);
                }
                continue;
            }
        }
        this.addToCache(string2, arrayList3);
        this.doneExecution();
        return arrayList3;
    }

    public void copyExeToRemote(String string) {
        String string2 = "";
        string2 = "/c " + string;
        ArrayList arrayList = this.executeRemoteCommandWithCopy(string2);
    }

    public void copyExeToRemote(String string, boolean bl) {
        String string2 = "";
        string2 = "/c " + string;
        if (!bl) {
            ArrayList arrayList = this.executeRemoteCommandWithCopy(string2);
        } else {
            this.executeRemoteCommandWithCopy("/noexec " + string2);
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean checkForExeOnRemote(String string) {
        boolean bl = false;
        ArrayList arrayList = null;
        String string2 = "dir " + EgInstallInfo.getXCmdRemoteDirectory() + string;
        String string3 = new String(this.machine + ":" + string);
        if (!latestScriptAvailHash.containsKey(string3)) {
            latestScriptAvailHash.put(string3, string2);
            return false;
        }
        arrayList = this.executeRemoteCommand(string2);
        if (arrayList == null || arrayList.size() <= 0) {
            return false;
        }
        int n = arrayList.size();
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null) {
            return false;
        }
        n = arrayList2.size();
        String string4 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            String string5;
            string4 = (String)arrayList2.get(i);
            if (string4 == null || string4.length() <= 0) continue;
            if ((string4 = string4.trim()).startsWith("File Not Found") || string4.startsWith("Failed") || string4.startsWith("TimedOut")) {
                if (string4.startsWith("TimedOut")) {
                    System.out.println("================Timed out ==================");
                }
                bl2 = false;
                break;
            }
            if (string4.indexOf(string) <= 0) continue;
            bl3 = true;
            if (!string4.endsWith(string)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList3.add(stringTokenizer.nextToken());
            }
            int n2 = arrayList3.size();
            if (n2 < 2 || !(string5 = (String)arrayList3.get(n2 - 1)).equalsIgnoreCase("0")) continue;
            bl4 = true;
        }
        if (!bl3 || bl4) {
            bl2 = false;
        }
        return bl2;
    }

    public ArrayList getRemoteCmdOutput(String string) {
        ArrayList arrayList = null;
        arrayList = this.executeRemoteCommand(string);
        return arrayList;
    }

    public ArrayList processResults(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n < 2) {
            System.out.println("Failed data " + arrayList);
            System.out.println("Currently executing " + currentlyExecuting);
            return arrayList;
        }
        ArrayList arrayList3 = (ArrayList)arrayList.get(0);
        ArrayList arrayList4 = (ArrayList)arrayList.get(1);
        if (arrayList3 != null) {
            boolean bl = arrayList3.contains("TimedOut");
            if (arrayList3.contains("Failed") || arrayList3.contains("EgFailed")) {
                System.out.println("FAILED DATA " + arrayList3);
                System.out.println("ERROR is " + arrayList4);
                if (arrayList4 != null && arrayList4.size() > 0) {
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        String string = (String)arrayList4.get(i);
                        if ((string = string.toLowerCase()).indexOf("network path was not found") < 0 && string.indexOf("no longer available") < 0 && string.indexOf("no network provider") < 0 && string.indexOf("unknown user name") < 0 && string.indexOf("logon failure") < 0) continue;
                        arrayList2.add(new Boolean(true));
                        break;
                    }
                }
                if (bl) {
                    System.out.println("***************Timed Out *********************" + arrayList3);
                    System.out.println("Currently executing " + currentlyExecuting);
                    return new ArrayList();
                }
                return null;
            }
        } else {
            return null;
        }
        return arrayList;
    }

    public ArrayList runRemoteCommands(String string) {
        long l;
        ExecThread execThread = new ExecThread(string);
        long l2 = 113L;
        for (l = 0L; l <= threadTimeOut && !execThread.done; l += l2) {
            try {
                Thread.sleep(l2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l > threadTimeOut) {
            System.out.println(string + " TIMEOUT!!!!");
            try {
                execThread.stopExec();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new ArrayList();
        }
        if (isit64agent && execThread.errlist != null && execThread.errlist.size() > 0) {
            this.useWin32 = this.findWin32Errors(execThread.errlist);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(execThread.output);
        if (execThread.errlist != null) {
            arrayList.add(execThread.errlist);
        } else {
            arrayList.add(new ArrayList());
        }
        return arrayList;
    }

    private boolean findWin32Errors(ArrayList arrayList) {
        boolean bl = false;
        if (arrayList == null) {
            return bl;
        }
        int n = arrayList.size();
        if (n == 0) {
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (string.indexOf("is not a valid Win32") < 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public ArrayList runRemoteCommands(String string, long l) {
        long l2;
        ExecThread execThread = new ExecThread(string);
        long l3 = 113L;
        for (l2 = 0L; l2 <= l && !execThread.done; l2 += l3) {
            try {
                Thread.sleep(l3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (l2 >= l) {
            System.out.println(string + " TIMEOUT!!!!");
            try {
                execThread.stopExec();
                Thread.currentThread();
                Thread.yield();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return new ArrayList();
        }
        if (isit64agent && execThread.errlist != null && execThread.errlist.size() > 0) {
            this.useWin32 = this.findWin32Errors(execThread.errlist);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(execThread.output);
        if (execThread.errlist != null) {
            arrayList.add(execThread.errlist);
        } else {
            arrayList.add(new ArrayList());
        }
        return arrayList;
    }

    public static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

