/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;

public class WsLocalTxTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String serverName = null;
    private String server = "";
    private static int localTransBegunIndex = 0;
    private static int activeLocalTransIndex = 1;
    private static int localTranDurationIndex = 2;
    private static int localCommitDurationIndex = 3;
    private static int localTransCommittedIndex = 4;
    private static int localTransRolledBackIndex = 5;
    private static int localTransTimeoutIndex = 6;
    private double localTransBegun = 0.0;
    private double activeLocalTrans = 0.0;
    private double localTranDuration = 0.0;
    private double localCommitDuration = 0.0;
    private double localTransCommitted = 0.0;
    private double localTransRolledBack = 0.0;
    private double localTransTimeout = 0.0;
    private String tempHost = "";

    public WsLocalTxTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 7;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        String string = this.getValueForParam("ssl");
        if (string != null) {
            this.isSsl = new Boolean(string);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        WsLocalTxTest wsLocalTxTest = new WsLocalTxTest(stringArray);
        wsLocalTxTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=transactionModule&summary=true&transaction=local&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "transaction", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].substring(0, stringArray[i].lastIndexOf("transactionModule") - 1);
                this.localTransBegun = this.getValue(stringArray[i], "localTransBegun", true);
                this.activeLocalTrans = this.getValue(stringArray[i], "activeLocalTrans", false);
                this.localTranDuration = this.getValue(stringArray[i], "localTranDuration", true);
                if (this.localTranDuration > 0.0) {
                    this.localTranDuration /= 1000.0;
                }
                this.localCommitDuration = this.getValue(stringArray[i], "localCommitDuration", true);
                if (this.localCommitDuration > 0.0) {
                    this.localCommitDuration /= 1000.0;
                }
                this.localTransCommitted = this.getValue(stringArray[i], "localTransCommitted", true);
                this.localTransRolledBack = this.getValue(stringArray[i], "localTransRolledBack", true);
                this.localTransTimeout = this.getValue(stringArray[i], "localTransTimeout", true);
                if (this.timeSinceLastTest <= 0.0) {
                    this.localTransBegun = -1.0;
                    this.localTransCommitted = -1.0;
                    this.localTranDuration = -1.0;
                    this.localCommitDuration = -1.0;
                    this.localTransRolledBack = -1.0;
                    this.localTransTimeout = -1.0;
                } else {
                    this.localTransBegun /= this.timeSinceLastTest;
                    this.localTransCommitted /= this.timeSinceLastTest;
                    this.localTransRolledBack /= this.timeSinceLastTest;
                    this.localTransTimeout /= this.timeSinceLastTest;
                }
                if (this.localTransBegun < 0.0 || this.localTranDuration < 0.0 || this.localCommitDuration < 0.0 || this.localTransCommitted < 0.0 || this.localTransRolledBack < 0.0 || this.localTransTimeout < 0.0) {
                    this.localTransBegun = -1.0;
                    this.localTranDuration = -1.0;
                    this.localCommitDuration = -1.0;
                    this.localTransCommitted = -1.0;
                    this.localTransRolledBack = -1.0;
                    this.localTransTimeout = -1.0;
                }
                this.addValueToResultSet(string + string3, localTransBegunIndex, this.localTransBegun);
                this.addValueToResultSet(string + string3, activeLocalTransIndex, this.activeLocalTrans);
                this.addValueToResultSet(string + string3, localTranDurationIndex, this.localTranDuration);
                this.addValueToResultSet(string + string3, localCommitDurationIndex, this.localCommitDuration);
                this.addValueToResultSet(string + string3, localTransCommittedIndex, this.localTransCommitted);
                this.addValueToResultSet(string + string3, localTransRolledBackIndex, this.localTransRolledBack);
                this.addValueToResultSet(string + string3, localTransTimeoutIndex, this.localTransTimeout);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            return true;
        }
    }
}

