/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentTopoInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WebSiteTransactionTester
extends WebAdapterTester {
    private boolean debug = false;
    private EgAgentTopoInfo topoInfo = new EgAgentTopoInfo("agent");
    private Hashtable serverSiteMapping = new Hashtable();
    private Hashtable validWebSites = new Hashtable();
    private Hashtable validWebTransactions = new Hashtable();

    public WebSiteTransactionTester(ThreadGroup threadGroup, String string, EgMainAgent egMainAgent, String string2, String string3, Long l) {
        super(threadGroup, string, "WebSiteTransactionTest", egMainAgent);
        this.mgrIp = string2;
        this.mgrPortNo = string3;
    }

    public void startTester(String[] stringArray, Integer n) {
        this.measurePeriod = n;
        this.tests = new WebSiteTransactionTest[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.tests[i] = this.generateTest(stringArray[i]);
        }
        this.start();
    }

    public EgTest generateTest(String string) {
        String string2 = null;
        string = new String(string + " -period " + this.measurePeriod / 1000);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n + 2];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("-port")) continue;
            string3 = new String(stringArray[i + 1]);
            break;
        }
        if (string3 == null) {
            return null;
        }
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("-host")) continue;
            string4 = stringArray[i + 1];
            break;
        }
        if (string4 == null) {
            return null;
        }
        if (!this.isIpAddress(string4)) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string4);
            }
            catch (UnknownHostException unknownHostException) {
                this.logToErrorFile("ERROR", this.entity, string4 + " is not a valid" + " Host Name or IpAddress ");
                return null;
            }
            string2 = inetAddress.getHostAddress();
        } else {
            string2 = string4;
        }
        stringArray[n] = "-hostIp";
        stringArray[n + 1] = string2;
        WebSiteTransactionTest webSiteTransactionTest = new WebSiteTransactionTest(stringArray);
        webSiteTransactionTest.host = string2;
        webSiteTransactionTest.port = string3;
        return webSiteTransactionTest;
    }

    public void run() {
        Object object;
        long l = -1L;
        this.initializeEgTester();
        this.reinitOnMeasurePeriodChange = true;
        boolean bl = true;
        String[] stringArray = this.topoInfo.getWebSites();
        if (stringArray == null || stringArray.length == 0) {
            bl = false;
        }
        this.validWebSites = new Hashtable();
        this.validWebTransactions = new Hashtable();
        this.serverSiteMapping = new Hashtable();
        boolean bl2 = true;
        if (bl) {
            bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                object = this.topoInfo.getTransactionsForWebSite(stringArray[i]);
                if (object == null || ((String[])object).length == 0) continue;
                bl2 = true;
                break;
            }
        }
        stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        object = new ArrayList();
        while (true) {
            int n;
            this.tests = this.updateTester(this.tests);
            if (this.tests == null) {
                System.out.println(this.entity + ": STOPPING TESTER!");
                return;
            }
            if (this.topoInfo.checkForUpdate()) {
                stringArray = this.topoInfo.getWebSites();
                this.validWebSites = new Hashtable();
                this.validWebTransactions = new Hashtable();
                this.serverSiteMapping = new Hashtable();
                bl = stringArray != null && stringArray.length != 0;
                if (bl) {
                    bl2 = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = this.topoInfo.getTransactionsForWebSite(stringArray[i]);
                        if (stringArray2 == null || stringArray2.length == 0) continue;
                        bl2 = true;
                        break;
                    }
                }
                stringArray = null;
            }
            if (!bl || !bl2) {
                l = this.measurePeriod;
                this.suspendTesterForPeriod(l);
                continue;
            }
            this.checkForUniqueTests(this.tests);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            object = arrayList;
            arrayList = new ArrayList();
            for (n = 0; n < this.tests.length; ++n) {
                if (this.tests[n] == null || arrayList.contains(this.tests[n].reportingName)) continue;
                arrayList.add(this.tests[n].reportingName);
            }
            n = 0;
            n = this.isDiff(arrayList, (ArrayList)object) ? 1 : 0;
            for (int i = 0; i < this.tests.length; ++i) {
                if (this.tests[i] == null || !this.tests[i].isValid) continue;
                ((WebSiteTransactionTest)this.tests[i]).reportingNames = arrayList;
                ((WebSiteTransactionTest)this.tests[i]).reread = n;
                if (!this.tests[i].executeTest()) {
                    this.logToErrorFile("ERROR", this.entity, this.tests[i].errorMsg);
                }
                Enumeration enumeration = this.tests[i].results.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    EgResultSet egResultSet = (EgResultSet)this.tests[i].results.get(string);
                    String[] stringArray3 = this.getSiteAndInfo(egResultSet.index);
                    if (stringArray3 == null) continue;
                    if (!this.isWebSiteValid(stringArray3[0])) {
                        this.tests[i].results.remove(string);
                        continue;
                    }
                    if (!this.isWebTransactionValid(stringArray3[0], stringArray3[1])) {
                        this.tests[i].results.remove(string);
                        continue;
                    }
                    String string2 = this.tests[i].reportingName + "\t" + this.tests[i].portNo + "\t" + stringArray3[0] + "\t" + stringArray3[1] + "\t" + this.tests[i].measurementHost + "\t" + this.tests[i].testDateAndTime;
                    String string3 = "";
                    for (int j = 0; j < egResultSet.values.length; ++j) {
                        string3 = string3 + "\t" + egResultSet.values[j] + "\t" + egResultSet.thresholds[j].state;
                    }
                    String[] stringArray4 = this.getWebSitesForServer(this.tests[i].reportingName + ":" + this.tests[i].portNo);
                    if (this.isWebSiteInList(stringArray4, stringArray3[0])) {
                        String string4 = string2 + string3;
                        arrayList2.add(string4);
                    }
                    for (int j = 0; j < this.tests.length; ++j) {
                        if (this.tests[j] == null || j == i || this.tests[j].isValid || ((WebSiteTransactionTest)this.tests[j]).host == null || ((WebSiteTransactionTest)this.tests[j]).port == null || !this.isMultiPortServer(((WebSiteTransactionTest)this.tests[j]).host, ((WebSiteTransactionTest)this.tests[j]).port, (WebSiteTransactionTest)this.tests[i]) || !this.isWebSiteInList(stringArray4 = this.getWebSitesForServer(this.tests[j].reportingName + ":" + ((WebSiteTransactionTest)this.tests[j]).port), stringArray3[0])) continue;
                        String string5 = this.tests[j].reportingName + "\t" + ((WebSiteTransactionTest)this.tests[j]).port + "\t" + stringArray3[0] + "\t" + stringArray3[1] + "\t" + this.tests[j].measurementHost + "\t" + this.tests[i].testDateAndTime;
                        string5 = string5 + string3;
                        arrayList2.add(string5);
                    }
                }
            }
            String[] stringArray5 = new String[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                stringArray5[i] = (String)arrayList2.get(i);
            }
            this.outputResults(stringArray5, this.mgrIp, this.mgrPortNo);
            l = this.measurePeriod;
            this.suspendTesterForPeriod(l);
        }
    }

    private boolean isWebTransactionValid(String string, String string2) {
        if (this.validWebTransactions.containsKey(string + string2)) {
            return true;
        }
        String[] stringArray = this.topoInfo.getTransactionsForWebSite(string);
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = EgConfigInfo.infoFieldSeparator + stringArray[i];
            if (!string3.equals(string2)) continue;
            this.validWebTransactions.put(string + string2, new Boolean(true));
            return true;
        }
        return false;
    }

    private boolean isWebSiteInList(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isWebSiteValid(String string) {
        if (this.validWebSites.containsKey(string)) {
            return true;
        }
        String[] stringArray = this.topoInfo.getWebSites();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            this.validWebSites.put(string, new Boolean(true));
            return true;
        }
        return false;
    }

    public String[] getWebSitesForServer(String string) {
        if (this.serverSiteMapping.containsKey(string)) {
            return (String[])this.serverSiteMapping.get(string);
        }
        String[] stringArray = this.topoInfo.getWebSitesForServer(string);
        this.serverSiteMapping.put(string, stringArray);
        return stringArray;
    }

    private boolean isDiff(ArrayList arrayList, ArrayList arrayList2) {
        String string;
        int n;
        if (arrayList == null && arrayList2 == null) {
            return false;
        }
        if (arrayList == null || arrayList2 == null) {
            return true;
        }
        if (arrayList.size() != arrayList2.size()) {
            return true;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string = (String)arrayList.get(n);
            if (arrayList2.contains(string)) continue;
            return true;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = (String)arrayList2.get(n);
            if (arrayList.contains(string)) continue;
            return true;
        }
        return false;
    }
}

