/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLThreadPoolTest
extends GenericTest {
    private String uri = "egurkha/egurkhaThreadPool.jsp";
    private String user = "system";
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String protocol = "t3";
    private String password = "weblogic";
    private int version = 0;
    private int reRun = 0;
    private int reDiscoveryCount = 12;
    private boolean isSsl = false;
    ArrayList serverName;
    Hashtable prevRequests = new Hashtable();
    private WebLogicHelperThread sh;
    private long timeout;
    int discCount = 0;
    private boolean isWindowsOS = false;
    private String server = "";
    private String url = "";
    private String tempHost = "";
    protected long jspTimeout;

    public WLThreadPoolTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(7);
        this.isDynamicInfoTest = true;
        if (stringArray.length < 5) {
            System.err.println("Usage: java WLThreadPoolTest -host <targetHost> -port <Port> -user <user> -password <password> ");
            System.exit(0);
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        if ((string = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string2 = this.getValueForParam("jspTimeout");
        if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase("null") || string2.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string2);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string2);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string2);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string2);
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        String string;
        this.user = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.server = (String)hashtable.get("server");
        this.s_useWarFile = (String)hashtable.get("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
        }
        if (this.server == null) {
            this.server = "";
        }
        this.url = (String)hashtable.get("url");
        String string2 = this.getValueForParam("encryptPass");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if ((string = (String)hashtable.get("ssl")) != null) {
            this.isSsl = new Boolean(string);
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3";
            }
        } else {
            this.url = this.url.toLowerCase();
            if (this.isSsl) {
                if (this.url.indexOf("https") < 0) {
                    this.url = this.findAndReplaceString(this.url, "http", "https");
                }
                this.protocol = "t3s";
            }
        }
        if (this.version == 0) {
            String string3 = this.getValueForParam("version");
            if (!string3.equalsIgnoreCase("none")) {
                n = string3.indexOf(".");
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                }
                try {
                    this.version = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    this.version = 0;
                }
            }
            if (this.version == 0) {
                this.version = this.discovery();
            }
        }
        int n2 = 0;
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d = 0.0;
        if (this.version >= 6) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string4 = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            ArrayList arrayList2 = this.returnMeasures();
            if (arrayList2 == null) {
                return;
            }
            int n7 = arrayList2.size();
            for (int i = 0; i < n7; ++i) {
                String string5 = (String)arrayList2.get(i);
                if (string5 == null || !string5.startsWith("eGurkhaThreadPool")) continue;
                if (string5.startsWith("eGurkhaThreadPool")) {
                    string5 = string5.substring(string5.indexOf(":") + 1, string5.length());
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string5, ",");
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                n = Integer.parseInt(stringTokenizer.nextToken());
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                n4 = Integer.parseInt(stringTokenizer.nextToken());
                n5 = Integer.parseInt(stringTokenizer.nextToken());
                n6 = Integer.parseInt(stringTokenizer.nextToken());
                d = Double.parseDouble(stringTokenizer.nextToken());
                arrayList = new ArrayList();
                arrayList.add(new Double(n2));
                arrayList.add(new Double(n));
                arrayList.add(new Double(n3));
                arrayList.add(new Double(n4));
                arrayList.add(new Double(n5));
                arrayList.add(new Double(n6));
                arrayList.add(new Double(d));
                if (debug) {
                    System.out.println("[WLThreadPoolTest]-Final Measure : al_measure_list=======" + arrayList);
                }
                this.addNewMeasure(arrayList);
            }
        }
    }

    private int parse(Object object) {
        if ((String)object == null || ((String)object).equals("")) {
            return -1;
        }
        return Integer.parseInt((String)object);
    }

    private long longParse(String string) {
        if (string == null || string.equals("")) {
            return -1L;
        }
        return Long.parseLong(string);
    }

    private ArrayList returnMeasures() {
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "getThreadPoolsStats.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                return null;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getThreadPoolsStats");
        }
        String string = "";
        HttpURLConnection httpURLConnection = null;
        Object var3_4 = null;
        Object var4_5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        URL uRL = null;
        if (this.isSsl) {
            try {
                string2 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            if (!this.server.equals("")) {
                string2 = string2 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
            }
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var10_16 = null;
            System.out.println("[measureUri ]- " + string2);
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false, "WLThreadPoolTest");
                ArrayList arrayList2 = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList2 = connectionThread.data;
                }
                connectionThread = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (arrayList2 == null || arrayList2.size() == 0) {
                    return null;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    if (string3 == null && string3.length() == 0 || !string3.startsWith("eGurkhaThreadPool")) continue;
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        try {
            string2 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (!this.server.equals("")) {
            string2 = string2 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        }
        try {
            uRL = new URL(string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList3 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList3 = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string4 = (String)arrayList3.get(i);
                if (string4 == null && string4.length() == 0 || !string4.startsWith("eGurkhaThreadPool")) continue;
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        return arrayList;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                String string = "Inside checkForTimeout method << Timeout happened >> ,Due to [ totalSleepTime >= timeout ] condition satisfied ,totalSleepTime :" + l2 + " ,timeout :" + this.timeout + ", so returing false  ";
                System.out.println("[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : " + string);
                this.logToErrorFile("WARNING :", "[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : ", string);
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        String string = "Inside checkForTimeout method << Timeout happened >> ,Due to [ sleepTime <= 0 ] condition satisfied ,sleepTime :" + l3 + ", so returing false  ";
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : " + string);
        this.logToErrorFile("WARNING :", "[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : ", string);
        return false;
    }

    public int discovery() {
        long l;
        this.sh = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), this.isSsl);
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (this.sh.done) {
                return this.sh.version;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                this.sh.stop();
                this.sh = null;
                return 0;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        this.sh.stop();
        this.sh = null;
        return 0;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

