/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WASSIBMsgEngineTest
extends GenericTest {
    private static final int WAS_SIB_MESSAGING_ENGINE_MEASURE_COUNT = 1;
    private String uri = "egurkha/egurkha/EgWebSphere";
    private String webServerPort = "80";
    private String url = "";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String serverHostName = null;
    private String serverName = null;
    private String nodeName = null;
    private String ssl = null;
    public boolean isSsl = false;
    private String reportingNameAndTestName = null;

    public WASSIBMsgEngineTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.webServerPort = this.getValueForParam("appport");
        this.serverHostName = this.getValueForParam("serverhostname");
        this.nodeName = this.getValueForParam("nodename");
        this.serverName = this.getValueForParam("servername");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.ssl = this.getValueForParam("ssl");
        if ("true".equalsIgnoreCase(this.ssl)) {
            this.url = "https://";
            this.isSsl = true;
        } else {
            this.url = "http://";
        }
        this.nodeName = URLEncoder.encode(this.nodeName);
        this.serverHostName = URLEncoder.encode(this.serverHostName);
        this.serverName = URLEncoder.encode(this.serverName);
        this.user = URLEncoder.encode(this.user);
        this.password = EgCrypt.encrypt(this.password, true);
        this.reportingNameAndTestName = this.reportingName + ":" + this.entity;
    }

    public static void main(String[] stringArray) {
        WASSIBMsgEngineTest wASSIBMsgEngineTest = new WASSIBMsgEngineTest(stringArray);
        wASSIBMsgEngineTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.returnMeasures();
        if (arrayList == null || arrayList.size() == 0) {
            this.addNewMeasure(null);
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            String string = (String)arrayList.get(i);
            if (string == null || string.length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.countTokens() < 2) {
                System.out.println("Error in " + this.reportingNameAndTestName + " for line " + string + " for " + this.targetHost + " " + this.portNo);
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            System.out.println(this.reportingNameAndTestName + "  Info :" + string2);
            String string3 = stringTokenizer.nextToken();
            System.out.println(this.reportingNameAndTestName + "  Measure :" + string3);
            stringTokenizer = new StringTokenizer(string3, ",");
            System.out.println(this.reportingNameAndTestName + " st count :" + stringTokenizer.countTokens());
            try {
                if (stringTokenizer.countTokens() != 1) continue;
                String string4 = stringTokenizer.nextToken();
                double d = -5.0;
                d = string4.equalsIgnoreCase("Stopped") ? 0.0 : (string4.equalsIgnoreCase("Started") ? 1.0 : -1.0);
                System.out.println(this.reportingNameAndTestName + " Info :" + string2 + " status :" + string4);
                arrayList2.add(new Double(d));
                System.out.println(this.reportingNameAndTestName + " Info :" + string2 + " Measure ArrayList :" + arrayList2);
                this.addNewMeasure(string2, arrayList2);
                continue;
            }
            catch (Exception exception) {
                System.out.println(this.reportingNameAndTestName + " Exception line is " + string);
                exception.printStackTrace();
            }
        }
    }

    private ArrayList returnMeasures() {
        HttpURLConnection httpURLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.url + this.targetHost + ":" + this.webServerPort;
        String string2 = null;
        try {
            string2 = string + "/" + this.uri + "?module=SIBMessagingEngine&hostname=" + this.serverHostName + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&server=" + this.serverName + "&nodename=" + this.nodeName;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        System.out.println(this.reportingNameAndTestName + " Measure url = " + string2);
        URL uRL = null;
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var10_14 = null;
            try {
                Object object;
                Object object2;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                    object2 = this.user + ":" + EgCrypt.decrypt(this.password);
                    object = Base64Coder.encodeString((String)object2);
                    httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
                }
                httpURLConnection.connect();
                object2 = new ConnectionThread(httpURLConnection, false);
                object = null;
                int n = 0;
                boolean bl = this.checkForTimeout((ConnectionThread)object2);
                if (bl) {
                    n = ((ConnectionThread)object2).code;
                    object = ((ConnectionThread)object2).data;
                }
                object2 = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    if (debug) {
                        System.out.println(this.reportingNameAndTestName + " timing out or invalid response code:" + n);
                    }
                    return null;
                }
                if (object == null || ((ArrayList)object).size() == 0) {
                    if (debug) {
                        System.out.println(this.reportingNameAndTestName + "  data null or empty data");
                    }
                    return null;
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string3 = (String)((ArrayList)object).get(i);
                    arrayList.add(string3);
                }
                System.out.println(this.reportingNameAndTestName + " : SSL enabled IBM WebSphere Application Server ");
                if (((ArrayList)object).size() == arrayList.size()) {
                    System.out.println(this.reportingNameAndTestName + " : All of the content added");
                }
                System.out.println(this.reportingNameAndTestName + " : Content something missed");
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                exception.printStackTrace();
                System.out.println(this.reportingNameAndTestName + " Error " + exception.toString() + " " + uRL.toString());
                return null;
            }
        } else {
            try {
                Object object;
                Object object3;
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                    object3 = this.user + ":" + EgCrypt.decrypt(this.password);
                    object = Base64Coder.encodeString((String)object3);
                    httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
                }
                httpURLConnection.connect();
                object3 = new ConnectionThread(httpURLConnection, false);
                object = null;
                int n = 0;
                boolean bl = this.checkForTimeout((ConnectionThread)object3);
                if (bl) {
                    n = ((ConnectionThread)object3).code;
                    object = ((ConnectionThread)object3).data;
                }
                object3 = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    if (debug) {
                        System.out.println(this.reportingNameAndTestName + " timing out or invalid response code:" + n);
                    }
                    return null;
                }
                if (object == null || ((ArrayList)object).size() == 0) {
                    if (debug) {
                        System.out.println(this.reportingNameAndTestName + "  data null or empty data");
                    }
                    return null;
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string4 = (String)((ArrayList)object).get(i);
                    arrayList.add(string4);
                }
                System.out.println(this.reportingNameAndTestName + " : SSL enabled IBM WebSphere Application Server ");
                if (((ArrayList)object).size() == arrayList.size()) {
                    System.out.println(this.reportingNameAndTestName + " : All of the content added");
                } else {
                    System.out.println(this.reportingNameAndTestName + " : Content something missed");
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                exception.printStackTrace();
                System.out.println(this.reportingNameAndTestName + " Error " + exception.toString() + " " + uRL.toString());
                return null;
            }
        }
        System.out.println(this.reportingNameAndTestName + "  The measures from the jsp are " + arrayList);
        return arrayList;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        if (debug) {
            System.out.println(this.reportingNameAndTestName + " Check for timeout begin:" + System.currentTimeMillis());
        }
        do {
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                if (debug) {
                    System.out.println(this.reportingNameAndTestName + " Executed Successfully :" + System.currentTimeMillis());
                }
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                if (debug) {
                    System.out.println(this.reportingNameAndTestName + "  Timed and killed the thread :" + System.currentTimeMillis());
                }
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                if (debug) {
                    System.out.println(this.reportingNameAndTestName + "   Timed out and hence going to kill the thread :" + System.currentTimeMillis());
                }
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            long l = (long)d;
            string = string + l;
            d -= (double)l;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (long)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

