/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class TftpHelperThread
extends Thread {
    private final byte OP_RRQ = 1;
    private final byte OP_WRT = (byte)2;
    private final byte OP_DATAPACKET = (byte)3;
    private final byte OP_ACK = (byte)4;
    private final byte OP_ERROR = (byte)5;
    private final int PACKET_SIZE = 1024;
    private List datagramChannels;
    private SocketAddress socketAddress;
    private String reportingName = "";
    private String TFTP_SERVER_ADDRESS;
    private String remoteFile;
    private String localFile;
    private String command;
    private int TFTP_SERVER_PORT = 69;
    private int timeout = 30;
    public boolean done = false;
    public int availability = 0;
    public int transferStatus = 0;
    public double totalResponseT = -5.0;

    public TftpHelperThread(String string, int n, String string2, String string3, String string4, int n2, String string5) {
        this.reportingName = string5;
        this.TFTP_SERVER_ADDRESS = string;
        this.TFTP_SERVER_PORT = n;
        this.command = string2;
        this.remoteFile = string3;
        this.localFile = string4;
        this.timeout = n2;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l;
        block34: {
            l = System.currentTimeMillis();
            this.availability = 0;
            Selector selector = this.registerAndRequest(this.remoteFile);
            try {
                if (selector != null) {
                    int n = 0;
                    try {
                        n = selector.select(this.timeout);
                    }
                    catch (Exception exception) {
                        System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] Exception in getting channel");
                        try {
                            if (this.datagramChannels != null && this.datagramChannels.size() > 0) {
                                int n2 = this.datagramChannels.size();
                                for (int i = 0; i < n2; ++i) {
                                    DatagramChannel datagramChannel = (DatagramChannel)this.datagramChannels.get(i);
                                    if (datagramChannel == null) continue;
                                    datagramChannel.close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            if (selector != null) {
                                selector.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    if (n > 0) {
                        this.availability = 100;
                        this.readFiles(selector, this.localFile);
                    } else {
                        this.availability = 0;
                    }
                    break block34;
                }
                this.availability = 0;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (this.datagramChannels != null && this.datagramChannels.size() > 0) {
                        int n = this.datagramChannels.size();
                        for (int i = 0; i < n; ++i) {
                            DatagramChannel datagramChannel = (DatagramChannel)this.datagramChannels.get(i);
                            if (datagramChannel == null) continue;
                            datagramChannel.close();
                        }
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        long l2 = System.currentTimeMillis();
        if (this.availability == 100) {
            this.totalResponseT = (double)(l2 - l) / 1000.0;
        }
        this.done = true;
    }

    private Selector registerAndRequest(String string) {
        Selector selector = null;
        try {
            selector = Selector.open();
            this.socketAddress = new InetSocketAddress(this.TFTP_SERVER_ADDRESS, this.TFTP_SERVER_PORT);
            this.datagramChannels = new ArrayList();
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            SelectionKey selectionKey = null;
            if (this.command.equalsIgnoreCase("get")) {
                selectionKey = datagramChannel.register(selector, 1);
            }
            selectionKey.attach(string);
            this.sendRequest(string, datagramChannel);
            this.datagramChannels.add(datagramChannel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.availability = 0;
            return selector;
        }
        return selector;
    }

    private void sendRequest(String string, DatagramChannel datagramChannel) {
        try {
            String string2 = "octet";
            ByteBuffer byteBuffer = null;
            if (this.command.equalsIgnoreCase("get")) {
                byteBuffer = this.createRequest((byte)1, string, string2);
            }
            int n = datagramChannel.send(byteBuffer, this.socketAddress);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] Exception in sending request...");
            this.availability = 0;
            return;
        }
    }

    private ByteBuffer createRequest(byte by, String string, String string2) {
        int n;
        byte by2 = 0;
        int n2 = 2 + string.length() + 1 + string2.length() + 1;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        byArray[n3] = by2;
        byArray[++n3] = by;
        ++n3;
        for (n = 0; n < string.length(); ++n) {
            byArray[n3] = (byte)string.charAt(n);
            ++n3;
        }
        byArray[n3] = by2;
        ++n3;
        for (n = 0; n < string2.length(); ++n) {
            byArray[n3] = (byte)string2.charAt(n);
            ++n3;
        }
        byArray[n3] = by2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return byteBuffer;
    }

    private void readFiles(Selector selector, String string) {
        try {
            Set<SelectionKey> set = selector.selectedKeys();
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                if (!selectionKey.isAcceptable() && !selectionKey.isConnectable()) {
                    if (selectionKey.isReadable()) {
                        this.receiveFile((DatagramChannel)selectionKey.channel(), string);
                    } else if (selectionKey.isWritable()) {
                        // empty if block
                    }
                }
                iterator.remove();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] Exception in reading");
            this.availability = 0;
            return;
        }
    }

    private void receiveFile(DatagramChannel datagramChannel, String string) {
        try {
            ByteBuffer byteBuffer = null;
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            do {
                byteBuffer = ByteBuffer.allocateDirect(1024);
                SocketAddress socketAddress = datagramChannel.receive(byteBuffer);
                byte[] byArray = new byte[]{byteBuffer.get(0), byteBuffer.get(1)};
                if (byArray[1] == 5) {
                    System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] Type of PACKET Received is ERROR!");
                    this.availability = 0;
                    return;
                }
                if (byArray[1] != 3) continue;
                byte[] byArray2 = new byte[]{byteBuffer.get(2), byteBuffer.get(3)};
                this.readAndWritePacket(byteBuffer, string);
                this.sendAcknowledgment(byArray2, socketAddress, datagramChannel);
            } while (!this.isLastPacket(byteBuffer));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] EXception in receiveFile");
            this.availability = 0;
            return;
        }
    }

    private void readAndWritePacket(ByteBuffer byteBuffer, String string) {
        try {
            byte[] byArray = new byte[1024];
            byteBuffer.flip();
            int n = 0;
            int n2 = 0;
            while (byteBuffer.hasRemaining()) {
                if (n2 > 3) {
                    byArray[n] = byteBuffer.get();
                    ++n;
                } else {
                    byteBuffer.get();
                }
                ++n2;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.writeToFile(string, byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] EXception in readAndWritePacket");
            this.availability = 0;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String string, byte[] byArray) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            if (file.exists()) {
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            } else {
                fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] EXception in writing");
            this.availability = 0;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] EXception in closing FileOutputStream");
                return;
            }
        }
    }

    private boolean isLastPacket(ByteBuffer byteBuffer) {
        return byteBuffer.limit() < 512;
    }

    private void sendAcknowledgment(byte[] byArray, SocketAddress socketAddress, DatagramChannel datagramChannel) {
        try {
            byte[] byArray2 = new byte[]{0, 4, byArray[0], byArray[1]};
            datagramChannel.send(ByteBuffer.wrap(byArray2), socketAddress);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(new Date() + " : " + this.reportingName + " : [TftpTest] EXception in sending acknowledgment");
            this.availability = 0;
            return;
        }
    }
}

