/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SybSpaceTest
extends GenericTest {
    private String user;
    private String passwd;
    private String dbName;
    private String includeDb;
    private String excludeDb;
    private String useProcedure;
    private boolean procedureValue = false;

    public SybSpaceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.dbName = this.getValueForParam("dbName");
        this.includeDb = this.getValueForParam("include_db");
        this.excludeDb = this.getValueForParam("exclude_db");
        this.useProcedure = this.getValueForParam("use_storedprocedure");
        if (this.dbName == null || this.dbName.equalsIgnoreCase("none")) {
            this.dbName = "master";
        }
        if (this.useProcedure == null || this.useProcedure.equalsIgnoreCase("true") || this.useProcedure.equalsIgnoreCase("yes")) {
            this.procedureValue = true;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        SybDbStats sybDbStats = new SybDbStats(this.targetHost, this.portNo, this.dbName, this.user, this.passwd);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        StringTokenizer stringTokenizer = null;
        try {
            Object object;
            if (this.includeDb != null && !this.includeDb.equalsIgnoreCase("none") && !this.includeDb.equalsIgnoreCase("all")) {
                stringTokenizer = new StringTokenizer(this.includeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (arrayList.contains(object)) continue;
                    arrayList.add(object);
                }
            }
            if (this.excludeDb != null && !this.excludeDb.equalsIgnoreCase("none")) {
                stringTokenizer = new StringTokenizer(this.excludeDb, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (arrayList2.contains(object)) continue;
                    arrayList2.add(object);
                }
            }
            if (this.procedureValue) {
                if (sybDbStats.executeDbSpace(arrayList, arrayList2)) {
                    for (int i = 0; i < sybDbStats.dbNames.length; ++i) {
                        ArrayList arrayList3 = sybDbStats.getDbSpaceStats(sybDbStats.dbNames[i]);
                        this.addNewMeasure(sybDbStats.dbNames[i], arrayList3);
                    }
                }
            } else {
                object = sybDbStats.executeDbSpaceUsingQuery(arrayList, arrayList2);
                if (object == null || ((Hashtable)object).size() == 0) {
                    ArrayList<Double> arrayList4 = new ArrayList<Double>();
                    for (int i = 0; i < 6; ++i) {
                        arrayList4.add(new Double(-5.0));
                    }
                    this.addNewMeasure(arrayList4);
                } else {
                    Enumeration enumeration = ((Hashtable)object).keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        ArrayList arrayList5 = (ArrayList)((Hashtable)object).get(string);
                        this.addNewMeasure(string, arrayList5);
                    }
                }
            }
            sybDbStats.close();
            sybDbStats = null;
        }
        catch (Exception exception) {
            sybDbStats.close();
            sybDbStats = null;
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        SybSpaceTest sybSpaceTest = new SybSpaceTest(stringArray);
        sybSpaceTest.computeMeasures(new Hashtable());
    }
}

