/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;

public class StaticDDData {
    private boolean debug = false;
    private String entity;
    private String reportingName;
    private String measureName;
    private String staticDataFileDirectory = EgInstallInfo.getInstallDir() + "/lib/StaticData/";

    public StaticDDData(String string, String string2, String string3, boolean bl) {
        this.entity = string;
        this.reportingName = string2;
        this.measureName = string3;
        this.debug = bl;
    }

    public Hashtable getMeasureData() {
        Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
        String string = this.getStaticDataFilePath();
        if (this.debug) {
            System.out.println(" staticDataFilePath for " + this.reportingName + " <==> " + this.entity + " is " + string);
        }
        if (string != null && string.length() > 0) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (this.debug) {
                        System.out.println("Line is " + string2);
                    }
                    String string3 = string2.substring(0, string2.indexOf("="));
                    String string4 = string2.substring(string2.indexOf("=") + 1);
                    ArrayList<String> arrayList = (ArrayList<String>)hashtable.get(string3);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        arrayList.add(string4);
                        hashtable.put(string3, arrayList);
                        continue;
                    }
                    arrayList.add(string4);
                    hashtable.put(string3, arrayList);
                }
                if (this.debug) {
                    System.out.println("====**======**====**====> DD HT is " + hashtable);
                }
                bufferedReader.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        return hashtable;
    }

    public static double round(double d, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        long l = (long)Math.pow(10.0, n);
        long l2 = Math.round(d *= (double)l);
        return (double)l2 / (double)l;
    }

    public String getStaticDataFilePath() {
        String string = "";
        if (this.entity != null && this.reportingName != null) {
            string = this.staticDataFileDirectory + this.reportingName + "/" + this.entity + "_" + this.measureName + ".txt";
        } else {
            System.err.println("Entity or Reporting Name is NULL");
        }
        return string;
    }

    public static ArrayList parseLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        int n = -1;
        int n2 = string2.indexOf(9);
        while (++n < 4 && n2 != -1) {
            if (n == 1 || n == 3) {
                arrayList.add(string2.substring(0, n2));
            }
            string2 = string2.substring(n2 + 1);
            n2 = string2.indexOf(9);
        }
        if (n == 1 || n == 3) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public double stringToDouble(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    public int stringToInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public double randomInRange(double d, double d2) {
        Random random = new Random();
        double d3 = d2 - d;
        double d4 = random.nextDouble() * d3;
        double d5 = d4 + d;
        return d5;
    }
}

