/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisReplicaTest
extends RedisBase {
    private static final String REDIS_REPLICATION_COMMAND = "Replication";
    private static final String indexSubject = "REDIS_REPLICATION_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_REPLICATION_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private static double previousMastRepOffset = 0.0;
    private static double previousSlavRepOffset = 0.0;
    private static double previousRepBacklogSize = 0.0;
    private static double previousRepBacklogFirByteOff = 0.0;
    private static double previousRepBacklogHistLen = 0.0;
    private static Date modifiedDate;

    public RedisReplicaTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisReplicationTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisReplicationTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisReplicationTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_REPLICATION_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Client Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureForReplication(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureForReplication(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureForReplication]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
            logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
            logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisMeasureForReplication] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureForReplication] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForReplication] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    double d = 0.0;
                    if (object.toString().equalsIgnoreCase("master")) {
                        d = 1.0;
                        logger.debug(this.logPrefix + "[getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + " value: " + d);
                        arrayList.set(n, new Double(d));
                        continue;
                    }
                    if (object.toString().equalsIgnoreCase("slave")) {
                        d = 2.0;
                        logger.debug(this.logPrefix + " [getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + "  value : " + d);
                        arrayList.set(n, new Double(d));
                        continue;
                    }
                    if (object.toString().equalsIgnoreCase("sentinel")) {
                        d = 3.0;
                        logger.debug(this.logPrefix + " [getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + " value : " + d);
                        arrayList.set(n, new Double(d));
                        continue;
                    }
                    try {
                        if (n != 2 && n != 8 && n != 9 && n != 10 && n != 12 && n != 13 && n != 14) {
                            if (n == 4) {
                                String string4 = object.toString();
                                d = string4.equals("up") ? 1.0 : 0.0;
                                logger.debug(this.logPrefix + "[getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + " value : " + d);
                            } else {
                                d = Double.parseDouble(object.toString());
                                d = d == -1.0 ? -5.0 : d;
                                logger.debug(this.logPrefix + "[getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + " value : " + d);
                            }
                            arrayList.set(n, new Double(d));
                            continue;
                        }
                        if (n == 8 || n == 12) {
                            d = Double.parseDouble(EgUtils.convertMemoryValues(object.toString(), "B", "MB"));
                        } else if (n == 9) {
                            double d2 = Double.parseDouble(object.toString());
                            d = d2 >= previousMastRepOffset ? d2 - previousMastRepOffset : d2;
                        } else if (n == 10) {
                            double d3 = Double.parseDouble(object.toString());
                            d = d3 >= previousSlavRepOffset ? d3 - previousSlavRepOffset : d3;
                        } else if (n == 12) {
                            double d4 = Double.parseDouble(object.toString());
                            d = d4 >= previousRepBacklogSize ? d4 - previousRepBacklogSize : d4;
                            previousRepBacklogSize = d4;
                        } else if (n == 13) {
                            double d5 = Double.parseDouble(object.toString());
                            d = d5 >= previousRepBacklogFirByteOff ? d5 - previousRepBacklogFirByteOff : d5;
                        } else if (n == 14) {
                            double d6 = Double.parseDouble(object.toString());
                            d = d6 >= previousRepBacklogHistLen ? d6 - previousRepBacklogHistLen : d6;
                            previousRepBacklogHistLen = d6;
                        }
                        logger.debug(this.logPrefix + "[getRedisMeasureForReplication] index : " + n + " ==> metric name : " + string2 + " value : " + d);
                        arrayList.set(n, new Double(d));
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForReplication] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
                logger.info(this.logPrefix + "[getRedisMeasureForReplication] The ArrayList  measure contains = " + arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureForReplication] ", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisReplicaTest redisReplicaTest = new RedisReplicaTest(stringArray);
        redisReplicaTest.computeMeasures(new Hashtable());
    }
}

