/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class RADLBThroughputTest
extends EgSnmpGenericTest {
    private static final int RADLBTHROUGHPUTTEST_MEASURECOUNT = 3;

    public RADLBThroughputTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(3);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = this.getMeasure(".1.3.6.1.4.1.1872.2.5.1.2.12.2");
            String string2 = this.getMeasure(".1.3.6.1.4.1.1872.2.5.1.2.12.4");
            String string3 = this.getMeasure(".1.3.6.1.4.1.1872.2.5.1.2.12.6");
            double d = -5.0;
            if (string == null || string.trim().length() == 0) {
                string = "-5";
            } else {
                try {
                    double d2 = Double.parseDouble(string);
                    if (d2 > 0.0) {
                        d = d2 / 8192.0;
                    }
                }
                catch (Exception exception) {
                    d = -5.0;
                }
            }
            if (string2 == null || string2.trim().length() == 0) {
                string2 = "-5";
            }
            if (string3 == null || string3.trim().length() == 0) {
                string3 = "-5";
            }
            if (string2.trim().endsWith("CPS")) {
                string2 = this.splitUnit(string2);
            }
            if (string3.trim().endsWith("Mbps")) {
                string3 = this.splitUnit(string3);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(string2));
            arrayList.add(new Double(string3));
            System.out.println(this.entity + ",measureList====>" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",error occur in computeMeasure", exception.toString());
            exception.printStackTrace();
        }
    }

    private String splitUnit(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.countTokens() == 2) {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "-5";
        }
        return string2;
    }

    private String getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        RADLBThroughputTest rADLBThroughputTest = new RADLBThroughputTest(stringArray);
        try {
            rADLBThroughputTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

