/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PSAppTuxSvcTest
extends GenericTest {
    int i_measureCnt = 2;
    private ArrayList al_fileData;
    private Properties p_prev;
    private Double D_minusOne = new Double(-1.0);
    private Double D_hundredPercent = new Double(100.0);
    private Double D_zero = new Double(0.0);
    private static final long msPerSecond = 1000L;

    public PSAppTuxSvcTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.i_measureCnt);
        this.clearLocFile();
    }

    private void clearLocFile() {
        try {
            String string = this.getValueForParam("APPNAME");
            String string2 = EgConfigInfo.egAgentConfigDir + string + ".read.loc";
            File file = new File(string2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = this.getValueForParam("APPNAME");
        this.al_fileData = new ArrayList();
        this.readFile(string);
        Properties properties = this.getMetrics();
        if (properties == null || properties.size() == 0) {
            this.logToErrorFile("Error", "PSAppTuxSvcTest", "Could not get service metrics for app - " + string);
            return;
        }
        if (this.p_prev == null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Properties properties2 = (Properties)properties.get(string2);
                String string3 = properties2.getProperty("STATUS");
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (string3.equals("AVAIL")) {
                    arrayList.add(this.D_hundredPercent);
                } else {
                    arrayList.add(this.D_zero);
                }
                arrayList.add(this.D_minusOne);
                this.addNewMeasure(string2, arrayList);
            }
            this.p_prev = properties;
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string4 = (String)enumeration.nextElement();
            Properties properties3 = (Properties)properties.get(string4);
            Properties properties4 = (Properties)this.p_prev.get(string4);
            if (properties3 == null || properties3.size() == 0) {
                object = new ArrayList<Double>();
                ((ArrayList)object).add(this.D_minusOne);
                ((ArrayList)object).add(this.D_minusOne);
                this.addNewMeasure(string4, (ArrayList)object);
                continue;
            }
            if (properties4 == null || properties4.size() == 0) {
                object = new ArrayList();
                String string5 = properties3.getProperty("STATUS");
                if (string5.equals("AVAIL")) {
                    ((ArrayList)object).add(this.D_hundredPercent);
                } else {
                    ((ArrayList)object).add(this.D_zero);
                }
                ((ArrayList)object).add(this.D_minusOne);
                this.addNewMeasure(string4, (ArrayList)object);
                continue;
            }
            object = properties3.getProperty("STATUS");
            double d = Double.parseDouble(properties3.getProperty("REQDONE"));
            double d2 = Double.parseDouble(properties4.getProperty("REQDONE"));
            double d3 = -1.0;
            double d4 = d - d2;
            if (d4 > -1.0) {
                d3 = d4 / this.timeSinceLastTest;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (((String)object).equals("AVAIL")) {
                arrayList.add(this.D_hundredPercent);
            } else {
                arrayList.add(this.D_zero);
            }
            arrayList.add(new Double(d3));
            this.addNewMeasure(string4, arrayList);
        }
        this.p_prev = properties;
    }

    private long getDiffInSeconds(Date date, Date date2) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = -1L;
        l3 = l - l2 >= 0L ? (l - l2) / 1000L : (l2 - l) / 1000L;
        return l3;
    }

    private void readFile(String string) {
        String string2 = EgConfigInfo.egAgentConfigDir + string + ".write.loc";
        String string3 = EgConfigInfo.egAgentConfigDir + string + ".read.loc";
        String string4 = EgConfigInfo.egAgentConfigDir + string + ".psc";
        int n = 1000;
        try {
            File file = new File(string2);
            int n2 = 0;
            while (file.exists()) {
                try {
                    System.out.println("The program is writing the file that i am supposed to read. So waiting for it to finish....");
                    Thread.sleep(50L);
                    if ((n2 += 50) < n) continue;
                    this.logToErrorFile("INFO", "PSAppTuxSvcTest", "Waited too long to read the file but it still locked. Giving up....");
                    return;
                }
                catch (Exception exception) {
                }
            }
            File file2 = new File(string3);
            while (!file2.createNewFile()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            File file3 = new File(string4);
            if (file3.exists()) {
                long l = file3.lastModified();
                long l2 = this.getDiffInSeconds(new Date(), new Date(l));
                if ((double)l2 > 2.0 * this.timeSinceLastTest) {
                    this.logToErrorFile("ERROR", "PSAppTuxSvcTest", "File to be read - " + string + ".psc - is not getting updated.");
                    if (file2.exists()) {
                        file2.delete();
                    }
                    return;
                }
            } else {
                this.logToErrorFile("ERROR", "PSAppTuxSvcTest", "File to be read - " + string + ".psc - does not exists.");
                if (file2.exists()) {
                    file2.delete();
                }
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string4)));
            String string5 = "";
            while ((string5 = bufferedReader.readLine()) != null) {
                System.out.println(string5);
                this.al_fileData.add(string5);
            }
            if (file2.exists()) {
                file2.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Properties getMetrics() {
        if (this.al_fileData == null || this.al_fileData.size() == 0) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < this.al_fileData.size(); ++i) {
            String string = (String)this.al_fileData.get(i);
            if (string.startsWith(">") || string.startsWith("-") || string.equals("")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("+") != -1) {
                string2 = string2.substring(0, string2.indexOf("+"));
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            String string8 = stringTokenizer.nextToken();
            String string9 = stringTokenizer.nextToken();
            String string10 = string7 + "_" + string4 + "_" + string2 + "_" + string6;
            Properties properties2 = new Properties();
            properties2.setProperty("STATUS", string9);
            properties2.setProperty("REQDONE", string8);
            properties.put(string10, properties2);
        }
        return properties;
    }
}

