/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTempTbsTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private static final int TEMP_DATAFILES_MEASURE_COUNT = 6;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isAboveOracle10G = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public OraTempTbsTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(6);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        if ((string = this.getValueForParam("cloud_hosted")) != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isAboveOracle10G = n > 10;
                this.isInitCheckNeeded = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        string = "";
        try {
            string = !this.isAboveOracle10G ? "select ss.tablespace_name,dtf.max_size_mb total_size_mb,(allocated_blocks*ss.block_size)/1024/1024 allocated_size_mb,(ss.free_blocks*ss.block_size)/1024/1024 free_allocated_size_mb from (select tablespace_name,used_blocks,free_blocks,(used_blocks+free_blocks) allocated_blocks,(select value from v$parameter where lower(name)='db_block_size') block_size from v$sort_segment) ss,(select tablespace_name, sum(maxbytes)/1024/1024 Max_Size_MB from dba_temp_files group by tablespace_name) dtf where ss.tablespace_name = dtf.tablespace_name" : "select A.TABLESPACE_NAME,B.MAXSIZE_MB TOTAL_SIZE_MB,ROUND(A.TABLESPACE_SIZE / 1048576 ) ALLOCATED_SIZE_MB,ROUND(A.FREE_SPACE / 1048576 ) FREE_ALLOCATED_SIZE_MB from dba_temp_free_space a,(select tablespace_name,round(sum(maxbytes / 1048576)) MAXSIZE_MB FROM DBA_TEMP_FILES GROUP BY TABLESPACE_NAME ) B WHERE A.TABLESPACE_NAME=B.TABLESPACE_NAME";
            object2 = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (object2 == null) {
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            return;
        }
        try {
            statement = object2.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraTempTbsTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            this.closeConn((Connection)object2);
            return;
        }
        try {
            try {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                object = statement.executeQuery(string);
                while (object.next()) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    string2 = object.getString(1);
                    string3 = object.getString(2);
                    string4 = object.getString(3);
                    string5 = object.getString(4);
                    double d4 = this.stringToDouble(string3);
                    double d5 = this.stringToDouble(string4);
                    d = this.stringToDouble(string5);
                    double d6 = 0.0;
                    if (d5 >= 0.0 && d >= 0.0) {
                        d6 = d5 > d ? d5 - d : d - d5;
                    }
                    if (d4 > 0.0) {
                        d2 = d4 - d6;
                        d3 = d2 / d4 * 100.0;
                    } else if (d5 > 0.0) {
                        d3 = d / d5 * 100.0;
                    }
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    if (debug) {
                        System.out.println("[OraTempTbsTest]info======>" + string2 + "output" + arrayList);
                    }
                    this.addNewMeasure(string2, arrayList);
                }
                Object var25_23 = null;
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                System.out.println("Exception Occured in OraTempTbsTest.computeMeasures():" + exception.toString());
                Object var25_24 = null;
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn((Connection)object2);
            }
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn((Connection)object2);
            throw throwable;
        }
    }

    public double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTempTbsTest oraTempTbsTest = new OraTempTbsTest(stringArray);
        oraTempTbsTest.computeMeasures(new Hashtable());
    }
}

