/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraExaBase
extends GenericTest {
    EgUtilities egutil = EgUtilities.createInstance();
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final Double DEFAULT_MINUS_FIVE = new Double(-5.0);
    protected static final double MINUS_FIVE = -5.0;
    protected static final int ZERO = 0;
    protected static final String DELIMITER = ":";
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    protected static final String CELLCLI = "cellcli -e list ";
    protected static final String STORAGE_CELL_DETAILS_COMMAND = "cellcli -e list cell detail";
    protected static final String STORAGE_CELLDISK_DETAILS_COMMAND = "cellcli -e list celldisk detail";
    protected static final String STORAGE_PHYSICALDISK_DETAILS_COMMAND = "cellcli -e list physicaldisk detail";
    protected static final String STORAGE_GRIDDISK_DETAILS_COMMAND = "cellcli -e list griddisk detail";
    protected static final String STORAGE_FLASHCACHE_DETAILS_COMMAND = "cellcli -e list flashcache detail";
    protected static final String STORAGE_FLASHLOG_DETAILS_COMMAND = "cellcli -e list flashlog detail";
    protected static final String STORAGE_ALERTHISTORY_DETAILS_COMMAND = "cellcli -e list alerthistory detail";
    protected static final String STORAGE_METRICCURRENT_CELL_COMMAND = "cellcli -e list metriccurrent attributes name ,metricObjectName,metricValue where objectType='CELL'";
    protected static final String STORAGE_METRICCURRENT_CELLDISK_COMMAND = "cellcli -e list metriccurrent attributes name ,metricObjectName,metricValue where objectType='CELLDISK'";
    protected static final String STORAGE_METRICCURRENT_FLASHCACHE_COMMAND = "cellcli -e list metriccurrent attributes name ,metricValue where objectType='FLASHCACHE'";
    protected static final String STORAGE_METRICCURRENT_HOST_INTERCONNECT_COMMAND = "cellcli -e list metriccurrent attributes name ,metricObjectName,metricValue where objectType='HOST_INTERCONNECT'";
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "OraExaBase";
    protected static final String LOG_FILE_NAME = "OraExaBaseLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "OraExaBaseLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "OraExaBaseLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double MB_TO_TB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 10.0;
    protected double debugLogSizeLimitInMB = 1.048576E7;
    protected static final double DAY = 86400.0;
    protected static final double HOUR = 3600.0;
    protected static final double MINUTES = 60.0;
    protected static final String OUTPUT_NULL_OR_EMPTY_INFO_MESSAGE = "Output is null or size is zero or empty";
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    int sshPortNo = 22;
    String typ = "ssh";
    protected String userName = null;
    protected String password = null;
    protected int cmd_time_out = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraExaBase(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        this.fixedTestPeriod = true;
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        if (this.targetHost == null || this.targetHost.trim().length() == 0) {
            this.logMessage = string + "Target host value null or empty";
            this.printOut(this.logMessage);
            this.logMessage = "";
        } else {
            this.logMessage = string + "Oracle Exadata Storage HOST :" + this.targetHost;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        this.userName = this.getValueForParam("username");
        if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase(NULL) || this.userName.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "Oracle Exadata Storage  User name is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        } else {
            this.logMessage = string + "Oracle Exadata Storage User name :" + this.userName;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        this.password = this.getValueForParam("password");
        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "Oracle Exadata Storage  password is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        } else {
            this.logMessage = string + "Oracle Exadata Storage  Password  :*******";
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        String string2 = this.getValueForParam("ssh_port");
        if (string2 == null || string2.trim().length() == 0 || string2.equalsIgnoreCase(NULL) || string2.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "SSH port is null or empty ,so assinging 22 default port";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            string2 = "22";
        } else {
            this.logMessage = string + "Oracle Exadata Storage SSH Port   :" + string2;
            this.printOut(this.logMessage);
            this.logMessage = "";
            try {
                this.sshPortNo = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.sshPortNo = 22;
            }
            this.logMessage = string + "Oracle Exadata Storage SSH Port (After parse)  :" + string2;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        String string3 = this.getValueForParam("timeout_seconds");
        if (string3 != null && string3.trim().length() > 0) {
            this.logMessage = string + "Timeout string value in constructor : " + string3;
            this.printOut(this.logMessage);
            this.logMessage = "";
            try {
                this.cmd_time_out = Integer.parseInt(string3);
                this.printOut(string + "Timeout value in constructor(After parse) : " + string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.cmd_time_out = 60;
                this.logMessage = string + "Timeout value parsing error ,so assigning default value : " + this.cmd_time_out;
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
        } else {
            this.logMessage = string + "Timeout value not provided by parameter ,so assigning default value : " + this.cmd_time_out;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
        this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
        if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
            this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
            try {
                this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                this.debugLogSizeLimitInMB *= 1048576.0;
                this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
            }
            catch (Exception exception) {
                this.printOut(string + "Conversion error for strLogSizeLimitInMB value to bytes : " + this.strLogSizeLimitInMB + " ,exception :" + exception.toString());
                this.debugLogSizeLimitInMB = 1.048576E7;
            }
        } else {
            this.debugLogSizeLimitInMB = 1.048576E7;
        }
        if (fieldSep.length() == 0) {
            String string4 = sync0;
            synchronized (string4) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    protected ArrayList getCellDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_CELL_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getCellDiskDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_CELLDISK_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getPhysicalDiskDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_PHYSICALDISK_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getGriddiskDiskDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_GRIDDISK_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getFlashCacheDiskDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_FLASHCACHE_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getFlashLogDiskDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_FLASHLOG_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getAlertHistoryDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_ALERTHISTORY_DETAILS_COMMAND);
        return arrayList;
    }

    protected ArrayList getCellMetricCurrentDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_METRICCURRENT_CELL_COMMAND);
        return arrayList;
    }

    protected ArrayList getCellDiskMetricCurrentDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_METRICCURRENT_CELLDISK_COMMAND);
        return arrayList;
    }

    protected ArrayList getFlashCacheMetricCurrentDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_METRICCURRENT_FLASHCACHE_COMMAND);
        return arrayList;
    }

    protected ArrayList getHostInterconnectMetricCurrentDetails() {
        ArrayList arrayList = this.collectMeasures(STORAGE_METRICCURRENT_HOST_INTERCONNECT_COMMAND);
        return arrayList;
    }

    protected ArrayList collectMeasures(String string) {
        String string2 = "collectMeasures";
        string2 = this.methodNameTemplate(string2);
        long l = System.currentTimeMillis();
        ArrayList arrayList = null;
        try {
            if (this.targetHost == null || this.targetHost.trim().length() == 0) {
                this.logMessage = string2 + "Target host value null or empty";
                this.printOut(this.logMessage);
                return null;
            }
            arrayList = this.cmdExecToOraExa(this.typ, this.targetHost, this.sshPortNo, this.userName, this.password, string);
            this.printOut(string2 + "Command output for the command \"" + string + "\"   : " + arrayList);
            if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
                this.logMessage = string2 + "Output is null or empty ,so test returning ";
                this.printOut(this.logMessage);
                this.logMessage = "";
                return null;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)arrayList.get(i);
                this.printOut(string2 + "String line  :" + string3);
            }
            this.logMessage = string2 + "Total time to took to complete the process to collect the command output  " + string + " : " + (System.currentTimeMillis() - l) + " ms";
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Error occured ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
        return arrayList;
    }

    private ArrayList cmdExecToOraExa(String string, String string2, int n, String string3, String string4, String string5) {
        long l = System.currentTimeMillis();
        String string6 = "cmdExecToOraExa";
        string6 = this.methodNameTemplate(string6);
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution starts for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        ArrayList arrayList = null;
        try {
            if (string.equalsIgnoreCase("ssh")) {
                if (EgMainAgent.bUseJavaSshForRemoteAgent) {
                    EgJavaSSH egJavaSSH = new EgJavaSSH(string2, n, string3, string4, (long)this.cmd_time_out);
                    ArrayList arrayList2 = egJavaSSH.executeCommand(string5);
                    ArrayList arrayList3 = new ArrayList();
                    if (arrayList2 != null) {
                        arrayList = (ArrayList)arrayList2.get(0);
                        arrayList3 = (ArrayList)arrayList2.get(1);
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            this.logMessage = string6 + "errorArrayList value greator than zero, so printing Error Message :" + arrayList3 + ",And All output :" + arrayList;
                            this.putErrorMessageToLogfile(this.logMessage);
                            this.logMessage = "";
                        }
                    }
                } else {
                    arrayList = EgSSHUtil.getExecResults(string2, n, string3, string4, string5);
                }
            } else if (string.equalsIgnoreCase("rexec")) {
                arrayList = EgRexecUtil.getExecResults(string2, n, string3, string4, string5);
            }
            if (arrayList == null) {
                this.logMessage = string6 + "Could not execute the command, Please verify the username/password or network ";
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
            if (arrayList.size() == 0) {
                this.logMessage = string6 + " ArrayList size is  less than zero   " + string5 + " for " + this.targetHost;
                this.putErrorMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return null;
            }
        }
        catch (Exception exception) {
            this.logMessage = string6 + "Problem while executing the command " + string5 + " for " + this.targetHost;
            this.logMessage = "";
            this.printOutStackTrace(this.logMessage, exception);
            arrayList = null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.logMessage = string6 + "Command \"" + string5 + "\"  execution ends for the Host :" + string2 + " , Port :" + n + " with User :" + string3;
        this.printOut(this.logMessage);
        this.logMessage = "";
        this.logMessage = string6 + " Total time(millis) took to execute " + l3 + "  for the command  " + string5;
        this.printOut(this.logMessage);
        this.logMessage = "";
        return arrayList;
    }

    protected double getCellDiskSpaceUtilisationSpacePct(double d, double d2) {
        String string = "getCellDiskSpaceUtilisationSpacePct";
        string = this.methodNameTemplate(string);
        double d3 = 0.0;
        double d4 = 0.0;
        if (d >= 0.0 && d < d2 && d2 > 0.0) {
            d3 = d2 - d;
            d4 = d3 / d2;
            d4 *= 100.0;
        } else {
            this.printOut(string + "Assigning zero due to free space :" + d + " and Total space:" + d2 + " so Assigning zero");
            d4 = 0.0;
        }
        return d4;
    }

    protected double getFlashCacheStatusPctOfUsage(double d, double d2) {
        String string = "getFlashCacheStatusPctOfUsage";
        string = this.methodNameTemplate(string);
        double d3 = 0.0;
        try {
            d3 = d / d2 * 100.0;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string, exception);
        }
        return d3;
    }

    private String getString(String string, String string2) {
        String string3 = "getString";
        string3 = this.methodNameTemplate(string3);
        String string4 = null;
        if ((string = this.validateString(string, HYPHEN)).equalsIgnoreCase(HYPHEN)) {
            return string4;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
        }
        catch (Exception exception) {
            this.logMessage = string3 + "Error occured ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            return null;
        }
        if (string4 != null && string4.trim().length() > 0) {
            string4 = string4.trim();
        }
        return string4;
    }

    protected double getMBToTBConverter(double d) {
        String string = "getMBToTBConverter";
        string = this.methodNameTemplate(string);
        if (d > 0.0) {
            d /= 1048576.0;
            d = this.roundDouble(d, 2);
        }
        this.printOut(string + " Value :" + d);
        return d;
    }

    protected double roundDouble(double d) {
        double d2 = 0.0;
        int n = 2;
        d2 = this.roundDouble(d, n);
        return d2;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + HYPHEN;
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.putErrorMessageToLogfile("Error in  roundDouble method :" + exception.toString());
        }
        this.printOut(string + "  roundDouble method value :" + d2);
        return d2;
    }

    protected double convertToDouble(String string) {
        String string2 = "convertToDouble";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (string != null && string.trim().length() > 0 && !string.equalsIgnoreCase(NULL) && !string.equalsIgnoreCase(NONE)) {
            if ((string = this.validateString(string)).equalsIgnoreCase(HYPHEN)) {
                return d;
            }
        } else {
            return d;
        }
        try {
            d = EgLangInfo.getDoubleValue(string, true);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    protected String validateString(String string) {
        return this.validateString(string, HYPHEN);
    }

    protected String validateString(String string, String string2) {
        String string3 = string2;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE)) {
            string3 = string2;
        } else {
            try {
                string3 = string.trim();
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    protected ArrayList getTokenString(String string, String string2) {
        String string3 = "getTokenString";
        string3 = this.methodNameTemplate(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string3, exception);
        }
        this.printOut(string3 + "Tokens :" + arrayList);
        return arrayList;
    }

    protected double getNumberOfTokens(String string, String string2) {
        String string3 = "getNumberOfTokens";
        string3 = this.methodNameTemplate(string3);
        double d = 1.0;
        try {
            if (!this.isStringNull(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
                d = stringTokenizer.countTokens();
            } else {
                d = 0.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string3, exception);
        }
        this.printOut(string3 + "Number Of Tokens :" + d + "[ String :'" + string + "' & Delimiter :" + string2 + " ]");
        return d;
    }

    protected double getStatusValue(String string) {
        String string2 = "getStatusValue";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (!this.isStringNull(string)) {
            if (string.equalsIgnoreCase("normal")) {
                d = 100.0;
            } else if (string.equalsIgnoreCase("running")) {
                d = 100.0;
            } else if (string.equalsIgnoreCase("on")) {
                d = 100.0;
            } else if (string.equalsIgnoreCase("Stopped")) {
                d = 0.0;
            } else if (string.equalsIgnoreCase("off")) {
                d = 0.0;
            } else if (string.equalsIgnoreCase("online")) {
                d = 100.0;
            } else if (string.equalsIgnoreCase("Offline")) {
                d = 0.0;
            } else if (string.equalsIgnoreCase("poor performance")) {
                d = 90.0;
            } else if (string.equalsIgnoreCase("write-through caching")) {
                d = 80.0;
            } else if (string.equalsIgnoreCase("predictive failure")) {
                d = 70.0;
            } else if (string.equalsIgnoreCase("peer failure")) {
                d = 60.0;
            } else if (string.equalsIgnoreCase("failed")) {
                d = 50.0;
            } else if (string.equalsIgnoreCase("not present")) {
                d = 0.0;
            } else if (string.equalsIgnoreCase("active")) {
                d = 100.0;
            } else if (string.equalsIgnoreCase("importRequired")) {
                d = 90.0;
            } else if (string.equalsIgnoreCase("inactive")) {
                d = 50.0;
            } else if (string.equalsIgnoreCase("warning")) {
                d = 90.0;
            } else if (string.equalsIgnoreCase("critical")) {
                d = 50.0;
            }
        } else {
            d = 0.0;
        }
        this.printOut(string2 + "Status '" + string + "' Converted to '" + d + "'");
        return d;
    }

    protected String getDataAndValue(String string) {
        String string2 = "getDataAndValue";
        string2 = this.methodNameTemplate(string2);
        String string3 = "";
        String string4 = "";
        if (!this.isStringNull(string) && string.contains(DELIMITER)) {
            int n = string.length();
            int n2 = 0;
            if (string.contains(DELIMITER)) {
                n2 = string.indexOf(DELIMITER);
            }
            string3 = string.substring(0, n2);
            string3 = string3.trim();
            string4 = string.substring(n2 + 1, n);
            string4 = string4.trim();
            this.printOut(string2 + "Key = " + string3 + " , Value = " + string4);
            return string4;
        }
        this.printOut(string2 + "Invalid data for the substring process");
        return null;
    }

    protected double getSizeFromString(String string) {
        String string2 = "getSizeFromString";
        string2 = this.methodNameTemplate(string2);
        String string3 = string;
        double d = 0.0;
        if (this.isStringNull(string3)) {
            d = -5.0;
            this.printOut(string2 + "Error due to value :" + string3);
        } else {
            int n = string3.length();
            string3 = string3.substring(0, n - 1);
            d = this.convertToDouble(string3);
            d = this.roundDouble(d, 4);
        }
        return d;
    }

    protected String getSizeTypeFromString(String string) {
        String string2 = "getSizeTypeFromString";
        string2 = this.methodNameTemplate(string2);
        String string3 = string;
        String string4 = "";
        String string5 = "";
        try {
            if (this.isStringNull(string3)) {
                string4 = "";
                this.printOut(string2 + "Error due to value :" + string3);
            } else {
                int n = string3.length();
                string4 = string3.substring(n - 1);
                string4 = string4.trim();
                this.printOut(string2 + "Memory type from string is '" + string4 + "'");
                if (string4.equalsIgnoreCase("T")) {
                    string5 = "TB";
                } else if (string4.equalsIgnoreCase("G")) {
                    string5 = "GB";
                } else if (string4.equalsIgnoreCase("M")) {
                    string5 = "MB";
                } else if (string4.equalsIgnoreCase("K")) {
                    string5 = "KB";
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2, exception);
        }
        return string5;
    }

    protected double getCalculatedSize(double d, String string, String string2) {
        String string3 = "getCalculatedSize";
        string3 = this.methodNameTemplate(string3);
        double d2 = 0.0;
        try {
            if (d < 0.0) {
                d2 = d;
                this.printOut(string3 + "Due to negative value  :" + d + " ,returning ");
                return d2;
            }
            if (string.equalsIgnoreCase(string2)) {
                d2 = d;
                this.printOut(string3 + "Convertion :" + d + string + " to " + d2 + string2);
                return d2;
            }
            if (string.equalsIgnoreCase("kb") && string2.equalsIgnoreCase("mb")) {
                d2 = d / 1024.0;
            } else if (string.equalsIgnoreCase("kb") && string2.equalsIgnoreCase("gb")) {
                d2 = d / 1048576.0;
            } else if (string.equalsIgnoreCase("kb") && string2.equalsIgnoreCase("tb")) {
                d2 = d / 1.073741824E9;
            } else if (string.equalsIgnoreCase("mb") && string2.equalsIgnoreCase("kb")) {
                d2 = d * 1024.0;
            } else if (string.equalsIgnoreCase("mb") && string2.equalsIgnoreCase("gb")) {
                d2 = d / 1024.0;
            } else if (string.equalsIgnoreCase("mb") && string2.equalsIgnoreCase("tb")) {
                d2 = d / 1048576.0;
            } else if (string.equalsIgnoreCase("gb") && string2.equalsIgnoreCase("kb")) {
                d2 = d * 1024.0 * 1024.0;
            } else if (string.equalsIgnoreCase("gb") && string2.equalsIgnoreCase("mb")) {
                d2 = d * 1024.0;
            } else if (string.equalsIgnoreCase("gb") && string2.equalsIgnoreCase("tb")) {
                d2 = d / 1024.0;
            } else if (string.equalsIgnoreCase("tb") && string2.equalsIgnoreCase("kb")) {
                d2 = d * 1024.0 * 1024.0 * 1024.0;
            } else if (string.equalsIgnoreCase("tb") && string2.equalsIgnoreCase("mb")) {
                d2 = d * 1024.0 * 1024.0;
            } else if (string.equalsIgnoreCase("tb") && string2.equalsIgnoreCase("gb")) {
                d2 = d * 1024.0;
            }
            d2 = this.roundDouble(d2, 4);
            this.printOut(string3 + "Convertion :" + d + string + " to " + d2 + string2);
        }
        catch (Exception exception) {
            this.printOut(string3 + " Error in Conversion :" + d + string + " to " + string2 + ",So returning zero");
            this.printOutStackTrace(string3, exception);
        }
        return d2;
    }

    protected double convertMicroSecondToMilliSecond(double d) {
        String string = "convertMicrSecondToMilliSecond";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        if (!(d >= 0.0)) {
            this.printOut(string + "Due to negative value  :" + d + " ,returning ");
            d2 = d;
            return d2;
        }
        d2 = d / 1000.0;
        d2 = this.roundDouble(d2, 4);
        this.printOut(string + "Microsecond value :" + d + " converted to Milliseconds :" + d2);
        return d2;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaBase.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaBase.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaBase.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            OraExaBase.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            OraExaBase.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            String string = EgCrypt.decrypt(stringArray[i + 1]);
            if (string.indexOf("~EG~") != -1) {
                string = string.substring(0, string.indexOf("~EG~"));
            }
            stringArray[i + 1] = string.trim();
            break;
        }
        OraExaBase oraExaBase = new OraExaBase(stringArray);
        oraExaBase.getCellDetails();
        oraExaBase.getCellDiskDetails();
        oraExaBase.getPhysicalDiskDetails();
        oraExaBase.getGriddiskDiskDetails();
        oraExaBase.getFlashCacheDiskDetails();
        oraExaBase.getFlashLogDiskDetails();
        oraExaBase.getAlertHistoryDetails();
        oraExaBase.getCellMetricCurrentDetails();
        oraExaBase.getCellDiskMetricCurrentDetails();
        oraExaBase.getFlashCacheMetricCurrentDetails();
        oraExaBase.getHostInterconnectMetricCurrentDetails();
    }
}

