/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeMemory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class NodeMemoryTest
extends NodeBase {
    public static final String[] propsOrder = new String[]{"enable_memory_profiling", "memory_dump_location"};
    private HashMap workers = null;
    private ArrayList<String> memeoryDumpFilesList;

    public NodeMemoryTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            logger.info("{} Initializing NodeMemoryTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{}  NodeMemoryTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.error("{}  Exception while initializing NodeMemoryTest {} ", (Object)this.logPrefix, (Object)exception);
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        logger.debug("{} - params {} ", (Object)this.logPrefix, (Object)hashtable);
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String string = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            ArrayList<Double> arrayList;
            logger.debug("{} - params {} ", (Object)this.logPrefix, (Object)hashtable.toString());
            this.checkForPropsChanges(propsOrder);
            if (!NodeDataRepository.isInfraIdExists(string)) {
                logger.debug("{}  siteId: {}  is not available", (Object)this.logPrefix, (Object)string);
                return;
            }
            int n = 0;
            if (NodeDataRepository.isInfraIdExists(string)) {
                n = NodeDataRepository.getInfraById(string).getWorkerCount();
            }
            NodeInfraCluster nodeInfraCluster = NodeDataRepository.getInfraById(string);
            NodeInfra nodeInfra = nodeInfraCluster.getMaster();
            NodeMemory nodeMemory = null;
            if (nodeInfra != null) {
                nodeMemory = nodeInfra.getMemoryUsage();
            }
            try {
                this.memeoryDumpFilesList = nodeInfraCluster.cloneMemoryDumpList();
                nodeInfraCluster.clearMemoryDumpList();
                logger.debug("{} siteId: {} memory dump list size : {}", new Object[]{this.logPrefix, string, this.memeoryDumpFilesList.size()});
            }
            catch (Exception exception) {
                logger.error("{} siteId: {} error while collecting memory dump list  : {} ", new Object[]{this.logPrefix, string, exception});
            }
            if (nodeMemory != null) {
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(nodeMemory.getPhysical()));
                arrayList.add(new Double(nodeMemory.getMax_heap()));
                arrayList.add(new Double(nodeMemory.getHeap_used()));
                arrayList.add(new Double(nodeMemory.getFree_heap()));
                arrayList.add(new Double(nodeMemory.getHeap_used() * 100.0 / nodeMemory.getMax_heap()));
                arrayList.add(new Double(nodeMemory.getNon_heap()));
                arrayList.add(new Double(-5.0));
                if (n > 0) {
                    this.addNewMeasure("Master", arrayList);
                } else {
                    this.addNewMeasure(arrayList);
                }
                nodeInfra.setMemoryUsage(null);
                logger.debug("{}  Master - measures: {}", (Object)this.logPrefix, arrayList);
            } else {
                logger.debug("{} {}  Master - measure is null", (Object)this.logPrefix, (Object)string);
            }
            this.workers = nodeInfraCluster.getWorkers();
            if (this.workers != null && this.workers.size() > 0) {
                nodeMemory = NodeDataRepository.aggregateMemory(this.workers);
                if (nodeMemory != null) {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(nodeMemory.getPhysical()));
                    arrayList.add(new Double(nodeMemory.getMax_heap()));
                    arrayList.add(new Double(nodeMemory.getHeap_used()));
                    arrayList.add(new Double(nodeMemory.getFree_heap()));
                    arrayList.add(new Double(nodeMemory.getHeap_used() * 100.0 / nodeMemory.getMax_heap()));
                    arrayList.add(new Double(nodeMemory.getNon_heap()));
                    arrayList.add(new Double(nodeInfraCluster.getWorkerCount()));
                    this.addNewMeasure("Workers", arrayList);
                    logger.debug("{}  Worker - measures: {} ", (Object)this.logPrefix, arrayList);
                } else {
                    logger.debug(" {} {}  Worker - Memory is null", (Object)this.logPrefix, (Object)string);
                }
            } else {
                logger.debug("{} {} Worker - measure is null", (Object)this.logPrefix, (Object)string);
            }
        }
        catch (Exception exception) {
            logger.debug("{} Exception occured while collecting Memory : {} ", (Object)this.logPrefix, (Object)exception);
        }
    }

    public HashMap getWorkers() {
        return this.workers;
    }

    public void setWorkers(HashMap hashMap) {
        this.workers = hashMap;
    }

    public ArrayList<String> getMemeoryDumpFilesList() {
        return this.memeoryDumpFilesList;
    }

    public void setMemeoryDumpFilesList(ArrayList<String> arrayList) {
        this.memeoryDumpFilesList = arrayList;
    }
}

