/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class NAUSDVolTest
extends NAUSDBase {
    private Hashtable prevPerfHT = null;
    public Hashtable Utilized_dd = new Hashtable();
    public Hashtable Busy_dd = new Hashtable();
    public Hashtable slow_dd = new Hashtable();
    private ArrayList top10Utilized = new ArrayList();
    private ArrayList top10PctUsed = new ArrayList();
    private ArrayList top10Busy = new ArrayList();
    private ArrayList top10TotalOps = new ArrayList();
    private ArrayList top10Slow = new ArrayList();
    private ArrayList top10AvgLat = new ArrayList();
    private static final int numStatusMeas = 8;
    private static final int numPerfMeas = 14;
    private static final int numMeas = 22;
    private static ArrayList dummyPerfList = NAUSDVolTest.getDummyList(14);
    private static final String TOP_UTILIZED_INFO = "Highly utilized volumes";
    private static final String TOP_BUSY_INFO = "Busy volumes";
    private static final String TOP_SLOW_INFO = "Slow volumes";
    private int numHighlyUtilized = 0;
    private int numBusy = 0;
    private int numSlow = 0;
    private double utilizationThresh = Double.POSITIVE_INFINITY;
    private double totalOpsThresh = Double.POSITIVE_INFINITY;
    private double avgLatThresh = Double.POSITIVE_INFINITY;
    private boolean getInstanceList = false;
    private static final ArrayList stateList = new ArrayList();
    private static final String[] perfCountersArr;
    public Hashtable errorDDTbl = new Hashtable();

    public NAUSDVolTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(22);
        System.out.println("[NAUSDVolTest]inside constructor=======>");
        String string = "";
        try {
            string = this.getValueForParam("Used_percentage_threshold(%)");
            if (string != null && !string.equalsIgnoreCase("none")) {
                this.utilizationThresh = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.utilizationThresh = Double.POSITIVE_INFINITY;
            this.logToErrorFile("ERROR", this.entity, "Error parsing parameter Utilization_Threshold value " + string);
        }
        System.out.println("[NAUSDVolTest]=======>utilizationThresh" + this.utilizationThresh);
        try {
            string = this.getValueForParam("Operations_threshold(Ops/sec)");
            if (string != null && !string.equalsIgnoreCase("none")) {
                this.totalOpsThresh = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.totalOpsThresh = Double.POSITIVE_INFINITY;
            this.logToErrorFile("ERROR", this.entity, "Error parsing parameter Total_Ops_Threshold value " + string);
        }
        System.out.println("[NAUSDVolTest]=======>totalOpsThresh" + this.totalOpsThresh);
        try {
            string = this.getValueForParam("Avg_latency_threshold(Milliseconds)");
            if (string != null && !string.equalsIgnoreCase("none")) {
                this.avgLatThresh = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.avgLatThresh = Double.POSITIVE_INFINITY;
            this.logToErrorFile("ERROR", this.entity, "Error parsing parameter Avg_Latency_Threshold value " + string);
        }
        System.out.println("[NAUSDVolTest]=======>avgLatThresh" + this.avgLatThresh);
    }

    public Hashtable getStatusForAllVolumes(NaServer naServer) {
        int n = 0;
        this.top10Utilized = new ArrayList();
        this.top10PctUsed = new ArrayList();
        this.numHighlyUtilized = 0;
        NaElement naElement = new NaElement("volume-list-info-iter-start");
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return null;
        }
        String string = naElement2.getChildContent("tag");
        n = naElement2.getChildIntValue("records", 0);
        Hashtable hashtable = new Hashtable();
        this.printOut("DEBUG", "Total number of volumes = " + n);
        naElement = new NaElement("volume-list-info-iter-next");
        naElement.addNewChild("maximum", this.maxIterRecs);
        naElement.addNewChild("tag", string);
        naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return null;
        }
        while (n > 0) {
            String string2 = null;
            Double d = FalseDbl;
            double d2 = -5.0;
            double d3 = -5.0;
            NaElement naElement3 = naElement2.getChildByName("volumes");
            List list = naElement3.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                NaElement naElement4;
                Double d4;
                Double d5;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                naElement3 = (NaElement)list.get(i);
                String string3 = naElement3.getChildContent("name");
                String string4 = naElement3.getChildContent("state");
                int n2 = stateList.indexOf(string4.toLowerCase());
                if (n2 == -1) {
                    n2 = -5;
                }
                Double d6 = new Double(n2);
                long l = naElement3.getChildLongValue("percentage-used", 0L);
                Double d7 = new Double(l);
                if (this.utilizationThresh != Double.POSITIVE_INFINITY && d7 >= this.utilizationThresh) {
                    this.addToSortedLists(this.top10Utilized, this.top10PctUsed, string3, d7);
                    ++this.numHighlyUtilized;
                }
                if ((d5 = new Double(n2 = naElement3.getChildIntValue("size-total", 0))) != null) {
                    d3 = d5;
                    d3 = this.convertBytesToMB(d3);
                }
                if ((d4 = new Double(n2 = naElement3.getChildIntValue("reserve", 0))) != null) {
                    d2 = d4;
                    d2 = this.convertBytesToMB(d2);
                }
                n2 = naElement3.getChildIntValue("reserve-used-actual", 0);
                Double d8 = new Double(n2);
                Double d9 = d4 > 0.0 ? new Double(d8 / d4 * 100.0) : NADbl;
                n2 = naElement3.getChildIntValue("files-used", 0);
                int n3 = naElement3.getChildIntValue("files-total", 0);
                Double d10 = n3 > 0 ? new Double((double)n2 / (double)n3 * 100.0) : NADbl;
                string4 = naElement3.getChildContent("is-inconsistent");
                if (string4.equalsIgnoreCase("true")) {
                    d = TrueDbl;
                    string2 = string2 + ", inconsistent";
                }
                if ((string4 = naElement3.getChildContent("is-invalid")).equalsIgnoreCase("true")) {
                    d = TrueDbl;
                    string2 = string2 + ", invalid";
                }
                if ((string4 = naElement3.getChildContent("is-unrecoverable")).equalsIgnoreCase("true")) {
                    d = TrueDbl;
                    string2 = string2 + ", unrecoverable";
                }
                if ((naElement4 = naElement3.getChildByName("sis")) != null && (string4 = naElement4.getChildContent("last-operation-error")) != null) {
                    d = TrueDbl;
                    string2 = string2 + ", SIS Error : " + string4;
                }
                if (d == TrueDbl) {
                    string2 = string2.substring(2);
                    this.errorDDTbl.put(string3, string2);
                }
                arrayList.add(NADbl);
                arrayList.add(d6);
                arrayList.add(d);
                arrayList.add(d7);
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d2));
                arrayList.add(d9);
                arrayList.add(d10);
                hashtable.put(string3, arrayList);
                this.printOut("DEBUG", "Got Status measures for volume " + string3 + " = " + arrayList);
            }
            naElement = new NaElement("volume-list-info-iter-next");
            naElement.addNewChild("maximum", this.maxIterRecs);
            naElement.addNewChild("tag", string);
            naElement2 = this.execONTAPI(naServer, naElement);
            if (naElement2 == null) {
                return null;
            }
            n = naElement2.getChildIntValue("records", 0);
        }
        naElement = new NaElement("volume-list-info-iter-end");
        naElement.addNewChild("tag", string);
        this.execONTAPI(naServer, naElement);
        return hashtable;
    }

    private ArrayList calcPerfMeas(String string, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList arrayList4 = this.getDiffList(arrayList, arrayList2);
        Object var6_6 = null;
        Object var7_7 = null;
        Double d = this.divide(arrayList4.get(1), arrayList4.get(0));
        if (this.totalOpsThresh != Double.POSITIVE_INFINITY && d >= this.totalOpsThresh) {
            this.addToSortedLists(this.top10Busy, this.top10TotalOps, string, d);
            ++this.numBusy;
        }
        Double d2 = this.divide(arrayList4.get(2), arrayList4.get(0));
        Double d3 = this.divide(arrayList4.get(3), arrayList4.get(0));
        Double d4 = this.divide(arrayList4.get(4), arrayList4.get(1));
        d4 = this.divide(d4, new Double(1000.0));
        if (this.avgLatThresh != Double.POSITIVE_INFINITY && d4 >= this.avgLatThresh) {
            this.addToSortedLists(this.top10Slow, this.top10AvgLat, string, d4);
            ++this.numSlow;
        }
        Double d5 = this.divide(arrayList4.get(5), arrayList4.get(3));
        d5 = this.divide(d5, new Double(1000.0));
        Double d6 = this.divide(arrayList4.get(6), arrayList4.get(2));
        d6 = this.divide(d6, new Double(1000.0));
        Double d7 = this.divide(arrayList4.get(7), arrayList4.get(0));
        Double d8 = this.divide(arrayList4.get(8), arrayList4.get(0));
        Double d9 = this.divide(arrayList4.get(9), arrayList4.get(0));
        Double d10 = this.divide(arrayList4.get(10), arrayList4.get(0));
        Double d11 = this.divide(arrayList4.get(11), arrayList4.get(0));
        Double d12 = new Double(d9 + d10 + d11);
        Double d13 = this.divide(arrayList4.get(12), arrayList4.get(9));
        Double d14 = this.divide(arrayList4.get(13), arrayList4.get(10));
        Double d15 = this.divide(arrayList4.get(14), arrayList4.get(11));
        Double d16 = this.getAvgProtocolLatency(d13, d9, d14, d10, d15, d11);
        d16 = this.divide(d16, new Double(1000.0));
        Double d17 = this.divide(arrayList4.get(15), arrayList4.get(0));
        Double d18 = this.divide(arrayList4.get(16), arrayList4.get(0));
        Double d19 = this.divide(arrayList4.get(17), arrayList4.get(0));
        Double d20 = new Double(d17 + d18 + d19);
        Double d21 = this.divide(arrayList4.get(18), arrayList4.get(15));
        Double d22 = this.divide(arrayList4.get(19), arrayList4.get(16));
        Double d23 = this.divide(arrayList4.get(20), arrayList4.get(17));
        Double d24 = this.getAvgProtocolLatency(d21, d17, d22, d18, d23, d19);
        d24 = this.divide(d24, new Double(1000.0));
        Double d25 = this.divide(arrayList4.get(21), arrayList4.get(0));
        Double d26 = this.divide(arrayList4.get(22), arrayList4.get(0));
        Double d27 = this.divide(arrayList4.get(23), arrayList4.get(0));
        Double d28 = new Double(d25 + d26 + d27);
        Double d29 = this.divide(arrayList4.get(24), arrayList4.get(21));
        Double d30 = this.divide(arrayList4.get(25), arrayList4.get(22));
        Double d31 = this.divide(arrayList4.get(26), arrayList4.get(23));
        Double d32 = this.getAvgProtocolLatency(d29, d25, d30, d26, d31, d27);
        d32 = this.divide(d32, new Double(1000.0));
        arrayList3.add(d);
        arrayList3.add(d2);
        arrayList3.add(d3);
        arrayList3.add(d4);
        arrayList3.add(d5);
        arrayList3.add(d6);
        arrayList3.add(d7);
        arrayList3.add(d8);
        arrayList3.add(d12);
        arrayList3.add(d16);
        arrayList3.add(d20);
        arrayList3.add(d24);
        arrayList3.add(d28);
        arrayList3.add(d32);
        return arrayList3;
    }

    private Double getAvgProtocolLatency(Double d, Double d2, Double d3, Double d4, Double d5, Double d6) {
        int n = 0;
        double d7 = 0.0;
        this.printOut("DEBUG", "getAvgProtLat : op1 ( " + d + "," + d2 + "), op2 ( " + d3 + "," + d4 + "), op3 : (" + d5 + "," + d6 + ")");
        if (d2 > 0.0 && d >= 0.0) {
            ++n;
            d7 += d.doubleValue();
        }
        if (d4 > 0.0 && d3 >= 0.0) {
            ++n;
            d7 += d3.doubleValue();
        }
        if (d6 > 0.0 && d5 >= 0.0) {
            ++n;
            d7 += d5.doubleValue();
        }
        if (n == 0) {
            return NADbl;
        }
        return new Double(d7 / (double)n);
    }

    private Hashtable getPerfOfAllVolumes(NaServer naServer) {
        Object object;
        this.numBusy = 0;
        this.numSlow = 0;
        Hashtable hashtable = null;
        if (this.getInstanceList) {
            object = this.getPerfInstanceList(naServer, "volume");
            hashtable = this.getPerfInstance(naServer, perfCountersArr, (String[])object, "volume", null);
        } else {
            hashtable = this.getPerfInstance(naServer, perfCountersArr, "volume", null);
            if (hashtable == null) {
                return null;
            }
            if (hashtable.size() == 0) {
                this.printOut("WARN", "Did not get any performance measure for volumes. Trying again by providing specific volume instances...");
                object = this.getPerfInstanceList(naServer, "volume");
                hashtable = this.getPerfInstance(naServer, perfCountersArr, (String[])object, "volume", null);
                this.getInstanceList = true;
            }
        }
        if (hashtable == null) {
            return null;
        }
        if (this.prevPerfHT == null) {
            this.prevPerfHT = hashtable;
            return null;
        }
        this.top10Busy = new ArrayList();
        this.top10TotalOps = new ArrayList();
        this.top10Slow = new ArrayList();
        this.top10AvgLat = new ArrayList();
        object = hashtable.keys();
        String string = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        Object var8_8 = null;
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            arrayList = (ArrayList)hashtable.get(string);
            arrayList2 = (ArrayList)this.prevPerfHT.get(string);
            arrayList3 = this.calcPerfMeas(string, arrayList, arrayList2);
            this.printOut("DEBUG", "Got performance measures for volume = " + string + " Measures = " + arrayList3);
            hashtable2.put(string, arrayList3);
        }
        this.prevPerfHT = hashtable;
        return hashtable2;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        NaServer naServer = null;
        naServer = this.getConnection();
        if (naServer == null) {
            this.closeConnection(naServer);
            return;
        }
        Hashtable hashtable2 = this.getStatusForAllVolumes(naServer);
        if (hashtable2 == null) {
            this.closeConnection(naServer);
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        Object var6_6 = null;
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        Hashtable hashtable3 = this.getPerfOfAllVolumes(naServer);
        if (hashtable3 != null && hashtable3.size() != hashtable2.size()) {
            this.printOut("DEBUG", "Error : Volume count mismatch between status API and perf API calls. Num Measure lists for status = " + hashtable2.size() + ", perf = " + hashtable3.size());
        }
        Enumeration enumeration2 = hashtable2.keys();
        String string = null;
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            arrayList = (ArrayList)hashtable2.get(string);
            if (hashtable3 == null) {
                arrayList2 = dummyPerfList;
            } else {
                arrayList2 = (ArrayList)hashtable3.get(string);
                if (arrayList2 == null) {
                    this.printOut("DEBUG", "Error : No performance measures found for volume " + string);
                    arrayList2 = dummyPerfList;
                }
            }
            arrayList.addAll(arrayList2);
            this.printOut("DEBUG", "Obtained measure list for volume " + string + " : " + arrayList.toString());
            if (bl) continue;
            this.addNewMeasure(string, arrayList);
        }
        if (this.top10Utilized != null && this.top10Utilized.size() > 0) {
            arrayList = this.getAverageValue(hashtable2, this.top10Utilized, 3, 7, this.numHighlyUtilized);
            this.Utilized_dd = this.getDDList(this.top10Utilized, this.top10PctUsed, TOP_UTILIZED_INFO);
            System.out.println("[NAUSDVolTEst]Utilized_dd=====>" + this.Utilized_dd);
            if (hashtable3 == null) {
                arrayList2 = dummyPerfList;
            } else {
                arrayList2 = this.getAverageValue(hashtable3, this.top10Utilized, 0, 13, -5);
                arrayList2.remove(0);
            }
            arrayList.addAll(arrayList2);
            this.printOut("DEBUG", "Obtained measure list for Top 10 utilized volumes  : " + arrayList.toString());
            if (!bl) {
                this.addNewMeasure(TOP_UTILIZED_INFO, arrayList);
            }
        }
        if (this.top10Busy != null && this.top10Busy.size() > 0) {
            arrayList = this.getAverageValue(hashtable2, this.top10Busy, 3, 7, this.numBusy);
            this.Busy_dd = this.getDDList(this.top10Busy, this.top10TotalOps, TOP_BUSY_INFO);
            System.out.println("[NAUSDVolTEst]Busy_dd=====>" + this.Busy_dd);
            if (hashtable3 == null) {
                arrayList2 = dummyPerfList;
            } else {
                arrayList2 = this.getAverageValue(hashtable3, this.top10Busy, 0, 13, -5);
                arrayList2.remove(0);
            }
            arrayList.addAll(arrayList2);
            this.printOut("DEBUG", "Obtained measure list for Top 10 Busy volumes  : " + arrayList.toString());
            if (!bl) {
                this.addNewMeasure(TOP_BUSY_INFO, arrayList);
            }
        }
        if (this.top10Slow != null && this.top10Slow.size() > 0) {
            arrayList = this.getAverageValue(hashtable2, this.top10Slow, 3, 7, this.numSlow);
            this.slow_dd = this.getDDList(this.top10Slow, this.top10AvgLat, TOP_SLOW_INFO);
            System.out.println("[NAUSDVolTEst]slow_dd=====>" + this.slow_dd);
            if (hashtable3 == null) {
                arrayList2 = dummyPerfList;
            } else {
                arrayList2 = this.getAverageValue(hashtable3, this.top10Slow, 0, 13, -5);
                arrayList2.remove(0);
            }
            arrayList.addAll(arrayList2);
            this.printOut("DEBUG", "Obtained measure list for Top 10 SLOW volumes  : " + arrayList.toString());
            if (!bl) {
                this.addNewMeasure(TOP_SLOW_INFO, arrayList);
            }
        }
        this.closeConnection(naServer);
    }

    public void freeTest() {
        this.Utilized_dd = new Hashtable();
        this.Busy_dd = new Hashtable();
        this.slow_dd = new Hashtable();
    }

    public static void main(String[] stringArray) {
        NAUSDVolTest nAUSDVolTest = new NAUSDVolTest(stringArray);
        nAUSDVolTest.debugComputeMeasures(new Hashtable(), true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nAUSDVolTest.debugComputeMeasures(new Hashtable(), true);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nAUSDVolTest.debugComputeMeasures(new Hashtable(), true);
    }

    static {
        stateList.add("online");
        stateList.add("creating");
        stateList.add("restricted");
        stateList.add("offline");
        stateList.add("partial");
        stateList.add("unknown");
        stateList.add("failed");
        perfCountersArr = new String[]{"total_ops", "write_ops", "read_ops", "avg_latency", "read_latency", "write_latency", "read_data", "write_data", "cifs_read_ops", "cifs_write_ops", "cifs_other_ops", "cifs_read_latency", "cifs_write_latency", "cifs_other_latency", "nfs_read_ops", "nfs_write_ops", "nfs_other_ops", "nfs_read_latency", "nfs_write_latency", "nfs_other_latency", "san_read_ops", "san_write_ops", "san_other_ops", "san_read_latency", "san_write_latency", "san_other_latency"};
    }
}

