/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.util.StringTokenizer;

public class LdapTest
extends EgTest {
    String DN = null;
    String password = null;
    String search = null;
    long cur_conn = 0L;
    long num_conn = 0L;
    long byt_sent = 0L;
    long availability;
    long tcp_availability;
    long ops_value = 0L;
    double respTime;
    private int defValue = 0;
    private long prev_conn = 0L;
    private long tot_conn = 0L;
    private long prev_bytes = 0L;
    private long bytes_sent = 0L;
    private long ops_init = 0L;
    private long ops_comp = 0L;
    private static int availabilityIndex = 0;
    private static int responseTimeIndex = 1;
    private static int tcpAvailabilityIndex = 2;
    private static int curConnsIndex = 3;
    private static int connRateIndex = 4;
    private static int kbyteRateIndex = 5;
    private static int opsValueIndex = 6;
    private String index;

    public static void main(String[] stringArray) {
        LdapTest ldapTest = new LdapTest(stringArray);
        ldapTest.executeTest();
    }

    public LdapTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 7;
        if (stringArray.length < 6 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: LdapTest -host <hostname> -port <port> -search <parameters> {-DN <DN> -password <password>}");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        this.portNo = new String("389");
        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: LdapTest -host <hostname> -port <port> -search <parameters> {-distinguishedName <DN> -password <password>}");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-distinguishedName")) {
                    if (++i < stringArray.length) {
                        this.DN = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: LdapTest -host <hostname> -port <port> -search <parameters> {-distinguishedName <DN> -password <password>}");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-password")) {
                    if (++i < stringArray.length) {
                        this.password = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: LdapTest -host <hostname> -port <port> -search <parameters> {-distinguishedName <DN> -password <password>}");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-search")) continue;
                if (++i >= stringArray.length) {
                    System.err.println("Usage: LdapTest -host <hostname> -port <port> -search <parameters> {-distinguishedName <DN> -password <password>}");
                    return;
                }
                this.search = new String(stringArray[i]);
                StringTokenizer stringTokenizer = new StringTokenizer(this.search, "|");
                String string = "";
                while (stringTokenizer.countTokens() > 0) {
                    string = string + stringTokenizer.nextToken().trim();
                    if (stringTokenizer.countTokens() <= 0) continue;
                    string = string + ",";
                }
                this.search = string;
            }
        }
        this.defValue = this.isPassive ? -5 : 0;
    }

    public boolean executeTest() {
        String string = null;
        this.initTest();
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("java.version");
        String string4 = null;
        if (string3.compareTo("10.0") > 0) {
            string4 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
            if (string2.indexOf("win") >= 0) {
                string4 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
            }
        } else if (string3.compareTo("1.7") > 0) {
            string4 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
            if (string2.indexOf("win") >= 0) {
                string4 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
            }
        } else if (string3.compareTo("1.6") > 0) {
            string4 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
            if (string2.indexOf("win") >= 0) {
                string4 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
            }
        }
        String string5 = "java ";
        if (string4 != null) {
            string5 = string5 + string4 + " ";
        }
        try {
            String string6;
            string = new String(string5 + "EgLdap -h " + this.targetHost + " -p " + this.portNo + " -b " + this.search + " -s base objectClass=*");
            if (this.DN != null && !this.DN.equalsIgnoreCase(noneValue)) {
                string6 = "";
                if (this.DN.indexOf("|") > -1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.DN, "|");
                    while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
                        string6 = string6 + stringTokenizer.nextToken() + ",";
                    }
                    string6 = string6.substring(0, string6.lastIndexOf(","));
                    string = string + " -D " + string6;
                } else {
                    string = string + " -D " + this.DN;
                }
            }
            if (this.password != null && !this.password.equalsIgnoreCase(noneValue)) {
                string = string + " -w " + this.password;
            }
            long l = System.currentTimeMillis();
            BufferedReader[] bufferedReaderArray = this.executeProgram(string);
            if (bufferedReaderArray != null) {
                String string7 = bufferedReaderArray[2].readLine();
                if (string7 != null) {
                    if (string7.indexOf("client connection fail") >= 0) {
                        this.errorMsg = new String("Connection to the server failed");
                        this.availability = 0L;
                        this.tcp_availability = 0L;
                        this.respTime = -1.0;
                        this.prev_conn = -1L;
                        this.prev_bytes = -1L;
                        this.cur_conn = -1L;
                        this.num_conn = -1L;
                        this.byt_sent = -1L;
                        this.ops_value = -1L;
                        if (this.isPassive) {
                            this.addValueToResultSet(this.index, availabilityIndex, this.defValue);
                            this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.defValue);
                            this.addValueToResultSet(this.index, responseTimeIndex, this.defValue);
                            this.addValueToResultSet(this.index, curConnsIndex, this.defValue);
                            this.addValueToResultSet(this.index, connRateIndex, this.defValue);
                            this.addValueToResultSet(this.index, kbyteRateIndex, this.defValue);
                            this.addValueToResultSet(this.index, opsValueIndex, this.defValue);
                        } else {
                            this.addValueToResultSet(this.index, availabilityIndex, 0.0);
                            this.addValueToResultSet(this.index, tcpAvailabilityIndex, 0.0);
                            this.addValueToResultSet(this.index, responseTimeIndex, -1.0);
                            this.addValueToResultSet(this.index, curConnsIndex, -1.0);
                            this.addValueToResultSet(this.index, connRateIndex, -1.0);
                            this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
                            this.addValueToResultSet(this.index, opsValueIndex, -1.0);
                        }
                        this.updateAllResultSets();
                        this.closeReader(bufferedReaderArray[1]);
                        this.closeReader(bufferedReaderArray[2]);
                        if (this.process != null) {
                            this.destroy(this.process);
                        }
                        return false;
                    }
                    this.errorMsg = new String(this.targetHost + ":" + this.portNo + ": Object specified is not existing in the directory");
                    this.tcp_availability = 100L;
                    this.availability = 0L;
                    this.respTime = -1.0;
                    this.prev_conn = -1L;
                    this.prev_bytes = -1L;
                    this.num_conn = -1L;
                    this.cur_conn = -1L;
                    this.byt_sent = -1L;
                    this.ops_value = -1L;
                    this.addValueToResultSet(this.index, availabilityIndex, this.availability);
                    this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.tcp_availability);
                    this.addValueToResultSet(this.index, responseTimeIndex, this.respTime);
                    this.addValueToResultSet(this.index, curConnsIndex, -1.0);
                    this.addValueToResultSet(this.index, connRateIndex, -1.0);
                    this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
                    this.addValueToResultSet(this.index, opsValueIndex, -1.0);
                    this.updateAllResultSets();
                    this.closeReader(bufferedReaderArray[1]);
                    this.closeReader(bufferedReaderArray[2]);
                    if (this.process != null) {
                        this.destroy(this.process);
                    }
                    return false;
                }
                this.availability = 100L;
                this.tcp_availability = 100L;
                if (this.search.equalsIgnoreCase("cn=monitor")) {
                    while ((string7 = bufferedReaderArray[1].readLine()) != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string7, ":");
                        if (stringTokenizer.countTokens() <= 1) continue;
                        string6 = stringTokenizer.nextToken();
                        string6.trim();
                        if (string6.equals("totalconnections")) {
                            this.tot_conn = Long.parseLong(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        if (string6.equals("currentconnections")) {
                            this.cur_conn = Long.parseLong(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        if (string6.equals("bytessent")) {
                            this.byt_sent = Long.parseLong(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        if (string6.equals("opsinitiated")) {
                            this.ops_init = Long.parseLong(stringTokenizer.nextToken().trim());
                            continue;
                        }
                        if (!string6.equals("opscompleted")) continue;
                        this.ops_comp = Long.parseLong(stringTokenizer.nextToken().trim());
                    }
                    if (this.ops_init != 0L && this.ops_comp != 0L) {
                        this.ops_value = this.ops_init - this.ops_comp;
                    }
                    if (this.prev_conn > 0L) {
                        this.num_conn = this.tot_conn - this.prev_conn;
                    } else {
                        this.num_conn = -1L;
                        this.prev_conn = this.tot_conn;
                    }
                    if (this.prev_bytes > 0L) {
                        long l2 = this.byt_sent;
                        this.byt_sent = l2 - this.prev_bytes;
                        this.prev_bytes = l2;
                    } else {
                        this.prev_bytes = this.byt_sent;
                        this.byt_sent = -1L;
                    }
                    long l3 = System.currentTimeMillis();
                    this.respTime = (double)(l3 - l) / 1000.0;
                    this.closeReader(bufferedReaderArray[1]);
                    this.closeReader(bufferedReaderArray[2]);
                    if (this.process != null) {
                        this.destroy(this.process);
                    }
                    this.computeResults();
                    return true;
                }
                long l4 = System.currentTimeMillis();
                this.respTime = (double)(l4 - l) / 1000.0;
                this.num_conn = 0L;
                this.prev_conn = 0L;
                this.prev_bytes = 0L;
                this.cur_conn = 0L;
                this.byt_sent = 0L;
                this.ops_value = 0L;
                this.addValueToResultSet(this.index, availabilityIndex, this.availability);
                this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.tcp_availability);
                this.addValueToResultSet(this.index, responseTimeIndex, this.respTime);
                this.addValueToResultSet(this.index, curConnsIndex, -5.0);
                this.addValueToResultSet(this.index, connRateIndex, -5.0);
                this.addValueToResultSet(this.index, kbyteRateIndex, -5.0);
                this.addValueToResultSet(this.index, opsValueIndex, -5.0);
                this.updateAllResultSets();
                this.closeReader(bufferedReaderArray[1]);
                this.closeReader(bufferedReaderArray[2]);
                if (this.process != null) {
                    this.destroy(this.process);
                }
                return true;
            }
            this.errorMsg = new String("Failed to execute LdapTest for target: " + this.targetHost);
            this.availability = -1L;
            this.tcp_availability = -1L;
            this.respTime = -1.0;
            this.prev_conn = -1L;
            this.prev_bytes = -1L;
            this.num_conn = -1L;
            this.cur_conn = -1L;
            this.byt_sent = -1L;
            this.ops_value = -1L;
            if (this.isPassive) {
                this.addValueToResultSet(this.index, availabilityIndex, this.defValue);
                this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.defValue);
                this.addValueToResultSet(this.index, responseTimeIndex, this.defValue);
                this.addValueToResultSet(this.index, curConnsIndex, this.defValue);
                this.addValueToResultSet(this.index, connRateIndex, this.defValue);
                this.addValueToResultSet(this.index, kbyteRateIndex, this.defValue);
                this.addValueToResultSet(this.index, opsValueIndex, this.defValue);
            } else {
                this.addValueToResultSet(this.index, availabilityIndex, this.availability);
                this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.tcp_availability);
                this.addValueToResultSet(this.index, responseTimeIndex, -1.0);
                this.addValueToResultSet(this.index, curConnsIndex, -1.0);
                this.addValueToResultSet(this.index, connRateIndex, -1.0);
                this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
                this.addValueToResultSet(this.index, opsValueIndex, -1.0);
            }
            if (this.process != null) {
                this.destroy(this.process);
            }
            this.updateAllResultSets();
            return false;
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception while executing LdapTest for target: " + this.targetHost);
            this.availability = -1L;
            this.tcp_availability = -1L;
            this.respTime = -1.0;
            this.cur_conn = -1L;
            this.num_conn = -1L;
            this.prev_conn = -1L;
            this.prev_bytes = -1L;
            this.byt_sent = -1L;
            this.ops_value = -1L;
            if (this.isPassive) {
                this.addValueToResultSet(this.index, availabilityIndex, this.defValue);
                this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.defValue);
                this.addValueToResultSet(this.index, responseTimeIndex, this.defValue);
                this.addValueToResultSet(this.index, curConnsIndex, this.defValue);
                this.addValueToResultSet(this.index, connRateIndex, this.defValue);
                this.addValueToResultSet(this.index, kbyteRateIndex, this.defValue);
                this.addValueToResultSet(this.index, opsValueIndex, this.defValue);
            } else {
                this.addValueToResultSet(this.index, availabilityIndex, -1.0);
                this.addValueToResultSet(this.index, tcpAvailabilityIndex, -1.0);
                this.addValueToResultSet(this.index, responseTimeIndex, -1.0);
                this.addValueToResultSet(this.index, curConnsIndex, -1.0);
                this.addValueToResultSet(this.index, connRateIndex, -1.0);
                this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
                this.addValueToResultSet(this.index, opsValueIndex, -1.0);
            }
            if (this.process != null) {
                this.destroy(this.process);
            }
            this.updateAllResultSets();
            return false;
        }
    }

    private void computeResults() {
        this.addValueToResultSet(this.index, availabilityIndex, this.availability);
        this.addValueToResultSet(this.index, tcpAvailabilityIndex, this.tcp_availability);
        this.addValueToResultSet(this.index, responseTimeIndex, this.respTime);
        this.addValueToResultSet(this.index, curConnsIndex, this.cur_conn);
        if (this.timeSinceLastTest > 0.0) {
            if (this.num_conn < 0L) {
                this.addValueToResultSet(this.index, connRateIndex, -1.0);
            } else {
                this.addValueToResultSet(this.index, connRateIndex, (double)this.num_conn / this.timeSinceLastTest);
            }
            if (this.byt_sent < 0L) {
                this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
            } else {
                this.addValueToResultSet(this.index, kbyteRateIndex, (double)this.byt_sent / 1024.0 / this.timeSinceLastTest);
            }
        } else {
            this.addValueToResultSet(this.index, connRateIndex, -1.0);
            this.addValueToResultSet(this.index, kbyteRateIndex, -1.0);
        }
        this.addValueToResultSet(this.index, opsValueIndex, this.ops_value);
        this.updateAllResultSets();
    }
}

