/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;

public class JbMQQueueTest
extends EgJbBase {
    String s_whoami = "JbMQQueueTest";
    private Hashtable queueDepthTable;
    private Hashtable scheduledMessageTable;
    private Hashtable subscribersTable;
    private Hashtable receiversTable;
    Hashtable lastMeasure = new Hashtable();

    public JbMQQueueTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(10);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        String[] stringArray;
        Properties properties = null;
        this.queueDepthTable = new Hashtable();
        this.scheduledMessageTable = new Hashtable();
        this.subscribersTable = new Hashtable();
        this.receiversTable = new Hashtable();
        if (this.viaJmx) {
            if (this.version >= 7) {
                stringArray = new String[]{"queueAddress", "consumerCount", "deliveringCount", "messageCount", "messagesAdded", "scheduledCount"};
                properties = this.getMQTestDetails("jboss.as:subsystem=messaging,*,jms-queue=*", Arrays.asList(stringArray));
            } else {
                properties = this.version >= 6 && this.version < 7 ? this.getMQTestDetails("org.hornetq:module=Core,type=Queue,*") : this.getMQTestDetails("*:service=Queue,*");
            }
        } else {
            properties = this.encrypt(this.s_whoami);
        }
        if (properties == null || properties.size() == 0) {
            this.logToErrorFile("Error", this.s_servletName, "Got no results from JBoss for JbMQQueueTest.");
            return;
        }
        if (properties != null && properties.size() > 0) {
            stringArray = properties.keys();
            while (stringArray.hasMoreElements()) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object v;
                Object object5;
                String string = (String)stringArray.nextElement();
                Hashtable hashtable2 = (Hashtable)properties.get(string.toString());
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                double d7 = -5.0;
                double d8 = -5.0;
                double d9 = -5.0;
                if (hashtable2.containsKey("JNDIName") && (object5 = hashtable2.get("JNDIName")) != null) {
                    string = object5.toString();
                }
                if (this.version >= 7) {
                    object5 = hashtable2.get("queueAddress");
                    if (object5 != null) {
                        string = object5.toString();
                    }
                    if ((v = hashtable2.get("consumerCount")) != null) {
                        d6 = this.convertDouble(v.toString());
                    }
                    if ((object4 = hashtable2.get("messageCount")) != null) {
                        d2 = this.convertDouble(object4.toString());
                    }
                    if ((object3 = hashtable2.get("messagesAdded")) != null) {
                        d4 = this.convertDouble(object3.toString());
                    }
                    if ((object2 = hashtable2.get("scheduledCount")) != null) {
                        d3 = this.convertDouble(object2.toString());
                    }
                    if (d4 > 0.0) {
                        d8 = d4 - (d2 + d3);
                    }
                    if (d8 < 0.0) {
                        d8 = -5.0;
                    }
                } else if (this.version >= 6 && this.version < 7) {
                    object5 = hashtable2.get("ConsumerCount");
                    if (object5 != null) {
                        d6 = this.convertDouble(object5.toString());
                    }
                    if ((v = hashtable2.get("MessageCount")) != null) {
                        d2 = this.convertDouble(v.toString());
                    }
                    if ((object4 = hashtable2.get("MessagesAdded")) != null) {
                        d4 = this.convertDouble(object4.toString());
                    }
                    if ((object3 = hashtable2.get("ScheduledCount")) != null) {
                        d3 = this.convertDouble(object3.toString());
                    }
                    if (d4 > 0.0) {
                        d8 = d4 - (d2 + d3);
                    }
                    if (d8 < 0.0) {
                        d8 = -5.0;
                    }
                } else {
                    Object object6;
                    String string2;
                    Object v2;
                    object5 = hashtable2.get("MaxDepth");
                    if (object5 != null) {
                        d = this.convertDouble(object5.toString());
                    }
                    if ((v = hashtable2.get("QueueDepth")) != null) {
                        d2 = this.convertDouble(v.toString());
                    }
                    if ((object4 = hashtable2.get("ScheduledMessageCount")) != null) {
                        d3 = this.convertDouble(object4.toString());
                    }
                    if ((object3 = hashtable2.get("Total_msg_added")) != null) {
                        d4 = this.convertDouble(object3.toString());
                    }
                    if ((object2 = hashtable2.get("SubscribersCount")) != null) {
                        d6 = this.convertDouble(object2.toString());
                    }
                    if ((object = hashtable2.get("ReceiversCount")) != null) {
                        d7 = this.convertDouble(object.toString());
                    }
                    if ((v2 = hashtable2.get("Subscribers_DD_Result")) != null) {
                        string2 = (String)v2;
                        object6 = new ArrayList<String>();
                        ((ArrayList)object6).add(string2);
                        this.subscribersTable.put(string, object6);
                    }
                    if ((string2 = hashtable2.get("Receivers_DD_Result")) != null) {
                        object6 = string2;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        arrayList.add(object6);
                        this.receiversTable.put(string, arrayList);
                    }
                    if ((object6 = hashtable2.get("Last_msg_time")) != null) {
                        try {
                            long l = Long.parseLong(object6.toString());
                            if (l > 0L) {
                                long l2 = System.currentTimeMillis();
                                long l3 = (l2 - l) / 60000L;
                                String string3 = Long.toString(l3);
                                d5 = this.convertDouble(string3);
                            } else {
                                d5 = this.convertDouble(object6.toString());
                            }
                        }
                        catch (Exception exception) {
                            d5 = -5.0;
                        }
                    }
                    if (d > 0.0) {
                        d9 = d2 / d * 100.0;
                    }
                }
                object5 = new ArrayList();
                v = hashtable2.get("QueueDepth_DD_Result");
                if (v != null) {
                    object4 = (String)v;
                    object3 = this.getDDResult((String)object4);
                    this.queueDepthTable.put(string, object3);
                }
                if ((object4 = hashtable2.get("Scheduled_DD_Result")) != null) {
                    object3 = (String)object4;
                    object2 = this.getDDResult((String)object3);
                    this.scheduledMessageTable.put(string, object2);
                }
                double d10 = 0.0;
                if (d4 >= 0.0) {
                    d10 = d4 / this.timeSinceLastTest;
                }
                object = new ArrayList();
                ((ArrayList)object).add((Double)new Double(d));
                ((ArrayList)object).add(new Double(d2));
                ((ArrayList)object).add(new Double(d9));
                ((ArrayList)object).add(new Double(d8));
                ((ArrayList)object).add(new Double(d3));
                ((ArrayList)object).add(new Double(d4));
                ((ArrayList)object).add(new Double(d5));
                ((ArrayList)object).add(new Double(d6));
                ((ArrayList)object).add(new Double(d7));
                ((ArrayList)object).add(new Double(d10));
                this.addNewMeasure(string, (ArrayList)object);
            }
        }
    }

    public ArrayList getDDResult(String string) {
        ArrayList arrayList = new ArrayList();
        if (string != null && string.length() > 0) {
            arrayList = JbMQQueueTest.myTokenizer(string, "$**$");
        }
        return arrayList;
    }

    public double convertDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public ArrayList getQueueDepthData(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.queueDepthTable.containsKey(string)) {
            arrayList = (ArrayList)this.queueDepthTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getScheduledMessageData(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.scheduledMessageTable.containsKey(string)) {
            arrayList = (ArrayList)this.scheduledMessageTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getSubscribersData(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.subscribersTable.containsKey(string)) {
            arrayList = (ArrayList)this.subscribersTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getReceiversData(String string) {
        ArrayList arrayList = new ArrayList();
        if (this.receiversTable.containsKey(string)) {
            arrayList = (ArrayList)this.receiversTable.get(string);
        }
        return arrayList;
    }
}

