/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IcaConnectionTest
extends GenericTest {
    String strhost = null;
    String strport;
    private int i_availability;
    private double responseTime;
    private int intPort = 0;
    private int timeOut = 15000;
    private int icaAvailability;
    IcaHelperThread ph;
    private static int measureCount = 3;
    private int defValue = 0;

    public IcaConnectionTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(measureCount);
        this.defValue = this.isPassive ? -5 : 0;
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        if (this.targetHost == null || this.portNo == null || this.targetHost.equals("") || this.portNo.equals("")) {
            this.setErrorMessage("Unexpected values for target host or target port");
            return;
        }
        String string = (String)hashtable.get("targetPorts");
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = (String)hashtable.get("timeout");
        if (string2 != null) {
            try {
                int n2 = Integer.parseInt(string2);
                this.timeOut = n2 * 1000;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        for (n = 0; n < stringArray.length; ++n) {
            String string3 = stringTokenizer.nextToken().trim();
            int n3 = string3.indexOf(58);
            if (n3 < 0) {
                stringArray[n] = string3;
                stringArray2[n] = string3;
                continue;
            }
            stringArray2[n] = string3.substring(0, n3);
            stringArray[n] = string3.substring(n3 + 1);
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n4 = stringArray[n].indexOf(58);
            String string4 = this.targetHost;
            if (n4 >= 0) {
                string4 = stringArray[n].substring(0, n4);
                stringArray[n] = stringArray[n].substring(n4 + 1);
            }
            try {
                this.intPort = Integer.parseInt(stringArray[n]);
            }
            catch (Exception exception) {
                continue;
            }
            long l = System.currentTimeMillis();
            if (this.doesSocketExist(string4, this.intPort)) {
                long l2 = System.currentTimeMillis();
                this.i_availability = 100;
                this.responseTime = l2 - l;
                this.icaAvailability = 0;
                if (this.ph.icaAvailability) {
                    this.icaAvailability = 100;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.i_availability));
                arrayList.add(new Double(this.icaAvailability));
                arrayList.add(new Double(this.responseTime / 1000.0));
                this.addNewMeasure(stringArray2[n], arrayList);
                continue;
            }
            if (this.isPassive) {
                this.i_availability = this.defValue;
                this.responseTime = this.defValue;
                this.icaAvailability = this.defValue;
            } else {
                this.i_availability = 0;
                this.responseTime = -5.0;
                this.icaAvailability = 0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.i_availability));
            arrayList.add(new Double(this.icaAvailability));
            arrayList.add(new Double(this.responseTime));
            this.addNewMeasure(stringArray2[n], arrayList);
        }
    }

    private boolean doesSocketExist(String string, int n) {
        long l;
        this.ph = new IcaHelperThread(string, n, this.timeOut);
        long l2 = 0L;
        long l3 = 3L;
        long l4 = System.currentTimeMillis();
        int n2 = 0;
        do {
            this.suspendForPeriod(l3);
            if (this.ph.done) {
                return this.ph.status;
            }
            if (++n2 >= 5) {
                n2 = 0;
                l = System.currentTimeMillis();
                l2 = l - l4;
            } else {
                l2 += l3;
            }
            if (l2 >= (long)this.timeOut) {
                this.ph.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.ph = null;
                return false;
            }
            l = l3;
            if ((long)this.timeOut - l2 >= l) continue;
            l = (long)this.timeOut - l2;
        } while ((l3 = l) > 0L);
        this.ph.interrupt();
        Thread.currentThread();
        Thread.yield();
        this.ph = null;
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

