/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class IbMemberServiceTest
extends EgSnmpGenericTest {
    boolean isFirst = true;
    private static final Hashtable serviceNameHash = new Hashtable();

    public IbMemberServiceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.7779.3.1.1.2.1.9.1.1");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.7779.3.1.1.2.1.9.1.2");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Error :", "IbMemberServiceTest error occured in getMeasure for targetHost:", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = this.getServiceName(string2);
                if (string3 == null) continue;
                String string4 = (String)hashtable3.get(string);
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "-5";
                }
                if (string4.equalsIgnoreCase("1")) {
                    string4 = "100";
                } else if (string4.equalsIgnoreCase("3")) {
                    string4 = "1";
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(string4));
                this.addNewMeasure(string3, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        System.err.println("result:" + bl);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "IbMemberServiceTest error occured in getMeasure", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getServiceName(String string) {
        String string2 = null;
        try {
            if (string == null) {
                return null;
            }
            string2 = (String)serviceNameHash.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    static {
        serviceNameHash.put(new String("1"), "dhcp");
        serviceNameHash.put(new String("2"), "dns");
        serviceNameHash.put(new String("3"), "ntp");
        serviceNameHash.put(new String("4"), "tftp");
        serviceNameHash.put(new String("5"), "http-file-dist");
        serviceNameHash.put(new String("6"), "ftp");
        serviceNameHash.put(new String("7"), "bloxtools-move");
        serviceNameHash.put(new String("8"), "bloxtools");
    }
}

