/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBSOAPStTest
extends IIBResourceStatisticsBase {
    private static final int SOAP_INPUT_STAT_MEASURE_COUNT = 7;

    public IIBSOAPStTest(String[] args) {
        super(args);
        this.setMeasureCount(7);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable data = new Hashtable();
        data = this.getData("SOAPInput");
        if (data == null && data.size() == 0) {
            return;
        }
        Enumeration enu = data.keys();
        double inboundMessagesTotal = 0.0;
        double repliesSentTotal = 0.0;
        double inboundMessagesMadeFlow = 0.0;
        double inboundMsgFaultBefFlow = 0.0;
        double successfulRepliesSent = 0.0;
        double faultRepliesSent = 0.0;
        double inboundMessagesRate = 0.0;
        double repliesSentRate = 0.0;
        double inboundMessagesFlowRate = 0.0;
        double msgFaultRate = 0.0;
        double faultRepliesRate = 0.0;
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            this.printOut("IIB Node name  :" + key);
            ArrayList tempArrayList = (ArrayList)data.get(key);
            this.printOut("IIB tempArrayList  :" + tempArrayList);
            inboundMessagesTotal = (Double)tempArrayList.get(0);
            repliesSentTotal = (Double)tempArrayList.get(1);
            inboundMessagesMadeFlow = (Double)tempArrayList.get(2);
            inboundMsgFaultBefFlow = (Double)tempArrayList.get(3);
            successfulRepliesSent = (Double)tempArrayList.get(4);
            faultRepliesSent = (Double)tempArrayList.get(5);
            ArrayList<Double> measureArrayList = new ArrayList<Double>();
            if (this.timeSinceLastTest > 0.0) {
                inboundMessagesRate = inboundMessagesTotal / this.timeSinceLastTest;
                repliesSentRate = repliesSentTotal / this.timeSinceLastTest;
                inboundMessagesFlowRate = inboundMessagesMadeFlow / this.timeSinceLastTest;
                msgFaultRate = inboundMsgFaultBefFlow / this.timeSinceLastTest;
                faultRepliesRate = faultRepliesSent / this.timeSinceLastTest;
            } else {
                this.printOut("WARNING : timeSinceLastTest value less than zero ");
                inboundMessagesRate = -5.0;
                repliesSentRate = -5.0;
                inboundMessagesFlowRate = -5.0;
                msgFaultRate = -5.0;
                faultRepliesRate = -5.0;
            }
            measureArrayList.add(new Double(inboundMessagesRate));
            measureArrayList.add(new Double(repliesSentRate));
            measureArrayList.add(new Double(inboundMessagesFlowRate));
            measureArrayList.add(new Double(inboundMsgFaultBefFlow));
            measureArrayList.add(new Double(msgFaultRate));
            measureArrayList.add(new Double(faultRepliesSent));
            measureArrayList.add(new Double(faultRepliesRate));
            this.printOut("Key   :" + key + "    Measure ArrayList  :" + measureArrayList);
            this.addNewMeasure(key, measureArrayList);
        }
    }

    public static void main(String[] args) {
        IIBSOAPStTest obj = new IIBSOAPStTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

